/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import oracle.bali.ewt.text.NumberTextField;

public class NumberRangeTextFieldEditor
extends NumberTextField {
    private Number minimum;
    private Number maximum;

    public NumberRangeTextFieldEditor(Number number, int columns) {
        super(number, columns);
        this.setScientific(true);
    }

    public NumberRangeTextFieldEditor(Number number) {
        super(number);
        this.setScientific(true);
    }

    public NumberRangeTextFieldEditor(int columns) {
        super(columns);
        this.setScientific(true);
    }

    public NumberRangeTextFieldEditor() {
        this.setScientific(true);
    }

    public boolean isInRange() {
        if (this.minimum == null && this.maximum == null) {
            return true;
        }
        Number realNumber = this.getNumber();
        if (realNumber == null) {
            return true;
        }
        if (this.isByteType()) {
            return this.validateByteInRange();
        }
        if (this.isShortType()) {
            return this.validateShortInRange();
        }
        if (this.isIntegerType()) {
            return this.validateIntegerInRange();
        }
        if (this.isLongType()) {
            return this.validateLongInRange();
        }
        if (this.isFloatType()) {
            return this.validateFloatInRange();
        }
        return this.validateDoubleInRange();
    }

    private boolean isByteType() {
        Class dataType = this.getDataType();
        return Byte.class.equals((Object)dataType) || Byte.TYPE.equals(dataType);
    }

    private boolean validateByteInRange() {
        Number number = this.getNumber();
        if (number == null) {
            return true;
        }
        byte value = number.byteValue();
        if (this.minimum != null && value < this.minimum.byteValue()) {
            return false;
        }
        return this.maximum == null || value <= this.maximum.byteValue();
    }

    private boolean isShortType() {
        Class dataType = this.getDataType();
        return Short.class.equals((Object)dataType) || Short.TYPE.equals(dataType);
    }

    private boolean validateShortInRange() {
        Number number = this.getNumber();
        if (number == null) {
            return true;
        }
        short value = number.shortValue();
        if (this.minimum != null && value < this.minimum.shortValue()) {
            return false;
        }
        return this.maximum == null || value <= this.maximum.shortValue();
    }

    private boolean isIntegerType() {
        Class dataType = this.getDataType();
        return Integer.class.equals((Object)dataType) || Integer.TYPE.equals(dataType);
    }

    private boolean validateIntegerInRange() {
        Number number = this.getNumber();
        if (number == null) {
            return true;
        }
        int value = number.intValue();
        if (this.minimum != null && value < this.minimum.intValue()) {
            return false;
        }
        return this.maximum == null || value <= this.maximum.intValue();
    }

    private boolean isLongType() {
        Class dataType = this.getDataType();
        return Long.class.equals((Object)dataType) || Long.TYPE.equals(dataType);
    }

    private boolean validateLongInRange() {
        Number number = this.getNumber();
        if (number == null) {
            return true;
        }
        long value = number.longValue();
        if (this.minimum != null && value < this.minimum.longValue()) {
            return false;
        }
        return this.maximum == null || value <= this.maximum.longValue();
    }

    private boolean isFloatType() {
        Class dataType = this.getDataType();
        return Float.class.equals((Object)dataType) || Float.TYPE.equals(dataType);
    }

    private boolean validateFloatInRange() {
        Number number = this.getNumber();
        if (number == null) {
            return true;
        }
        float value = number.floatValue();
        if (this.minimum != null && value < this.minimum.floatValue()) {
            return false;
        }
        return this.maximum == null || !(value > this.maximum.floatValue());
    }

    private boolean validateDoubleInRange() {
        Number number = this.getNumber();
        if (number == null) {
            return true;
        }
        double value = number.doubleValue();
        if (this.minimum != null && value < this.minimum.doubleValue()) {
            return false;
        }
        return this.maximum == null || !(value > this.maximum.doubleValue());
    }

    public void setMinimum(Number minimum) {
        this.minimum = minimum;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public void setMaximum(Number maximum) {
        this.maximum = maximum;
    }

    public Number getMaximum() {
        return this.maximum;
    }
}

