/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.text.IlvAttributedStringUtil;
import ilog.views.util.text.IlvBaseTextDirectionInterface;
import java.awt.ComponentOrientation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class IlvBidiUtil {
    public static final String LRM = "\u200e";
    public static final String RLM = "\u200f";
    public static final String LRE = "\u202a";
    public static final String RLE = "\u202b";
    public static final String PDF = "\u202c";
    public static final int UNDEFINED_DIRECTION = 0;
    public static final int INHERITED_DIRECTION = 513;
    public static final int COMPONENT_DIRECTION = 514;
    public static final int LEFT_TO_RIGHT = 516;
    public static final int RIGHT_TO_LEFT = 520;
    public static final int CONTEXTUAL_DIRECTION = 527;
    public static final int CONTEXTUAL_LEFT_TO_RIGHT = 526;
    public static final int CONTEXTUAL_RIGHT_TO_LEFT = 525;
    public static final String UNDEFINED_DIRECTION_NAME = "Undefined";
    public static final String INHERITED_DIRECTION_NAME = "Inherited";
    public static final String COMPONENT_DIRECTION_NAME = "Component Orientation";
    public static final String LEFT_TO_RIGHT_NAME = "Left-To-Right";
    public static final String RIGHT_TO_LEFT_NAME = "Right-To-Left";
    public static final String CONTEXTUAL_DIRECTION_NAME = "Contextual";
    public static final String CONTEXTUAL_LEFT_TO_RIGHT_NAME = "Contextual Left-To-Right";
    public static final String CONTEXTUAL_RIGHT_TO_LEFT_NAME = "Contextual Right-To-Left";
    public static final String ADVANCED_BIDI = "ilog.jviews.bidi.support.on";
    public static final String BASE_TEXT_DIRECTION = "baseTextDirection";
    private static final String[] a;
    private static final int[] b;
    private static boolean c;
    private static boolean d;
    private static boolean e;

    private IlvBidiUtil() {
    }

    public static void checkBaseTextDirectionChoice(int n, boolean bl, boolean bl2) {
        if (n == 0 && bl) {
            return;
        }
        if ((n == 526 || n == 525) && bl) {
            return;
        }
        if (n == 514 || n == 516 || n == 520 || n == 527 || n == 513) {
            return;
        }
        throw new IllegalArgumentException("Unsupported base text direction " + n);
    }

    private static boolean a(String string, int n, ComponentOrientation componentOrientation, int n2) {
        if (n == 516) {
            return false;
        }
        if (n == 520) {
            return true;
        }
        return IlvBidiUtil.a(string, componentOrientation, n2);
    }

    private static boolean a(String string, ComponentOrientation componentOrientation, int n) {
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                byte by = Character.getDirectionality(string.charAt(i));
                if (by == 1 || by == 2) {
                    return true;
                }
                if (by != 0) continue;
                return false;
            }
        }
        if (componentOrientation != null) {
            return !componentOrientation.isLeftToRight();
        }
        if (n == 0) {
            return false;
        }
        return n == 520;
    }

    public static boolean isStringRTL(IlvBaseTextDirectionInterface ilvBaseTextDirectionInterface, String string, ComponentOrientation componentOrientation) {
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            return false;
        }
        if (string == null) {
            return false;
        }
        int n = ilvBaseTextDirectionInterface.getResolvedBaseTextDirection();
        if (n == 520) {
            return true;
        }
        if (n == 516) {
            return false;
        }
        return IlvBidiUtil.isStringRTL(string, componentOrientation);
    }

    public static boolean isStringRTL(String string, int n) {
        return IlvBidiUtil.a(string, null, n);
    }

    public static boolean isStringRTL(String string, ComponentOrientation componentOrientation) {
        return IlvBidiUtil.a(string, componentOrientation, 0);
    }

    public static boolean isStringRTL(String string, int n, ComponentOrientation componentOrientation) {
        return IlvBidiUtil.a(string, n, componentOrientation, 0);
    }

    public static boolean isStringRTL(String string, int n, int n2) {
        return IlvBidiUtil.a(string, n, null, n2);
    }

    public static String getStringWithMarks(String string) {
        return IlvBidiUtil.getStringWithMarks(string, true, true, true, false);
    }

    public static String getStringWithMarks(String string, String string2) {
        String string3 = string;
        if (string2 != null) {
            if (string2.equalsIgnoreCase("rtl")) {
                string3 = IlvBidiUtil.getStringWithMarks(string, true, true, true, true);
            } else if (string2.equalsIgnoreCase("ltr")) {
                string3 = IlvBidiUtil.getStringWithMarks(string, false, true, true, true);
            } else if (string2.equalsIgnoreCase("contextual")) {
                string3 = IlvBidiUtil.getStringWithMarks(string, IlvBidiUtil.isStringRTL(string, 0), true, true, true);
            }
        }
        return string3;
    }

    public static String getStringWithMarks(String string, boolean bl, boolean bl2, boolean bl3) {
        return IlvBidiUtil.getStringWithMarks(string, bl, bl2, bl3, false);
    }

    public static String getStringWithMarks(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = bl4 ? (bl ? RLE : LRE) : (bl ? RLM : LRM);
        String string3 = bl4 ? PDF : (bl ? RLM : LRM);
        return (bl2 ? string2 : "") + IlvBidiUtil.removeMarksFromString(string) + (bl3 ? string3 : "");
    }

    public static String getDirectedString(String string, int n, ComponentOrientation componentOrientation) {
        if (n == 527) {
            n = componentOrientation == null ? 526 : (componentOrientation.isLeftToRight() ? 526 : 525);
        }
        return IlvBidiUtil.getDirectedString(string, n);
    }

    public static String getDirectedString(String string, int n) {
        if (!IlvBidiUtil.isAdvancedBidiOn() || string == null || string.length() == 0) {
            return string;
        }
        int n2 = n == 525 ? 520 : 516;
        return (IlvBidiUtil.isStringRTL(string, n, n2) ? RLE : LRE) + string;
    }

    public static String getCombinedString(String string, int n, ComponentOrientation componentOrientation, boolean bl) {
        if (!IlvBidiUtil.isAdvancedBidiOn() || string == null) {
            return string;
        }
        boolean bl2 = IlvBidiUtil.isStringRTL(string, n, componentOrientation);
        if (bl) {
            return IlvBidiUtil.getStringWithMarks(string, bl2, true, false, true);
        }
        return (bl2 ? RLE : LRE) + string;
    }

    public static String getEmbeddableCombinedString(String string, int n, ComponentOrientation componentOrientation, boolean bl) {
        if (!IlvBidiUtil.isAdvancedBidiOn() || string == null) {
            return string;
        }
        boolean bl2 = IlvBidiUtil.isStringRTL(string, n, componentOrientation);
        if (bl) {
            return IlvBidiUtil.getStringWithMarks(string, bl2, true, true, true);
        }
        return (bl2 ? RLE : LRE) + string + PDF;
    }

    public static String getDirectedSimpleHTMLText(String string, int n) {
        if (!IlvBidiUtil.isAdvancedBidiOn() || string == null || string.length() == 0) {
            return string;
        }
        int n2 = n == 525 ? 520 : 516;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '<' && !bl) {
                boolean bl3 = false;
                if (i > n4) {
                    String string2 = IlvSwingUtil.unescapeHTMLCharacterData(string.substring(n4, i));
                    bl3 = IlvBidiUtil.isStringRTL(string2, n, n2);
                    if (IlvBidiUtil.a(string2)) {
                        stringBuffer.append(string2);
                    } else {
                        stringBuffer.append(IlvSwingUtil.escapeForHTMLElementVariableSpaces((bl3 ? RLE : LRE) + string2, true));
                    }
                }
                if (n5 >= 0) {
                    if (string.startsWith("leading\"", n5)) {
                        if (bl3) {
                            stringBuffer.replace(n6, n6 + 8, "right\"");
                        } else {
                            stringBuffer.replace(n6, n6 + 8, "left\"");
                        }
                    } else if (string.startsWith("trailing\"", n5)) {
                        if (bl3) {
                            stringBuffer.replace(n6, n6 + 9, "left\"");
                        } else {
                            stringBuffer.replace(n6, n6 + 9, "right\"");
                        }
                    }
                    n5 = -1;
                    n6 = -1;
                }
                bl = true;
                stringBuffer.append('<');
                if (string.startsWith("<p ", i)) {
                    bl2 = true;
                    continue;
                }
                if (string.startsWith("<div ", i)) {
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                continue;
            }
            if (c == '>' && bl) {
                bl = false;
                stringBuffer.append('>');
                n4 = i + 1;
                continue;
            }
            if (!bl) continue;
            if (bl2) {
                if (string.startsWith(" align=\"", i)) {
                    n5 = i + 8;
                    n6 = stringBuffer.length() + 8;
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static boolean a(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isSpace(c)) continue;
            return false;
        }
        return true;
    }

    public static String removeAllBidiMarks(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return string.replaceAll(LRM, "").replaceAll(RLM, "").replaceAll(LRE, "").replaceAll(RLE, "").replaceAll(PDF, "");
    }

    public static String removeMarksFromString(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        if (IlvBidiUtil.b(string)) {
            ++n;
        }
        if (IlvBidiUtil.c(string)) {
            --n2;
        }
        if (n >= n2) {
            return "";
        }
        return string.substring(n, n2);
    }

    public static AttributedString getAttrStringWithMarks(AttributedString attributedString) {
        return IlvBidiUtil.getAttrStringWithMarks(attributedString, true, true, true);
    }

    public static AttributedString getAttrStringWithMarks(AttributedString attributedString, boolean bl, boolean bl2, boolean bl3) {
        if (attributedString == null || IlvAttributedStringUtil.length(attributedString) == 0) {
            return attributedString;
        }
        String string = bl ? RLM : LRM;
        AttributedString attributedString2 = IlvBidiUtil.removeMarksFromAttrString(attributedString);
        AttributedString attributedString3 = new AttributedString(string);
        IlvAttributedStringUtil.copyAttributes(attributedString, 0, attributedString3, 0, 1);
        AttributedString attributedString4 = new AttributedString(string);
        IlvAttributedStringUtil.copyAttributes(attributedString, IlvAttributedStringUtil.length(attributedString) - 1, attributedString4, 0, 1);
        if (bl2) {
            attributedString2 = IlvAttributedStringUtil.concat(attributedString3, attributedString2);
        }
        if (bl3) {
            attributedString2 = IlvAttributedStringUtil.concat(attributedString2, attributedString4);
        }
        return attributedString2;
    }

    public static AttributedCharacterIterator getIteratorWithMarks(AttributedCharacterIterator attributedCharacterIterator) {
        return IlvBidiUtil.getIteratorWithMarks(attributedCharacterIterator, true, true, true);
    }

    public static AttributedCharacterIterator getIteratorWithMarks(AttributedCharacterIterator attributedCharacterIterator, boolean bl, boolean bl2, boolean bl3) {
        AttributedString attributedString = new AttributedString(attributedCharacterIterator);
        if (attributedString == null || IlvAttributedStringUtil.length(attributedString) == 0) {
            return attributedCharacterIterator;
        }
        String string = bl ? RLM : LRM;
        AttributedString attributedString2 = IlvBidiUtil.removeMarksFromAttrString(attributedString);
        AttributedString attributedString3 = new AttributedString(string);
        IlvAttributedStringUtil.copyAttributes(attributedString, 0, attributedString3, 0, 1);
        AttributedString attributedString4 = new AttributedString(string);
        IlvAttributedStringUtil.copyAttributes(attributedString, IlvAttributedStringUtil.length(attributedString) - 1, attributedString4, 0, 1);
        if (bl2) {
            attributedString2 = IlvAttributedStringUtil.concat(attributedString3, attributedString2);
        }
        if (bl3) {
            attributedString2 = IlvAttributedStringUtil.concat(attributedString2, attributedString4);
        }
        return attributedString2.getIterator();
    }

    public static AttributedString removeMarksFromAttrString(AttributedString attributedString) {
        if (attributedString == null || IlvAttributedStringUtil.length(attributedString) == 0) {
            return attributedString;
        }
        String string = IlvAttributedStringUtil.getString(attributedString);
        int n = 0;
        int n2 = string.length();
        if (IlvBidiUtil.b(string)) {
            ++n;
        }
        if (IlvBidiUtil.c(string)) {
            --n2;
        }
        return IlvAttributedStringUtil.substring(attributedString, n, n2);
    }

    private static boolean b(String string) {
        block5: {
            block4: {
                if (string == null || string.length() == 0) {
                    return false;
                }
                if (string.startsWith(LRM)) break block4;
                if (string.startsWith(RLM)) break block4;
                if (string.startsWith(LRE)) break block4;
                if (!string.startsWith(RLE)) break block5;
            }
            return true;
        }
        return false;
    }

    private static boolean c(String string) {
        block5: {
            block4: {
                if (string == null || string.length() == 0) {
                    return false;
                }
                if (string.endsWith(LRM)) break block4;
                if (string.endsWith(RLM)) break block4;
                if (string.endsWith(PDF)) break block4;
                if (!string.endsWith(PDF)) break block5;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkStrongDir(String string, boolean bl) {
        if (bl) {
            if (string.startsWith(RLE)) return true;
        }
        if (bl) return false;
        if (!string.startsWith(LRE)) return false;
        return true;
    }

    public static String getBaseTextDirectionName(int n) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != n) continue;
            return a[i];
        }
        return UNDEFINED_DIRECTION_NAME;
    }

    public static int getBaseTextDirectionFromName(String string) {
        if (string == null) {
            return 513;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equalsIgnoreCase(string)) continue;
            return b[i];
        }
        return 513;
    }

    public static String bidiTransform(String string, boolean bl) {
        if (string == null || string.length() < 2) {
            return string;
        }
        if (!e) {
            try {
                String string2 = bl ? "IRNNN" : "ILNNN";
                return new BidiEngine().bidiTransform(string, string2, "VLYSN");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("Turning off bidi handling through IlvBidiUtil.bidiTransform because of " + noClassDefFoundError);
                e = true;
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isAdvancedBidiOn() {
        block4: {
            if (IlvBidiUtil.c) break block4;
            try {
                var0 = System.getProperty("ilog.jviews.bidi.support.on");
                if (var0 == null) ** GOTO lbl-1000
                if (var0.equalsIgnoreCase("true")) lbl-1000:
                // 2 sources

                {
                    v0 = true;
                } else {
                    v0 = false;
                }
                IlvBidiUtil.d = v0;
                IlvBidiUtil.c = true;
            }
            catch (Exception var0_1) {
                IlvBidiUtil.d = true;
            }
        }
        return IlvBidiUtil.d;
    }

    public static void setAdvancedBidiOn(boolean bl) {
        d = bl;
        c = true;
    }

    public static DocumentFilter getBidiDocumentHandler(JTextComponent jTextComponent, ComponentOrientation componentOrientation) {
        return new BidiDocumentHandler(jTextComponent, componentOrientation);
    }

    public static void setBidiDocumentHandler(JTextComponent jTextComponent, ComponentOrientation componentOrientation) {
        BidiDocumentHandler bidiDocumentHandler = new BidiDocumentHandler(jTextComponent, componentOrientation);
        ((AbstractDocument)jTextComponent.getDocument()).setDocumentFilter(bidiDocumentHandler);
    }

    static {
        String[] stringArray = new String[8];
        stringArray[0] = UNDEFINED_DIRECTION_NAME;
        stringArray[1] = INHERITED_DIRECTION_NAME;
        stringArray[2] = COMPONENT_DIRECTION_NAME;
        stringArray[3] = LEFT_TO_RIGHT_NAME;
        stringArray[4] = RIGHT_TO_LEFT_NAME;
        stringArray[5] = CONTEXTUAL_DIRECTION_NAME;
        stringArray[6] = CONTEXTUAL_LEFT_TO_RIGHT_NAME;
        stringArray[7] = CONTEXTUAL_RIGHT_TO_LEFT_NAME;
        a = stringArray;
        b = new int[]{0, 513, 514, 516, 520, 527, 526, 525};
        c = false;
    }

    private static class BidiEngine {
        private String a = "IR";

        public String bidiTransform(String string, String string2, String string3) {
            block7: {
                block6: {
                    block5: {
                        if (!string2.equals("")) break block5;
                        if (string3.equals("")) break block6;
                    }
                    if (!string.equals("")) break block7;
                }
                return string;
            }
            String string4 = "^[(I|V)][(L|R|C|D)][(Y|N)][(S|N)][N|H|C|A]$";
            if (!string2.matches(string4) || !string3.matches(string4)) {
                throw new Error("The bidi layout string is wrong!");
            }
            if (string2.equals(string3)) {
                return string;
            }
            this.a = string3.charAt(0) + "R";
            short s = string2.charAt(2) != string3.charAt(2) ? (short)2 : 0;
            String string5 = this.a(string, string2.substring(0, 2), string3.substring(0, 2), s);
            string5 = this.a(string2.substring(3), string3.substring(3), string5);
            return string5;
        }

        public byte checkContextual(String string, String string2) {
            byte by = this.a(string);
            if (by == 0 || by == 1) {
                return by;
            }
            return string2.equals("C") ? (byte)0 : 1;
        }

        /*
         * Unable to fully structure code
         */
        private String a(String var1_1, String var2_2, String var3_3, short var4_4) {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            var5_5 = new Bidi();
                            var6_6 = new Bidi();
                            var7_7 = var2_2.substring(0, 1);
                            var8_8 = var3_3.substring(0, 1);
                            var9_9 = var2_2.substring(1, 2);
                            var10_10 = var3_3.substring(1, 2);
                            var11_11 = var7_7 + var9_9;
                            var12_12 = var8_8 + var10_10;
                            if (var9_9.equals("C")) break block24;
                            if (!var9_9.equals("D")) break block25;
                        }
                        var13_13 = -1;
                        var13_13 = this.a(var1_1);
                        if (var10_10.equals("C")) ** GOTO lbl-1000
                        if (var10_10.equals("D")) lbl-1000:
                        // 2 sources

                        {
                            if (var13_13 == 0 || var13_13 == 1) {
                                this.a = var8_8 + (var13_13 == 0 ? "L" : "R");
                                return var1_1;
                            }
                            var9_9 = var9_9.equals("C") ? "L" : "R";
                            var10_10 = var10_10.equals("C") ? "L" : "R";
                            var11_11 = var7_7 + var9_9;
                            var12_12 = var8_8 + var10_10;
                        } else {
                            var9_9 = var13_13 == 0 || var13_13 == 1 ? (var13_13 == 0 ? "L" : "R") : (var9_9.equals("C") ? "L" : "R");
                            var11_11 = var7_7 + var9_9;
                        }
                    }
                    if (var10_10.equals("C")) break block26;
                    if (!var10_10.equals("D")) break block27;
                }
                var10_10 = (var13_13 = (byte)this.a(var1_1)) == 1 ? "R" : (var13_13 == 0 ? ((var13_13 = (byte)this.b(var1_1)) == 0 ? "L" : "R") : (var10_10.equals("C") ? "L" : "R"));
                var12_12 = var8_8 + var10_10;
            }
            this.a = var8_8 + var10_10;
            if (var11_11.equals(var12_12)) {
                return var1_1;
            }
            var13_13 = 0;
            if (var7_7.equals("I")) {
                if (var12_12.equals("VL")) {
                    if (var9_9.equals("L")) {
                        var13_13 = 0;
                    }
                    if (var9_9.equals("R")) {
                        var13_13 = 1;
                    }
                    var5_5.setPara(var1_1, var13_13, null);
                    return var5_5.writeReordered((int)var4_4);
                }
            }
            if (var7_7.equals("V")) {
                if (var8_8.equals("V")) {
                    return new StringBuffer(var1_1).reverse().toString();
                }
            }
            if (var7_7.equals("I")) {
                if (var12_12.equals("VR")) {
                    var13_13 = var9_9.equals("L") != false ? 0 : 1;
                    var5_5.setPara(var1_1, var13_13, null);
                    var1_1 = var5_5.writeReordered(var4_4 | 16);
                    return var1_1;
                }
            }
            if (var11_11.equals("VL")) {
                if (var12_12.equals("IL")) {
                    var5_5.setPara(var1_1, var13_13, null);
                    return var5_5.writeReordered((int)var4_4);
                }
            }
            if (var7_7.equals("V")) {
                if (var8_8.equals("I") && !var9_9.equals(var10_10)) {
                    var1_1 = new StringBuffer(var1_1).reverse().toString();
                    var1_1 = var9_9.equals("R") ? this.a(var1_1, "IL", "VL", var4_4) : this.a(var1_1, "IR", "VR", var4_4);
                }
            }
            if (var11_11.equals("VR")) {
                if (var12_12.equals("IR")) {
                    var1_1 = this.a(var1_1, "IR", "VR", var4_4);
                }
            }
            if (var7_7.equals("I")) {
                if (var8_8.equals("I")) {
                    if (var9_9.equals("R")) {
                        var13_13 = 1;
                        var5_5.setPara(var1_1, var13_13, null);
                        var1_1 = var5_5.writeReordered(0);
                        var13_13 = 0;
                        var6_6.setPara(var1_1, var13_13, null);
                        var1_1 = var6_6.writeReordered((int)var4_4);
                    } else {
                        var13_13 = 0;
                        var5_5.setPara(var1_1, var13_13, null);
                        var1_1 = var5_5.writeReordered(0);
                        var1_1 = this.a(var1_1, "VL", "IR", var4_4);
                    }
                    return var1_1;
                }
            }
            return var1_1;
        }

        private byte a(String string) {
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                n = UCharacter.getDirection((int)string.charAt(i));
                if (n != 0 && n != 1) continue;
                return n == 0 ? (byte)0 : 1;
            }
            return -1;
        }

        private byte b(String string) {
            return this.a(new StringBuffer(string).reverse().toString());
        }

        private String a(String string, String string2, String string3) {
            if (string.equals(string2)) {
                return string3;
            }
            int n = 0;
            if (string.charAt(0) != string2.charAt(0)) {
                int n2 = n = string2.charAt(0) == 'N' ? 16 : 8;
            }
            if (string.charAt(1) != string2.charAt(1)) {
                switch (string2.charAt(1)) {
                    case 'N': {
                        n |= 0x40;
                        break;
                    }
                    case 'H': {
                        n |= 0x20;
                        break;
                    }
                    case 'C': {
                        n |= 0x60;
                        break;
                    }
                    default: {
                        n |= 0;
                    }
                }
            }
            if (this.a.charAt(0) == 'V' && this.a.charAt(1) == 'L') {
                n |= 4;
            }
            ArabicShaping arabicShaping = new ArabicShaping(n);
            try {
                return arabicShaping.shape(string3);
            }
            catch (ArabicShapingException arabicShapingException) {
                arabicShapingException.printStackTrace();
                return "";
            }
        }
    }

    private static class BidiDocumentHandler
    extends DocumentFilter {
        private final JTextComponent a;
        private final ComponentOrientation b;

        public BidiDocumentHandler(JTextComponent jTextComponent, ComponentOrientation componentOrientation) {
            this.a = jTextComponent;
            this.b = componentOrientation;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            AbstractDocument abstractDocument = (AbstractDocument)filterBypass.getDocument();
            int n2 = abstractDocument.getLength();
            String string2 = (n > 0 ? abstractDocument.getText(0, n) : "") + string + (n < n2 ? abstractDocument.getText(n, n2 - n) : "");
            this.handleDirection(string2);
            super.insertString(filterBypass, n, string, attributeSet);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            AbstractDocument abstractDocument = (AbstractDocument)filterBypass.getDocument();
            int n3 = abstractDocument.getLength();
            String string = (n > 0 ? abstractDocument.getText(0, n) : "") + (n < n3 ? abstractDocument.getText(n + n2, n3 - (n + n2)) : "");
            this.handleDirection(string);
            super.remove(filterBypass, n, n2);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            AbstractDocument abstractDocument = (AbstractDocument)filterBypass.getDocument();
            int n3 = abstractDocument.getLength();
            String string2 = (n > 0 ? abstractDocument.getText(0, n) : "") + string + (n < n3 ? abstractDocument.getText(n + n2, n3 - (n + n2)) : "");
            this.handleDirection(string2);
            super.replace(filterBypass, n, n2, string, attributeSet);
        }

        public void handleDirection(String string) {
            if (IlvBidiUtil.isStringRTL(string, this.b)) {
                if (this.a.getComponentOrientation().isLeftToRight()) {
                    this.a.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                }
            } else if (!this.a.getComponentOrientation().isLeftToRight()) {
                this.a.applyComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        }
    }
}

