/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.font;

import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.swing.IlvJComboBox;
import ilog.views.util.swing.font.DefaultFontSelectionModel;
import ilog.views.util.swing.font.FontSelectionModel;
import ilog.views.util.swing.internal.IlvX11Debug;
import ilog.views.util.swing.layout.IlvBetterFlowLayout;
import ilog.views.util.swing.validation.IlvValidatableForm;
import ilog.views.util.swing.validation.ValidationEvent;
import ilog.views.util.swing.validation.ValidationListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class IlvFontChooser
extends JPanel
implements IlvValidatableForm {
    private final ResourceBundle a = IlvResourceUtil.getBundle("resources.messages", IlvFontChooser.class, IlvLocaleUtil.getCurrentLocale());
    private FontSelectionModel b;
    private IlvJComboBox c;
    private IlvJComboBox d;
    private JCheckBox e;
    private JCheckBox f;
    private JComponent g;
    private boolean h = false;
    private boolean i = false;
    private transient EventListenerList j;
    private static final String[] k;

    public IlvFontChooser() {
        this((Font)null);
    }

    public IlvFontChooser(Font font) {
        if (font == null) {
            font = Font.decode(this.a.getString("IlvFontChooser.DefaultFont"));
        }
        this.a(new DefaultFontSelectionModel(font));
        this.a();
    }

    public IlvFontChooser(FontSelectionModel fontSelectionModel) {
        this.a(fontSelectionModel);
        this.a();
    }

    private void a(FontSelectionModel fontSelectionModel) {
        this.b = fontSelectionModel;
        this.b.addChangeListener(new PreviewListener());
    }

    private void a() {
        this.setLayout(new BorderLayout());
        FontListener fontListener = new FontListener();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new IlvBetterFlowLayout(10));
        this.c = new IlvJComboBox(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        jPanel.add(this.c);
        this.c.addUndelayedActionListener(fontListener);
        this.d = new IlvJComboBox(k);
        this.d.setEditable(true);
        jPanel.add(this.d);
        this.d.addUndelayedActionListener(fontListener);
        this.e = new JCheckBox(this.a.getString("IlvFontChooser.Italic"));
        jPanel.add(this.e);
        this.e.addActionListener(fontListener);
        this.f = new JCheckBox(this.a.getString("IlvFontChooser.Bold"));
        jPanel.add(this.f);
        this.f.addActionListener(fontListener);
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), this.a.getString("IlvFontChooser.Preview")));
        this.g = new JPanel(){
            private final String a;
            {
                this.a = IlvFontChooser.this.a.getString("IlvFontChooser.ExemplarCharacters.Long");
            }

            private int a() {
                FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                return (int)Math.ceil(this.getFont().getStringBounds(this.a, fontRenderContext).getWidth());
            }

            private int b() {
                return this.getFont().getSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(Math.max(this.a(), 256), Math.max(this.b(), 72));
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                graphics.setFont(this.getFont());
                graphics.setColor(this.getForeground());
                Insets insets = this.getInsets();
                Rectangle rectangle = this.getBounds();
                graphics.drawString(this.a, insets.left + (rectangle.width - this.a() + 4) / 2, insets.top + rectangle.height - insets.bottom + this.b() / 2 - 36);
            }
        };
        this.g.setForeground(Color.black);
        this.g.setFont(this.b.getSelectedFont());
        jPanel2.add(this.g);
        this.add((Component)jPanel2, "Center");
        this.updateChooser();
    }

    public Font getSelectedFont() {
        return this.b.getSelectedFont();
    }

    public void setSelectedFont(Font font) {
        this.b.setSelectedFont(font);
    }

    public FontSelectionModel getSelectionModel() {
        return this.b;
    }

    public void setSelectionMode(FontSelectionModel fontSelectionModel) {
        this.b = fontSelectionModel;
    }

    protected void updateChooser() {
        this.h = true;
        if (this.b.getSelectedFont() == null) {
            this.c.setSelectedIndex(-1);
            this.d.setSelectedIndex(-1);
            this.e.setSelected(false);
            this.f.setSelected(false);
        } else {
            this.c.setEditable(true);
            this.c.setSelectedItem(this.b.getSelectedFont().getFamily());
            this.c.setEditable(false);
            this.d.setSelectedItem(Integer.toString(this.b.getSelectedFont().getSize()));
            this.e.setSelected(this.b.getSelectedFont().isItalic());
            this.f.setSelected(this.b.getSelectedFont().isBold());
        }
        this.h = false;
    }

    @Override
    public boolean isAllValid() {
        return this.c.getSelectedIndex() >= 0 && this.d.getSelectedIndex() >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValidationListener(ValidationListener validationListener) {
        if (validationListener == null) {
            throw new IllegalArgumentException();
        }
        IlvFontChooser ilvFontChooser = this;
        synchronized (ilvFontChooser) {
            if (this.j == null) {
                this.j = new EventListenerList();
            }
            this.j.add(ValidationListener.class, validationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValidationListener(ValidationListener validationListener) {
        IlvFontChooser ilvFontChooser = this;
        synchronized (ilvFontChooser) {
            if (this.j != null) {
                this.j.remove(ValidationListener.class, validationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validationPerformed(boolean bl) {
        Object[] objectArray;
        Serializable serializable;
        IlvFontChooser ilvFontChooser = this;
        synchronized (ilvFontChooser) {
            serializable = this.j;
            if (serializable == null) {
                return;
            }
            objectArray = serializable.getListenerList();
        }
        int n = objectArray.length;
        if (n > 0) {
            serializable = new ValidationEvent(this, bl);
            for (int i = 1; i < n; i += 2) {
                ((ValidationListener)objectArray[i]).validationPerformed((ValidationEvent)serializable);
            }
        }
    }

    static {
        String[] stringArray = new String[16];
        stringArray[0] = "8";
        stringArray[1] = "9";
        stringArray[2] = "10";
        stringArray[3] = "11";
        stringArray[4] = "12";
        stringArray[5] = "14";
        stringArray[6] = "16";
        stringArray[7] = "18";
        stringArray[8] = "20";
        stringArray[9] = "22";
        stringArray[10] = "24";
        stringArray[11] = "26";
        stringArray[12] = "28";
        stringArray[13] = "36";
        stringArray[14] = "48";
        stringArray[15] = "72";
        k = stringArray;
    }

    private class PreviewListener
    implements ChangeListener {
        private PreviewListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            IlvFontChooser.this.g.setFont(IlvFontChooser.this.b.getSelectedFont());
            IlvFontChooser.this.g.repaint();
            if (!IlvFontChooser.this.i) {
                IlvFontChooser.this.updateChooser();
            }
        }
    }

    private class FontListener
    implements ActionListener {
        private FontListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (IlvFontChooser.this.h) {
                return;
            }
            IlvX11Debug.invokePopupOrComboBoxAction(new Runnable(){

                @Override
                public void run() {
                    if (IlvFontChooser.this.isAllValid()) {
                        String string = (String)IlvFontChooser.this.c.getSelectedItem();
                        Float f = Float.valueOf((String)IlvFontChooser.this.d.getSelectedItem());
                        boolean bl = IlvFontChooser.this.f.isSelected();
                        boolean bl2 = IlvFontChooser.this.e.isSelected();
                        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>(4);
                        hashMap.put(TextAttribute.FAMILY, string);
                        hashMap.put(TextAttribute.SIZE, f);
                        hashMap.put(TextAttribute.WEIGHT, bl ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
                        hashMap.put(TextAttribute.POSTURE, bl2 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
                        IlvFontChooser.this.i = true;
                        IlvFontChooser.this.b.setSelectedFont(Font.getFont(hashMap));
                        IlvFontChooser.this.i = false;
                        IlvFontChooser.this.validationPerformed(true);
                    } else {
                        IlvFontChooser.this.validationPerformed(false);
                    }
                }
            });
        }
    }
}

