/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.date;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.swing.date.DateEditorDropDown;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class IlvDateTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected DateEditorDropDown editionComponent;
    protected ActionListener actionListener;

    public IlvDateTableCellEditor() {
        ULocale uLocale = IlvLocaleUtil.getCurrentULocale();
        this.editionComponent = new DateEditorDropDown(uLocale);
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("CancelEdition")) {
                    IlvDateTableCellEditor.this.cancelCellEditing();
                } else if (actionEvent.getActionCommand().equals("StopEdition")) {
                    IlvDateTableCellEditor.this.stopCellEditing();
                }
            }
        };
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.editionComponent.setDateFormat(dateFormat);
    }

    public void setTimeFormat(DateFormat dateFormat) {
        this.editionComponent.setTimeFormat(dateFormat);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.editionComponent.setDate(object);
        this.editionComponent.addActionListener(this.actionListener);
        return this.editionComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editionComponent.getDate();
    }

    @Override
    public boolean stopCellEditing() {
        Object object = this.getCellEditorValue();
        if (object != null && super.stopCellEditing()) {
            this.editionComponent.removeActionListener(this.actionListener);
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        this.editionComponent.removeActionListener(this.actionListener);
        super.cancelCellEditing();
    }
}

