/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing;

import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.java2d.internal.IlvPaintToggleButton;
import ilog.views.util.swing.IlvJComboBox;
import ilog.views.util.swing.color.IlvColorChooserPanel;
import ilog.views.util.swing.color.IlvJColorChooser;
import ilog.views.util.swing.internal.IlvFileFilterByExtension;
import ilog.views.util.swing.internal.IlvTextField;
import ilog.views.util.text.IlvNumberFormatFactory;
import ilog.views.util.text.IlvWrappedICUDecimalFormat;
import ilog.views.util.text.internal.IlvFormatUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class SwingFactories
implements SwingConstants {
    protected static boolean init = false;
    protected static boolean initAvailableLocales = false;
    private static JFileChooser a = null;
    private static File b = null;
    private static Locale[] c = null;

    protected SwingFactories() {
    }

    public static synchronized void init() {
        if (init) {
            return;
        }
        init = true;
        a = new JFileChooser(System.getProperty("user.dir") + System.getProperty("file.separator"));
        if (b != null) {
            a.setCurrentDirectory(b);
            b = null;
        }
    }

    public static synchronized void initAvailableLocales() {
        if (initAvailableLocales) {
            return;
        }
        initAvailableLocales = true;
        c = Locale.getAvailableLocales();
    }

    public static JTabbedPane createTabbedPane() {
        JDebugTabbedPane jDebugTabbedPane = new JDebugTabbedPane();
        jDebugTabbedPane.setTabLayoutPolicy(1);
        return jDebugTabbedPane;
    }

    public static Document createDecimalNumberDocument() {
        return SwingFactories.createDecimalNumberDocument(true, false);
    }

    public static Document createDecimalNumberDocument(boolean bl, boolean bl2) {
        return SwingFactories.createDecimalNumberDocument(bl, bl2, IlvLocaleUtil.getCurrentULocale());
    }

    public static Document createDecimalNumberDocument(boolean bl, boolean bl2, ULocale uLocale) {
        return SwingFactories.createDecimalNumberDocument(bl2 ? -1.7976931348623157E308 : 0.0, Double.MAX_VALUE, bl, uLocale);
    }

    public static Document createDecimalNumberDocument(double d, double d2, boolean bl) {
        return SwingFactories.createDecimalNumberDocument(d, d2, bl, IlvLocaleUtil.getCurrentULocale());
    }

    public static Document createDecimalNumberDocument(double d, double d2, boolean bl, ULocale uLocale) {
        return SwingFactories.createDecimalNumberDocument(d, d2, bl, IlvNumberFormatFactory.createInstance(uLocale));
    }

    public static Document createDecimalNumberDocument(double d, double d2, boolean bl, NumberFormat numberFormat) {
        return SwingFactories.createDecimalNumberDocument(d, d2, bl, false, numberFormat);
    }

    public static Document createDecimalNumberDocument(double d, double d2, boolean bl, boolean bl2, NumberFormat numberFormat) {
        return new DecimalNumberDocument(d, d2, bl, bl2, numberFormat);
    }

    public static String getStringForNumberTextComponent(JTextComponent jTextComponent, double d) {
        return SwingFactories.getStringForDecimalNumberDocument(jTextComponent.getDocument(), d);
    }

    public static double getDoubleFromNumberTextComponent(JTextComponent jTextComponent) throws NumberFormatException, ParseException {
        return SwingFactories.getNumberFromDecimalNumberDocument(jTextComponent.getDocument()).doubleValue();
    }

    public static long getLongFromNumberTextComponent(JTextComponent jTextComponent) throws NumberFormatException, ParseException {
        return SwingFactories.getNumberFromDecimalNumberDocument(jTextComponent.getDocument()).longValue();
    }

    public static String getStringForDecimalNumberDocument(Document document, double d) {
        NumberFormat numberFormat;
        NumberFormat numberFormat2 = numberFormat = document == null ? null : SwingFactories.getNumberFormatFromDecimalNumberDocument(document);
        if (numberFormat != null) {
            return numberFormat.format(d);
        }
        return Double.toString(d);
    }

    public static Number getNumberFromDecimalNumberDocument(Document document) throws NumberFormatException, ParseException {
        String string;
        if (document == null) {
            throw new IllegalArgumentException("Missing document");
        }
        try {
            string = document.getText(0, document.getLength()).trim();
        }
        catch (BadLocationException badLocationException) {
            string = "";
        }
        NumberFormat numberFormat = SwingFactories.getNumberFormatFromDecimalNumberDocument(document);
        if (numberFormat != null) {
            return IlvFormatUtil.parseFully(numberFormat, string);
        }
        return Double.valueOf(string);
    }

    public static NumberFormat getNumberFormatFromDecimalNumberDocument(Document document) {
        if (document instanceof DecimalNumberDocument) {
            return ((DecimalNumberDocument)document).a();
        }
        return null;
    }

    public static JTextField createTextField(String string) {
        return SwingFactories.createTextField(null, string, 0);
    }

    public static JTextField createTextField(Document document, String string, int n) {
        return new IlvTextField(document, string, n);
    }

    public static ComboBoxModel createFontListComboBoxModel() {
        return new FontListComboBoxModel();
    }

    public static ComboBoxModel createLnFComboBoxModel() {
        return new LnFComboBoxModel();
    }

    public static ComboBoxModel createLocaleComboBoxModel() {
        return new LocaleComboBoxModel();
    }

    public static JComboBox createColorComboBox() {
        IlvJComboBox ilvJComboBox = new IlvJComboBox((ComboBoxModel)new AutoAddComboBoxModel());
        ((JComboBox)ilvJComboBox).setRenderer(new ColorCellRenderer());
        ilvJComboBox.setEditor(new ColorComboBoxEditor());
        return ilvJComboBox;
    }

    public static JComboBox createPaintComboBox() {
        IlvJComboBox ilvJComboBox = new IlvJComboBox();
        ((JComboBox)ilvJComboBox).setRenderer(new PaintCellRenderer());
        return ilvJComboBox;
    }

    public static DefaultComboBoxModel createAutoAddComboBoxModel() {
        return new AutoAddComboBoxModel();
    }

    public static AbstractColorChooserPanel createColorChooserPanel() {
        return new IlvColorChooserPanel();
    }

    public static File chooseFile(String string, boolean bl, boolean bl2, String string2, String string3, File file, Component component, String string4) {
        FileFilter[] fileFilterArray = null;
        if (string2 != null) {
            String string5 = string2.substring(1);
            fileFilterArray = new FileFilter[]{new IlvFileFilterByExtension(new String[]{string5}, string3 != null ? string3 : MessageFormat.format(SwingFactories.a().getString("file.filter"), string2), false)};
        }
        SwingFactories.setFileFilters(fileFilterArray, 0);
        return SwingFactories.chooseFile(string, bl, bl2, file, component, string4);
    }

    public static void setCurrentDirectory(File file) {
        if (a != null) {
            a.setCurrentDirectory(file);
        } else {
            b = file;
        }
    }

    public static File getCurrentDirectory() {
        if (a != null) {
            return a.getCurrentDirectory();
        }
        return b;
    }

    public static void setFileFilters(FileFilter[] fileFilterArray, int n) {
        SwingFactories.init();
        a.setFileFilter(a.getAcceptAllFileFilter());
        a.resetChoosableFileFilters();
        if (fileFilterArray != null) {
            for (int i = 0; i < fileFilterArray.length; ++i) {
                if (fileFilterArray[i] == null) continue;
                a.addChoosableFileFilter(fileFilterArray[i]);
            }
            if (fileFilterArray[n] != null) {
                a.setFileFilter(fileFilterArray[n]);
            } else {
                a.setFileFilter(fileFilterArray[0]);
            }
        }
    }

    public static FileFilter getSelectedFileFilter() {
        SwingFactories.init();
        return a.getFileFilter();
    }

    public static File chooseFile(String string, boolean bl, boolean bl2, File file, Component component, String string2) {
        int n;
        SwingFactories.init();
        File file2 = null;
        a.setSelectedFile(null);
        a.setDialogTitle(string);
        a.setFileSelectionMode(bl2 ? 1 : 0);
        if (file != null) {
            try {
                a.setCurrentDirectory(file);
                a.setSelectedFile(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        file2 = a.getCurrentDirectory();
        if (string2 != null) {
            a.setApproveButtonText(string2);
        }
        int n2 = n = bl ? a.showSaveDialog(component) : a.showOpenDialog(component);
        if (n == 0) {
            File file3 = a.getSelectedFile();
            if (file3 != null && file3.exists() && bl) {
                int n3 = JOptionPane.showConfirmDialog(a, MessageFormat.format(SwingFactories.a().getString("file.already"), file3.getAbsolutePath()), SwingFactories.a().getString("file.save"), 1, 3);
                switch (n3) {
                    case -1: 
                    case 2: {
                        a.setCurrentDirectory(file2);
                        return null;
                    }
                    case 0: {
                        return file3;
                    }
                    case 1: {
                        return SwingFactories.chooseFile(string, bl, bl2, file3, component, string2);
                    }
                }
            }
            return file3;
        }
        a.setCurrentDirectory(file2);
        return null;
    }

    static ResourceBundle a() {
        return IlvResourceUtil.getBundle("messages", SwingFactories.class, IlvLocaleUtil.getCurrentLocale());
    }

    public static Frame getFrame(Component component) {
        if (component instanceof Frame || component == null) {
            return (Frame)component;
        }
        return SwingFactories.getFrame(component.getParent());
    }

    public static Box createHorizontalBox() {
        return new Box(2);
    }

    public static Box createVerticalBox() {
        return new Box(3);
    }

    public static int getBoxLayoutLineAxis() {
        return 2;
    }

    public static int getBoxLayoutPageAxis() {
        return 3;
    }

    public static int getGridBagLayoutLineStart() {
        return 21;
    }

    public static int getGridBagLayoutLineEnd() {
        return 22;
    }

    public static Dimension getIconComboBoxPreferredSize(JComboBox jComboBox, Dimension dimension) {
        return dimension;
    }

    static class JDebugTabbedPane
    extends JTabbedPane {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processFocusEvent(FocusEvent focusEvent) {
            JDebugTabbedPane jDebugTabbedPane = this;
            synchronized (jDebugTabbedPane) {
                if (this.getTabCount() == 0) {
                    return;
                }
                super.processFocusEvent(focusEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAll() {
            JDebugTabbedPane jDebugTabbedPane = this;
            synchronized (jDebugTabbedPane) {
                if (this.getTabCount() == 0) {
                    return;
                }
                super.removeAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTabAt(int n) {
            JDebugTabbedPane jDebugTabbedPane = this;
            synchronized (jDebugTabbedPane) {
                if (this.getTabCount() == 0) {
                    return;
                }
                super.removeTabAt(n);
            }
        }

        @Override
        public void remove(Component component) {
            if (this.getTabCount() == 0) {
                return;
            }
            super.remove(component);
        }

        @Override
        public void remove(int n) {
            if (this.getTabCount() == 0) {
                return;
            }
            super.remove(n);
        }
    }

    private static class PaintCellRenderer
    extends IlvPaintToggleButton
    implements ListCellRenderer {
        public PaintCellRenderer() {
            this.setEnabled(false);
            this.setPreferredSize(new Dimension(40, 40));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.paint = (Paint)object;
            if (bl) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            }
            return this;
        }
    }

    public static class LocaleComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        int a = 0;
        String b = "System";

        LocaleComboBoxModel() {
            SwingFactories.initAvailableLocales();
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object.equals(this.b)) {
                this.a = 0;
            } else {
                for (int i = 0; i < c.length; ++i) {
                    if (!c[i].getDisplayName(IlvLocaleUtil.getCurrentLocale()).equals(object)) continue;
                    this.a = i + 1;
                    break;
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            if (this.a == 0) {
                return this.b;
            }
            return c[this.a - 1].getDisplayName(IlvLocaleUtil.getCurrentLocale());
        }

        public void setSelectedLocale(Locale locale) {
            for (int i = 0; i < c.length; ++i) {
                if (!locale.equals(c[i])) continue;
                this.a = i + 1;
                break;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Locale getSelectedLocale() {
            if (this.a != 0) {
                return c[this.a - 1];
            }
            return IlvLocaleUtil.getCurrentLocale();
        }

        @Override
        public int getSize() {
            return c.length + 1;
        }

        @Override
        public Object getElementAt(int n) {
            if (n > 0 && n <= c.length) {
                return c[n - 1].getDisplayName(IlvLocaleUtil.getCurrentLocale());
            }
            return this.b;
        }
    }

    public static class LnFComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        UIManager.LookAndFeelInfo[] a = UIManager.getInstalledLookAndFeels();
        int b = this.a.length;
        String c = "System";

        LnFComboBoxModel() {
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object.equals(this.c)) {
                this.b = this.a.length;
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!this.a[i].getName().equals(object)) continue;
                    this.b = i;
                    break;
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            if (this.b == this.a.length) {
                return this.c;
            }
            return this.a[this.b].getName();
        }

        public String getSelectedLnFClassName() {
            if (this.b != this.a.length) {
                return this.a[this.b].getClassName();
            }
            return UIManager.getSystemLookAndFeelClassName();
        }

        @Override
        public int getSize() {
            return this.a.length + 1;
        }

        @Override
        public Object getElementAt(int n) {
            if (n >= 0 && n < this.a.length) {
                return this.a[n].getName();
            }
            return this.c;
        }
    }

    static class DecimalNumberDocument
    extends PlainDocument {
        private double a = -1.7976931348623157E308;
        private double b = Double.MAX_VALUE;
        private boolean c = true;
        private boolean d = true;
        private boolean e = false;
        private NumberFormat f;

        public DecimalNumberDocument(double d, double d2, boolean bl) {
            this(d, d2, bl, null);
        }

        public DecimalNumberDocument(double d, double d2, boolean bl, NumberFormat numberFormat) {
            this(d, d2, bl, false, numberFormat);
        }

        public DecimalNumberDocument(double d, double d2, boolean bl, boolean bl2, NumberFormat numberFormat) {
            this.a = d;
            this.b = d2;
            this.c = bl;
            this.e = bl2;
            this.d = d < 0.0;
            this.f = numberFormat;
            if (this.f != null) {
                this.f.setParseIntegerOnly(!bl);
            }
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            String string2 = this.getText(0, this.getLength());
            string = this.a(string, n);
            super.insertString(n, string, attributeSet);
            String string3 = this.getText(0, this.getLength());
            if (string3 == null || string3.trim().length() == 0 || !this.d && this.f(string3) || !this.c && this.g(string3)) {
                this.c(string2);
            }
        }

        void a(String string) {
            String string2 = null;
            try {
                string2 = this.getText(0, this.getLength());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                double d = this.e(string2);
                if (!this.a(d)) {
                    this.c(string);
                }
            }
            catch (Throwable throwable) {
                this.c(string);
            }
        }

        private boolean a(double d) {
            return d >= this.a && d <= this.b;
        }

        private void c(String string) {
            this.warnInvalidNumber();
            this.d(string);
        }

        protected void warnInvalidNumber() {
            Toolkit.getDefaultToolkit().beep();
        }

        private String a(String string, int n) {
            if (string == null || string.length() == 0) {
                return string;
            }
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            boolean bl = false;
            if (n == 0 && cArray.length > 0 && cArray[0] == this.c()) {
                if (this.d) {
                    stringBuffer.append(cArray[n2++]);
                } else {
                    bl = true;
                }
            } else if (n == 0 && cArray.length > 0 && cArray[0] == this.d()) {
                stringBuffer.append(cArray[n2++]);
            }
            if (this.c && new String(cArray, n2, cArray.length - n2).equals(this.e())) {
                while (n2 < cArray.length) {
                    stringBuffer.append(cArray[n2]);
                    ++n2;
                }
            } else {
                char c;
                char c2;
                char c3 = this.c();
                char c4 = this.d();
                char c5 = c2 = this.c ? (char)this.b() : (char)'\uffffffff';
                char c6 = this.c && this.f instanceof DecimalFormat ? (this.f instanceof IlvWrappedICUDecimalFormat ? (char)((IlvWrappedICUDecimalFormat)this.f).getUnderlyingICUFormat().getDecimalFormatSymbols().getGroupingSeparator() : (char)((DecimalFormat)this.f).getDecimalFormatSymbols().getGroupingSeparator()) : (c = '\uffffffff');
                while (n2 < cArray.length) {
                    if (Character.isDigit(cArray[n2]) || cArray[n2] == 'e' || cArray[n2] == 'E' || cArray[n2] == c3 || cArray[n2] == c4 || cArray[n2] == c2) {
                        if (cArray[n2] == 'e') {
                            cArray[n2] = 69;
                        }
                        stringBuffer.append(cArray[n2]);
                    } else if (cArray[n2] == c) {
                        if (this.e) {
                            stringBuffer.append(cArray[n2]);
                        }
                    } else {
                        bl = true;
                    }
                    ++n2;
                }
            }
            if (bl) {
                this.warnInvalidNumber();
            }
            return stringBuffer.toString();
        }

        private void d(String string) {
            try {
                this.remove(0, this.getLength());
                super.insertString(0, string, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        NumberFormat a() {
            return this.f;
        }

        private double e(String string) throws NumberFormatException, ParseException {
            if (this.c) {
                return this.f != null ? IlvFormatUtil.parseFully(this.f, string).doubleValue() : Double.parseDouble(string);
            }
            return this.f != null ? (double)IlvFormatUtil.parseFully(this.f, string).longValue() : (double)Long.parseLong(string);
        }

        String b(String string) throws NumberFormatException, ParseException {
            if (string == null || string.length() == 0 || this.f == null) {
                return string;
            }
            double d = this.e(string);
            return this.c ? Double.toString(d) : Long.toString((long)d);
        }

        private char b() {
            return this.f instanceof DecimalFormat ? (this.f instanceof IlvWrappedICUDecimalFormat ? ((IlvWrappedICUDecimalFormat)this.f).getUnderlyingICUFormat().getDecimalFormatSymbols().getDecimalSeparator() : ((DecimalFormat)this.f).getDecimalFormatSymbols().getDecimalSeparator()) : (char)'.';
        }

        private char c() {
            return this.f instanceof DecimalFormat ? (this.f instanceof IlvWrappedICUDecimalFormat ? ((IlvWrappedICUDecimalFormat)this.f).getUnderlyingICUFormat().getDecimalFormatSymbols().getMinusSign() : ((DecimalFormat)this.f).getDecimalFormatSymbols().getMinusSign()) : (char)'-';
        }

        private char d() {
            return '+';
        }

        private String e() {
            return this.f instanceof DecimalFormat ? (this.f instanceof IlvWrappedICUDecimalFormat ? ((IlvWrappedICUDecimalFormat)this.f).getUnderlyingICUFormat().getDecimalFormatSymbols().getInfinity() : ((DecimalFormat)this.f).getDecimalFormatSymbols().getInfinity()) : "\u221e";
        }

        private boolean f(String string) {
            return string != null && string.trim().length() == 1 && string.trim().charAt(0) == this.c();
        }

        private boolean g(String string) {
            return string != null && string.trim().length() == 1 && string.trim().charAt(0) == this.b();
        }
    }

    public static class AutoAddComboBoxModel
    extends DefaultComboBoxModel {
        @Override
        public void setSelectedItem(Object object) {
            if (object != null) {
                for (int i = 0; i < this.getSize(); ++i) {
                    if (object instanceof Color && this.getElementAt(i) instanceof Color) {
                        if (((Color)this.getElementAt(i)).getRGB() != ((Color)object).getRGB()) continue;
                        super.setSelectedItem(object);
                        return;
                    }
                    if (!object.equals(this.getElementAt(i))) continue;
                    super.setSelectedItem(object);
                    return;
                }
                this.addElement(object);
                super.setSelectedItem(object);
            }
        }
    }

    public static class FontListComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        String[] a = this.a();
        int b = 0;

        private String[] a() {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }

        @Override
        public void setSelectedItem(Object object) {
            for (int i = 0; i < this.a.length; ++i) {
                if (!this.a[i].equals(object)) continue;
                this.b = i;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.a[this.b];
        }

        @Override
        public int getSize() {
            return this.a.length;
        }

        @Override
        public Object getElementAt(int n) {
            if (n >= 0 && n < this.a.length) {
                return this.a[n];
            }
            return null;
        }
    }

    public static class URLStringChooser
    extends JPanel
    implements ActionListener {
        private JTextField a;

        public URLStringChooser(String string) {
            this.setLayout(new BorderLayout());
            this.a = new JTextField(20);
            this.add((Component)this.a, "Center");
            this.a.setText(string);
            JButton jButton = new JButton(SwingFactories.a().getString("choose.file"));
            this.add((Component)jButton, "After");
            jButton.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.a();
        }

        public final JTextField getTextField() {
            return this.a;
        }

        public final void setURLString(String string) {
            this.a.setText(string);
            this.a.postActionEvent();
        }

        public final String getURLString() {
            return this.a.getText();
        }

        private void a() {
            File file = SwingFactories.chooseFile(SwingFactories.a().getString("choose.image"), false, false, null, null, new File(this.a.getText()), this, SwingFactories.a().getString("ok"));
            if (file != null) {
                URL uRL;
                try {
                    uRL = IlvURLUtil.convertFileToAbsoluteURL(file);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                if (uRL != null) {
                    this.a.setText(uRL.toString());
                }
            }
        }
    }

    private static class ColorComboBoxEditor
    extends JPanel
    implements ComboBoxEditor {
        private JColorChooser a;
        private ColorComponent b;
        private JDialog c;

        ColorComboBoxEditor() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            this.a = new IlvJColorChooser(true, true, false, true, true, false);
            JButton jButton = new JButton("...");
            this.add((Component)jButton, "After");
            jButton.setPreferredSize(new Dimension(20, 16));
            this.b = new ColorComponent();
            this.add((Component)this.b, "Center");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorComboBoxEditor.this.a.setColor(ColorComboBoxEditor.this.b.a());
                    ColorComboBoxEditor.this.c.applyComponentOrientation(ColorComboBoxEditor.this.getComponentOrientation());
                    ColorComboBoxEditor.this.c.setVisible(true);
                }
            });
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.c = JColorChooser.createDialog(SwingFactories.getFrame(this), SwingFactories.a().getString("color"), true, this.a, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ColorComboBoxEditor.this.fireActionPerformed();
                }
            }, null);
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.listenerList.add(ActionListener.class, actionListener);
        }

        protected void fireActionPerformed() {
            this.b.a(this.a.getColor());
            Object[] objectArray = this.listenerList.getListenerList();
            ActionEvent actionEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ActionListener.class) continue;
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, null, 0);
                }
                ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
            }
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.b.a();
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.listenerList.remove(ActionListener.class, actionListener);
        }

        @Override
        public void selectAll() {
        }

        @Override
        public void setItem(Object object) {
            if (object != null) {
                this.b.a((Color)object);
            }
        }
    }

    private static class ColorCellRenderer
    extends ColorComponent
    implements ListCellRenderer {
        ColorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.selectedColor = (Color)object;
            if (bl) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.black)));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            }
            return this;
        }
    }

    private static class ColorComponent
    extends JComponent {
        protected Color selectedColor = null;
        private static Dimension a = new Dimension(60, 16);

        ColorComponent() {
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(this.selectedColor);
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            graphics.fillRect(insets.left, insets.top, dimension.width - (insets.left + insets.right), dimension.height - (insets.top + insets.bottom));
        }

        @Override
        public Dimension getPreferredSize() {
            return a;
        }

        void a(Color color) {
            this.selectedColor = color;
        }

        Color a() {
            return this.selectedColor;
        }
    }
}

