/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.servlet;

import ilog.views.util.IlvResourceUtil;
import ilog.views.util.image.PNGImageEncoder;
import ilog.views.util.internal.IlvLoggerUtil;
import ilog.views.util.servlet.IlvRequestParameter;
import ilog.views.util.servlet.IlvServerActionEvent;
import ilog.views.util.servlet.IlvServletParameterHandler;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class IlvParameterValidationListener
implements EventListener {
    private static Logger a = IlvLoggerUtil.getLogger("ilog.views.util.servlet");
    public static final String ACTION_NAME = "validateRequest";
    public static final String ERROR_MESSAGES = "jviews.security.messages";
    private String[] b = new String[0];
    private IlvServletParameterHandler c;
    private static final String d = "ilog.views.faces.IlvResourceController";
    private static final String e = "facesData";
    private static final String f = "res";
    private boolean g = false;

    public IlvParameterValidationListener() {
    }

    public IlvParameterValidationListener(ServletContext servletContext) {
        this.setParamChecking(servletContext);
    }

    public void setParamChecking(ServletContext servletContext) {
        Boolean bl = (Boolean)servletContext.getAttribute("ilog.views.servlet.CHECK_PARAM");
        if (bl != null) {
            this.g = bl;
        }
    }

    public final synchronized boolean actionPerformed(IlvServerActionEvent ilvServerActionEvent) throws ServletException {
        if (this.g) {
            if (ACTION_NAME.equals(ilvServerActionEvent.getActionName())) {
                try {
                    this.c = this.getServletParametersHandler((ServletRequest)ilvServerActionEvent.getRequest());
                    return this.a(ilvServerActionEvent.getRequest(), ilvServerActionEvent.getResponse());
                }
                catch (IOException iOException) {
                    throw new ServletException((Throwable)iOException);
                }
            }
        }
        return true;
    }

    private boolean a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        boolean bl;
        boolean bl2 = false;
        String string = httpServletRequest.getParameter(e);
        if (string != null) {
            if (string.endsWith(f)) {
                string = d;
            }
        }
        if (this.b.length > 0) {
            for (String string2 : this.b) {
                if (!string2.equals(string)) continue;
                bl2 = true;
                break;
            }
        } else {
            bl2 = true;
        }
        if (bl2 && !(bl = this.validate(httpServletRequest, httpServletResponse))) {
            this.handleViolation(httpServletRequest, httpServletResponse);
            return false;
        }
        return true;
    }

    protected abstract IlvServletParameterHandler getServletParametersHandler(ServletRequest var1);

    protected boolean validate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        String string2;
        boolean bl;
        block13: {
            block12: {
                bl = true;
                string2 = null;
                string = httpServletRequest.getParameter("request");
                if (this.c == null) break block12;
                if (!this.c.isEmpty()) break block13;
            }
            string2 = MessageFormat.format(IlvResourceUtil.getCurrentLocaleString(IlvParameterValidationListener.class, "unknowRequestType"), string);
            httpServletRequest.setAttribute(ERROR_MESSAGES, (Object)string2);
            return false;
        }
        Set<String> set = this.c.getRequiredParameterNames();
        Set set2 = httpServletRequest.getParameterMap().keySet();
        for (String object2 : set) {
            if (set2.contains(object2)) continue;
            string2 = MessageFormat.format(IlvResourceUtil.getCurrentLocaleString(IlvParameterValidationListener.class, "missingParameter"), object2, string);
            httpServletRequest.setAttribute(ERROR_MESSAGES, (Object)string2);
            return false;
        }
        Iterator iterator = set2.iterator();
        block1: while (iterator.hasNext() && bl) {
            String string3 = (String)iterator.next();
            Set<IlvRequestParameter> set3 = this.c.getRequetsParameter(string3);
            if (set3 == null) {
                string2 = MessageFormat.format(IlvResourceUtil.getCurrentLocaleString(IlvParameterValidationListener.class, "unexpectedParameter"), string3, string);
                bl = false;
                break;
            }
            for (IlvRequestParameter ilvRequestParameter : set3) {
                IlvRequestParameter.Comparator comparator;
                String string4;
                if (!ilvRequestParameter.isCompared()) continue;
                String string5 = httpServletRequest.getParameter(string3);
                String string6 = httpServletRequest.getParameter(e);
                if (string == null) {
                    if (string6.equals(f)) {
                        string = f;
                        if (string5 != null) {
                            if (string5.endsWith("?")) {
                                string5 = string5.substring(0, string5.length() - 1);
                            }
                        }
                    }
                }
                if (bl = this.a(string5, string4 = ilvRequestParameter.getValue(), comparator = ilvRequestParameter.getComparator())) continue;
                string2 = MessageFormat.format(IlvResourceUtil.getCurrentLocaleString(IlvParameterValidationListener.class, "unexpectedParameterValue"), string5, string);
                bl = false;
                continue block1;
            }
        }
        if (!bl) {
            httpServletRequest.setAttribute(ERROR_MESSAGES, (Object)string2);
        }
        return bl;
    }

    private boolean a(String string, String string2, IlvRequestParameter.Comparator comparator) {
        boolean bl = false;
        block0 : switch (comparator) {
            case EQUALS: {
                if (!string.equals(string2)) break;
                bl = true;
                break;
            }
            case CONTAINS: {
                if (!string.contains(string2)) break;
                bl = true;
                break;
            }
            case NOT_CONTAINS: {
                if (!string.contains(string2)) {
                    bl = true;
                }
            }
            case STARTS_WITH: {
                String[] stringArray;
                for (String string3 : stringArray = string2.split(";")) {
                    if (!string.startsWith(string3)) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case ENDS_WITH: {
                String[] stringArray;
                for (String string4 : stringArray = string2.split(";")) {
                    if (!string.endsWith(string4)) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case LIST: {
                String[] stringArray;
                for (String string5 : stringArray = string2.split(";")) {
                    if (!string.equalsIgnoreCase(string5)) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
        }
        return bl;
    }

    protected void handleViolation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        Object object = httpServletRequest.getAttribute(ERROR_MESSAGES);
        String string = object == null ? "" : object.toString();
        String string2 = httpServletRequest.getParameter("request");
        String string3 = httpServletRequest.getParameter(e);
        a.log(Level.SEVERE, string);
        if (string2 == null) {
            if (string3.equals(f)) {
                String string4 = httpServletRequest.getParameter(f);
                string2 = "text/javascript";
                if (string4 != null) {
                    if (string4.endsWith("?")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                }
            }
        }
        if (string2.equals("image")) {
            this.c(httpServletRequest, httpServletResponse, string);
        } else if (string2.equals("imagemap")) {
            this.b(httpServletRequest, httpServletResponse, string);
        } else {
            this.a(httpServletRequest, httpServletResponse, string);
        }
    }

    private void a(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/javascript;charset=utf-8");
        httpServletResponse.setHeader("pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        PrintWriter printWriter = new PrintWriter(httpServletResponse.getWriter());
        printWriter.print("alert('" + string + "')");
        printWriter.close();
    }

    private void b(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2;
        block3: {
            block2: {
                string2 = httpServletRequest.getParameter("mapname");
                if (string2 == null) break block2;
                if (string2.length() != 0) break block3;
            }
            string2 = "imagemap";
        }
        httpServletResponse.setContentType("text/javascript;charset=utf-8");
        httpServletResponse.setHeader("pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<map name=\"" + string2 + "\">");
        printWriter.println(string);
        printWriter.println("</map>");
        printWriter.close();
    }

    private void c(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("image/jpeg;charset=iso-8859-1");
        int n = httpServletRequest.getParameter("width") == null ? 400 : Integer.parseInt(httpServletRequest.getParameter("width"));
        int n2 = httpServletRequest.getParameter("height") == null ? 300 : Integer.parseInt(httpServletRequest.getParameter("height"));
        boolean bl = Boolean.parseBoolean(httpServletRequest.getParameter("overview"));
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (!bl) {
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setFont(new Font("Serif", 0, 18));
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            Rectangle2D rectangle2D = textLayout.getBounds();
            int n3 = (int)Math.ceil(rectangle2D.getWidth());
            int n4 = (int)Math.ceil(rectangle2D.getHeight());
            int n5 = Math.max(n, n3);
            int n6 = Math.max(n2, n4);
            if ((double)n5 / (double)n < (double)n6 / (double)n2) {
                n6 = Math.max(n6, (int)Math.round((double)n5 / (double)n * (double)n2));
            } else {
                n5 = Math.max(n5, (int)Math.round((double)n6 / (double)n2 * (double)n));
            }
            if (n5 > n || n6 > n2) {
                graphics2D.dispose();
                bufferedImage = new BufferedImage(n5, n6, 1);
                graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setFont(new Font("Serif", 0, 18));
            }
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, n5, n6);
            graphics2D.setColor(Color.RED);
            graphics2D.drawString(string, (n5 - n3) / 2, (n6 - n4) / 2);
            graphics2D.dispose();
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder((OutputStream)servletOutputStream, null);
            pNGImageEncoder.encode(bufferedImage);
        }
        servletOutputStream.close();
    }
}

