/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.psheet;

import ilog.views.util.beans.editor.IlvInternationalizedPropertyEditor;
import ilog.views.util.psheet.CustomPropertyEditor;
import ilog.views.util.psheet.IlvMultipleSelectionPropertyDescriptor;
import ilog.views.util.psheet.IlvPropertyDescriptor;
import ilog.views.util.psheet.IlvPropertySheet;
import ilog.views.util.swing.IlvJComboBox;
import ilog.views.util.swing.SwingFactories;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import java.text.MessageFormat;
import java.util.EventObject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

class PropertyCellEditor
extends ComponentAdapter
implements TableCellEditor,
ActionListener {
    private IlvPropertySheet a;
    protected EventListenerList listenerList = new EventListenerList();
    protected JComponent editorComponent;
    private JComboBox b;
    private JTextField c;
    private JTextArea d;
    private CustomPropertyEditor e;
    protected ChangeEvent changeEvent = null;

    PropertyCellEditor(IlvPropertySheet ilvPropertySheet) {
        this.a = ilvPropertySheet;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.stopCellEditing();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.a.getTable().removeEditor();
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.add(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listenerList.remove(CellEditorListener.class, cellEditorListener);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.editorComponent instanceof JTextField) {
            return ((JTextField)this.editorComponent).getText();
        }
        if (this.editorComponent instanceof JComboBox) {
            Object object = ((JComboBox)this.editorComponent).getSelectedItem();
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        if (this.editorComponent instanceof JScrollPane) {
            return this.d.getText();
        }
        return ((CustomPropertyEditor)this.editorComponent).getValue();
    }

    public boolean startCellEditing(EventObject eventObject) {
        if (this.editorComponent instanceof JComboBox) {
            return eventObject instanceof AWTEvent;
        }
        if (this.editorComponent instanceof JTextField || this.editorComponent instanceof JScrollPane) {
            this.editorComponent.requestFocus();
        }
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return !(eventObject instanceof MouseEvent) || ((MouseEvent)eventObject).getClickCount() >= 1;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        boolean bl = true;
        if (this.isCellEditable(eventObject) && (eventObject == null || ((MouseEvent)eventObject).getClickCount() >= 1)) {
            bl = this.startCellEditing(eventObject);
        }
        return bl;
    }

    @Override
    public boolean stopCellEditing() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != CellEditorListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
        }
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        PropertyEditor propertyEditor = this.a.getEditors()[n];
        if (propertyEditor.supportsCustomEditor()) {
            if (this.e == null) {
                this.e = new CustomPropertyEditor(SwingFactories.getFrame(jTable), this.a.getResourceBundle());
            }
            this.e.setEditor(propertyEditor);
            this.e.setDefaultTextDirection(this.a.getDefaultTextDirection());
            IlvPropertyDescriptor ilvPropertyDescriptor = this.a.getPropertyDescriptors()[n];
            if (ilvPropertyDescriptor instanceof IlvMultipleSelectionPropertyDescriptor) {
                try {
                    this.e.a(!((IlvMultipleSelectionPropertyDescriptor)ilvPropertyDescriptor).sameValues(this.a.getTarget()));
                }
                catch (Exception exception) {
                    this.e.a(false);
                }
            }
            String string = ilvPropertyDescriptor.getDisplayName();
            this.e.a(MessageFormat.format(this.a.getResourceBundle().getString("dialog.title"), string));
            this.e.a().addPropertyChangeListener(this.a.y);
            this.e.a().addComponentListener(this);
            this.editorComponent = this.e;
        } else if (propertyEditor.getTags() != null) {
            if (this.b == null) {
                this.b = new IlvJComboBox();
                this.b.setBorder(null);
                this.b.setFont(jTable.getFont());
                this.b.addActionListener(this);
            }
            this.editorComponent = this.b;
            String[] stringArray = propertyEditor instanceof IlvInternationalizedPropertyEditor ? ((IlvInternationalizedPropertyEditor)propertyEditor).getValuesAsLocalizedText() : propertyEditor.getTags();
            if (this.b.getItemCount() > 0) {
                this.b.removeAllItems();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                this.b.addItem(stringArray[i]);
            }
            this.b.setSelectedItem(IlvPropertySheet.a(propertyEditor));
            if (IlvBidiUtil.isAdvancedBidiOn()) {
                this.editorComponent.applyComponentOrientation(IlvBidiUtil.isStringRTL(IlvPropertySheet.a(propertyEditor), this.a.getDefaultTextDirection(), null) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
            }
        } else {
            String string = IlvPropertySheet.a(propertyEditor);
            if (string.indexOf(10) == -1) {
                if (this.c == null) {
                    this.c = new JTextField(){

                        @Override
                        protected void processComponentKeyEvent(KeyEvent keyEvent) {
                            if (keyEvent.getID() == 401 && (keyEvent.getKeyChar() == 'F' || keyEvent.getKeyChar() == 'Z' || keyEvent.getKeyChar() == 'U' || keyEvent.getKeyChar() == 'I')) {
                                keyEvent.consume();
                            }
                            super.processComponentKeyEvent(keyEvent);
                        }
                    };
                    this.c.setBorder(null);
                    this.c.setFont(jTable.getFont());
                    this.c.addActionListener(this);
                    this.c.addFocusListener(new FocusListener(){

                        @Override
                        public void focusGained(FocusEvent focusEvent) {
                        }

                        @Override
                        public void focusLost(FocusEvent focusEvent) {
                            if (focusEvent.getOppositeComponent() != PropertyCellEditor.this.a.getTable()) {
                                PropertyCellEditor.this.stopCellEditing();
                            }
                        }
                    });
                }
                this.c.setText(IlvPropertySheet.a(propertyEditor));
                if (IlvBidiUtil.isAdvancedBidiOn()) {
                    this.c.applyComponentOrientation(IlvBidiUtil.isStringRTL(IlvPropertySheet.a(propertyEditor), this.a.getDefaultTextDirection(), null) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
                    this.c.setText(this.c.getText());
                    if (this.a.getDefaultTextDirection() == 527) {
                        IlvBidiUtil.setBidiDocumentHandler(this.c, jTable.getComponentOrientation());
                    }
                }
                this.editorComponent = this.c;
            } else {
                if (this.d == null) {
                    this.d = new JTextArea(){

                        @Override
                        protected void processComponentKeyEvent(KeyEvent keyEvent) {
                            if (keyEvent.getID() == 401 && (keyEvent.getKeyChar() == 'F' || keyEvent.getKeyChar() == 'Z' || keyEvent.getKeyChar() == 'U' || keyEvent.getKeyChar() == 'I')) {
                                keyEvent.consume();
                            }
                            super.processComponentKeyEvent(keyEvent);
                        }
                    };
                    JScrollPane jScrollPane = new JScrollPane(this.d, 21, 31);
                    this.d.setBorder(null);
                    this.d.setFont(jTable.getFont());
                }
                this.d.setText(IlvPropertySheet.a(propertyEditor));
                if (IlvBidiUtil.isAdvancedBidiOn()) {
                    this.d.applyComponentOrientation(IlvBidiUtil.isStringRTL(IlvPropertySheet.a(propertyEditor), this.a.getDefaultTextDirection(), null) ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT);
                    this.d.setText(this.d.getText());
                    if (this.a.getDefaultTextDirection() == 527) {
                        IlvBidiUtil.setBidiDocumentHandler(this.d, jTable.getComponentOrientation());
                    }
                }
                this.editorComponent = (JComponent)this.d.getParent().getParent();
                this.editorComponent.applyComponentOrientation(this.d.getComponentOrientation());
            }
        }
        this.editorComponent.setForeground(jTable.getForeground());
        this.editorComponent.setBackground(jTable.getBackground());
        jTable.setRowSelectionInterval(n, n);
        return this.editorComponent;
    }
}

