/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.java2d.internal;

public class IlvMath {
    private IlvMath() {
    }

    public static int calcLinearSolution(double d, double d2, double[] dArray) {
        if (d == 0.0) {
            if (d2 == 0.0) {
                return -1;
            }
            return 0;
        }
        dArray[0] = -d2 / d;
        return 1;
    }

    public static int calcQuadSolution(double d, double d2, double d3, double[] dArray) {
        if (d == 0.0) {
            return IlvMath.calcLinearSolution(d2, d3, dArray);
        }
        double d4 = d2 * d2 - 4.0 * d * d3;
        if (d4 < 0.0) {
            return 0;
        }
        if (d4 == 0.0) {
            dArray[0] = -d2 / (2.0 * d);
            return 1;
        }
        double d5 = Math.sqrt(d4);
        dArray[0] = (d5 - d2) / (2.0 * d);
        dArray[1] = (-d5 - d2) / (2.0 * d);
        return 2;
    }

    public static int calcCubicSolution(double d, double d2, double d3, double d4, double[] dArray) {
        if (d == 0.0) {
            return IlvMath.calcQuadSolution(d2, d3, d4, dArray);
        }
        double d5 = 0.3333333333333333;
        double d6 = d2 / (3.0 * d);
        double d7 = 3.0 * d * d;
        double d8 = (3.0 * d * d3 - d2 * d2) / d7;
        double d9 = (2.0 * d2 * d2 * d2 - 9.0 * d * d2 * d3 + 9.0 * d7 * d4) / (9.0 * d7 * d);
        if (d8 == 0.0) {
            double d10 = d9 >= 0.0 ? 1.0 : -1.0;
            dArray[0] = -d10 * Math.pow(d10 * d9, d5) - d6;
            return 1;
        }
        double d11 = d8 * d8 * d8 / 27.0;
        double d12 = d9 * d9 / 4.0;
        double d13 = d11 + d12;
        if (d13 < 0.0) {
            double d14 = Math.sqrt(-d11);
            double d15 = Math.acos(-d9 / (2.0 * d14));
            double d16 = d14 >= 0.0 ? 1.0 : -1.0;
            double d17 = 2.0 * d16 * Math.pow(d16 * d14, d5);
            dArray[0] = d17 * Math.cos(d15 / 3.0) - d6;
            dArray[1] = d17 * Math.cos((d15 + Math.PI * 2) / 3.0) - d6;
            dArray[2] = d17 * Math.cos((d15 + Math.PI * 4) / 3.0) - d6;
            return 3;
        }
        double d18 = d9 > 0.0 ? d11 / (Math.sqrt(d13) + d9 / 2.0) : Math.sqrt(d13) - d9 / 2.0;
        double d19 = d18 >= 0.0 ? 1.0 : -1.0;
        double d20 = d19 * Math.pow(d19 * d18, d5);
        if (d20 == 0.0) {
            d19 = d9 >= 0.0 ? 1.0 : -1.0;
            dArray[0] = -d19 * Math.pow(d19 * d9, d5) - d6;
            return 1;
        }
        double d21 = -d8 / (3.0 * d20);
        if (d20 == d21) {
            dArray[0] = d20 + d21 - d6;
            dArray[1] = -0.5 * (d20 + d21) - d6;
            return 2;
        }
        dArray[0] = d20 + d21 - d6;
        return 1;
    }

    public static int calcPolynomialSolution(int n, double[] dArray, double[] dArray2) {
        while (n > 0 && dArray[n] == 0.0) {
            --n;
        }
        switch (n) {
            case 0: {
                return dArray[0] == 0.0 ? -1 : 0;
            }
            case 1: {
                return IlvMath.calcLinearSolution(dArray[1], dArray[0], dArray2);
            }
            case 2: {
                return IlvMath.calcQuadSolution(dArray[2], dArray[1], dArray[0], dArray2);
            }
            case 3: {
                return IlvMath.calcCubicSolution(dArray[3], dArray[2], dArray[1], dArray[0], dArray2);
            }
        }
        return IlvMath.a(n, dArray, -1.7976931348623157E308, Double.MAX_VALUE, dArray2);
    }

    public static int calcPolynomialSolution(int n, double[] dArray, double d, double d2, double[] dArray2) {
        while (n > 0 && dArray[n] == 0.0) {
            --n;
        }
        switch (n) {
            case 0: {
                return dArray[0] == 0.0 ? -1 : 0;
            }
            case 1: {
                return IlvMath.a(IlvMath.calcLinearSolution(dArray[1], dArray[0], dArray2), dArray2, d, d2);
            }
            case 2: {
                return IlvMath.a(IlvMath.calcQuadSolution(dArray[2], dArray[1], dArray[0], dArray2), dArray2, d, d2);
            }
            case 3: {
                return IlvMath.a(IlvMath.calcCubicSolution(dArray[3], dArray[2], dArray[1], dArray[0], dArray2), dArray2, d, d2);
            }
        }
        return IlvMath.a(n, dArray, d, d2, dArray2);
    }

    private static int a(int n, double[] dArray, double d, double d2) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!(dArray[i] >= d) || !(dArray[i] <= d2)) continue;
            dArray[n2++] = dArray[i];
        }
        return n2;
    }

    private static int a(int n, double[] dArray, double d, double d2, double[] dArray2) {
        assert (n > 0);
        assert (dArray[n] != 0.0);
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 = Math.max(d3, Math.abs(dArray[i]));
        }
        double d4 = d3 / Math.abs(dArray[n]) + 1.0;
        if (d < -d4) {
            d = -d4;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        if (d < d2) {
            int n2;
            int n3;
            int n4;
            double[][] dArrayArray;
            if (dArray.length > n + 1) {
                double[] dArray3 = new double[n + 1];
                System.arraycopy(dArray, 0, dArray3, 0, n + 1);
                dArray = dArray3;
            }
            while (true) {
                dArrayArray = new double[n + 1][];
                n4 = 0;
                dArrayArray[n4++] = dArray;
                double[] dArray4 = new double[n];
                for (n3 = 0; n3 < n; ++n3) {
                    dArray4[n3] = dArray[n3 + 1] * (double)(n3 + 1);
                }
                dArrayArray[n4++] = dArray4;
                while ((dArray4 = IlvMath.b(dArrayArray[n4 - 2], dArrayArray[n4 - 1])).length != 0) {
                    dArrayArray[n4++] = dArray4;
                }
                if (dArrayArray[n4 - 1].length <= 1) break;
                dArray = IlvMath.a(dArray, dArrayArray[n4 - 1]);
                n = dArray.length - 1;
                switch (n) {
                    case 1: {
                        return IlvMath.a(IlvMath.calcLinearSolution(dArray[1], dArray[0], dArray2), dArray2, d, d2);
                    }
                    case 2: {
                        return IlvMath.a(IlvMath.calcQuadSolution(dArray[2], dArray[1], dArray[0], dArray2), dArray2, d, d2);
                    }
                    case 3: {
                        return IlvMath.a(IlvMath.calcCubicSolution(dArray[3], dArray[2], dArray[1], dArray[0], dArray2), dArray2, d, d2);
                    }
                }
            }
            int n5 = 0;
            n3 = IlvMath.a(dArrayArray, n4, d);
            if (n3 < 0) {
                n3 = -1 - n3;
                dArray2[n5++] = d;
            }
            if ((n2 = IlvMath.a(dArrayArray, n4, d2)) < 0 && (n2 = -1 - n2) < n3) {
                dArray2[n5++] = d2;
                ++n2;
            }
            return IlvMath.a(dArrayArray, n4, d, n3, d2, n2, n5, dArray2);
        }
        if (d == d2) {
            if (IlvMath.a(dArray, d) == 0.0) {
                dArray2[0] = d;
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private static int a(double[][] dArray, int n, double d, int n2, double d2, int n3, int n4, double[] dArray2) {
        if (n2 > n3) {
            double d3 = (d + d2) * 0.5;
            if (d < d3 && d3 < d2) {
                int n5;
                int n6;
                int n7 = n6 = IlvMath.a(dArray, n, d3);
                if (n6 < 0) {
                    n7 = n6 = -1 - n6;
                    if (n6 >= n3 && n6 < n2) {
                        dArray2[n4++] = d3;
                        n7 = n6 + 1;
                    }
                }
                if (n7 > n2) {
                    n5 = n7 - n2;
                    n6 -= n5;
                    n7 -= n5;
                }
                if (n6 < n3) {
                    n5 = n3 - n6;
                    n6 += n5;
                    n7 += n5;
                }
                n4 = IlvMath.a(dArray, n, d, n2, d3, n7, n4, dArray2);
                n4 = IlvMath.a(dArray, n, d3, n6, d2, n3, n4, dArray2);
            } else {
                dArray2[n4++] = d3;
            }
        }
        return n4;
    }

    private static int a(double[][] dArray, int n, double d) {
        boolean bl = dArray[n - 1][0] < 0.0;
        int n2 = 0;
        for (int i = n - 2; i >= 1; --i) {
            boolean bl2;
            double d2 = IlvMath.a(dArray[i], d);
            if (d2 == 0.0) continue;
            boolean bl3 = bl2 = d2 < 0.0;
            if (bl2 != bl) {
                ++n2;
            }
            bl = bl2;
        }
        double d3 = IlvMath.a(dArray[0], d);
        if (d3 != 0.0) {
            boolean bl4;
            boolean bl5 = bl4 = d3 < 0.0;
            if (bl4 != bl) {
                ++n2;
            }
            bl = bl4;
            return n2;
        }
        return -1 - n2;
    }

    private static double a(double[] dArray, double d) {
        int n = dArray.length - 1;
        double d2 = dArray[n];
        for (int i = n - 1; i >= 0; --i) {
            d2 = d2 * d + dArray[i];
        }
        return d2;
    }

    private static double[] a(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray2.length - 1;
        double[] dArray3 = new double[n + 1];
        System.arraycopy(dArray, 0, dArray3, 0, n + 1);
        double[] dArray4 = new double[n - n2 + 1];
        for (n = dArray.length - 1; n >= n2; --n) {
            double d;
            dArray4[n - n2] = d = dArray3[n] / dArray2[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = i + n - n2;
                dArray3[n3] = dArray3[n3] - d * dArray2[i];
            }
        }
        return dArray4;
    }

    private static double[] b(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray2.length - 1;
        double[] dArray3 = new double[n + 1];
        System.arraycopy(dArray, 0, dArray3, 0, n + 1);
        for (n = dArray.length - 1; n >= n2; --n) {
            double d = dArray3[n] / dArray2[n2];
            for (int i = 0; i < n2; ++i) {
                int n3 = i + n - n2;
                dArray3[n3] = dArray3[n3] - d * dArray2[i];
            }
        }
        while (n >= 0 && dArray3[n] == 0.0) {
            --n;
        }
        double[] dArray4 = new double[n + 1];
        for (int i = 0; i <= n; ++i) {
            dArray4[i] = -dArray3[i];
        }
        return dArray4;
    }
}

