/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class IlvStreamTokenizer {
    public double nval;
    public String sval;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    protected static final int TT_UNKNOWN = -4;
    public int ttype = -4;
    protected byte[] tokenTypes = new byte[256];
    protected static final byte TOKEN_COMMENT = 1;
    protected static final byte TOKEN_QUOTE = 2;
    protected static final byte TOKEN_WHITE = 4;
    protected static final byte TOKEN_WORD = 8;
    protected static final byte TOKEN_DIGIT = 16;
    protected int lineNumber = 1;
    protected boolean forceLowercase;
    protected boolean isEOLSignificant;
    protected boolean slashStarComments;
    protected boolean slashSlashComments;
    protected boolean pushBackToken;
    protected boolean lastCr;
    protected int nextChar;
    protected InputStream inStream;
    protected Reader inReader;
    protected int peekChar = -2;
    protected StringBuffer quoteString;

    public IlvStreamTokenizer() {
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.commentChar(47);
        this.quoteChar(34);
        this.quoteChar(39);
        this.parseNumbers();
    }

    @Deprecated
    public IlvStreamTokenizer(InputStream inputStream) {
        this();
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.inStream = inputStream;
    }

    public IlvStreamTokenizer(Reader reader) {
        this();
        if (reader == null) {
            throw new NullPointerException();
        }
        this.inReader = reader;
    }

    public void commentChar(int n) {
        if (0 <= n && n < this.tokenTypes.length) {
            this.tokenTypes[n] = 1;
        }
    }

    public void eolIsSignificant(boolean bl) {
        this.isEOLSignificant = bl;
    }

    public int lineno() {
        return this.lineNumber;
    }

    public void lowerCaseMode(boolean bl) {
        this.forceLowercase = bl;
    }

    public int nextToken() throws IOException {
        int n;
        int n2;
        if (this.pushBackToken) {
            this.pushBackToken = false;
            if (this.ttype != -4) {
                return this.ttype;
            }
        }
        this.sval = null;
        int n3 = n2 = this.peekChar == -2 ? this.read() : this.peekChar;
        if (this.lastCr && n2 == 10) {
            this.lastCr = false;
            n2 = this.read();
        }
        if (n2 == -1) {
            this.ttype = -1;
            return -1;
        }
        int n4 = n = n2 > 255 ? 8 : this.tokenTypes[n2];
        while ((n & 4) != 0) {
            if (n2 == 13) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.lastCr = true;
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n2 = this.read();
                if (n2 == 10) {
                    n2 = this.read();
                }
            } else if (n2 == 10) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n2 = this.read();
            } else {
                n2 = this.read();
            }
            if (n2 == -1) {
                this.ttype = -1;
                return -1;
            }
            n = n2 > 255 ? 8 : this.tokenTypes[n2];
        }
        if ((n & 0x10) != 0) {
            boolean bl;
            StringBuilder stringBuilder = new StringBuilder(20);
            boolean bl2 = false;
            boolean bl3 = bl = n2 == 45;
            do {
                if (n2 == 46) {
                    bl2 = true;
                }
                stringBuilder.append((char)n2);
            } while ((n2 = this.read()) >= 48 && n2 <= 57 || !bl2 && n2 == 46);
            this.peekChar = n2;
            if (bl && stringBuilder.length() == 1) {
                this.ttype = 45;
                return 45;
            }
            try {
                this.nval = Double.valueOf(stringBuilder.toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.nval = 0.0;
            }
            this.ttype = -2;
            return -2;
        }
        if ((n & 8) != 0) {
            StringBuffer stringBuffer = new StringBuffer(20);
            do {
                stringBuffer.append((char)n2);
            } while ((n2 = this.read()) != -1 && (n2 >= 256 || (this.tokenTypes[n2] & 0x18) != 0));
            this.peekChar = n2;
            this.sval = this.forceLowercase ? stringBuffer.toString().toLowerCase() : stringBuffer.toString();
            this.ttype = -3;
            return -3;
        }
        if (n == 2) {
            int n5 = n2;
            this.quoteString = new StringBuffer();
            int n6 = this.read();
            while (n6 >= 0 && n6 != n5 && n6 != 13 && n6 != 10) {
                boolean bl = true;
                this.getNextChar();
                if (n6 == 92) {
                    n6 = this.handleBackslashInString();
                }
                if (!bl) continue;
                this.quoteString.append((char)n6);
                n6 = this.nextChar;
            }
            if (n6 == n5) {
                n6 = this.read();
            }
            this.peekChar = n6;
            this.ttype = n5;
            this.sval = this.quoteString.toString();
            return this.ttype;
        }
        if (n2 == 47 && (this.slashSlashComments || this.slashStarComments)) {
            n2 = this.read();
            if (n2 == 42 && this.slashStarComments) {
                int n7 = this.read();
                while (true) {
                    n2 = n7;
                    n7 = this.read();
                    if (n2 == -1) {
                        this.peekChar = -1;
                        this.ttype = -1;
                        return -1;
                    }
                    if (n2 == 13) {
                        if (n7 == 10) {
                            n7 = this.read();
                        }
                        ++this.lineNumber;
                        continue;
                    }
                    if (n2 == 10) {
                        ++this.lineNumber;
                        continue;
                    }
                    if (n2 == 42 && n7 == 47) break;
                }
                this.peekChar = this.read();
                return this.nextToken();
            }
            if (n2 == 47 && this.slashSlashComments) {
                while ((n2 = this.read()) >= 0 && n2 != 13 && n2 != 10) {
                }
                this.peekChar = n2;
                return this.nextToken();
            }
            if (n != 1) {
                this.peekChar = n2;
                this.ttype = 47;
                return 47;
            }
        }
        if (n == 1) {
            while ((n2 = this.read()) >= 0 && n2 != 13 && n2 != 10) {
            }
            this.peekChar = n2;
            return this.nextToken();
        }
        this.peekChar = this.read();
        this.ttype = n2;
        return this.ttype;
    }

    protected int getNextChar() {
        try {
            this.nextChar = this.inStream == null ? (int)((char)this.inReader.read()) : this.inStream.read();
            if (this.nextChar == -1) {
                this.nextChar = -1;
            }
        }
        catch (IOException iOException) {
            this.nextChar = -1;
        }
        return this.nextChar;
    }

    protected char handleBackslashInString() {
        char c;
        boolean bl = true;
        if (this.nextChar <= 55 && this.nextChar >= 48) {
            int n = this.nextChar - 48;
            this.nextChar = this.getNextChar();
            if (this.nextChar > 55 || this.nextChar < 48) {
                bl = false;
            } else {
                n = n * 8 + (this.nextChar - 48);
                this.nextChar = this.getNextChar();
                if (n > 31 || this.nextChar > 55 || this.nextChar < 48) {
                    bl = false;
                } else {
                    n = n * 8 + (this.nextChar - 48);
                }
            }
            if (!bl) {
                return (char)n;
            }
            c = (char)n;
        } else {
            switch (this.nextChar) {
                case 97: {
                    c = '\u0007';
                    break;
                }
                case 98: {
                    c = '\b';
                    break;
                }
                case 102: {
                    c = '\f';
                    break;
                }
                case 110: {
                    c = '\n';
                    break;
                }
                case 114: {
                    c = '\r';
                    break;
                }
                case 116: {
                    c = '\t';
                    break;
                }
                case 118: {
                    c = '\u000b';
                    break;
                }
                default: {
                    c = (char)this.nextChar;
                }
            }
        }
        this.getNextChar();
        return c;
    }

    public void ordinaryChar(int n) {
        if (0 <= n && n < this.tokenTypes.length) {
            this.tokenTypes[n] = 0;
        }
    }

    public void ordinaryChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.tokenTypes.length) {
            n2 = this.tokenTypes.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            this.tokenTypes[i] = 0;
        }
    }

    public void parseNumbers() {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            this.tokenTypes[n2] = (byte)(this.tokenTypes[n2] | 0x10);
        }
        this.tokenTypes[46] = (byte)(this.tokenTypes[46] | 0x10);
        this.tokenTypes[45] = (byte)(this.tokenTypes[45] | 0x10);
    }

    public void pushBack() {
        this.pushBackToken = true;
    }

    public void quoteChar(int n) {
        if (0 <= n && n < this.tokenTypes.length) {
            this.tokenTypes[n] = 2;
        }
    }

    protected int read() throws IOException {
        if (this.inStream == null) {
            return this.inReader.read();
        }
        return this.inStream.read();
    }

    public void resetSyntax() {
        for (int i = 0; i < 256; ++i) {
            this.tokenTypes[i] = 0;
        }
    }

    public void slashSlashComments(boolean bl) {
        this.slashSlashComments = bl;
    }

    public void slashStarComments(boolean bl) {
        this.slashStarComments = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Token[");
        switch (this.ttype) {
            case -1: {
                stringBuilder.append("EOF");
                break;
            }
            case 10: {
                stringBuilder.append("EOL");
                break;
            }
            case -2: {
                stringBuilder.append("n=");
                stringBuilder.append(this.nval);
                break;
            }
            case -3: {
                stringBuilder.append(this.sval);
                break;
            }
            default: {
                if (this.ttype == -4 || this.tokenTypes[this.ttype] == 2) {
                    stringBuilder.append(this.sval);
                    break;
                }
                stringBuilder.append('\'');
                stringBuilder.append((char)this.ttype);
                stringBuilder.append('\'');
            }
        }
        stringBuilder.append("], line ");
        stringBuilder.append(this.lineNumber);
        return stringBuilder.toString();
    }

    public void whitespaceChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.tokenTypes.length) {
            n2 = this.tokenTypes.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            this.tokenTypes[i] = 4;
        }
    }

    public void wordChars(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.tokenTypes.length) {
            n2 = this.tokenTypes.length - 1;
        }
        int n3 = n;
        while (n3 <= n2) {
            int n4 = n3++;
            this.tokenTypes[n4] = (byte)(this.tokenTypes[n4] | 8);
        }
    }
}

