/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public abstract class SimpleRenderedImage
implements RenderedImage {
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset = 0;
    protected int tileGridYOffset = 0;
    protected SampleModel sampleModel = null;
    protected ColorModel colorModel = null;
    protected Vector sources = new Vector();
    protected Hashtable properties = new Hashtable();

    @Override
    public int getMinX() {
        return this.minX;
    }

    public final int getMaxX() {
        return this.getMinX() + this.getWidth();
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    @Override
    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    @Override
    public int getMinTileX() {
        return this.XToTileX(this.getMinX());
    }

    public int getMaxTileX() {
        return this.XToTileX(this.getMaxX() - 1);
    }

    @Override
    public int getNumXTiles() {
        return this.getMaxTileX() - this.getMinTileX() + 1;
    }

    @Override
    public int getMinTileY() {
        return this.YToTileY(this.getMinY());
    }

    public int getMaxTileY() {
        return this.YToTileY(this.getMaxY() - 1);
    }

    @Override
    public int getNumYTiles() {
        return this.getMaxTileY() - this.getMinTileY() + 1;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public Object getProperty(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        return this.properties.get(string);
    }

    @Override
    public String[] getPropertyNames() {
        String[] stringArray = new String[this.properties.size()];
        int n = 0;
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public String[] getPropertyNames(String string) {
        String[] stringArray = this.getPropertyNames();
        if (stringArray == null) {
            return null;
        }
        string = string.toLowerCase(Locale.ENGLISH);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            vector.addElement(stringArray[i]);
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[vector.size()];
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            stringArray2[n++] = (String)iterator.next();
        }
        return stringArray2;
    }

    public static int XToTileX(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public static int YToTileY(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public int XToTileX(int n) {
        return SimpleRenderedImage.XToTileX(n, this.getTileGridXOffset(), this.getTileWidth());
    }

    public int YToTileY(int n) {
        return SimpleRenderedImage.YToTileY(n, this.getTileGridYOffset(), this.getTileHeight());
    }

    public static int tileXToX(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public static int tileYToY(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public int tileXToX(int n) {
        return n * this.tileWidth + this.tileGridXOffset;
    }

    public int tileYToY(int n) {
        return n * this.tileHeight + this.tileGridYOffset;
    }

    public Vector getSources() {
        return null;
    }

    @Override
    public Raster getData() {
        Rectangle rectangle = new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
        return this.getData(rectangle);
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        if (n == n3 && n2 == n4) {
            Raster raster = this.getTile(n, n2);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, rectangle.getLocation());
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Raster raster = this.getTile(j, i);
                Rectangle rectangle2 = raster.getBounds();
                Rectangle rectangle3 = rectangle.intersection(raster.getBounds());
                Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                writableRaster.setDataElements(0, 0, raster2);
            }
        }
        return writableRaster;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        if (writableRaster == null) {
            rectangle = this.getBounds();
            Point point = new Point(this.minX, this.minY);
            SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(this.width, this.height);
            writableRaster = Raster.createWritableRaster(sampleModel, point);
        } else {
            rectangle = writableRaster.getBounds();
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                Raster raster = this.getTile(j, i);
                Rectangle rectangle2 = raster.getBounds();
                Rectangle rectangle3 = rectangle.intersection(raster.getBounds());
                Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                writableRaster.setDataElements(0, 0, raster2);
            }
        }
        return writableRaster;
    }

    @Override
    public abstract Raster getTile(int var1, int var2);
}

