/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.event;

import ilog.views.util.collections.IlvCollections;
import ilog.views.util.event.IlvEventListenerCollection;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;

public abstract class IlvAbstractEventListenerCollection<L extends EventListener>
implements IlvEventListenerCollection<L>,
Serializable {
    Collection<L> a = null;

    protected abstract void initListeners();

    protected abstract Collection<L> cloneListeners();

    @Override
    public synchronized void addListener(L l) {
        if (this.a == null) {
            this.initListeners();
        }
        Collection<L> collection = this.cloneListeners();
        collection.add(l);
        this.a = collection;
    }

    @Override
    public synchronized void removeListener(L l) {
        if (this.a != null) {
            Collection<L> collection = this.cloneListeners();
            collection.remove(l);
            this.a = collection.isEmpty() ? null : collection;
        }
    }

    @Override
    public synchronized Iterator<L> getListeners() {
        if (this.a == null) {
            return IlvCollections.emptyIterator();
        }
        return this.a.iterator();
    }

    public synchronized int size() {
        return this.a == null ? 0 : this.a.size();
    }

    @Override
    public synchronized boolean contains(L l) {
        return this.a.contains(l);
    }

    @Override
    public void save(ObjectOutputStream objectOutputStream, String string) throws IOException {
        Iterator<L> iterator = this.getListeners();
        while (iterator.hasNext()) {
            EventListener eventListener = (EventListener)iterator.next();
            if (!(eventListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(string);
            objectOutputStream.writeObject(eventListener);
        }
    }
}

