/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.data;

import ilog.views.util.IlvClassLoaderUtil;
import ilog.views.util.IlvRuntimeException;
import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class IlvJDBCQueryUtil {
    public static void recognizeComments(CharSequence charSequence, QueryCharacterHandler queryCharacterHandler) throws SQLException {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            char c = charSequence.charAt(n2);
            if (c == '/') {
                if (n2 + 1 < n && charSequence.charAt(n2 + 1) == '*') {
                    n4 = n2;
                    n2 += 2;
                    while (true) {
                        if (n2 + 1 >= n) {
                            throw new SQLException("unterminated comment");
                        }
                        if (charSequence.charAt(n2) == '-' && charSequence.charAt(n2 + 1) == '-') {
                            throw new SQLException("ambiguous comment syntax: -- inside /* */ comment");
                        }
                        if (charSequence.charAt(n2) == '/' && charSequence.charAt(n2 + 1) == '*') {
                            throw new SQLException("ambiguous comment syntax: nested /* */ comments");
                        }
                        if (charSequence.charAt(n2) == '*' && charSequence.charAt(n2 + 1) == '/') break;
                        ++n2;
                    }
                    n3 = n2 += 2;
                    queryCharacterHandler.handleComment(charSequence, n4, n3);
                    continue;
                }
            } else if (c == '-') {
                if (n2 + 1 < n && charSequence.charAt(n2 + 1) == '-') {
                    n4 = n2;
                    n2 += 2;
                    while (n2 < n && charSequence.charAt(n2) != '\n') {
                        ++n2;
                    }
                    n3 = ++n2;
                    queryCharacterHandler.handleComment(charSequence, n4, n3);
                    continue;
                }
            } else {
                if (c == '\'') {
                    queryCharacterHandler.handleNonCommentChar(charSequence, n2, c);
                    ++n2;
                    do {
                        if (n2 >= n) {
                            throw new SQLException("unterminated string literal");
                        }
                        c = charSequence.charAt(n2);
                        queryCharacterHandler.handleNonCommentChar(charSequence, n2, c);
                        ++n2;
                    } while (c != '\'');
                    continue;
                }
                if (c == '\"') {
                    queryCharacterHandler.handleNonCommentChar(charSequence, n2, c);
                    ++n2;
                    do {
                        if (n2 >= n) {
                            throw new SQLException("unterminated identifier");
                        }
                        c = charSequence.charAt(n2);
                        queryCharacterHandler.handleNonCommentChar(charSequence, n2, c);
                        ++n2;
                    } while (c != '\"');
                    continue;
                }
                if (c == '{' || c == '}') {
                    throw new SQLException("ambiguous comment syntax: {} not supported here, use /* */ instead");
                }
            }
            queryCharacterHandler.handleNonCommentChar(charSequence, n2, c);
            ++n2;
        }
    }

    static boolean a(int n) {
        if (n >= 9 && n <= 13 || n == 133) {
            return true;
        }
        int n2 = Character.getType(n);
        switch (n2) {
            case 12: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    static List<Integer> a(CharSequence charSequence) throws SQLException {
        final ArrayList<Integer> arrayList = new ArrayList<Integer>();
        QueryCharacterHandler queryCharacterHandler = new QueryCharacterHandler(){
            private boolean a = false;
            private boolean b = false;

            @Override
            public void handleNonCommentChar(CharSequence charSequence, int n, char c) {
                if (c == '\'' && !this.b) {
                    boolean bl = this.a = !this.a;
                }
                if (c == '\"' && !this.a) {
                    boolean bl = this.b = !this.b;
                }
                if (c == '?' && !this.a && !this.b) {
                    arrayList.add(new Integer(n));
                }
            }

            @Override
            public void handleComment(CharSequence charSequence, int n, int n2) {
            }
        };
        IlvJDBCQueryUtil.recognizeComments(charSequence, queryCharacterHandler);
        return arrayList;
    }

    static int b(CharSequence charSequence) throws SQLException {
        return IlvJDBCQueryUtil.a(charSequence).size();
    }

    public static String combineQueryWithParameters(Connection connection, String string, Object[] objectArray) throws SQLException {
        ParameterMetaData parameterMetaData;
        PreparedStatement preparedStatement;
        if (objectArray == null) {
            return string;
        }
        int n = objectArray.length;
        if (n == 0) {
            return string;
        }
        List<Integer> list = IlvJDBCQueryUtil.a((CharSequence)string);
        if (connection != null) {
            preparedStatement = connection.prepareStatement(string);
            try {
                parameterMetaData = preparedStatement.getParameterMetaData();
            }
            catch (LinkageError linkageError) {
                parameterMetaData = null;
            }
            catch (SQLException sQLException) {
                parameterMetaData = null;
            }
        } else {
            preparedStatement = null;
            parameterMetaData = null;
        }
        if (parameterMetaData != null && parameterMetaData.getParameterCount() != list.size()) {
            throw new SQLException("unsupported query syntax, named parameters are unsupported here: " + string);
        }
        if (list.size() > n) {
            throw new IllegalArgumentException("query needs more than the given " + n + " parameters");
        }
        if (list.size() < n) {
            throw new IllegalArgumentException("query needs fewer than the given " + n + " parameters");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = list.get(i);
            stringBuffer.append(string, n2, n3);
            stringBuffer.append(' ');
            Object object = objectArray[i];
            if (parameterMetaData != null && object != null) {
                Class clazz;
                String string2 = parameterMetaData.getParameterClassName(i + 1);
                try {
                    clazz = IlvClassLoaderUtil.forName(IlvJDBCQueryUtil.class, string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IlvRuntimeException(classNotFoundException);
                }
                catch (LinkageError linkageError) {
                    throw new IlvRuntimeException(linkageError);
                }
                try {
                    object = IlvConvert.convert(object, clazz);
                }
                catch (IlvConvertException ilvConvertException) {
                    SQLException sQLException = new SQLException(ilvConvertException.getMessage());
                    sQLException.initCause(ilvConvertException);
                    throw sQLException;
                }
            }
            stringBuffer.append(IlvJDBCQueryUtil.convertToString(object));
            stringBuffer.append(' ');
            n2 = n3 + 1;
        }
        stringBuffer.append(string, n2, string.length());
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        return stringBuffer.toString();
    }

    public static String combineQueryWithParameters(String string, Object[] objectArray) throws SQLException {
        return IlvJDBCQueryUtil.combineQueryWithParameters(null, string, objectArray);
    }

    public static String convertToString(Object object) {
        if (object == null) {
            return "NULL";
        }
        if (object instanceof Boolean) {
            return ((Boolean)object).booleanValue() ? "TRUE" : "FALSE";
        }
        if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
            return String.valueOf(((Number)object).intValue());
        }
        if (object instanceof Long) {
            return String.valueOf((Long)object);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString();
        }
        if (object instanceof Float) {
            return String.valueOf(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return String.valueOf((Double)object);
        }
        if (object instanceof String) {
            String string = (String)object;
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            stringBuffer.append('\'');
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    stringBuffer.append(c);
                }
                stringBuffer.append(c);
            }
            stringBuffer.append('\'');
            return stringBuffer.toString();
        }
        if (object instanceof Date) {
            return "DATE '" + ((Date)object).toString() + "'";
        }
        if (object instanceof Time) {
            return "TIME '" + ((Time)object).toString() + "'";
        }
        if (object instanceof Timestamp) {
            return "TIMESTAMP '" + ((Timestamp)object).toString() + "'";
        }
        throw new IllegalArgumentException("cannot convert to SQL syntax: " + object);
    }

    private static boolean b(int n) {
        int n2 = Character.getType(n);
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    private static boolean c(int n) {
        if (n == 183) {
            return true;
        }
        int n2 = Character.getType(n);
        switch (n2) {
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    private static int b(String string, int n) {
        int n2;
        int n3;
        int n4 = string.length();
        for (n2 = n; n2 < n4 && (IlvJDBCQueryUtil.b(n3 = string.codePointAt(n2)) || n2 > n && IlvJDBCQueryUtil.c(n3)); n2 += Character.charCount(n3)) {
        }
        if (n2 > n) {
            return n2;
        }
        return -1;
    }

    private static boolean b(String string) {
        return IlvJDBCQueryUtil.b(string, 0) == string.length();
    }

    private static int c(String string, int n) {
        int n2 = n;
        int n3 = string.length();
        if (n2 < n3 && string.charAt(n2) == '\"') {
            ++n2;
            int n4 = -1;
            while (n2 < n3) {
                if (string.charAt(n2) == '\"') {
                    n4 = ++n2;
                    if (n2 >= n3 || string.charAt(n2) != '\"') break;
                    ++n2;
                    continue;
                }
                ++n2;
            }
            return n4 - n > 2 ? n4 : -1;
        }
        return -1;
    }

    private static boolean c(String string) {
        return IlvJDBCQueryUtil.c(string, 0) == string.length();
    }

    private static int d(String string, int n) {
        int n2 = IlvJDBCQueryUtil.b(string, n);
        if (n2 >= 0) {
            return n2;
        }
        n2 = IlvJDBCQueryUtil.c(string, n);
        if (n2 >= 0) {
            return n2;
        }
        return -1;
    }

    public static String validateIdentifier(String string) throws SQLException {
        if (IlvJDBCQueryUtil.d(string, 0) == string.length()) {
            return string;
        }
        throw new SQLException("invalid or unsupported SQL identifier: " + string);
    }

    static int a(String string, int n, int n2, List<String> list) {
        int n3;
        int n4 = string.length();
        int n5 = n;
        int n6 = -1;
        while ((n3 = IlvJDBCQueryUtil.d(string, n5)) >= 0) {
            n6 = n3;
            list.add(string.substring(n5, n3));
            if (--n2 == 0 || n3 >= n4 || string.charAt(n3) != '.') break;
            n5 = n3 + 1;
        }
        return n6;
    }

    private static int e(String string, int n) {
        return IlvJDBCQueryUtil.a(string, n, 3, new ArrayList<String>(3));
    }

    public static String validateTableName(String string) throws SQLException {
        if (IlvJDBCQueryUtil.e(string, 0) == string.length()) {
            return string;
        }
        throw new SQLException("invalid or unsupported SQL table name: " + string);
    }

    public static String validateColumnName(String string) throws SQLException {
        return IlvJDBCQueryUtil.validateIdentifier(string);
    }

    private static int f(String string, int n) {
        return IlvJDBCQueryUtil.a(string, n, Integer.MAX_VALUE, new ArrayList<String>());
    }

    public static String validateColumnReference(String string) throws SQLException {
        if (IlvJDBCQueryUtil.f(string, 0) == string.length()) {
            return string;
        }
        throw new SQLException("invalid or unsupported SQL column reference: " + string);
    }

    static String a(String string) throws SQLException {
        class Handler
        implements QueryCharacterHandler {
            boolean a = false;

            Handler() {
            }

            @Override
            public void handleNonCommentChar(CharSequence charSequence, int n, char c) {
                if (c == ';' || c == '(' || c == ')') {
                    this.a = true;
                }
            }

            @Override
            public void handleComment(CharSequence charSequence, int n, int n2) {
            }
        }
        Handler handler = new Handler();
        IlvJDBCQueryUtil.recognizeComments(string, handler);
        if (!handler.a) {
            return string;
        }
        throw new SQLException("invalid or unsupported SQL expression: " + string);
    }

    private IlvJDBCQueryUtil() {
    }

    public static class IdentifierChain {
        public static String last(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (IlvJDBCQueryUtil.a(string, 0, Integer.MAX_VALUE, arrayList) != string.length()) {
                throw new IllegalArgumentException("invalid identifier chain: " + string);
            }
            return arrayList.get(arrayList.size() - 1);
        }

        public static String butLast(String string) {
            int n;
            String string2 = string;
            int n2 = string2.length();
            int n3 = 0;
            int n4 = -1;
            int n5 = -1;
            while ((n = IlvJDBCQueryUtil.d(string2, n3)) >= 0) {
                n4 = n5;
                n5 = n;
                if (n >= n2 || string2.charAt(n) != '.') break;
                n3 = n + 1;
            }
            if (n5 != string.length()) {
                throw new IllegalArgumentException("invalid identifier chain: " + string);
            }
            if (n4 >= 0) {
                return string.substring(0, n4);
            }
            return null;
        }

        private IdentifierChain() {
        }
    }

    public static interface QueryCharacterHandler {
        public void handleNonCommentChar(CharSequence var1, int var2, char var3);

        public void handleComment(CharSequence var1, int var2, int var3);
    }
}

