/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.convert;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvColorUtil;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.beans.editor.IlvInternationalizedPropertyEditor;
import ilog.views.util.convert.DefaultLocalizedPropertyEditorFactory;
import ilog.views.util.convert.IlvConvertException;
import ilog.views.util.convert.IlvConverter;
import ilog.views.util.convert.IlvLocalizedConverter;
import ilog.views.util.convert.IlvLocalizedPropertyEditorFactory;
import ilog.views.util.text.IlvDateFormatFactory;
import ilog.views.util.text.internal.IlvFormatUtil;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class IlvConvert
implements Serializable {
    private static HashMap<Class, HashMap<Class, IlvConverter>> a = new HashMap();
    private static final Class[] b;

    private IlvConvert() {
    }

    public static final void addConverter(IlvConverter ilvConverter) {
        Class[] classArray = ilvConverter.fromTypes();
        Class[] classArray2 = ilvConverter.toTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            HashMap<Class<Object>, IlvConverter> hashMap = a.get(clazz);
            if (hashMap == null) {
                hashMap = new HashMap();
                a.put(clazz, hashMap);
            }
            for (int j = 0; j < classArray2.length; ++j) {
                hashMap.put(classArray2[j], ilvConverter);
            }
        }
    }

    public static final void addConverter(PropertyEditor propertyEditor, Class clazz) {
        if (propertyEditor instanceof IlvInternationalizedPropertyEditor) {
            IlvConvert.addConverter(new LocalizedPropertyEditorWrapper(propertyEditor.getClass(), clazz));
        } else {
            IlvConvert.addConverter(new PropertyEditorWrapper(propertyEditor, clazz));
        }
    }

    public static final void addConverter(IlvLocalizedPropertyEditorFactory ilvLocalizedPropertyEditorFactory, Class clazz) {
        IlvConvert.addConverter(new LocalizedPropertyEditorWrapper(ilvLocalizedPropertyEditorFactory, clazz));
    }

    public static IlvConverter getConverter(Class clazz, Class clazz2) {
        HashMap<Class, IlvConverter> hashMap = a.get(clazz);
        IlvConverter ilvConverter = hashMap == null ? null : hashMap.get(clazz2);
        if (ilvConverter == null) {
            if (clazz != Object.class) {
                return IlvConvert.getConverter(clazz.getSuperclass(), clazz2);
            }
        }
        return ilvConverter;
    }

    public static boolean isConverterLocalized(Class clazz, Class clazz2) {
        IlvConverter ilvConverter = IlvConvert.getConverter(clazz, clazz2);
        return ilvConverter != null && ilvConverter instanceof IlvLocalizedConverter;
    }

    public static void removeConverter(Class clazz, Class clazz2) {
        HashMap<Class, IlvConverter> hashMap = a.get(clazz);
        if (hashMap != null) {
            hashMap.remove(clazz2);
        }
    }

    public static final Object convert(Object object, Class clazz) throws IlvConvertException {
        if (object == null) {
            throw new IlvConvertException("cannot convert null value");
        }
        if ((clazz = IlvConvert.a(clazz)).isAssignableFrom(object.getClass())) {
            return object;
        }
        IlvConverter ilvConverter = IlvConvert.getConverter(object.getClass(), clazz);
        if (ilvConverter != null) {
            return ilvConverter.convert(object, clazz);
        }
        throw new IlvConvertException("No converter registered for " + object.getClass().getName() + " to " + clazz.getName());
    }

    public static boolean isConvertible(Class clazz, Class clazz2) {
        if (clazz == null) {
            return false;
        }
        if ((clazz2 = IlvConvert.a(clazz2)).isAssignableFrom(clazz)) {
            return true;
        }
        IlvConverter ilvConverter = IlvConvert.getConverter(clazz, clazz2);
        return ilvConverter != null;
    }

    public static final Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
        return IlvConvert.convert(object, clazz, ULocale.forLocale((Locale)locale));
    }

    public static final Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
        if (object == null) {
            throw new IlvConvertException("cannot convert null value");
        }
        if ((clazz = IlvConvert.a(clazz)).isAssignableFrom(object.getClass())) {
            return object;
        }
        IlvConverter ilvConverter = IlvConvert.getConverter(object.getClass(), clazz);
        if (ilvConverter != null) {
            if (ilvConverter instanceof IlvLocalizedConverter) {
                IlvLocalizedConverter ilvLocalizedConverter = (IlvLocalizedConverter)ilvConverter;
                return ilvLocalizedConverter.convert(object, clazz, uLocale);
            }
            if (uLocale != null) {
                return ilvConverter.convert(object, clazz);
            }
            throw new IlvConvertException("No localized version of the converter registered for " + object.getClass().getName() + " to " + clazz.getName());
        }
        throw new IlvConvertException("No localized converter registered for " + object.getClass().getName() + " to " + clazz.getName());
    }

    private static Class a(Class clazz) {
        if (clazz == Boolean.TYPE) {
            clazz = Boolean.class;
        } else if (clazz == Byte.TYPE) {
            clazz = Byte.class;
        } else if (clazz == Character.TYPE) {
            clazz = Character.class;
        } else if (clazz == Short.TYPE) {
            clazz = Short.class;
        } else if (clazz == Integer.TYPE) {
            clazz = Integer.class;
        } else if (clazz == Long.TYPE) {
            clazz = Long.class;
        } else if (clazz == Float.TYPE) {
            clazz = Float.class;
        } else if (clazz == Double.TYPE) {
            clazz = Double.class;
        }
        return clazz;
    }

    public static final String convertToString(Object object) throws IlvConvertException {
        return (String)IlvConvert.convert(object, String.class);
    }

    public static final int convertToInt(Object object) throws IlvConvertException {
        return (Integer)IlvConvert.convert(object, Integer.class);
    }

    public static final long convertToLong(Object object) throws IlvConvertException {
        return (Long)IlvConvert.convert(object, Long.class);
    }

    public static final boolean convertToBoolean(Object object) throws IlvConvertException {
        return (Boolean)IlvConvert.convert(object, Boolean.class);
    }

    public static final float convertToFloat(Object object) throws IlvConvertException {
        return ((Float)IlvConvert.convert(object, Float.class)).floatValue();
    }

    public static final double convertToDouble(Object object) throws IlvConvertException {
        return (Double)IlvConvert.convert(object, Double.class);
    }

    public static final short convertToShort(Object object) throws IlvConvertException {
        return (Short)IlvConvert.convert(object, Short.class);
    }

    public static final byte convertToByte(Object object) throws IlvConvertException {
        return (Byte)IlvConvert.convert(object, Byte.class);
    }

    static {
        Class[] classArray = new Class[9];
        classArray[0] = Byte.class;
        classArray[1] = Short.class;
        classArray[2] = Integer.class;
        classArray[3] = Long.class;
        classArray[4] = Float.class;
        classArray[5] = Double.class;
        classArray[6] = BigDecimal.class;
        classArray[7] = BigInteger.class;
        classArray[8] = Boolean.class;
        b = classArray;
        IlvConvert.addConverter(new NumberToNumberFilter());
        IlvConvert.addConverter(new StringToColorFilter());
        IlvConvert.addConverter(new ColorToStringFilter());
        IlvConvert.addConverter(new NumberToColorFilter());
        IlvConvert.addConverter(new ColorToNumberFilter());
        IlvConvert.addConverter(new StringToFontFilter());
        IlvConvert.addConverter(new FontToStringFilter());
        IlvConvert.addConverter(new StringToULocaleFilter());
        IlvConvert.addConverter(new ULocaleToStringFilter());
        IlvConvert.addConverter(new StringToComponentOrientationFilter());
        IlvConvert.addConverter(new ComponentOrientationToStringFilter());
        IlvConvert.addConverter(new StringToNumberFilter());
        IlvConvert.addConverter(new NumberToStringFilter());
        IlvConvert.addConverter(new StringToCurrencyPercentConverter());
        IlvConvert.addConverter(new StringToDateConverter());
        IlvConvert.addConverter(new PercentToStringConverter());
        IlvConvert.addConverter(new CurrencyToStringConverter());
    }

    private static class LocalizedPropertyEditorWrapper
    extends PropertyEditorWrapper
    implements IlvLocalizedConverter {
        private IlvLocalizedPropertyEditorFactory a;

        public LocalizedPropertyEditorWrapper(Class<? extends PropertyEditor> clazz, Class clazz2) {
            super(null, clazz2);
            this.a = new DefaultLocalizedPropertyEditorFactory(clazz);
        }

        public LocalizedPropertyEditorWrapper(IlvLocalizedPropertyEditorFactory ilvLocalizedPropertyEditorFactory, Class clazz) {
            super(null, clazz);
            this.a = ilvLocalizedPropertyEditorFactory;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            if (((PropertyEditorWrapper)this).a == null) {
                PropertyEditor propertyEditor = this.a.getPropertyEditor(ULocale.US);
                if (propertyEditor == null) {
                    throw new IlvConvertException("cannot convert " + object + " to " + clazz);
                }
                ((PropertyEditorWrapper)this).a = propertyEditor;
            }
            return super.convert(object, clazz);
        }

        @Override
        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            return this.convert(object, clazz, ULocale.forLocale((Locale)locale));
        }

        @Override
        public Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
            PropertyEditor propertyEditor = this.a.getPropertyEditor(uLocale);
            if (propertyEditor == null) {
                throw new IlvConvertException("cannot convert " + object + " to " + clazz);
            }
            if (propertyEditor instanceof IlvInternationalizedPropertyEditor) {
                IlvInternationalizedPropertyEditor ilvInternationalizedPropertyEditor = (IlvInternationalizedPropertyEditor)propertyEditor;
                try {
                    if (clazz == this.b && object instanceof String) {
                        ilvInternationalizedPropertyEditor.setAsLocalizedText(object.toString());
                        return ilvInternationalizedPropertyEditor.getValue();
                    }
                    if (clazz == String.class && object.getClass() == this.b) {
                        ilvInternationalizedPropertyEditor.setValue(object);
                        return ilvInternationalizedPropertyEditor.getAsLocalizedText();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IlvConvertException(illegalArgumentException, "cannot convert " + object + " to " + clazz);
                }
                throw new IlvConvertException("cannot convert " + object + " to " + clazz);
            }
            try {
                if (clazz == this.b && object instanceof String) {
                    propertyEditor.setAsText(object.toString());
                    return propertyEditor.getValue();
                }
                if (clazz == String.class && object.getClass() == this.b) {
                    propertyEditor.setValue(object);
                    return propertyEditor.getAsText();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IlvConvertException(illegalArgumentException, "cannot convert " + object + " to " + clazz);
            }
            throw new IlvConvertException("cannot convert " + object + " to " + clazz);
        }
    }

    private static class PropertyEditorWrapper
    implements IlvConverter {
        PropertyEditor a;
        Class b;

        public PropertyEditorWrapper(PropertyEditor propertyEditor, Class clazz) {
            this.a = propertyEditor;
            this.b = clazz;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            try {
                if (clazz == this.b && object instanceof String) {
                    this.a.setAsText(object.toString());
                    return this.a.getValue();
                }
                if (clazz == String.class && object.getClass() == this.b) {
                    this.a.setValue(object);
                    return this.a.getAsText();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IlvConvertException(illegalArgumentException, "cannot convert " + object + " to " + clazz);
            }
            throw new IlvConvertException("cannot convert " + object + " to " + clazz);
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[2];
            classArray[0] = String.class;
            classArray[1] = this.b;
            return classArray;
        }

        @Override
        public Class[] toTypes() {
            return this.fromTypes();
        }
    }

    static class StringToComponentOrientationFilter
    implements IlvConverter {
        StringToComponentOrientationFilter() {
        }

        @Override
        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = ComponentOrientation.class;
            return classArray;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            String string = (String)object;
            if ("Left-to-right".equals(string)) {
                return ComponentOrientation.LEFT_TO_RIGHT;
            }
            if ("Right-to-left".equals(string)) {
                return ComponentOrientation.RIGHT_TO_LEFT;
            }
            return ComponentOrientation.UNKNOWN;
        }
    }

    static class ComponentOrientationToStringFilter
    implements IlvConverter {
        ComponentOrientationToStringFilter() {
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = ComponentOrientation.class;
            return classArray;
        }

        @Override
        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            ComponentOrientation componentOrientation = (ComponentOrientation)object;
            if (componentOrientation == ComponentOrientation.UNKNOWN) {
                return "Unknown";
            }
            if (componentOrientation.isLeftToRight()) {
                return "Left-to-right";
            }
            return "Right-to-left";
        }
    }

    static class StringToULocaleFilter
    implements IlvConverter {
        StringToULocaleFilter() {
        }

        @Override
        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = ULocale.class;
            return classArray;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            String string = (String)object;
            return ULocale.createCanonical((String)string);
        }
    }

    static class ULocaleToStringFilter
    implements IlvConverter {
        ULocaleToStringFilter() {
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = ULocale.class;
            return classArray;
        }

        @Override
        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            ULocale uLocale = (ULocale)object;
            return uLocale.getName();
        }
    }

    static class StringToFontFilter
    implements IlvConverter {
        StringToFontFilter() {
        }

        @Override
        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Font.class;
            return classArray;
        }

        @Override
        public Object convert(Object object, Class clazz) {
            return Font.decode((String)object);
        }
    }

    static class FontToStringFilter
    implements IlvConverter {
        FontToStringFilter() {
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Font.class;
            return classArray;
        }

        @Override
        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Object convert(Object object, Class clazz) {
            Font font = (Font)object;
            String string = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
            String string2 = font.getName();
            if (string2 == null) {
                string2 = "Dialog";
            }
            return string2 + "-" + string + "-" + font.getSize();
        }
    }

    static class StringToDateConverter
    extends AbstractLocalizedConverter
    implements IlvLocalizedConverter {
        DatatypeFactory a;

        StringToDateConverter() {
        }

        @Override
        public Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
            String string = ((String)object).trim();
            DateFormat dateFormat = IlvDateFormatFactory.getDateTimeInstance(2, 2, uLocale);
            try {
                return IlvFormatUtil.parseFully(dateFormat, string);
            }
            catch (ParseException parseException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            dateFormat = IlvDateFormatFactory.getDateTimeInstance(3, 3, uLocale);
            try {
                return IlvFormatUtil.parseFully(dateFormat, string);
            }
            catch (ParseException parseException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int n = string.indexOf(44);
            if (n > 0) {
                DateFormat dateFormat2 = IlvDateFormatFactory.getInstance(string.substring(0, n), uLocale, null);
                ParsePosition parsePosition = new ParsePosition(n + 1);
                try {
                    Date date = dateFormat2.parse(string, parsePosition);
                    if (parsePosition.getErrorIndex() == -1) {
                        return date;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                throw new IlvConvertException("cannot convert " + string.substring(n + 1) + " to java.util.Date using format \"" + string.substring(0, n) + "\". Problem located at pos " + (parsePosition.getErrorIndex() - n - 1) + ".", object);
            }
            if (this.a == null) {
                try {
                    this.a = DatatypeFactory.newInstance();
                }
                catch (DatatypeConfigurationException datatypeConfigurationException) {
                    // empty catch block
                }
            }
            if (this.a != null) {
                XMLGregorianCalendar xMLGregorianCalendar = null;
                try {
                    xMLGregorianCalendar = this.a.newXMLGregorianCalendar(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (xMLGregorianCalendar != null) {
                    return xMLGregorianCalendar.toGregorianCalendar().getTime();
                }
            }
            throw new IlvConvertException("cannot convert " + string + " to java.util.Date. " + "Use syntax that matches locale " + uLocale + ", specify the format explicitly by prepending it " + "to the value like \"mm/dd/yy,02/21/03\", " + "or use ISO8601 syntax like \"2004-02-25T10:21:00Z\"");
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            ULocale uLocale = IlvLocaleUtil.getCurrentULocale();
            return this.convert(object, clazz, uLocale);
        }

        @Override
        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Date.class;
            return classArray;
        }
    }

    static class NumberToColorFilter
    implements IlvConverter {
        private static NumberToNumberFilter a = new NumberToNumberFilter();
        private static Class b;

        NumberToColorFilter() {
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[6];
            classArray[0] = Byte.class;
            classArray[1] = Short.class;
            classArray[2] = Integer.class;
            classArray[3] = Long.class;
            classArray[4] = Float.class;
            classArray[5] = Double.class;
            Class[] classArray2 = classArray;
            return classArray2;
        }

        @Override
        public Class[] toTypes() {
            Class[] classArray;
            if (b != null) {
                classArray = new Class[2];
                classArray[0] = Color.class;
                classArray[1] = b;
            } else {
                classArray = new Class[1];
                classArray[0] = Color.class;
            }
            return classArray;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Integer n = (Integer)a.convert(object, Integer.class);
            return new Color(n);
        }

        static {
            try {
                b = Class.forName("java.awt.Paint");
            }
            catch (Throwable throwable) {
                b = null;
            }
        }
    }

    static class ColorToNumberFilter
    implements IlvConverter {
        private static NumberToNumberFilter a = new NumberToNumberFilter();

        ColorToNumberFilter() {
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Color.class;
            return classArray;
        }

        @Override
        public Class[] toTypes() {
            Class[] classArray = new Class[6];
            classArray[0] = Byte.class;
            classArray[1] = Short.class;
            classArray[2] = Integer.class;
            classArray[3] = Long.class;
            classArray[4] = Float.class;
            classArray[5] = Double.class;
            Class[] classArray2 = classArray;
            return classArray2;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Color color = (Color)object;
            int n = color.getRGB();
            return a.convert(new Integer(n), clazz);
        }
    }

    static class StringToColorFilter
    implements IlvConverter {
        StringToColorFilter() {
        }

        @Override
        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] toTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Color.class;
            return classArray;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            try {
                return IlvColorUtil.toColor(object.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IlvConvertException("cannot convert " + object + " to java.awt.Color");
            }
        }
    }

    static class ColorToStringFilter
    implements IlvConverter {
        ColorToStringFilter() {
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[1];
            classArray[0] = Color.class;
            return classArray;
        }

        @Override
        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            try {
                return IlvColorUtil.toHumanReadableString((Color)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IlvConvertException("cannot convert color " + object + " to String");
            }
        }
    }

    static class CurrencyToStringConverter
    extends AbstractLocalizedConverter
    implements IlvLocalizedConverter {
        CurrencyToStringConverter() {
        }

        @Override
        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] fromTypes() {
            return new Class[]{IlvLocalizedConverter.CURRENCY_AS_NUMBER_CLASS};
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return this.convert(object, clazz, IlvLocaleUtil.getCurrentULocale());
        }

        @Override
        public Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
            NumberFormat numberFormat = NumberFormat.getCurrencyInstance((ULocale)uLocale);
            return numberFormat.format(object);
        }
    }

    static class PercentToStringConverter
    extends AbstractLocalizedConverter
    implements IlvLocalizedConverter {
        PercentToStringConverter() {
        }

        @Override
        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] fromTypes() {
            return new Class[]{IlvLocalizedConverter.PERCENT_AS_NUMBER_CLASS};
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return this.convert(object, clazz, IlvLocaleUtil.getCurrentULocale());
        }

        @Override
        public Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
            NumberFormat numberFormat = NumberFormat.getPercentInstance((ULocale)uLocale);
            return numberFormat.format(object);
        }
    }

    static class StringToCurrencyPercentConverter
    extends AbstractLocalizedConverter
    implements IlvLocalizedConverter {
        StringToCurrencyPercentConverter() {
        }

        @Override
        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] toTypes() {
            return new Class[]{IlvLocalizedConverter.CURRENCY_AS_NUMBER_CLASS, IlvLocalizedConverter.PERCENT_AS_NUMBER_CLASS};
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return this.convert(object, clazz, IlvLocaleUtil.getCurrentULocale());
        }

        @Override
        public Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
            boolean bl = clazz == IlvLocalizedConverter.PERCENT_AS_NUMBER_CLASS;
            try {
                NumberFormat numberFormat = bl ? NumberFormat.getCurrencyInstance((ULocale)uLocale) : NumberFormat.getPercentInstance((ULocale)uLocale);
                Number number = IlvFormatUtil.parseFully(numberFormat, (String)object);
                return number;
            }
            catch (ParseException parseException) {
                throw new IlvConvertException("cannot convert " + (bl ? "percent " : "currency ") + object + " to String, with Locale: " + uLocale);
            }
        }
    }

    static class StringToNumberFilter
    extends AbstractLocalizedConverter
    implements IlvLocalizedConverter {
        static HashMap[] a = new HashMap[10];
        static final int b = 500;

        StringToNumberFilter() {
        }

        @Override
        public Class[] fromTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Class[] toTypes() {
            return b;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Comparable<Boolean> comparable;
            HashMap<Object, Boolean> hashMap;
            block32: {
                int n = 9;
                if (clazz == Byte.class) {
                    n = 0;
                } else if (clazz == Short.class) {
                    n = 1;
                } else if (clazz == Integer.class) {
                    n = 2;
                } else if (clazz == Long.class) {
                    n = 3;
                } else if (clazz == Float.class) {
                    n = 4;
                } else if (clazz == Double.class) {
                    n = 5;
                } else if (clazz == String.class) {
                    n = 6;
                } else if (clazz == BigInteger.class) {
                    n = 7;
                } else if (clazz == BigDecimal.class) {
                    n = 8;
                }
                hashMap = a[n];
                comparable = null;
                if (hashMap == null) {
                    StringToNumberFilter.a[n] = hashMap = new HashMap<Object, Boolean>();
                } else {
                    comparable = (Comparable<Boolean>)hashMap.get(object);
                }
                if (comparable != null) {
                    return comparable;
                }
                String string = (String)object;
                try {
                    if (clazz == Boolean.class) {
                        comparable = string.equalsIgnoreCase("true") ? Boolean.TRUE : (string.equalsIgnoreCase("false") ? Boolean.FALSE : (Double.valueOf(string) != 0.0 ? Boolean.TRUE : Boolean.FALSE));
                        break block32;
                    }
                    if (clazz == Byte.class) {
                        comparable = Byte.valueOf(string);
                        break block32;
                    }
                    if (clazz == Short.class) {
                        comparable = Short.valueOf(string);
                        break block32;
                    }
                    if (clazz == Integer.class) {
                        comparable = Integer.valueOf(string);
                        break block32;
                    }
                    if (clazz == Long.class) {
                        comparable = Long.valueOf(string);
                        break block32;
                    }
                    if (clazz == Float.class) {
                        comparable = Float.valueOf(string);
                        break block32;
                    }
                    if (clazz == Double.class) {
                        comparable = Double.valueOf(string);
                        break block32;
                    }
                    if (clazz == BigDecimal.class) {
                        comparable = new BigDecimal(string);
                        break block32;
                    }
                    if (clazz == BigInteger.class) {
                        comparable = new BigInteger(string);
                        break block32;
                    }
                    throw new IlvConvertException("cannot convert " + object + " to " + clazz);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IlvConvertException("cannot convert " + object + " to " + clazz);
                }
            }
            if (hashMap.size() < 500) {
                hashMap.put(object, (Boolean)comparable);
            }
            return comparable;
        }

        @Override
        public Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
            try {
                if (clazz == Boolean.class) {
                    return this.convert(object, clazz);
                }
                Number number = IlvFormatUtil.parseFully(NumberFormat.getInstance((ULocale)uLocale), (String)object);
                return IlvConvert.convert(number, clazz);
            }
            catch (ParseException parseException) {
                throw new IlvConvertException("cannot convert number " + object + " to String, with Locale: " + uLocale);
            }
        }
    }

    static class NumberToStringFilter
    extends AbstractLocalizedConverter
    implements IlvLocalizedConverter {
        NumberToStringFilter() {
        }

        @Override
        public Class[] fromTypes() {
            return b;
        }

        @Override
        public Class[] toTypes() {
            return IlvConverter.STRING_TYPE;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            return object.toString();
        }

        @Override
        public Object convert(Object object, Class clazz, ULocale uLocale) throws IlvConvertException {
            if (object.getClass() == Boolean.class) {
                return object.toString();
            }
            return IlvConvert.convert(NumberFormat.getInstance((ULocale)uLocale).format(object), clazz);
        }
    }

    static class NumberToNumberFilter
    implements IlvConverter {
        NumberToNumberFilter() {
        }

        @Override
        public Class[] fromTypes() {
            Class[] classArray = new Class[b.length + 1];
            for (int i = 0; i < b.length; ++i) {
                classArray[i] = b[i];
            }
            classArray[i] = Number.class;
            return classArray;
        }

        @Override
        public Class[] toTypes() {
            return b;
        }

        @Override
        public Object convert(Object object, Class clazz) throws IlvConvertException {
            Class<?> clazz2 = object.getClass();
            if (clazz2 == Boolean.class) {
                if (clazz == Byte.class) {
                    return new Byte((byte)((Boolean)object != false ? 1 : 0));
                }
                if (clazz == Short.class) {
                    return new Short((short)((Boolean)object != false ? 1 : 0));
                }
                if (clazz == Integer.class) {
                    return new Integer((Boolean)object != false ? 1 : 0);
                }
                if (clazz == Long.class) {
                    return new Long((Boolean)object != false ? 1L : 0L);
                }
                if (clazz == Float.class) {
                    return new Float((Boolean)object != false ? 1.0f : 0.0f);
                }
                if (clazz == Double.class) {
                    return new Double((Boolean)object != false ? 1.0 : 0.0);
                }
                if (clazz == BigDecimal.class) {
                    return BigDecimal.valueOf((Boolean)object != false ? 1L : 0L);
                }
                if (clazz == BigInteger.class) {
                    return BigInteger.valueOf((Boolean)object != false ? 1L : 0L);
                }
                return object;
            }
            Number number = (Number)object;
            if (clazz == Byte.class) {
                return new Byte(number.byteValue());
            }
            if (clazz == Short.class) {
                return new Short(number.shortValue());
            }
            if (clazz == Integer.class) {
                return new Integer(number.intValue());
            }
            if (clazz == Long.class) {
                return new Long(number.longValue());
            }
            if (clazz == Float.class) {
                return new Float(number.floatValue());
            }
            if (clazz == Double.class) {
                return new Double(number.doubleValue());
            }
            if (clazz == BigDecimal.class) {
                return BigDecimal.valueOf(number.longValue());
            }
            if (clazz == BigInteger.class) {
                return BigInteger.valueOf(number.longValue());
            }
            return number.longValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }
    }

    static abstract class AbstractLocalizedConverter
    implements IlvLocalizedConverter {
        AbstractLocalizedConverter() {
        }

        @Override
        public Object convert(Object object, Class clazz, Locale locale) throws IlvConvertException {
            return this.convert(object, clazz, ULocale.forLocale((Locale)locale));
        }

        @Override
        public abstract Object convert(Object var1, Class var2, ULocale var3) throws IlvConvertException;
    }
}

