/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import ilog.views.util.beans.editor.IlvFloatArrayEditorPanel;
import ilog.views.util.beans.editor.IlvTextLineArrayEditorPanel;
import ilog.views.util.beans.editor.IlvTextLineArrayPropertyEditor;
import java.awt.Component;

public class IlvFloatArrayPropertyEditor
extends IlvTextLineArrayPropertyEditor {
    static IlvTextLineArrayEditorPanel a = null;
    float[] b = null;

    @Override
    public Object getValue() {
        return this.b;
    }

    @Override
    public void setValue(Object object) {
        float[] fArray = this.b;
        this.b = (float[])object;
        this.firePropertyChange(fArray, this.b);
        if (((IlvTextLineArrayPropertyEditor)this).b) {
            a.setElements(this.b);
        }
    }

    @Override
    public String getJavaInitializationString() {
        if (this.b == null) {
            return "null";
        }
        int n = this.b.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("new float");
        if (n == 0) {
            stringBuffer.append("[0]");
        } else {
            stringBuffer.append("[] {");
            for (int i = 0; i < n; ++i) {
                float f;
                if (i > 0) {
                    stringBuffer.append(",");
                }
                if (Float.isNaN(f = this.b[i])) {
                    stringBuffer.append("java.lang.Float.NaN");
                    continue;
                }
                if (Float.isInfinite(f)) {
                    stringBuffer.append(f < 0.0f ? "java.lang.Float.NEGATIVE_INFINITY" : "java.lang.Float.POSITIVE_INFINITY");
                    continue;
                }
                stringBuffer.append(Float.toString(f));
                stringBuffer.append("f");
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public String getAsText() {
        if (this.b == null) {
            return "";
        }
        int n = this.b.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(Float.toString(this.b[i]));
        }
        return stringBuffer.toString();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        try {
            float[] fArray;
            int n = string.length();
            if (n == 0) {
                fArray = new float[]{};
            } else {
                int n2;
                int n3 = 0;
                int n4 = 0;
                while (n4 < n && (n2 = string.indexOf(44, n4)) >= 0) {
                    ++n3;
                    n4 = n2 + 1;
                }
                fArray = new float[n3 + 1];
                n4 = 0;
                n2 = 0;
                while (n2 < n) {
                    int n5 = string.indexOf(44, n2);
                    String string2 = n5 < 0 ? string.substring(n2) : string.substring(n2, n5);
                    fArray[n4] = Float.parseFloat(string2);
                    ++n4;
                    if (n5 < 0) break;
                    n2 = n5 + 1;
                }
                assert (n4 == fArray.length);
            }
            this.setValue(fArray);
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.getMessage());
            illegalArgumentException.initCause(exception);
            throw illegalArgumentException;
        }
    }

    @Override
    public String convertElementToLocalizedText(Object object) {
        return IlvFloatArrayEditorPanel.d().format(((Float)object).floatValue());
    }

    @Override
    public Component getCustomEditor() {
        if (a == null) {
            a = new IlvFloatArrayEditorPanel();
        }
        a.setEditor(this);
        a.setElements(this.b);
        return a;
    }
}

