/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.beans.editor.IlvInternationalizedPropertyEditor;
import ilog.views.util.text.internal.IlvFormatUtil;
import ilog.views.util.text.internal.IlvICUNumberFormatFactory;
import java.beans.PropertyEditorSupport;

public class IlvDoublePropertyEditor
extends PropertyEditorSupport
implements IlvInternationalizedPropertyEditor {
    private static final String a = "Infinity";
    private static final String b = "-Infinity";
    private static final String c = "NaN";
    private static final Double d = new Double(Double.POSITIVE_INFINITY);
    private static final Double e = new Double(Double.NEGATIVE_INFINITY);
    private static final Double f = new Double(Double.NaN);
    private final ULocale g;
    private boolean h = false;
    private int i = 20;
    private static final Double j = new Double(0.0);
    private static final Double k = new Double(1.0);

    public IlvDoublePropertyEditor() {
        this(IlvLocaleUtil.getCurrentULocale());
    }

    public IlvDoublePropertyEditor(ULocale uLocale) {
        this.g = uLocale;
    }

    @Override
    public String getJavaInitializationString() {
        double d = (Double)this.getValue();
        if (Double.isNaN(d)) {
            return "Double.NaN";
        }
        if (d == Double.POSITIVE_INFINITY) {
            return "Double.POSITIVE_INFINITY";
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return "Double.NEGATIVE_INFINITY";
        }
        return Double.toString(d);
    }

    @Override
    public void setAsText(String string) {
        this.a(string, false);
    }

    @Override
    public void setAsLocalizedText(String string) throws IllegalArgumentException {
        this.a(string, true);
    }

    @Override
    public String getAsText() {
        return this.a(false);
    }

    @Override
    public String getAsLocalizedText() {
        return this.a(true);
    }

    @Override
    public String[] getValuesAsLocalizedText() {
        return null;
    }

    private void a(String string, boolean bl) {
        if ("0" == string) {
            this.setValue(j);
            return;
        }
        if ("1" == string) {
            this.setValue(k);
            return;
        }
        if (a.equals(string)) {
            this.setValue(d);
        } else if (b.equals(string)) {
            this.setValue(e);
        } else if (c.equals(string)) {
            this.setValue(f);
        } else if (bl) {
            NumberFormat numberFormat = IlvICUNumberFormatFactory.getInstance(this.g);
            try {
                this.setValue(IlvFormatUtil.parseFully(numberFormat, string).doubleValue());
            }
            catch (Exception exception) {
                if (numberFormat instanceof DecimalFormat && !((DecimalFormat)numberFormat).isScientificNotation()) {
                    ((DecimalFormat)numberFormat).setScientificNotation(true);
                    numberFormat.setGroupingUsed(this.h);
                    try {
                        this.setValue(IlvFormatUtil.parseFully(numberFormat, string).doubleValue());
                    }
                    catch (Exception exception2) {
                        throw new IllegalArgumentException("invalid double:" + string);
                    }
                }
                throw new IllegalArgumentException("invalid double:" + string);
            }
        } else {
            this.setValue(Double.valueOf(string));
        }
    }

    private String a(boolean bl) {
        Object object = this.getValue();
        if (object instanceof Double) {
            double d = (Double)object;
            if (IlvDoublePropertyEditor.d.equals(object)) {
                return a;
            }
            if (e.equals(object)) {
                return b;
            }
            if (f.equals(object)) {
                return c;
            }
            if (bl) {
                NumberFormat numberFormat = IlvICUNumberFormatFactory.createInstance(this.g);
                numberFormat.setGroupingUsed(this.h);
                String string = numberFormat.format(d);
                if (string.length() >= this.i && numberFormat instanceof DecimalFormat && !((DecimalFormat)numberFormat).isScientificNotation()) {
                    ((DecimalFormat)numberFormat).setScientificNotation(true);
                    numberFormat.setGroupingUsed(this.h);
                    string = numberFormat.format(d);
                }
                return string;
            }
            return Double.toString(d);
        }
        return "0";
    }

    public void setGroupingUsed(boolean bl) {
        this.h = bl;
    }

    public boolean isGroupingUsed() {
        return this.h;
    }

    public void setMinTextLengthForceingScientificNotation(int n) {
        this.i = n;
    }

    public int getMinTextLengthForceingScientificNotation() {
        return this.i;
    }
}

