/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.editor;

import ilog.views.IlvGraphic;
import ilog.views.IlvGrid;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.applications.util.eventpanel.IlvSelectable;
import ilog.views.applications.util.eventpanel.event.SelectionEvent;
import ilog.views.applications.util.eventpanel.event.SelectionListener;
import ilog.views.css.model.IlvRule;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.ObjectBBoxChangedEvent;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvIcon;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import ilog.views.interactor.IlvSelectInteractor;
import ilog.views.interactor.IlvSelectInteractorMoveSelection;
import ilog.views.swing.IlvJManagerViewPanel;
import ilog.views.swing.IlvJScrollManagerView;
import ilog.views.swing.IlvToolTipManager;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.IlvSymbolEditorInteractor;
import ilog.views.symbology.editor.event.SelectionChangedEvent;
import ilog.views.symbology.editor.event.SelectionChangedListener;
import ilog.views.symbology.editor.eventpanel.IlvSymbolEventPanel;
import ilog.views.symbology.editor.eventpanel.IlvSymbolGraphicSelectable;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.editor.rules.IlvSymbolRuleModel;
import ilog.views.symbology.editor.tree.IlvSymbolTree;
import ilog.views.symbology.editor.wizard.imagelist.ImageListWizard;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.swing.IlvPaletteDragAndDropData;
import ilog.views.symbology.palettes.swing.IlvPaletteObjectTransferable;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.IlvSwingUtil;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;

public class IlvSymbolEditorView
extends JPanel {
    private IlvManagerView a;
    private IlvSymbolEventPanel b;
    private IlvSymbolEditorDocument c;
    private boolean d;
    private static final String e = "SymbolEditorClipboard";
    private double f = 2.0;
    private boolean g = false;
    private boolean h;
    private IlvGrid i;
    private IlvSelectInteractor j;
    private RunModeListener k;
    public static String lastImageFileChooserDirectory;
    public static String lastImageFileChooserFilter;
    private static boolean l;
    private static FileFilter m;
    private static FileFilter n;
    private static FileFilter o;
    private static FileFilter p;

    public IlvSymbolEditorView(IlvSymbolEditorDocument ilvSymbolEditorDocument) {
        this.c = ilvSymbolEditorDocument;
        this.a = new IlvManagerView(ilvSymbolEditorDocument.getManager());
        this.a.setAntialiasing(true);
        this.a.setKeepingAspectRatio(true);
        this.a.setTripleBufferedLayerCount(1);
        IlvToolTipManager.registerView(this.a);
        IlvJScrollManagerView ilvJScrollManagerView = new IlvJScrollManagerView(this.a);
        this.b = new IlvSymbolEventPanel(this.a, ilvJScrollManagerView, ilvSymbolEditorDocument);
        this.setLayout(new BorderLayout());
        this.add((Component)this.b, "Center");
        this.a();
        this.a.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                IlvSymbolEditorView.this.a();
            }
        });
        ComponentContextManager.getSingleton().registerTarget(this);
        this.b.getSelectionManager().addSelectionListener(new SymbolEventPanelSelectionListener());
        ilvSymbolEditorDocument.addSelectionChangedListener(new RuleSelectionListener());
        this.a.addInteractorListener(new InteractorListener(){

            @Override
            public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
                if (interactorChangedEvent.getOldValue() == null && interactorChangedEvent.getNewValue() != null && !(interactorChangedEvent.getNewValue() instanceof IlvSelectInteractor)) {
                    IlvSymbolEditorView.this.h = IlvSymbolEditorView.this.isSelectMode();
                    IlvSymbolEditorView.this.setSelectMode(false);
                } else if (interactorChangedEvent.getOldValue() != null && !(interactorChangedEvent.getOldValue() instanceof IlvSelectInteractor) && interactorChangedEvent.getNewValue() == null) {
                    IlvSymbolEditorView.this.setSelectMode(IlvSymbolEditorView.this.h);
                }
            }
        });
        new DropTarget(this, new SymbolDropTargetListener());
        this.j = new IlvSelectInteractor();
        this.j.allowEnsureVisible(true);
        this.k = new RunModeListener();
        this.a.getManager().addManagerSelectionListener(this.k);
        this.a.getManager().addManagerContentChangedListener(this.k);
        this.setGridVisible(true);
    }

    public IlvSymbolEditorDocument getDocument() {
        return this.c;
    }

    public IlvManagerView getManagerView() {
        return this.a;
    }

    public IlvSymbolEventPanel getEventPanel() {
        return this.b;
    }

    public void setSelectMode(boolean bl) {
        if (this.c.a()) {
            this.getEventPanel().trapEvent(false);
            if (bl) {
                if (!(this.a.getInteractor() instanceof IlvSelectInteractor)) {
                    this.a.getManager().deSelectAll(false);
                    this.a.setInteractor(this.j);
                }
            } else {
                if (this.a.getInteractor() instanceof IlvSelectInteractor) {
                    this.a.setInteractor(null);
                }
                this.getDocument().getToplevelGraphic().setObjectInteractor(new IlvSymbolEditorInteractor(this));
            }
        } else {
            this.getEventPanel().trapEvent(bl);
            if (bl) {
                while (this.getManagerView().getInteractor() != null) {
                    this.getManagerView().popInteractor();
                }
            } else {
                this.getDocument().getToplevelGraphic().setObjectInteractor(new IlvSymbolEditorInteractor(this));
            }
        }
    }

    public boolean isSelectMode() {
        if (this.c.a()) {
            return this.a.getInteractor() instanceof IlvSelectInteractor;
        }
        return this.getEventPanel().getGlassPane().isVisible();
    }

    public boolean updateGeometry(IlvGraphic ilvGraphic, boolean bl, IlvPoint ilvPoint) {
        Iterator iterator = this.c.getSelection().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        IlvRule ilvRule = this.c.getRuleModel().getMainRuleFromGraphic(ilvGraphic);
        return this.c.getRuleModel().updateGeometry(ilvGraphic, ilvRule, bl, ilvPoint);
    }

    private void a() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IlvTransformer ilvTransformer = IlvSymbolEditorView.this.a.getTransformer();
                ilvTransformer.compose(SymbolEditorUtilities.getRecenterTransformer(IlvSymbolEditorView.this, ilvTransformer));
                IlvSymbolEditorView.this.a.setTransformer(ilvTransformer);
                IlvSymbolEditorView.this.a.repaint();
            }
        });
    }

    public void zoomIn() {
        Dimension dimension = this.getManagerView().getSize();
        this.getManagerView().zoom(new IlvPoint((float)(dimension.getWidth() / 2.0), (float)(dimension.getHeight() / 2.0)), this.f, this.f, true);
    }

    public void zoomOut() {
        Dimension dimension = this.getManagerView().getSize();
        this.getManagerView().zoom(new IlvPoint((float)(dimension.getWidth() / 2.0), (float)(dimension.getHeight() / 2.0)), 1.0 / this.f, 1.0 / this.f, true);
    }

    public void resetZoom() {
        this.getManagerView().setTransformer(SymbolEditorUtilities.getRecenterTransformer(this, null));
        this.repaint();
    }

    public boolean canResetZoom() {
        return !this.getManagerView().getTransformer().equals(SymbolEditorUtilities.getRecenterTransformer(this, null));
    }

    public void fitToContents() {
        this.getManagerView().fitTransformerToContent(new Insets(10, 10, 10, 10));
        this.getManagerView().repaint();
    }

    public boolean isInteractor(IlvManagerViewInteractor ilvManagerViewInteractor) {
        return this.getManagerView().getInteractor() == ilvManagerViewInteractor;
    }

    public void setInteractor(IlvManagerViewInteractor ilvManagerViewInteractor, boolean bl) {
        IlvManagerView ilvManagerView = this.getManagerView();
        if (bl) {
            if (ilvManagerView.getInteractor() != ilvManagerViewInteractor) {
                while (ilvManagerView.getInteractor() != null) {
                    ilvManagerView.popInteractor();
                }
                if (ilvManagerViewInteractor instanceof IlvPermanentInteractorInterface) {
                    ((IlvPermanentInteractorInterface)((Object)ilvManagerViewInteractor)).setPermanent(this.g);
                }
                ilvManagerView.pushInteractor(ilvManagerViewInteractor);
            }
        } else if (ilvManagerView.getInteractor() == ilvManagerViewInteractor) {
            ilvManagerView.popInteractor();
        }
    }

    public void cut() {
        this.getDocument().cut(this.b());
    }

    public void copy() {
        this.getDocument().copy(this.b());
    }

    public void paste() {
        this.getDocument().paste(this.b());
    }

    public boolean canCut() {
        try {
            return this.getDocument().canDelete() && this.b() != null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    public boolean canCopy() {
        return this.getDocument().canCopy() && this.b() != null;
    }

    public boolean canPaste() {
        return this.b() != null && this.getDocument().canPaste(this.b());
    }

    private IlvSymbolEditorDocument.Clipboard b() {
        ComponentContext componentContext = ComponentContextManager.getSingleton().getContext(this);
        if (componentContext != null) {
            IlvSymbolEditorDocument.Clipboard clipboard = (IlvSymbolEditorDocument.Clipboard)componentContext.getProperty(e);
            if (clipboard == null) {
                clipboard = new IlvSymbolEditorDocument.Clipboard();
                componentContext.setProperty(e, clipboard);
            }
            return clipboard;
        }
        return null;
    }

    public void addShape() {
        IlvGraphic ilvGraphic = SymbolEditorUtilities.chooseShape(this);
        if (ilvGraphic != null) {
            IlvGraphic ilvGraphic2 = ilvGraphic.copy();
            ilvGraphic2.setName(ilvGraphic.getName());
            this.getDocument().addGraphic(ilvGraphic2, false, this.a(ilvGraphic2));
        }
    }

    public void addDecoration() {
        IlvGraphic ilvGraphic = SymbolEditorUtilities.chooseDecoration(this);
        if (ilvGraphic != null) {
            IlvGraphic ilvGraphic2 = ilvGraphic.copy();
            ilvGraphic2.setName(ilvGraphic.getName());
            this.getDocument().addGraphic(ilvGraphic2, false, this.a(ilvGraphic2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeShape() {
        IlvGraphic ilvGraphic;
        IlvGraphic ilvGraphic2 = SymbolEditorUtilities.chooseShape(this);
        if (ilvGraphic2 != null && (ilvGraphic = SymbolEditorUtilities.translateGraphic(ilvGraphic2, false)) instanceof IlvGeneralPath) {
            List list = this.getDocument().getSelection();
            IlvSymbolRuleModel ilvSymbolRuleModel = this.getDocument().getRuleModel();
            try {
                ilvSymbolRuleModel.setAdjusting(true);
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof IlvRule)) continue;
                    IlvGeneralPath ilvGeneralPath = (IlvGeneralPath)this.getDocument().getRuleModel().getGraphicFromRule((IlvRule)e);
                    GeneralPath generalPath = new GeneralPath(((IlvGeneralPath)ilvGraphic).getShape());
                    IlvRect ilvRect = SymbolEditorUtilities.getAttachmentBounds(ilvGeneralPath);
                    boolean bl = ilvGeneralPath.isTransformedShapeMode();
                    ilvGeneralPath.setTransformedShapeMode(false);
                    ilvGeneralPath.setShape(generalPath);
                    ilvGeneralPath.setShapeBounds(ilvRect);
                    boolean bl2 = ilvGeneralPath.isPointEditionAllowed();
                    ilvGeneralPath.setPointEditionAllowed(true);
                    ilvSymbolRuleModel.updateGeometry(ilvGeneralPath, (IlvRule)e, false, null);
                    ilvGeneralPath.setPointEditionAllowed(bl2);
                    ilvGeneralPath.setTransformedShapeMode(bl);
                }
            }
            finally {
                ilvSymbolRuleModel.setAdjusting(false);
            }
        }
    }

    public boolean canChangeShape() {
        List list = this.getDocument().getSelection();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof IlvRule) {
                IlvGraphic ilvGraphic = this.getDocument().getRuleModel().getGraphicFromRule((IlvRule)e);
                if (!(ilvGraphic instanceof IlvGeneralPath)) {
                    return false;
                }
            } else {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public void addImage() {
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
        File file = this.c();
        if (file != null) {
            try {
                IlvGraphic ilvGraphic = this.a(file);
                String string = this.b(file) ? "Bitmap" : (this.c(file) ? "SVG" : (this.e(file) ? "DXF" : "IVL"));
                if ((this.c(file) || this.d(file)) && !l) {
                    final JCheckBox jCheckBox = new JCheckBox(resourceBundle.getString("SymbolEditor.AddImage.AddingVectorGraphics.DontShowThisAgain"));
                    jCheckBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent itemEvent) {
                            l = jCheckBox.isSelected();
                        }
                    });
                    Object[] objectArray = new Object[2];
                    objectArray[0] = resourceBundle.getString("SymbolEditor.AddImage.AddingVectorGraphics.Message");
                    objectArray[1] = jCheckBox;
                    JOptionPane.showMessageDialog(this, objectArray, resourceBundle.getString("SymbolEditor.AddImage.AddingVectorGraphics.Title"), 1);
                }
                this.getDocument().addObject(ilvGraphic, string, this.a(ilvGraphic));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = MessageFormat.format(resourceBundle.getString("SymbolEditor.AddImage.CannotLoadImage.Format"), file);
                IlvSwingUtil.showErrorDialog(this, string, exception);
            }
        }
    }

    private IlvGraphic a(File file) throws InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, MalformedURLException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        IlvGraphic ilvGraphic = null;
        if (this.b(file)) {
            IlvIcon ilvIcon = new IlvIcon();
            ilvIcon.setImageLocation(IlvURLUtil.convertFileToAbsoluteURL(file).toExternalForm());
            ilvGraphic = ilvIcon;
        } else {
            if (!this.c(file) && !this.d(file)) {
                if (!this.e(file)) {
                    throw new RuntimeException("Unexpected file type: " + file);
                }
            }
            Class<?> clazz = Class.forName("ilog.views.sdm.graphic.IlvURLGraphic");
            ilvGraphic = (IlvGraphic)clazz.newInstance();
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            clazz.getMethod("setURL", classArray).invoke((Object)ilvGraphic, IlvURLUtil.convertFileToAbsoluteURL(file).toExternalForm());
        }
        return ilvGraphic;
    }

    private File c() {
        Object object;
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(resourceBundle.getString("SymbolEditor.AddImage.FileChooser.Title"));
        if (m == null) {
            String[] stringArray = new String[4];
            stringArray[0] = ".png";
            stringArray[1] = ".jpg";
            stringArray[2] = ".jpeg";
            stringArray[3] = ".gif";
            m = new MyFileFilter(stringArray, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.BitmapFilesDescription"));
            String[] stringArray2 = new String[2];
            stringArray2[0] = ".svg";
            stringArray2[1] = ".svgz";
            n = new MyFileFilter(stringArray2, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.SVGFilesDescription"));
            String[] stringArray3 = new String[1];
            stringArray3[0] = ".ivl";
            o = new MyFileFilter(stringArray3, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.IVLFilesDescription"));
            String[] stringArray4 = new String[1];
            stringArray4[0] = ".dxf";
            p = new MyFileFilter(stringArray4, resourceBundle.getString("SymbolEditor.AddImage.FileChooser.DXFFilesDescription"));
        }
        jFileChooser.addChoosableFileFilter(m);
        try {
            Class.forName("ilog.views.sdm.graphic.IlvURLGraphic");
            jFileChooser.addChoosableFileFilter(n);
            jFileChooser.addChoosableFileFilter(o);
            jFileChooser.addChoosableFileFilter(p);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object object2 = null;
        if (lastImageFileChooserFilter != null) {
            object = jFileChooser.getChoosableFileFilters();
            for (int i = 0; i < ((FileFilter[])object).length; ++i) {
                if (!(object[i] instanceof MyFileFilter)) continue;
                for (int j = 0; j < ((MyFileFilter)object[i]).a.length; ++j) {
                    if (!((MyFileFilter)object[i]).a[j].equals(lastImageFileChooserFilter)) continue;
                    object2 = object[i];
                    break;
                }
                if (object2 != null) break;
            }
        }
        if (object2 == null) {
            object2 = m;
        }
        jFileChooser.setFileFilter((FileFilter)object2);
        if (lastImageFileChooserDirectory != null) {
            jFileChooser.setCurrentDirectory(new File(lastImageFileChooserDirectory));
        }
        object = new IlvJManagerViewPanel(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, super.getPreferredSize().height);
            }
        };
        ((IlvJManagerViewPanel)object).getManagerView().setKeepingAspectRatio(true);
        ((IlvJManagerViewPanel)object).getManagerView().setMaxZoomXFactor(1.0);
        ((IlvJManagerViewPanel)object).getManagerView().setMaxZoomYFactor(1.0);
        ((JComponent)object).setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel jLabel = new JLabel(resourceBundle.getString("SymbolEditor.AddImage.FileChooser.Preview"));
        jLabel.setHorizontalAlignment(0);
        jPanel.add((Component)jLabel, "First");
        jPanel.add((Component)object, "Center");
        jFileChooser.setAccessory(jPanel);
        jFileChooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener((IlvJManagerViewPanel)object){
            final /* synthetic */ IlvJManagerViewPanel b;
            {
                this.b = ilvJManagerViewPanel;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                File file = jFileChooser.getSelectedFile();
                if (file != null) {
                    this.b.getManagerView().getManager().deleteAll(false);
                    try {
                        IlvGraphic ilvGraphic = IlvSymbolEditorView.this.a(file);
                        this.b.getManagerView().getManager().addObject(ilvGraphic, false);
                        this.b.getManagerView().fitTransformerToContent(new Insets(5, 5, 5, 5));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    finally {
                        this.b.getManagerView().repaint();
                    }
                }
            }
        });
        if (jFileChooser.showOpenDialog(this) == 0) {
            lastImageFileChooserDirectory = jFileChooser.getCurrentDirectory().getPath();
            lastImageFileChooserFilter = jFileChooser.getFileFilter() instanceof MyFileFilter ? ((MyFileFilter)jFileChooser.getFileFilter()).a[0] : null;
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private boolean b(File file) {
        return m.accept(file);
    }

    private boolean c(File file) {
        return n.accept(file);
    }

    private boolean d(File file) {
        return o.accept(file);
    }

    private boolean e(File file) {
        return p.accept(file);
    }

    private IlvRect a(IlvGraphic ilvGraphic) {
        int n = this.getManagerView().getWidth();
        int n2 = this.getManagerView().getHeight();
        IlvRect ilvRect = ilvGraphic.boundingBox();
        IlvPoint ilvPoint = new IlvPoint(((float)n - ilvRect.width) / 2.0f, ((float)n2 - ilvRect.height) / 2.0f);
        IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
        ilvTransformer.inverse(ilvPoint);
        return new IlvRect(ilvPoint.x, ilvPoint.y, 0.0f, 0.0f);
    }

    public void viewCSS() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        IlvRule[] ilvRuleArray = this.getDocument().getRuleModel().getAllRules(true);
        for (int i = 0; i < ilvRuleArray.length; ++i) {
            ilvRuleArray[i].printCSS(printWriter, null);
        }
        printWriter.flush();
        String string = stringWriter.toString();
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setRows(20);
        jTextArea.setColumns(70);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
        JOptionPane.showMessageDialog(this, jScrollPane, resourceBundle.getString("SymbolEditor.ViewCSS.Title"), -1);
    }

    public void reparent() {
        final IlvSymbolTree ilvSymbolTree = new IlvSymbolTree(true);
        ilvSymbolTree.setDocument(this.c);
        ilvSymbolTree.clearSelection();
        final IlvRule[] ilvRuleArray = new IlvRule[1];
        ilvSymbolTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                IlvGraphic ilvGraphic;
                IlvRule ilvRule = ilvSymbolTree.getSelectedParentRule();
                if (!(ilvRule == null || (ilvGraphic = IlvSymbolEditorView.this.getDocument().getRuleModel().getGraphicFromRule(ilvRule)) instanceof IlvCompositeGraphic && IlvSymbolEditorView.this.getDocument().canReparent(ilvRule))) {
                    ilvRule = null;
                }
                ilvRuleArray[0] = ilvRule;
                ilvSymbolTree.getRootPane().getDefaultButton().setEnabled(ilvRule != null);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(ilvSymbolTree);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
        if (SymbolEditorUtilities.showDialog(this, resourceBundle.getString("SymbolEditor.Reparent.Title"), jScrollPane, false) && ilvRuleArray[0] != null) {
            this.getDocument().reparent(ilvRuleArray[0]);
        }
    }

    public boolean canReparent() {
        return this.c.canReparent(null);
    }

    private IlvGrid d() {
        if (this.i == null) {
            this.i = new IlvGrid();
        }
        return this.i;
    }

    public boolean isGridVisible() {
        return this.getManagerView().getGrid() != null;
    }

    public void setGridVisible(boolean bl) {
        IlvManagerView ilvManagerView = this.getManagerView();
        ilvManagerView.setGrid(bl ? this.d() : null);
        ilvManagerView.repaint();
    }

    public void changeGridSpacing() {
        ResourceBundle resourceBundle = IlvResourceUtil.getBundle("ilog.views.symbology.editor.symboleditor", IlvLocaleUtil.getCurrentLocale(), IlvSymbolEditorDocument.class.getClassLoader());
        float f = this.d().getHorizontalSpacing();
        Object object = IlvSwingUtil.showInputDialog(this.getManagerView(), resourceBundle.getString("SymbolEditor.GridSpacing.Message"), resourceBundle.getString("SymbolEditor.GridSpacing.Title"), -1, null, null, String.valueOf(f));
        if (object instanceof String) {
            try {
                f = Float.parseFloat((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                f = 0.0f;
            }
            if (f > 0.0f) {
                this.d().setHorizontalSpacing(f);
                this.d().setVerticalSpacing(f);
                this.getManagerView().invalidateTripleBuffer(true);
            } else {
                String string = MessageFormat.format(resourceBundle.getString("SymbolEditor.GridSpacing.InvalidSpacing"), object);
                IlvSwingUtil.showErrorDialog(this, string, null);
            }
        }
    }

    public void addImageList() {
        ImageListWizard imageListWizard = new ImageListWizard(this.getDocument());
        imageListWizard.run(this.getManagerView());
    }

    private class SymbolDropTargetListener
    implements DropTargetListener {
        private SymbolDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i] != IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR) continue;
                return;
            }
            dropTargetDragEvent.rejectDrag();
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            IlvPaletteSymbol ilvPaletteSymbol = this.a(dropTargetDropEvent.getTransferable());
            if (ilvPaletteSymbol != null) {
                IlvPoint ilvPoint = new IlvPoint(dropTargetDropEvent.getLocation().x, dropTargetDropEvent.getLocation().y);
                IlvTransformer ilvTransformer = IlvSymbolEditorView.this.getManagerView().getTransformer();
                ilvTransformer.inverse(ilvPoint);
                IlvSymbolEditorView.this.getDocument().addSymbol(ilvPaletteSymbol, ilvPoint);
            }
        }

        private IlvPaletteSymbol a(Transferable transferable) {
            if (transferable != null) {
                try {
                    IlvPaletteDragAndDropData ilvPaletteDragAndDropData = (IlvPaletteDragAndDropData)transferable.getTransferData(IlvPaletteObjectTransferable.PALETTE_OBJECT_FLAVOR);
                    if (ilvPaletteDragAndDropData.getPaletteObject() instanceof IlvPaletteSymbol) {
                        return (IlvPaletteSymbol)ilvPaletteDragAndDropData.getPaletteObject();
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return null;
        }
    }

    private static class MyFileFilter
    extends FileFilter {
        private String[] a;
        private String b;

        MyFileFilter(String[] stringArray, String string) {
            this.a = stringArray;
            this.b = string;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.a.length; ++i) {
                if (!file.getName().toLowerCase(Locale.US).endsWith(this.a[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.b;
        }
    }

    private class RuleSelectionListener
    implements SelectionChangedListener {
        private RuleSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            if (IlvSymbolEditorView.this.d) {
                return;
            }
            try {
                IlvSymbolEditorView.this.d = true;
                IlvSymbolEditorDocument ilvSymbolEditorDocument = selectionChangedEvent.getDocument();
                IlvSymbolEventPanel ilvSymbolEventPanel = IlvSymbolEditorView.this.getEventPanel();
                ilvSymbolEventPanel.getSelectionManager().clear();
                List list = ilvSymbolEditorDocument.getSelection();
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        Object e = list.get(i);
                        if (!(e instanceof IlvRule)) continue;
                        ilvSymbolEditorDocument.applyChanges(false);
                        IlvGraphic ilvGraphic = ilvSymbolEditorDocument.getRuleModel().getGraphicFromRule((IlvRule)e);
                        ilvSymbolEventPanel.select(ilvGraphic, false, true);
                    }
                }
                ilvSymbolEventPanel.repaint();
            }
            finally {
                IlvSymbolEditorView.this.d = false;
            }
        }

        @Override
        public void refresh() {
            IlvSymbolEventPanel ilvSymbolEventPanel = IlvSymbolEditorView.this.getEventPanel();
            ilvSymbolEventPanel.updateSelection();
        }
    }

    private class SymbolEventPanelSelectionListener
    implements SelectionListener {
        private SymbolEventPanelSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectionChanged(SelectionEvent selectionEvent) {
            if (IlvSymbolEditorView.this.d) {
                return;
            }
            try {
                IlvSymbolEditorView.this.d = true;
                IlvSymbolRuleModel ilvSymbolRuleModel = IlvSymbolEditorView.this.getDocument().getRuleModel();
                ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
                Iterator iterator = IlvSymbolEditorView.this.getEventPanel().getSelectionManager().getSelectableIterator();
                while (iterator.hasNext()) {
                    IlvSelectable ilvSelectable = (IlvSelectable)iterator.next();
                    IlvRule ilvRule = ilvSymbolRuleModel.getMainRuleFromGraphic(((IlvSymbolGraphicSelectable)ilvSelectable).getGraphic());
                    if (ilvRule == null) continue;
                    arrayList.add(ilvRule);
                }
                IlvSymbolEditorView.this.getDocument().setSelection(arrayList);
            }
            finally {
                IlvSymbolEditorView.this.d = false;
            }
        }
    }

    private class RunModeListener
    implements ManagerSelectionListener,
    ManagerContentChangedListener {
        private RunModeListener() {
        }

        @Override
        public void selectionChanged(ManagerSelectionChangedEvent managerSelectionChangedEvent) {
            IlvSymbolEditorView.this.c.setSelected(IlvSymbolEditorView.this.a.getManager().isSelected(IlvSymbolEditorView.this.c.getToplevelGraphic()));
        }

        @Override
        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            if (IlvSymbolEditorView.this.c.a() && managerContentChangedEvent.getType() == 4 && (IlvSymbolEditorView.this.isSelectMode() || IlvSymbolEditorView.this.a.getInteractor() instanceof IlvSelectInteractorMoveSelection)) {
                IlvRect ilvRect = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getOldBoundingBox();
                IlvRect ilvRect2 = ((ObjectBBoxChangedEvent)managerContentChangedEvent).getNewBoundingBox();
                if (!ilvRect2.equals(ilvRect)) {
                    IlvSymbolEditorView.this.c.updateBBox();
                    IlvRect ilvRect3 = new IlvRect(ilvRect2);
                    IlvSymbolEditorView.this.a.getTransformer().apply(ilvRect3);
                    IlvSymbolEditorView.this.a.ensureVisible(ilvRect3);
                }
            }
        }
    }
}

