/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbology.builder;

import ilog.views.IlvGraphic;
import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.builder.IlvBuilder;
import ilog.views.builder.docview.IlvMessageView;
import ilog.views.css.model.IlvRule;
import ilog.views.symbology.builder.docview.IlvSymbolDesignerDocument;
import ilog.views.symbology.editor.IlvSymbolEditorDocument;
import ilog.views.symbology.editor.internal.SymbolEditorUtilities;
import ilog.views.symbology.palettes.IlvPalette;
import ilog.views.symbology.palettes.IlvPaletteBaseObject;
import ilog.views.symbology.palettes.IlvPaletteCategory;
import ilog.views.symbology.palettes.IlvPaletteCategoryChild;
import ilog.views.symbology.palettes.IlvPaletteManager;
import ilog.views.symbology.palettes.IlvPaletteObject;
import ilog.views.symbology.palettes.IlvPaletteSymbol;
import ilog.views.symbology.palettes.IlvPaletteSymbolParameter;
import ilog.views.symbology.palettes.event.PaletteManagerEvent;
import ilog.views.symbology.palettes.event.PaletteManagerListener;
import ilog.views.symbology.palettes.swing.IlvPaletteTreeViewer;
import ilog.views.util.IlvImageUtil;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.swing.IlvJComboBox;
import ilog.views.util.swing.context.ComponentAction;
import ilog.views.util.swing.context.ComponentContext;
import ilog.views.util.swing.context.ComponentContextManager;
import ilog.views.util.swing.internal.IlvFileFilterByExtension;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class IlvSymbolDesignerUtilities {
    public static final String SYMBOL_PALETTE_CHANGED_MSG = "SymbolPaletteChanged";
    public static final String SYMBOL_PALETTE_RENAMED_MSG = "SymbolPaletteRenamed";
    public static final String SYMBOL_OPENED_MSG = "SymbolOpened";
    public static final String DEFAULT_SYMBOL_PALETTE_PROPERTY = "DefaultSymbolPalette";
    public static final boolean SUPPORT_CHARTS_PALETTE = false;
    private static final String a = "_symbol_/";
    private static HashMap b = new HashMap();
    public static String lastPaletteFileChooserDirectory;

    public static String getPaletteObjectURL(URL uRL, String string) {
        return uRL.toExternalForm() + a + string;
    }

    public static URL getPaletteURL(String string) throws MalformedURLException {
        int n = string.lastIndexOf(a);
        if (n > 0) {
            return new URL(string.substring(0, n));
        }
        return new URL(string);
    }

    public static String getPaletteObjectName(String string) {
        int n = string.lastIndexOf(a);
        if (n > 0) {
            String string2 = string.substring(n + a.length());
            if (string2.endsWith(".jar")) {
                string2 = string2.substring(0, string2.length() - 4);
            }
            return string2;
        }
        return null;
    }

    public static String getPaletteObjectPath(IlvPaletteObject ilvPaletteObject) {
        return SymbolEditorUtilities.getPaletteObjectPath(ilvPaletteObject);
    }

    public static IlvPaletteManager getPaletteManager(IlvApplication ilvApplication) {
        IlvPaletteManager ilvPaletteManager = (IlvPaletteManager)ilvApplication.getProperty(IlvPaletteManager.class.getName());
        if (ilvPaletteManager == null) {
            ilvPaletteManager = new IlvPaletteManager();
            ilvApplication.setProperty(IlvPaletteManager.class.getName(), ilvPaletteManager);
            ilvPaletteManager.setWorkingDirectory(IlvSymbolDesignerUtilities.getPaletteWorkingDirectory(ilvApplication));
        }
        return ilvPaletteManager;
    }

    public static File getPaletteWorkingDirectory(IlvApplication ilvApplication) {
        int n = 0;
        while (true) {
            try {
                File file = File.createTempFile("palettes", "");
                file.delete();
                File file2 = new File(file.getPath());
                file2.mkdir();
                file2.deleteOnExit();
                return file2;
            }
            catch (IOException iOException) {
                if (n++ > 10) {
                    IlvBuilder.showErrorBox(ilvApplication, "SymbolDesigner.CannotCreateTemporaryPaletteDirectory", iOException);
                    return null;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    public static URL getDefaultPalette(IlvApplication ilvApplication) {
        return (URL)ilvApplication.getProperty(DEFAULT_SYMBOL_PALETTE_PROPERTY);
    }

    public static void setDefaultPalette(IlvApplication ilvApplication, URL uRL) {
        ilvApplication.setProperty(DEFAULT_SYMBOL_PALETTE_PROPERTY, uRL);
    }

    public static void openSymbol(IlvApplication ilvApplication, URL uRL, String string) {
        ilvApplication.openDocumentFile(IlvSymbolDesignerUtilities.getPaletteObjectURL(uRL, string), true, true);
    }

    public static void openPalette(IlvApplication ilvApplication, URL uRL) {
        IlvPaletteManager ilvPaletteManager = IlvSymbolDesignerUtilities.getPaletteManager(ilvApplication);
        IlvPalette ilvPalette = SymbolEditorUtilities.getPalette(ilvPaletteManager, uRL);
        if (ilvPalette == null) {
            try {
                ilvPaletteManager.load(uRL);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean rename(IlvSymbolDesignerDocument ilvSymbolDesignerDocument, Object object, String string) {
        int n;
        block15: {
            block14: {
                if (!IlvSymbolDesignerUtilities.b(string)) {
                    String string2 = ilvSymbolDesignerDocument.getApplication().getString("SymbolDesigner.InvalidName");
                    JOptionPane.showMessageDialog(IlvBuilder.getBuilder(ilvSymbolDesignerDocument.getApplication()).getFrame(), string2, ilvSymbolDesignerDocument.getApplication().getString("Builder.Error.Title"), 0);
                    return false;
                }
                if (string.equals("x")) break block14;
                if (string.equals("y")) break block14;
                if (string.equals("width")) break block14;
                if (string.equals("height")) break block14;
                if (string.equals("editable")) break block14;
                if (string.equals("movable")) break block14;
                if (string.equals("selectable")) break block14;
                if (string.equals("boundingBox")) break block14;
                if (string.equals("graphicBag")) break block14;
                if (!string.equals("Symbol")) break block15;
            }
            String string3 = ilvSymbolDesignerDocument.getApplication().getString("SymbolDesigner.InvalidParameterName");
            JOptionPane.showMessageDialog(IlvBuilder.getBuilder(ilvSymbolDesignerDocument.getApplication()).getFrame(), string3, ilvSymbolDesignerDocument.getApplication().getString("Builder.Error.Title"), 0);
            return false;
        }
        IlvPaletteSymbolParameter[] ilvPaletteSymbolParameterArray = IlvPaletteSymbol.getGraphicParameters();
        for (n = 0; n < ilvPaletteSymbolParameterArray.length; ++n) {
            if (!ilvPaletteSymbolParameterArray[n].getID().equals(string)) continue;
            IlvBuilder.showErrorBox(ilvSymbolDesignerDocument.getApplication(), "SymbolDesigner.InvalidParameterName", null);
            return false;
        }
        if (object instanceof IlvRule) {
            object = SymbolEditorUtilities.hasCondition((IlvRule)object) ? null : ilvSymbolDesignerDocument.getEditorDocument().getRuleModel().getGraphicFromRule((IlvRule)object);
        }
        if (object instanceof IlvPaletteSymbol) {
            String string4 = ilvSymbolDesignerDocument.getEditorDocument().getSymbol().getName();
            ilvSymbolDesignerDocument.getEditorDocument().renameSymbol(string);
            IlvDocument[] ilvDocumentArray = ilvSymbolDesignerDocument.getApplication().getOpenDocuments();
            for (int i = 0; i < ilvDocumentArray.length; ++i) {
                if (!(ilvDocumentArray[i] instanceof IlvSymbolDesignerDocument) || ilvDocumentArray[i] == ilvSymbolDesignerDocument) continue;
                IlvSymbolDesignerDocument ilvSymbolDesignerDocument2 = (IlvSymbolDesignerDocument)ilvDocumentArray[i];
                IlvSymbolEditorDocument ilvSymbolEditorDocument = ilvSymbolDesignerDocument2.getEditorDocument();
                IlvRule[] ilvRuleArray = ilvSymbolEditorDocument.getRuleModel().getAllRules(false);
                for (int j = 0; j < ilvRuleArray.length; ++j) {
                    IlvCSSDeclaration ilvCSSDeclaration = ilvRuleArray[j].getDeclaration("class");
                    String string5 = ilvCSSDeclaration.getValue();
                    if (!string5.startsWith("@|symbolResource(") || string5.indexOf(string4) == -1) continue;
                    string5 = string5.replace(string4, string);
                    ilvRuleArray[j].setDeclaration("class", string5);
                }
            }
        } else if (object instanceof IlvGraphic || object instanceof IlvPaletteSymbolParameter) {
            Serializable serializable;
            n = object instanceof IlvGraphic;
            Serializable serializable2 = serializable = n != 0 ? SymbolEditorUtilities.findGraphicByName(ilvSymbolDesignerDocument.getEditorDocument(), string) : SymbolEditorUtilities.findParameterByName(ilvSymbolDesignerDocument.getEditorDocument(), string);
            if (serializable != null && serializable != object) {
                IlvApplication ilvApplication = ilvSymbolDesignerDocument.getApplication();
                String string6 = MessageFormat.format(ilvApplication.getString("SymbolDesigner." + (n != 0 ? "Element" : "Parameter") + "Exists.Format"), string);
                JOptionPane.showMessageDialog(IlvBuilder.getBuilder(ilvApplication).getFrame(), string6, ilvApplication.getString("SymbolDesigner." + (n != 0 ? "Element" : "Parameter") + "Exists.Title"), 0);
                return false;
            }
            if (n != 0) {
                ilvSymbolDesignerDocument.getEditorDocument().renameObject((IlvGraphic)object, string);
            } else {
                ilvSymbolDesignerDocument.getEditorDocument().renameParameter((IlvPaletteSymbolParameter)object, string);
            }
        }
        return true;
    }

    private static boolean b(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.charAt(0) == '_') {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public static void invokeLaterOnce(Object object, Runnable runnable) {
        Invoker invoker = (Invoker)b.get(object);
        if (invoker == null) {
            invoker = new Invoker(object, runnable);
            b.put(object, invoker);
        } else {
            invoker.c = runnable;
            invoker.b.restart();
        }
    }

    public static File choosePaletteFile(IlvApplication ilvApplication, boolean bl, File file) {
        JFileChooser jFileChooser = new JFileChooser();
        String[] stringArray = new String[1];
        stringArray[0] = "jar";
        jFileChooser.setFileFilter(new IlvFileFilterByExtension(stringArray, ilvApplication.getString("SymbolDesigner.PaletteFilterDescription"), false));
        jFileChooser.setDialogType(bl ? 0 : 1);
        jFileChooser.setDialogTitle(ilvApplication.getString("SymbolDesigner." + (bl ? "Open" : "Save") + "PaletteFile.Title"));
        if (lastPaletteFileChooserDirectory != null) {
            jFileChooser.setCurrentDirectory(new File(lastPaletteFileChooserDirectory));
        }
        if (file != null) {
            jFileChooser.setSelectedFile(file);
        }
        JFrame jFrame = IlvBuilder.getBuilder(ilvApplication).getFrame();
        while (jFileChooser.showDialog(jFrame, null) == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (!bl && file2.exists()) {
                int n = JOptionPane.showConfirmDialog(jFrame, ilvApplication.getString("SymbolDesigner.ReplacePaletteFile.Message"), ilvApplication.getString("SymbolDesigner.ReplacePaletteFile.Title"), 1);
                if (n == 1) continue;
                if (n == 2) {
                    return null;
                }
            }
            if (!bl && !file2.exists() && file2.getName().indexOf(46) < 0) {
                file2 = new File(file2.getPath() + ".jar");
            }
            lastPaletteFileChooserDirectory = jFileChooser.getCurrentDirectory().getPath();
            return file2;
        }
        return null;
    }

    public static String chooseSymbol(final IlvApplication ilvApplication, String string, final String string2, final boolean bl, Component component) {
        URL uRL;
        String string3;
        Object object;
        Object object2;
        Object object3;
        IlvPaletteManager ilvPaletteManager = IlvSymbolDesignerUtilities.getPaletteManager(ilvApplication);
        final IlvPaletteManager ilvPaletteManager2 = new IlvPaletteManager();
        for (int i = 0; i < ilvPaletteManager.getPaletteCount(); ++i) {
            try {
                ilvPaletteManager2.load(ilvPaletteManager.getPalette(i).getJarURL());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ilvPaletteManager2.setWorkingDirectory(ilvPaletteManager.getWorkingDirectory());
        String string4 = bl ? "Open" : "Save";
        String string5 = ilvApplication.getString("SymbolDesigner.ChooseSymbol." + string4 + "Title");
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        final JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string5, true) : new JDialog((Dialog)window, string5, true);
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jDialog.setContentPane(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(2, 2, 3, 3);
        HtmlLabel htmlLabel = new HtmlLabel(ilvApplication.getString("SymbolDesigner.ChooseSymbol.ChoosePalette" + string4), false);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)htmlLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        final IlvJComboBox ilvJComboBox = new IlvJComboBox((ComboBoxModel)new PaletteManagerComboModel(ilvPaletteManager2)){

            @Override
            protected Object defaultRendererAdaptedValue(Object object) {
                if (object instanceof IlvPalette) {
                    return ((IlvPalette)object).getName(IlvLocaleUtil.getCurrentLocale());
                }
                return object;
            }
        };
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)ilvJComboBox, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        JButton jButton = new JButton(ilvApplication.getString("SymbolDesigner.ChooseSymbol.OpenPalette"));
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.fill = 1;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        final JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setBackground(jPanel.getBackground());
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jScrollPane.setBorder(new TitledBorder(ilvApplication.getString("SymbolDesigner.ChooseSymbol.PaletteDescription")));
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        JButton jButton2 = new JButton(ilvApplication.getString("SymbolDesigner.ChooseSymbol.NewPalette"));
        jButton2.setEnabled(!bl);
        if (!bl) {
            gridBagConstraints.fill = 2;
            jPanel.add((Component)jButton2, gridBagConstraints);
            gridBagConstraints.fill = 1;
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)jSeparator, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        HtmlLabel htmlLabel2 = new HtmlLabel(ilvApplication.getString("SymbolDesigner.ChooseSymbol.ChooseSymbol" + string4), false);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)htmlLabel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        final IlvPaletteTreeViewer ilvPaletteTreeViewer = new IlvPaletteTreeViewer();
        final JTree jTree = (JTree)ilvPaletteTreeViewer.getComponent();
        jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridx;
        final JButton jButton3 = new JButton(ilvApplication.getString("SymbolDesigner.ChooseSymbol.NewCategory"));
        jButton3.setEnabled(false);
        if (!bl) {
            gridBagConstraints.fill = 2;
            jPanel.add((Component)jButton3, gridBagConstraints);
            gridBagConstraints.fill = 1;
            ++gridBagConstraints.gridx;
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        HtmlLabel htmlLabel3 = new HtmlLabel(ilvApplication.getString("SymbolDesigner.ChooseSymbol.SymbolName" + string4), false);
        jPanel.add((Component)htmlLabel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        final JTextField jTextField = new JTextField();
        jTextField.setEditable(!bl);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        final JButton jButton4 = new JButton(ilvApplication.getString("SymbolDesigner.ChooseSymbol." + string4));
        jButton4.setEnabled(false);
        jPanel.add((Component)jButton4, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        final JLabel jLabel = new JLabel();
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        JButton jButton5 = new JButton(ilvApplication.getString("SymbolDesigner.ChooseSymbol.Cancel"));
        jPanel.add((Component)jButton5, gridBagConstraints);
        ilvJComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                block7: {
                    block4: {
                        String string;
                        block6: {
                            block5: {
                                IlvPalette ilvPalette = (IlvPalette)ilvJComboBox.getSelectedItem();
                                ilvPaletteTreeViewer.setPalette(ilvPalette != null ? ilvPalette : new IlvPalette());
                                IlvSymbolDesignerUtilities.expandAll(jTree);
                                if (!bl) {
                                    jTree.setSelectionRow(0);
                                }
                                if (ilvPalette == null) break block4;
                                string = ilvPalette.getDescription(IlvLocaleUtil.getCurrentLocale());
                                if (string == null) break block5;
                                if (string.length() != 0) break block6;
                            }
                            string = ilvApplication.getString("SymbolDesigner.ChooseSymbol.NoDescription");
                        }
                        jTextPane.setText(string);
                        break block7;
                    }
                    jTextPane.setText("");
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvPalette ilvPalette = IlvSymbolDesignerUtilities.newPalette(ilvApplication, ilvPaletteManager2);
                if (ilvPalette != null) {
                    ilvJComboBox.setSelectedItem(ilvPalette);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvPalette ilvPalette = IlvSymbolDesignerUtilities.openPalette(ilvApplication, ilvPaletteManager2);
                if (ilvPalette != null) {
                    ilvJComboBox.setSelectedItem(ilvPalette);
                }
            }
        });
        final boolean[] blArray = new boolean[1];
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                IlvPaletteSymbol ilvPaletteSymbol = IlvSymbolDesignerUtilities.d(ilvPaletteTreeViewer);
                if (!blArray[0]) {
                    blArray[0] = true;
                    if (ilvPaletteSymbol != null) {
                        jTextField.setText(ilvPaletteSymbol.getID());
                    } else if (!jTextField.getText().equals(string2)) {
                        jTextField.setText("");
                    }
                    blArray[0] = false;
                }
                if (bl) {
                    jButton4.setEnabled(ilvPaletteSymbol != null);
                } else {
                    jButton3.setEnabled(IlvSymbolDesignerUtilities.e(ilvPaletteTreeViewer) != null);
                    jButton4.setEnabled(ilvPaletteSymbol != null || IlvSymbolDesignerUtilities.e(ilvPaletteTreeViewer) != null && IlvSymbolDesignerUtilities.b(jTextField.getText()));
                }
            }
        });
        jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && jButton4.isEnabled()) {
                    jDialog.setVisible(false);
                }
            }
        });
        final ArrayList arrayList = new ArrayList();
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvPaletteCategory ilvPaletteCategory = IlvSymbolDesignerUtilities.e(ilvPaletteTreeViewer);
                if (ilvPaletteCategory != null) {
                    String string = ilvApplication.getString("SymbolDesigner.DefaultCategoryName");
                    IlvPaletteCategory ilvPaletteCategory2 = new IlvPaletteCategory(string);
                    ilvPaletteCategory2.setName(string);
                    if (IlvSymbolDesignerUtilities.showPalettePropertiesForm(jPanel, ilvApplication, ilvPaletteCategory2, false)) {
                        ilvPaletteCategory.add(ilvPaletteCategory2);
                        arrayList.add(ilvPaletteCategory2);
                        IlvPalette ilvPalette = (IlvPalette)ilvJComboBox.getSelectedItem();
                        IlvSymbolDesignerUtilities.savePalette(ilvApplication, ilvPaletteManager2, ilvPalette, IlvURLUtil.convertFileURLToFile(ilvPalette.getJarURL()));
                        IlvSymbolDesignerUtilities.expandAll(jTree);
                        for (int i = 0; i < jTree.getRowCount(); ++i) {
                            if (jTree.getPathForRow(i).getLastPathComponent() != ilvPaletteCategory2) continue;
                            jTree.setSelectionRow(i);
                            break;
                        }
                    }
                }
            }
        });
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.a();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.a();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.a();
            }

            private void a() {
                if (!bl) {
                    Object object;
                    if (IlvSymbolDesignerUtilities.d(ilvPaletteTreeViewer) != null && !blArray[0] && (object = jTree.getSelectionPath()) != null) {
                        blArray[0] = true;
                        jTree.setSelectionPath(((TreePath)object).getParentPath());
                        blArray[0] = false;
                    }
                    if (!IlvSymbolDesignerUtilities.b((String)(object = jTextField.getText()))) {
                        if (object != null && ((String)object).length() > 0) {
                            jLabel.setIcon(new ImageIcon(IlvImageUtil.loadImage(this.getClass().getResource(ilvApplication.getString("SymbolDesigner.ChooseSymbol.ErrorIcon")))));
                            jLabel.setText(ilvApplication.getString("SymbolDesigner.ChooseSymbol.InvalidName"));
                        } else {
                            jLabel.setIcon(null);
                            jLabel.setText("");
                        }
                        jButton4.setEnabled(false);
                    } else {
                        jLabel.setIcon(null);
                        jLabel.setText("");
                        jButton4.setEnabled(IlvSymbolDesignerUtilities.e(ilvPaletteTreeViewer) != null);
                    }
                }
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ilvPaletteTreeViewer.setPalette(null);
                jDialog.setVisible(false);
            }
        });
        if (jDialog.getContentPane() instanceof JComponent) {
            ((JComponent)jDialog.getContentPane()).registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ilvPaletteTreeViewer.setPalette(null);
                    jDialog.setVisible(false);
                }
            }, "close", KeyStroke.getKeyStroke(27, 0), 2);
        }
        IlvPalette ilvPalette = null;
        IlvPaletteSymbol ilvPaletteSymbol = null;
        if (string != null) {
            try {
                URL uRL2 = IlvSymbolDesignerUtilities.getPaletteURL(IlvURLUtil.convertFilenameToAbsoluteURL(string).toExternalForm());
                ilvPalette = SymbolEditorUtilities.getPalette(ilvPaletteManager2, uRL2);
                if (ilvPalette != null && (object3 = IlvSymbolDesignerUtilities.getPaletteObjectName(string)) != null) {
                    ilvPaletteSymbol = (IlvPaletteSymbol)SymbolEditorUtilities.getPaletteObject(ilvPalette, (String)object3);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (ilvPalette == null && ilvPaletteManager2.getPaletteCount() > 0) {
            ilvPalette = ilvPaletteManager2.getPalette(0);
        }
        ilvJComboBox.setSelectedItem(ilvPalette);
        if (ilvPalette == null) {
            ilvPaletteTreeViewer.setPalette(new IlvPalette());
        }
        if (ilvPaletteSymbol != null) {
            jTree.clearSelection();
            ilvPaletteTreeViewer.select(ilvPaletteSymbol);
        } else if (string2 != null) {
            jTextField.setText(string2);
        }
        jDialog.getRootPane().setDefaultButton(jButton4);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        jDialog.setVisible(true);
        for (int i = 0; i < arrayList.size(); ++i) {
            object3 = (IlvPaletteCategory)arrayList.get(i);
            object2 = SymbolEditorUtilities.getPalette(ilvPaletteManager, ((IlvPaletteCategoryChild)object3).getPalette().getJarURL());
            if (object2 == null || (object = (IlvPaletteCategory)SymbolEditorUtilities.getPaletteObject((IlvPalette)object2, string3 = SymbolEditorUtilities.getPaletteObjectPath(((IlvPaletteCategoryChild)object3).getParent()))) == null) continue;
            ((IlvPaletteCategory)object).add((IlvPaletteCategory)((IlvPaletteCategory)object3).copy());
            ilvApplication.sendMessage(null, jDialog, SYMBOL_PALETTE_CHANGED_MSG, new Object[]{object2});
        }
        ilvPalette = ilvPaletteTreeViewer.getPalette();
        if (ilvPalette != null && (uRL = ilvPalette.getJarURL()) != null) {
            object3 = null;
            ilvPaletteSymbol = IlvSymbolDesignerUtilities.d(ilvPaletteTreeViewer);
            if (ilvPaletteSymbol != null) {
                if (!bl && !IlvSymbolDesignerUtilities.confirmOverwriteSymbol(jPanel, ilvApplication, ilvPaletteSymbol.getName())) {
                    return null;
                }
                object3 = SymbolEditorUtilities.getPaletteObjectPath(ilvPaletteSymbol);
            } else {
                object2 = IlvSymbolDesignerUtilities.e(ilvPaletteTreeViewer);
                if (object2 != null && (string3 = jTextField.getText()).length() > 0) {
                    object3 = SymbolEditorUtilities.getPaletteObjectPath((IlvPaletteObject)object2) + "/" + string3;
                    object = ilvPalette.getRoot().getID();
                    if (((String)object3).startsWith((String)object + "/")) {
                        object3 = ((String)object3).substring(((String)object).length() + 1);
                    }
                    if (!bl && SymbolEditorUtilities.getPaletteObject(ilvPalette, (String)object3) != null && !IlvSymbolDesignerUtilities.confirmOverwriteSymbol(jPanel, ilvApplication, string3)) {
                        return null;
                    }
                }
            }
            if (object3 != null) {
                return IlvSymbolDesignerUtilities.getPaletteObjectURL(uRL, (String)object3);
            }
        }
        return null;
    }

    private static IlvPaletteObject c(IlvPaletteTreeViewer ilvPaletteTreeViewer) {
        TreePath treePath;
        if (ilvPaletteTreeViewer.getPalette() != null && (treePath = ((JTree)ilvPaletteTreeViewer.getComponent()).getSelectionPath()) != null && treePath.getLastPathComponent() instanceof IlvPaletteObject) {
            return (IlvPaletteObject)treePath.getLastPathComponent();
        }
        return null;
    }

    private static IlvPaletteSymbol d(IlvPaletteTreeViewer ilvPaletteTreeViewer) {
        IlvPaletteObject ilvPaletteObject = IlvSymbolDesignerUtilities.c(ilvPaletteTreeViewer);
        if (ilvPaletteObject instanceof IlvPaletteSymbol) {
            return (IlvPaletteSymbol)ilvPaletteObject;
        }
        return null;
    }

    private static IlvPaletteCategory e(IlvPaletteTreeViewer ilvPaletteTreeViewer) {
        IlvPaletteObject ilvPaletteObject = IlvSymbolDesignerUtilities.c(ilvPaletteTreeViewer);
        if (ilvPaletteObject instanceof IlvPaletteCategory) {
            return (IlvPaletteCategory)ilvPaletteObject;
        }
        return null;
    }

    public static IlvPalette newPalette(IlvApplication ilvApplication, IlvPaletteManager ilvPaletteManager) {
        String string = ilvApplication.getString("SymbolDesigner.DefaultPaletteName");
        IlvPalette ilvPalette = new IlvPalette();
        ilvPalette.setName(string);
        String string2 = ilvApplication.getString("SymbolDesigner.DefaultRootCategory");
        IlvPaletteCategory ilvPaletteCategory = new IlvPaletteCategory(string2);
        ilvPaletteCategory.setName(string2);
        ilvPalette.setRoot(ilvPaletteCategory);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '/') continue;
            stringBuffer.setCharAt(i, '_');
        }
        ilvPalette.setPackageName("ilog.views.palettes." + stringBuffer);
        if (!IlvSymbolDesignerUtilities.showPaletteProperties(ilvApplication, ilvPalette)) {
            return null;
        }
        File file = IlvSymbolDesignerUtilities.choosePaletteFile(ilvApplication, false, new File(ilvPalette.getName() + ".jar"));
        if (file != null) {
            ilvPaletteManager.add(ilvPalette);
            if (IlvSymbolDesignerUtilities.savePalette(ilvApplication, ilvPaletteManager, ilvPalette, file)) {
                return ilvPalette;
            }
            ilvPaletteManager.remove(ilvPalette);
        }
        return null;
    }

    public static IlvPalette openPalette(IlvApplication ilvApplication, IlvPaletteManager ilvPaletteManager) {
        File file = IlvSymbolDesignerUtilities.choosePaletteFile(ilvApplication, true, null);
        if (file != null) {
            try {
                IlvPalette[] ilvPaletteArray;
                URL uRL = IlvURLUtil.convertFileToAbsoluteURL(file);
                IlvURLUtil.openStream(uRL).close();
                IlvPalette ilvPalette = SymbolEditorUtilities.getPalette(ilvPaletteManager, uRL);
                if (ilvPalette == null && (ilvPaletteArray = ilvPaletteManager.load(uRL)).length > 0) {
                    return ilvPaletteArray[0];
                }
            }
            catch (Exception exception) {
                if (!IlvMessageView.isEnabled(ilvApplication)) {
                    IlvMessageView.getMessageView(ilvApplication);
                }
                IlvBuilder.showErrorBox(ilvApplication, "SymbolDesigner.CannotOpenPalette", exception);
            }
        }
        return null;
    }

    public static boolean savePalette(IlvApplication ilvApplication, IlvPaletteManager ilvPaletteManager, IlvPalette ilvPalette, File file) {
        if (ilvPalette != null) {
            try {
                ilvPaletteManager.save(ilvPalette, file, false, true);
            }
            catch (IOException iOException) {
                IlvBuilder.showErrorBox(ilvApplication, "SymbolDesigner.CannotSavePalette", iOException);
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean showPaletteProperties(IlvApplication ilvApplication, IlvPalette ilvPalette) {
        return IlvSymbolDesignerUtilities.showPalettePropertiesForm(IlvBuilder.getBuilder(ilvApplication).getFrame(), ilvApplication, ilvPalette, true);
    }

    public static boolean showPalettePropertiesForm(Component component, final IlvApplication ilvApplication, final Object object, boolean bl) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        JTextComponent[] jTextComponentArray;
        final JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 3, 3);
        String string = "SymbolDesigner." + (object instanceof IlvPalette ? "Palette" : "Category") + "Form.";
        if (bl) {
            jTextComponentArray = new JLabel(ilvApplication.getString("SymbolDesigner.NewPaletteProperties"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 10;
            gridBagConstraints.insets.bottom = 20;
            jPanel.add((Component)jTextComponentArray, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.left = 2;
            gridBagConstraints.insets.bottom = 3;
        }
        jTextComponentArray = new JTextComponent[3];
        int n = 0;
        final ImageIcon imageIcon = new ImageIcon(IlvImageUtil.loadImage(IlvSymbolDesignerUtilities.class.getResource(ilvApplication.getString("SymbolDesigner.ChooseSymbol.ErrorIcon"))));
        final JLabel jLabel = new JLabel("<html><br><br></html>");
        jLabel.setVerticalTextPosition(1);
        final boolean[] blArray = new boolean[]{bl};
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                String string;
                String string2 = null;
                if (!IlvSymbolDesignerUtilities.b(jTextComponentArray[0].getText())) {
                    string2 = ilvApplication.getString("SymbolDesigner.InvalidName");
                } else if (object instanceof IlvPalette) {
                    string = jTextComponentArray[1].getText();
                    for (int i = 0; i < string.length(); ++i) {
                        n = string.charAt(i);
                        if (Character.isLetterOrDigit((char)n) || n == 46 || n == 95) continue;
                        string2 = ilvApplication.getString("SymbolDesigner.InvalidPackageName");
                    }
                }
                if (string2 != null) {
                    jLabel.setText("<html>" + string2 + "</html>");
                    jLabel.setIcon(imageIcon);
                    if (jPanel.getRootPane().getDefaultButton() != null) {
                        jPanel.getRootPane().getDefaultButton().setEnabled(false);
                    }
                } else {
                    jLabel.setText("");
                    jLabel.setIcon(null);
                    if (jPanel.getRootPane().getDefaultButton() != null) {
                        jPanel.getRootPane().getDefaultButton().setEnabled(true);
                    }
                }
                if (object instanceof IlvPalette) {
                    if (actionEvent.getSource() == jTextComponentArray[0] && blArray[0] && string2 == null) {
                        string = jTextComponentArray[0].getText();
                        String string3 = jTextComponentArray[1].getText();
                        n = string3.lastIndexOf(46);
                        string3 = n > 0 ? string3.substring(0, n) + "." + string : string;
                        jTextComponentArray[1].setText(string3);
                        blArray[0] = true;
                    } else if (actionEvent.getSource() == jTextComponentArray[1]) {
                        blArray[0] = false;
                    }
                }
            }
        };
        boolean bl2 = false;
        if (object instanceof IlvPalette) {
            object5 = (IlvPalette)object;
            bl2 = IlvSymbolDesignerUtilities.getPaletteManager(ilvApplication).isPaletteReadOnly((IlvPalette)object5);
            jTextComponentArray[n] = IlvSymbolDesignerUtilities.a(ilvApplication, jPanel, gridBagConstraints, actionListener, string + "Name", ((IlvPalette)object5).getName());
            jTextComponentArray[n].setEditable(!bl2);
            ++n;
            object4 = ((IlvPalette)object5).getPackageName();
            object4 = ((String)object4).replace('/', '.');
            if (((String)object4).endsWith(".")) {
                object4 = ((String)object4).substring(0, ((String)object4).length() - 1);
            }
            jTextComponentArray[n] = IlvSymbolDesignerUtilities.a(ilvApplication, jPanel, gridBagConstraints, actionListener, string + "PackageName", (String)object4);
            jTextComponentArray[n].setEditable(!bl2);
            jTextComponentArray[++n] = IlvSymbolDesignerUtilities.a(ilvApplication, jPanel, gridBagConstraints, null, string + "Description", ((IlvPalette)object5).getDescription(), 3);
            jTextComponentArray[n].setEditable(!bl2);
            jTextComponentArray[n].setEnabled(!bl2);
            ++n;
            object3 = ((IlvPalette)object5).getJarURL();
            if (object3 != null) {
                object2 = IlvSymbolDesignerUtilities.a(ilvApplication, jPanel, gridBagConstraints, null, string + "JarURL", ((URL)object3).toExternalForm());
                ((JTextComponent)object2).setEditable(false);
            }
        } else {
            object5 = (IlvPaletteCategory)object;
            object4 = ((IlvPaletteCategoryChild)object5).getPalette();
            bl2 = IlvSymbolDesignerUtilities.getPaletteManager(ilvApplication).isPaletteReadOnly((IlvPalette)object4);
            jTextComponentArray[n] = IlvSymbolDesignerUtilities.a(ilvApplication, jPanel, gridBagConstraints, actionListener, string + "Name", ((IlvPaletteBaseObject)object5).getName());
            jTextComponentArray[n].setEditable(!bl2);
            jTextComponentArray[++n] = IlvSymbolDesignerUtilities.a(ilvApplication, jPanel, gridBagConstraints, null, string + "ShortDescription", ((IlvPaletteBaseObject)object5).getShortDescription(), 2);
            jTextComponentArray[n].setEditable(!bl2);
            jTextComponentArray[n].setEnabled(!bl2);
            jTextComponentArray[++n] = IlvSymbolDesignerUtilities.a(ilvApplication, jPanel, gridBagConstraints, null, string + "LongDescription", ((IlvPaletteBaseObject)object5).getLongDescription(), 3);
            jTextComponentArray[n].setEditable(!bl2);
            jTextComponentArray[n].setEnabled(!bl2);
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 5;
        jPanel.add((Component)jLabel, gridBagConstraints);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (jTextComponentArray[0].isShowing()) {
                    actionListener.actionPerformed(new ActionEvent(jTextComponentArray[0], 1001, ""));
                    jTextComponentArray[0].selectAll();
                    jTextComponentArray[0].requestFocus();
                } else {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        Object object6 = object5 = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (object5 == null) {
            object5 = SwingUtilities.getWindowAncestor(ilvApplication.getMainContainer());
        }
        if (SymbolEditorUtilities.showDialog((Component)object5, ilvApplication.getString(string + "Title"), jPanel, !bl2, !bl2)) {
            if (object instanceof IlvPalette) {
                object4 = (IlvPalette)object;
                object3 = ((IlvPalette)object4).getName();
                if (!((String)object3).equals(jTextComponentArray[0].getText())) {
                    ((IlvPalette)object4).setName(jTextComponentArray[0].getText());
                    ilvApplication.sendMessage(null, IlvBuilder.getBuilder(ilvApplication).getFrame(), SYMBOL_PALETTE_RENAMED_MSG, new Object[]{object4});
                }
                object2 = jTextComponentArray[1].getText();
                object2 = ((String)object2).replace('.', '/');
                ((IlvPalette)object4).setPackageName((String)object2);
                ((IlvPalette)object4).setDescription(jTextComponentArray[2].getText());
            } else {
                object4 = (IlvPaletteCategory)object;
                ((IlvPaletteBaseObject)object4).setName(jTextComponentArray[0].getText());
                ((IlvPaletteBaseObject)object4).setID(jTextComponentArray[0].getText());
                ((IlvPaletteBaseObject)object4).setShortDescription(jTextComponentArray[1].getText());
                ((IlvPaletteBaseObject)object4).setLongDescription(jTextComponentArray[2].getText());
            }
            return true;
        }
        return false;
    }

    private static JTextField a(IlvApplication ilvApplication, JPanel jPanel, GridBagConstraints gridBagConstraints, final ActionListener actionListener, String string, String string2) {
        JLabel jLabel = new JLabel(ilvApplication.getString(string));
        jLabel.setHorizontalAlignment(11);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JTextField jTextField = new JTextField();
        jTextField.setColumns(40);
        jTextField.setText(string2);
        jTextField.setCaretPosition(0);
        if (actionListener != null) {
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.a();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.a();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.a();
                }

                private void a() {
                    actionListener.actionPerformed(new ActionEvent(jTextField, 1001, ""));
                }
            });
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jTextField;
    }

    private static JTextArea a(IlvApplication ilvApplication, JPanel jPanel, GridBagConstraints gridBagConstraints, final ActionListener actionListener, String string, String string2, int n) {
        JLabel jLabel = new JLabel(ilvApplication.getString(string));
        jLabel.setHorizontalAlignment(11);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(UIManager.getFont("TextField.font"));
        jTextArea.setLineWrap(true);
        jTextArea.setColumns(40);
        jTextArea.setRows(n);
        jTextArea.setText(string2);
        jTextArea.setCaretPosition(0);
        if (actionListener != null) {
            jTextArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.a();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.a();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.a();
                }

                private void a() {
                    actionListener.actionPerformed(new ActionEvent(jTextArea, 1001, ""));
                }
            });
        }
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        ++gridBagConstraints.gridy;
        return jTextArea;
    }

    public static void expandAll(JTree jTree) {
        IlvSymbolDesignerUtilities.a(jTree, new TreePath(jTree.getModel().getRoot()));
    }

    private static void a(JTree jTree, TreePath treePath) {
        jTree.expandPath(treePath);
        Object object = treePath.getLastPathComponent();
        TreeModel treeModel = jTree.getModel();
        int n = treeModel.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            IlvSymbolDesignerUtilities.a(jTree, treePath.pathByAddingChild(treeModel.getChild(object, i)));
        }
    }

    public static boolean confirmOverwriteSymbol(Component component, IlvApplication ilvApplication, String string) {
        return JOptionPane.showOptionDialog(component != null ? component : IlvBuilder.getBuilder(ilvApplication).getFrame(), MessageFormat.format(ilvApplication.getString("SymbolDesigner.ReplaceSymbol.Format"), string), ilvApplication.getString("SymbolDesigner.ReplaceSymbol.Title"), 0, 3, null, null, null) != 1;
    }

    public static void notifySymbolOpened(IlvApplication ilvApplication, IlvPalette ilvPalette, IlvPaletteSymbol ilvPaletteSymbol) {
        ilvApplication.sendMessage(null, IlvBuilder.getBuilder(ilvApplication).getFrame(), SYMBOL_OPENED_MSG, new Object[]{ilvPalette, ilvPaletteSymbol});
    }

    private static class PaletteManagerComboModel
    implements ComboBoxModel,
    PaletteManagerListener {
        private IlvPaletteManager a;
        private IlvPalette b;
        private ArrayList c = new ArrayList();

        public PaletteManagerComboModel(IlvPaletteManager ilvPaletteManager) {
            this.a = ilvPaletteManager;
            this.a.addPaletteManagerListener(this);
        }

        @Override
        public void setSelectedItem(Object object) {
            this.b = (IlvPalette)object;
        }

        @Override
        public Object getSelectedItem() {
            return this.b;
        }

        @Override
        public int getSize() {
            return this.a.getPaletteCount();
        }

        @Override
        public Object getElementAt(int n) {
            return this.a.getPalette(n);
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.c.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.c.remove(listDataListener);
        }

        private void a() {
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, -1, -1);
            for (int i = 0; i < this.c.size(); ++i) {
                ((ListDataListener)this.c.get(i)).contentsChanged(listDataEvent);
            }
        }

        @Override
        public void paletteAdded(PaletteManagerEvent paletteManagerEvent) {
            this.a();
        }

        @Override
        public void paletteRemoved(PaletteManagerEvent paletteManagerEvent) {
            this.a();
        }
    }

    private static class HtmlLabel
    extends JLabel {
        public HtmlLabel(String string, boolean bl) {
            super(string);
            if (bl) {
                this.setFont(new Font(this.getFont().getFamily(), 1, this.getFont().getSize()));
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(10, super.getPreferredSize().height);
        }
    }

    private static class Invoker {
        Object a;
        Timer b;
        Runnable c;

        public Invoker(Object object, Runnable runnable) {
            this.a = object;
            this.c = runnable;
            this.b = new Timer(10, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Invoker.this.c.run();
                    b.remove(Invoker.this.a);
                }
            });
            this.b.setRepeats(false);
            this.b.setCoalesce(true);
            this.b.start();
        }
    }

    public static class PopupMenuListener
    extends MouseAdapter {
        private JPopupMenu a;

        public PopupMenuListener(JPopupMenu jPopupMenu) {
            this.a = jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTree jTree;
            int n;
            if (mouseEvent.getButton() == 3 && mouseEvent.getSource() instanceof JTree && ((n = (jTree = (JTree)mouseEvent.getSource()).getRowForLocation(mouseEvent.getX(), mouseEvent.getY())) <= -1 || !jTree.isRowSelected(n))) {
                ((Component)mouseEvent.getSource()).dispatchEvent(new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), 1024, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), false, 1));
            }
            this.a(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.a(mouseEvent);
        }

        protected JPopupMenu getPopupMenu(int n, int n2) {
            return this.a;
        }

        private void a(MouseEvent mouseEvent) {
            int n;
            int n2;
            JPopupMenu jPopupMenu;
            if (mouseEvent.isPopupTrigger() && (jPopupMenu = this.getPopupMenu(n2 = mouseEvent.getX(), n = mouseEvent.getY())) != null) {
                ComponentContext componentContext = ComponentContextManager.getSingleton().getContext(mouseEvent.getComponent());
                if (componentContext != null) {
                    ComponentAction.updateActions(jPopupMenu, componentContext.getTarget());
                }
                jPopupMenu.show((Component)mouseEvent.getSource(), n2, n);
            }
        }
    }
}

