/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.symbol.util.dashboard;

import ilog.views.util.convert.IlvConvert;
import ilog.views.util.convert.IlvConvertException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;

public class DashboardIO {
    public static final String HEADER = "Rogue WaveJViewsDashboardFile";
    public static final int UTF_STRING_BYTES_VERSION = 870000;
    public static final int IOVERSION = 870000;
    private static final int a = 1;
    public static final int PALETTES = 2000;
    public static final int PALETTE_SYMBOLS = 2500;
    public static final int SYMBOLS = 20000;
    public static final int LINKS = 20001;
    public static final int BACKGROUND = 40000;
    private HashMap<String, ValueIO> b = new HashMap();
    private ArrayList<Object> c;
    private boolean d;
    private Hashtable<String, Serializable> e;
    private int f;
    private int g = -1;

    protected DashboardIO() {
        this.a("boolean", new BooleanIO());
        this.a("int", new IntIO());
        this.a("float", new FloatIO());
        this.a("double", new DoubleIO());
        this.a("string", new StringIO());
    }

    void a(String string, ValueIO valueIO) {
        this.b.put(string, valueIO);
    }

    protected ValueIO getValueIO(String string) {
        return this.b.get(string);
    }

    public ArrayList<Object> getProperties() {
        return this.c;
    }

    public void setProperties(ArrayList<Object> arrayList) {
        this.c = arrayList;
    }

    public int getReadingVersion() {
        return this.g;
    }

    public void setReadingVersion(int n) {
        this.g = n;
    }

    public void writeUTF8StringBytes(ObjectOutputStream objectOutputStream, String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray, 0, byArray.length);
    }

    public String readUTF8StringBytes(ObjectInputStream objectInputStream) throws IOException {
        int n;
        if (this.getReadingVersion() < 870000) {
            return objectInputStream.readUTF();
        }
        int n2 = objectInputStream.readInt();
        byte[] byArray = new byte[n2];
        for (int i = objectInputStream.read(byArray, 0, n2); i < n2; i += n) {
            n = objectInputStream.read(byArray, i, n2 - i);
        }
        return new String(byArray, "UTF-8");
    }

    protected void readInternalProperties(ObjectInputStream objectInputStream) throws IOException {
        this.d = objectInputStream.readBoolean();
        objectInputStream.readUTF();
    }

    protected void writeInternalProperties(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(true);
        objectOutputStream.writeUTF("");
    }

    protected static ArrayList<Serializable> readObjectArray(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        ArrayList<Serializable> arrayList = null;
        if (n > 0) {
            arrayList = new ArrayList<Serializable>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add((Serializable)objectInputStream.readObject());
            }
        }
        return arrayList;
    }

    protected static void writeObjectArray(ObjectOutputStream objectOutputStream, ArrayList<Serializable> arrayList) throws IOException {
        int n = arrayList == null ? 0 : arrayList.size();
        objectOutputStream.writeInt(n);
        if (n > 0) {
            for (Serializable serializable : arrayList) {
                objectOutputStream.writeObject(serializable);
            }
        }
    }

    protected void writeExtendedProperties(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(1);
        if (this.e == null) {
            objectOutputStream.writeInt(0);
        } else {
            int n = this.e.size();
            objectOutputStream.writeInt(n);
            Enumeration<String> enumeration = this.e.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                objectOutputStream.writeUTF(string);
                Serializable serializable = this.e.get(string);
                objectOutputStream.writeObject(serializable);
            }
        }
    }

    protected void readExtendedProperties(ObjectInputStream objectInputStream) throws IOException {
        int n = 0;
        if (this.d) {
            this.f = objectInputStream.readInt();
            n = objectInputStream.readInt();
        }
        if (n > 0) {
            this.e = new Hashtable(n);
            for (int i = 0; i < n; ++i) {
                String string = objectInputStream.readUTF();
                try {
                    Serializable serializable = (Serializable)objectInputStream.readObject();
                    this.e.put(string, serializable);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    IOException iOException = new IOException();
                    iOException.initCause(classNotFoundException);
                    throw iOException;
                }
            }
        }
    }

    protected void setExtendedProperty(String string, Serializable serializable) {
        if (this.e == null) {
            this.e = new Hashtable();
        }
        this.e.put(string, serializable);
    }

    protected Serializable getExtendedProperty(String string) {
        if (this.e == null) {
            return null;
        }
        return this.e.get(string);
    }

    private static class DoubleIO
    implements ValueIO {
        private DoubleIO() {
        }

        @Override
        public Object read(ObjectInputStream objectInputStream) throws IOException {
            return new Double(objectInputStream.readDouble());
        }

        @Override
        public void write(ObjectOutputStream objectOutputStream, Object object) throws IOException {
            double d;
            if (object instanceof Double) {
                d = (Double)object;
            } else {
                try {
                    d = IlvConvert.convertToDouble(object);
                }
                catch (IlvConvertException ilvConvertException) {
                    throw new IOException("Cannot convert to Float: " + object);
                }
            }
            objectOutputStream.writeDouble(d);
        }
    }

    private static class FloatIO
    implements ValueIO {
        private FloatIO() {
        }

        @Override
        public Object read(ObjectInputStream objectInputStream) throws IOException {
            return new Float(objectInputStream.readFloat());
        }

        @Override
        public void write(ObjectOutputStream objectOutputStream, Object object) throws IOException {
            float f;
            if (object instanceof Float) {
                f = ((Float)object).floatValue();
            } else {
                try {
                    f = IlvConvert.convertToFloat(object);
                }
                catch (IlvConvertException ilvConvertException) {
                    throw new IOException("Cannot convert to Float: " + object);
                }
            }
            objectOutputStream.writeFloat(f);
        }
    }

    private static class StringIO
    implements ValueIO {
        private StringIO() {
        }

        @Override
        public Object read(ObjectInputStream objectInputStream) throws IOException {
            return objectInputStream.readUTF();
        }

        @Override
        public void write(ObjectOutputStream objectOutputStream, Object object) throws IOException {
            objectOutputStream.writeUTF(object == null ? "" : object.toString());
        }
    }

    private static class BooleanIO
    implements ValueIO {
        private BooleanIO() {
        }

        @Override
        public Object read(ObjectInputStream objectInputStream) throws IOException {
            return new Boolean(objectInputStream.readBoolean());
        }

        @Override
        public void write(ObjectOutputStream objectOutputStream, Object object) throws IOException {
            boolean bl;
            if (object instanceof Boolean) {
                bl = (Boolean)object;
            } else {
                try {
                    bl = IlvConvert.convertToBoolean(object);
                }
                catch (IlvConvertException ilvConvertException) {
                    throw new IOException("Cannot convert to Boolean: " + object);
                }
            }
            objectOutputStream.writeBoolean(bl);
        }
    }

    private static class IntIO
    implements ValueIO {
        private IntIO() {
        }

        @Override
        public Object read(ObjectInputStream objectInputStream) throws IOException {
            return new Integer(objectInputStream.readInt());
        }

        @Override
        public void write(ObjectOutputStream objectOutputStream, Object object) throws IOException {
            int n;
            if (object instanceof Integer) {
                n = (Integer)object;
            } else {
                try {
                    n = IlvConvert.convertToInt(object);
                }
                catch (IlvConvertException ilvConvertException) {
                    throw new IOException("Cannot convert to Integer: " + object);
                }
            }
            objectOutputStream.writeInt(n);
        }
    }

    protected static interface ValueIO {
        public void write(ObjectOutputStream var1, Object var2) throws IOException;

        public Object read(ObjectInputStream var1) throws IOException;
    }
}

