/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.swing;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.swing.IlvPopupMenuContext;
import ilog.views.swing.IlvSimplePopupMenu;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingConstants;

public class IlvPopupMenuManager
implements SwingConstants {
    private IlvPoint a = new IlvPoint();
    private Adapter b = new Adapter();
    private HashMap c;
    private static IlvPopupMenuManager d;
    public static final String JCOMPONENT_POPUP_MENU_KEY;
    public static final String JCOMPONENT_POPUP_MENU_CONTEXT_KEY;

    private IlvPopupMenuManager() {
    }

    public static void registerView(IlvManagerView ilvManagerView) {
        if (d == null) {
            d = new IlvPopupMenuManager();
        }
        ilvManagerView.addMouseListener(IlvPopupMenuManager.d.b);
    }

    public static void unregisterView(IlvManagerView ilvManagerView) {
        if (d != null) {
            ilvManagerView.removeMouseListener(IlvPopupMenuManager.d.b);
        }
    }

    public static void registerMenu(String string, JPopupMenu jPopupMenu) {
        if (string == null) {
            throw new NullPointerException("Null name in IlvPopupMenuManager.registerMenu");
        }
        if (d == null) {
            d = new IlvPopupMenuManager();
        }
        d.a(string, jPopupMenu);
    }

    public static void unregisterMenu(String string) {
        if (string == null) {
            throw new NullPointerException("Null name in IlvPopupMenuManager.unregisterMenu");
        }
        if (d != null) {
            d.a(string, null);
        }
    }

    private void a(String string, JPopupMenu jPopupMenu) {
        if (jPopupMenu == null) {
            if (this.c != null) {
                this.c.remove(string);
                if (this.c.size() == 0) {
                    this.c = null;
                }
            }
        } else {
            if (this.c == null) {
                this.c = new HashMap();
            }
            this.c.put(string, jPopupMenu);
        }
    }

    public static JPopupMenu getRegisteredMenu(String string) {
        if (d != null) {
            return d.a(string);
        }
        return null;
    }

    private JPopupMenu a(String string) {
        if (string == null) {
            return null;
        }
        if (this.c != null) {
            return (JPopupMenu)this.c.get(string);
        }
        return null;
    }

    public static void setPopupMenu(JComponent jComponent, JPopupMenu jPopupMenu) {
        if (jComponent == null) {
            return;
        }
        jComponent.putClientProperty(JCOMPONENT_POPUP_MENU_KEY, jPopupMenu);
        if (jPopupMenu == null) {
            jComponent.removeMouseListener(IlvPopupMenuManager.d.b);
        } else {
            jComponent.addMouseListener(IlvPopupMenuManager.d.b);
        }
    }

    public static void setPopupMenuName(JComponent jComponent, String string) {
        if (jComponent == null) {
            return;
        }
        jComponent.putClientProperty(JCOMPONENT_POPUP_MENU_KEY, string);
        if (string == null) {
            jComponent.removeMouseListener(IlvPopupMenuManager.d.b);
        } else {
            jComponent.addMouseListener(IlvPopupMenuManager.d.b);
        }
    }

    public static JPopupMenu getPopupMenu(JComponent jComponent) {
        if (jComponent == null) {
            return null;
        }
        Object object = jComponent.getClientProperty(JCOMPONENT_POPUP_MENU_KEY);
        if (object instanceof JPopupMenu) {
            return (JPopupMenu)object;
        }
        if (object instanceof String) {
            return IlvPopupMenuManager.getRegisteredMenu((String)object);
        }
        return null;
    }

    public static void setPopupMenuContext(MenuElement menuElement, IlvPopupMenuContext ilvPopupMenuContext) {
        Container container;
        if (menuElement == null) {
            return;
        }
        if (menuElement instanceof JPopupMenu) {
            container = (JPopupMenu)menuElement;
            ((JComponent)container).putClientProperty(JCOMPONENT_POPUP_MENU_CONTEXT_KEY, ilvPopupMenuContext);
        }
        for (container = menuElement.getComponent().getParent(); !(container instanceof JPopupMenu) && container != null; container = container.getParent()) {
        }
        IlvPopupMenuManager.setPopupMenuContext((MenuElement)((Object)container), ilvPopupMenuContext);
    }

    public static IlvPopupMenuContext getPopupMenuContext(MenuElement menuElement) {
        Container container;
        if (menuElement == null) {
            return null;
        }
        if (menuElement instanceof JPopupMenu) {
            JPopupMenu jPopupMenu = (JPopupMenu)menuElement;
            return (IlvPopupMenuContext)jPopupMenu.getClientProperty(JCOMPONENT_POPUP_MENU_CONTEXT_KEY);
        }
        for (container = menuElement.getComponent().getParent(); !(container instanceof JPopupMenu) && container != null; container = container.getParent()) {
        }
        return IlvPopupMenuManager.getPopupMenuContext((JPopupMenu)container);
    }

    private void a(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Object object = mouseEvent.getSource();
            if (object instanceof IlvManagerView) {
                this.a((IlvManagerView)object, mouseEvent);
            } else {
                this.a((JComponent)object, mouseEvent);
            }
        }
    }

    private void a(IlvManagerView ilvManagerView, MouseEvent mouseEvent) {
        if (!(ilvManagerView.getParent() instanceof JComponent)) {
            return;
        }
        JComponent jComponent = (JComponent)ilvManagerView.getParent();
        IlvManager ilvManager = ilvManagerView.getManager();
        if (ilvManager == null) {
            return;
        }
        this.a.move(mouseEvent.getX(), mouseEvent.getY());
        JPopupMenu jPopupMenu = ilvManagerView.getPopupMenu(this.a, this);
        if (jPopupMenu != null) {
            IlvPopupMenuContext ilvPopupMenuContext = IlvPopupMenuManager.getPopupMenuContext(jPopupMenu);
            if (ilvPopupMenuContext != null) {
                ilvPopupMenuContext.a(mouseEvent);
                ilvPopupMenuContext.a(jComponent);
            }
            if (jPopupMenu instanceof IlvSimplePopupMenu) {
                ((IlvSimplePopupMenu)jPopupMenu).beforeDisplay(ilvPopupMenuContext);
            }
            jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void a(JComponent jComponent, MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = IlvPopupMenuManager.getPopupMenu(jComponent);
        this.a.move(mouseEvent.getX(), mouseEvent.getY());
        if (jPopupMenu != null) {
            IlvPopupMenuContext ilvPopupMenuContext = new IlvPopupMenuContext(this.a, jComponent, null, null, null);
            ilvPopupMenuContext.a(mouseEvent);
            IlvPopupMenuManager.setPopupMenuContext(jPopupMenu, ilvPopupMenuContext);
            if (jPopupMenu instanceof IlvSimplePopupMenu) {
                ((IlvSimplePopupMenu)jPopupMenu).beforeDisplay(ilvPopupMenuContext);
            }
            jPopupMenu.show(jComponent, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static void doPopup(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic) {
        if (d == null) {
            d = new IlvPopupMenuManager();
        }
        d.a(ilvManagerView, ilvGraphic);
    }

    private void a(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic) {
        if (!(ilvManagerView.getParent() instanceof JComponent)) {
            return;
        }
        JComponent jComponent = (JComponent)ilvManagerView.getParent();
        IlvManager ilvManager = ilvManagerView.getManager();
        if (ilvManager == null) {
            return;
        }
        IlvTransformer ilvTransformer = ilvManagerView.getTransformer();
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        while (!(ilvGraphicBag instanceof IlvManager) && ilvGraphicBag instanceof IlvGraphic) {
            ilvGraphicBag = ((IlvGraphic)((Object)ilvGraphicBag)).getGraphicBag();
        }
        if (ilvGraphicBag instanceof IlvManager) {
            ilvTransformer = ((IlvManager)ilvGraphicBag).getDrawingTransformer(ilvManagerView);
        }
        IlvPoint ilvPoint = ilvGraphic.getCenter(ilvTransformer);
        this.a.move(ilvPoint.x, ilvPoint.y);
        JPopupMenu jPopupMenu = ilvGraphic.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, this);
        if (jPopupMenu != null) {
            IlvPopupMenuContext ilvPopupMenuContext = IlvPopupMenuManager.getPopupMenuContext(jPopupMenu);
            if (ilvPopupMenuContext != null) {
                MouseEvent mouseEvent = new MouseEvent(jComponent, 501, 0L, 0, (int)ilvPoint.x, (int)ilvPoint.y, 0, true);
                ilvPopupMenuContext.a(mouseEvent);
                ilvPopupMenuContext.a(jComponent);
            }
            if (jPopupMenu instanceof IlvSimplePopupMenu) {
                ((IlvSimplePopupMenu)jPopupMenu).beforeDisplay(ilvPopupMenuContext);
            }
            jPopupMenu.show(jComponent, (int)ilvPoint.x, (int)ilvPoint.y);
        }
    }

    static {
        JCOMPONENT_POPUP_MENU_KEY = "__IlvPopupMenuManager.JComponent.PopupMenu".intern();
        JCOMPONENT_POPUP_MENU_CONTEXT_KEY = "__IlvPopupMenuManager.JComponent.PopupMenuContext".intern();
    }

    private class Adapter
    extends MouseAdapter {
        private Adapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            IlvPopupMenuManager.this.a(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            IlvPopupMenuManager.this.a(mouseEvent);
        }
    }
}

