/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.svg.css;

import ilog.views.IlvRect;
import ilog.views.IlvUtil;
import ilog.views.svg.css.PrimitiveValue;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.util.HashMap;

public class Util {
    public static final float SQRT2 = (float)Math.sqrt(2.0);
    public static final String[] CSSUNITNAMES;
    public static final short T_PE = 0;
    public static final short T_EM = 1;
    public static final short T_EX = 2;
    public static final short T_PX = 3;
    public static final short T_CM = 4;
    public static final short T_MM = 5;
    public static final short T_IN = 6;
    public static final short T_PT = 7;
    public static final short T_PC = 8;
    private static final short a = 1;
    private static final short b = 2;
    private static final short c = 3;
    private static HashMap d;
    private static HashMap e;
    private static HashMap f;
    static final char[] g;

    private Util() {
    }

    public static String getColorIdentifier(Color color, boolean bl) {
        String string = (String)d.get(color);
        if (string == null && !bl && (string = (String)e.get(color)) == null) {
            string = (String)f.get(color);
        }
        if (string == null) {
            return Util.a(color);
        }
        return string;
    }

    private static String a(Color color) {
        char[] cArray = new char[7];
        cArray[0] = 35;
        int n = color.getRGB();
        int n2 = 4;
        int n3 = 7;
        int n4 = 1 << n2;
        int n5 = n4 - 1;
        for (int n6 = 0; n6 < 6; n6 = (int)((short)(n6 + 1))) {
            cArray[--n3] = g[n & n5];
            n >>>= n2;
        }
        return new String(cArray);
    }

    public static float getXLength(PrimitiveValue primitiveValue, IlvRect ilvRect) {
        return Util.getLength(primitiveValue, ilvRect, (short)1);
    }

    public static float getYLength(PrimitiveValue primitiveValue, IlvRect ilvRect) {
        return Util.getLength(primitiveValue, ilvRect, (short)2);
    }

    public static float getXYLength(PrimitiveValue primitiveValue, IlvRect ilvRect) {
        return Util.getLength(primitiveValue, ilvRect, (short)3);
    }

    public static float getXLength(String string, IlvRect ilvRect) {
        return Util.getLength(string, ilvRect, (short)1);
    }

    public static float getYLength(String string, IlvRect ilvRect) {
        return Util.getLength(string, ilvRect, (short)2);
    }

    public static float getXYLength(String string, IlvRect ilvRect) {
        return Util.getLength(string, ilvRect, (short)3);
    }

    private static float a(float f, float f2, short s) {
        switch (s) {
            case 3: {
                break;
            }
            case 6: {
                f *= (float)Util.a();
                break;
            }
            case 0: {
                if (f > 100.0f) {
                    f = 100.0f;
                } else if (f < 0.0f) {
                    f = 0.0f;
                }
                f = f * f2 / 100.0f;
                break;
            }
            case 4: {
                f *= (float)Util.a() / 2.54f;
                break;
            }
            case 5: {
                f *= (float)Util.a() / 25.4f;
                break;
            }
            case 7: {
                f *= (float)Util.a() / 72.0f;
                break;
            }
            case 8: {
                f *= (float)Util.a() / 6.0f;
            }
        }
        return f;
    }

    private static int a() {
        if (GraphicsEnvironment.isHeadless()) {
            return IlvUtil.GetHeadlessScreenResolution();
        }
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public static float getLength(PrimitiveValue primitiveValue, IlvRect ilvRect, short s) {
        float f = 0.0f;
        if (primitiveValue.b != -2.1474836E9f) {
            f = primitiveValue.b;
        } else {
            String string = primitiveValue.getCssText();
            f = Util.a(ilvRect, s, string);
        }
        return f;
    }

    private static float a(IlvRect ilvRect, short s, String string) {
        float f = 0.0f;
        block5: for (short s2 = 0; s2 < CSSUNITNAMES.length; s2 = (short)((short)(s2 + 1))) {
            int n = string.indexOf(CSSUNITNAMES[s2]);
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            f = Float.parseFloat(string2);
            if (s2 != 0 || ilvRect == null) {
                f = Util.a(f, 0.0f, s2);
                continue;
            }
            switch (s) {
                case 1: {
                    f = Util.a(f, ilvRect.width, s2);
                    continue block5;
                }
                case 2: {
                    f = Util.a(f, ilvRect.height, s2);
                    continue block5;
                }
                case 3: {
                    f = Util.a(f, (float)Math.sqrt(ilvRect.width * ilvRect.width + ilvRect.height * ilvRect.height) / SQRT2, s2);
                }
            }
        }
        return f;
    }

    public static float getLength(String string, IlvRect ilvRect, short s) {
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            f = Util.a(ilvRect, s, string);
        }
        return f;
    }

    static {
        String[] stringArray = new String[9];
        stringArray[0] = "%";
        stringArray[1] = "em";
        stringArray[2] = "ex";
        stringArray[3] = "px";
        stringArray[4] = "cm";
        stringArray[5] = "mm";
        stringArray[6] = "in";
        stringArray[7] = "pt";
        stringArray[8] = "pc";
        CSSUNITNAMES = stringArray;
        d = new HashMap(16);
        d.put(Color.black, "black");
        d.put(Color.lightGray, "silver");
        d.put(Color.gray, "gray");
        d.put(Color.white, "white");
        d.put(new Color(128, 0, 0), "maroon");
        d.put(Color.red, "red");
        d.put(new Color(128, 0, 128), "purple");
        d.put(new Color(0, 128, 0), "green");
        d.put(Color.green, "lime");
        d.put(new Color(128, 128, 0), "olive");
        d.put(Color.yellow, "yellow");
        d.put(new Color(0, 0, 128), "navy");
        d.put(Color.blue, "blue");
        d.put(new Color(0, 128, 128), "teal");
        d.put(Color.cyan, "aqua");
        e = new HashMap(34);
        e.put(new Color(240, 255, 255), "azure");
        e.put(new Color(245, 245, 220), "beige");
        e.put(new Color(250, 248, 255), "aliceblue");
        e.put(new Color(250, 235, 215), "antiquewhite");
        e.put(new Color(127, 255, 212), "aquamarine");
        e.put(new Color(0, 0, 139), "darkblue");
        e.put(new Color(0, 139, 139), "darkcyan");
        e.put(new Color(169, 169, 169), "darkgray");
        e.put(new Color(0, 100, 0), "darkgreen");
        e.put(new Color(169, 169, 169), "darkgrey");
        e.put(new Color(139, 0, 0), "darkred");
        e.put(new Color(255, 127, 80), "coral");
        e.put(new Color(255, 215, 0), "gold");
        e.put(new Color(255, 255, 224), "lightyellow");
        e.put(new Color(240, 128, 128), "lightcoral");
        e.put(new Color(173, 216, 230), "lightblue");
        e.put(new Color(224, 255, 255), "lightcyan");
        e.put(new Color(211, 211, 211), "lightgray");
        e.put(new Color(144, 238, 144), "lightgreen");
        e.put(new Color(211, 211, 211), "lightgrey");
        e.put(Color.magenta, "magenta");
        e.put(new Color(255, 192, 203), "pink");
        e.put(new Color(250, 128, 114), "salmon");
        e.put(new Color(165, 42, 42), "brown");
        e.put(new Color(255, 165, 0), "orange");
        e.put(new Color(64, 224, 208), "turquoise");
        e.put(new Color(238, 130, 238), "violet");
        e.put(new Color(245, 222, 179), "wheat");
        e.put(new Color(255, 228, 196), "bisque");
        e.put(new Color(75, 0, 130), "indigo");
        e.put(new Color(255, 255, 240), "ivory");
        e.put(new Color(240, 230, 140), "khaki");
        f = new HashMap(17);
        f.put(SystemColor.activeCaptionBorder, "ActiveBorder");
        f.put(SystemColor.activeCaption, "ActiveCaption");
        f.put(SystemColor.desktop, "AppWorkspace");
        f.put(SystemColor.control, "ButtonFace");
        f.put(SystemColor.controlLtHighlight, "ButtonHighlight");
        f.put(SystemColor.controlShadow, "ButtonShadow");
        f.put(SystemColor.controlText, "ButtonText");
        f.put(SystemColor.activeCaptionText, "CaptionText");
        f.put(SystemColor.textInactiveText, "TextInactiveText");
        f.put(SystemColor.controlHighlight, "Highlight");
        f.put(SystemColor.textHighlightText, "HighlightText");
        f.put(SystemColor.inactiveCaptionBorder, "InactiveBorder");
        f.put(SystemColor.inactiveCaption, "InactiveCaption");
        f.put(SystemColor.inactiveCaptionText, "InactiveCaptionText");
        f.put(SystemColor.info, "InfoBackground");
        f.put(SystemColor.infoText, "InfoText");
        f.put(SystemColor.menu, "Menu");
        f.put(SystemColor.menuText, "MenuText");
        f.put(SystemColor.scrollbar, "Scrollbar");
        f.put(SystemColor.controlDkShadow, "ThreeDDarkShadow");
        f.put(SystemColor.controlHighlight, "ThreeDHighlight");
        f.put(SystemColor.window, "Window");
        f.put(SystemColor.windowBorder, "WindowFrame");
        f.put(SystemColor.windowText, "WindowText");
        g = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

