/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.servlet;

import ilog.views.IlvGraphic;
import ilog.views.IlvManagerView;
import ilog.views.IlvTransformer;
import ilog.views.servlet.IlvCursorInfoGenerator;
import ilog.views.servlet.IlvGroupInfoGenerator;
import ilog.views.servlet.IlvHitmap;
import ilog.views.servlet.IlvNavigationInfoGenerator;
import ilog.views.servlet.IlvTooltipInfoGenerator;
import ilog.views.util.hitmap.IlvHitmapConstants;
import ilog.views.util.hitmap.IlvHitmapInfoGenerator;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IlvHitmapDefinition
implements IlvHitmapConstants {
    private transient IlvManagerView a;
    private transient IlvHitmap b = new IlvHitmap();
    private int c;
    private int d;
    private String[] e = null;
    private Map<String, IlvHitmapInfoGenerator> f = new HashMap<String, IlvHitmapInfoGenerator>();
    private transient Vector<IlvGraphic> g = new Vector();

    public void registerHitmapInfoGenerator(String string, IlvHitmapInfoGenerator ilvHitmapInfoGenerator) {
        this.f.put(string, ilvHitmapInfoGenerator);
    }

    public void unregisterHitmapInfoGenerator(String string) {
        this.f.remove(string);
    }

    public void init(IlvManagerView ilvManagerView) {
        Rectangle rectangle = ilvManagerView.getBounds();
        this.c = rectangle.width;
        this.d = rectangle.height;
        this.a = ilvManagerView;
        this.g.clear();
    }

    public void init(IlvManagerView ilvManagerView, int n, int n2) {
        this.init(ilvManagerView);
        this.c += n;
        this.d += n2;
    }

    public void addGraphic(IlvGraphic ilvGraphic) {
        this.g.add(ilvGraphic);
    }

    public Vector<IlvGraphic> getGraphics() {
        return this.g;
    }

    public IlvManagerView getManagerView() {
        return this.a;
    }

    public void setManagerView(IlvManagerView ilvManagerView) {
        this.a = ilvManagerView;
    }

    public boolean shouldRender(IlvGraphic ilvGraphic) {
        return true;
    }

    public void renderHitmap() {
        this.renderHitmap(0, 0);
    }

    public void renderHitmap(int n, int n2) {
        IlvTransformer ilvTransformer = this.a();
        for (int i = 0; i < this.getGraphics().size(); ++i) {
            this.b.a(this.getGraphics().elementAt(i), ilvTransformer, n, n2);
        }
    }

    private IlvTransformer a() {
        this.b.init(this.c, this.d);
        IlvTransformer ilvTransformer = this.a.getTransformer();
        return ilvTransformer;
    }

    public String getDefinition() {
        String string = this.b.encodeHitmap();
        return string + this.b();
    }

    public String getDefinition(StringTokenizer stringTokenizer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.b.encodeHitmap());
        if (stringTokenizer != null) {
            stringBuilder.append(this.a(stringTokenizer));
            stringBuilder.append(this.getExtensions());
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    private String a(StringTokenizer stringTokenizer) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("jviews_hitInfos={");
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            String string;
            String string2 = stringTokenizer.nextToken();
            IlvHitmapInfoGenerator ilvHitmapInfoGenerator = this.f.get(string2);
            if (ilvHitmapInfoGenerator == null && (ilvHitmapInfoGenerator = this.createHitmapInfoGenerator(string2)) != null) {
                this.f.put(string2, ilvHitmapInfoGenerator);
            }
            if (ilvHitmapInfoGenerator == null || (string = ilvHitmapInfoGenerator.buildInformation(string2)) == null) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected IlvHitmapInfoGenerator createHitmapInfoGenerator(String string) {
        if (string.equals("tooltip")) {
            return new IlvTooltipInfoGenerator(this);
        }
        if (string.equals("group")) {
            return new IlvGroupInfoGenerator(this);
        }
        if (string.equals("cursor")) {
            return new IlvCursorInfoGenerator(this);
        }
        if (string.equals("navigation")) {
            return new IlvNavigationInfoGenerator(this);
        }
        return null;
    }

    public String getExtensions() {
        StringBuffer stringBuffer = new StringBuffer("extensions:[,");
        Vector<IlvGraphic> vector = this.getGraphics();
        for (int i = 0; i < vector.size(); ++i) {
            IlvGraphic ilvGraphic = vector.elementAt(i);
            stringBuffer.append("\"" + this.getExtension(ilvGraphic) + "\"");
            if (i >= vector.size() - 1) continue;
            stringBuffer.append(",\n");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected String getExtension(IlvGraphic ilvGraphic) {
        return "";
    }

    public void dispose() {
        this.b.dispose();
    }

    private String b() {
        StringBuffer stringBuffer = new StringBuffer("jviews_tooltips=[,\n");
        for (int i = 0; i < this.getGraphics().size(); ++i) {
            IlvGraphic ilvGraphic = this.getGraphics().elementAt(i);
            stringBuffer.append("\"" + this.getTooltip(ilvGraphic) + "\"");
            if (i >= this.getGraphics().size() - 1) continue;
            stringBuffer.append(",\n");
        }
        stringBuffer.append("];\n");
        return stringBuffer.toString();
    }

    protected String getTooltip(IlvGraphic ilvGraphic) {
        String string = ilvGraphic.getToolTipText();
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table class='jviews_tooltip'>");
        stringBuffer.append("<tr class='jviews_tooltip_title'>");
        stringBuffer.append("<td>" + string + "</td>");
        stringBuffer.append("</table>");
        return stringBuffer.toString();
    }

    public void setHitmapLayers(String[] stringArray) {
        this.e = stringArray;
    }

    public String[] getHitmapLayers() {
        return this.e;
    }
}

