/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.io;

import ilog.views.util.internal.IlvStreamTokenizer;
import java.io.IOException;
import java.io.InputStream;

final class Tokenizer
extends IlvStreamTokenizer {
    Tokenizer(InputStream inputStream) {
        super(inputStream);
        this.initSyntax();
    }

    protected void initSyntax() {
        this.resetSyntax();
        this.wordChars(97, 122);
        this.wordChars(65, 90);
        this.wordChars(48, 57);
        this.wordChars(35, 47);
        this.wordChars(58, 64);
        this.wordChars(33, 33);
        this.wordChars(91, 91);
        this.wordChars(123, 126);
        this.wordChars(93, 96);
        this.wordChars(92, 92);
        this.wordChars(160, 255);
        this.whitespaceChars(0, 32);
        this.quoteChar(34);
        this.parseNumbers();
    }

    @Override
    public int nextToken() throws IOException {
        int n;
        int n2;
        boolean bl = false;
        if (bl) {
            return super.nextToken();
        }
        if (this.pushBackToken) {
            this.pushBackToken = false;
            if (this.ttype != -4) {
                return this.ttype;
            }
        }
        this.sval = null;
        int n3 = n2 = this.peekChar == -2 ? this.read() : this.peekChar;
        if (this.lastCr && n2 == 10) {
            this.lastCr = false;
            n2 = this.read();
        }
        if (n2 == -1) {
            this.ttype = -1;
            return -1;
        }
        int n4 = n = n2 > 255 ? 8 : this.tokenTypes[n2];
        while ((n & 4) != 0) {
            if (n2 == 13) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.lastCr = true;
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n2 = this.read();
                if (n2 == 10) {
                    n2 = this.read();
                }
            } else if (n2 == 10) {
                ++this.lineNumber;
                if (this.isEOLSignificant) {
                    this.peekChar = -2;
                    this.ttype = 10;
                    return 10;
                }
                n2 = this.read();
            } else {
                n2 = this.read();
            }
            if (n2 == -1) {
                this.ttype = -1;
                return -1;
            }
            n = n2 > 255 ? 8 : this.tokenTypes[n2];
        }
        if ((n & 0x10) != 0) {
            boolean bl2;
            StringBuilder stringBuilder = new StringBuilder(20);
            boolean bl3 = false;
            boolean bl4 = bl2 = n2 == 45;
            do {
                if (n2 == 46) {
                    bl3 = true;
                }
                stringBuilder.append((char)n2);
            } while ((n2 = this.read()) >= 48 && n2 <= 57 || !bl3 && n2 == 46 || bl3 && (n2 == 45 || n2 == 43 || n2 == 101 || n2 == 69));
            this.peekChar = n2;
            if (bl2 && stringBuilder.length() == 1) {
                this.ttype = 45;
                return 45;
            }
            String string = stringBuilder.toString();
            char c = string.charAt(0);
            if ('0' <= c && c <= '9' || c == '.' || c == '-' || c == '+' || c == 'e' || c == 'E') {
                try {
                    this.nval = Double.parseDouble(string);
                    this.ttype = -2;
                    return -2;
                }
                catch (NumberFormatException numberFormatException) {
                    this.nval = 0.0;
                }
            }
            this.ttype = -3;
            return -3;
        }
        if ((n & 8) != 0) {
            StringBuffer stringBuffer = new StringBuffer(20);
            do {
                stringBuffer.append((char)n2);
            } while ((n2 = this.read()) != -1 && (n2 >= 256 || (this.tokenTypes[n2] & 0x18) != 0));
            this.peekChar = n2;
            this.sval = this.forceLowercase ? stringBuffer.toString().toLowerCase() : stringBuffer.toString();
            this.ttype = -3;
            return -3;
        }
        if (n == 2) {
            int n5 = n2;
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = this.read();
            while (n6 >= 0 && n6 != n5 && n6 != 13 && n6 != 10) {
                boolean bl5 = true;
                if (n6 == 92) {
                    int n7 = this.getNextChar();
                    if (n7 <= 55 && n7 >= 48) {
                        int n8 = n7 - 48;
                        n7 = this.read();
                        if (n7 > 55 || n7 < 48) {
                            bl5 = false;
                        } else {
                            n8 = n8 * 8 + (n7 - 48);
                            n7 = this.read();
                            if (n8 > 31 || n7 > 55 || n7 < 48) {
                                bl5 = false;
                            } else {
                                n8 = n8 * 8 + (n7 - 48);
                            }
                        }
                        if (!bl5) {
                            stringBuffer.append((char)n8);
                            n6 = n7;
                        } else {
                            n6 = n8;
                        }
                    } else {
                        n6 = this.handleBackslashInString();
                    }
                }
                if (!bl5) continue;
                stringBuffer.append((char)n6);
                n6 = this.getNextChar();
            }
            if (n6 == n5) {
                n6 = this.read();
            }
            this.peekChar = n6;
            this.ttype = n5;
            this.sval = stringBuffer.toString();
            return this.ttype;
        }
        if (n2 == 47 && (this.slashSlashComments || this.slashStarComments)) {
            n2 = this.read();
            if (n2 == 42 && this.slashStarComments) {
                int n9 = this.read();
                while (true) {
                    n2 = n9;
                    n9 = this.read();
                    if (n2 == -1) {
                        this.peekChar = -1;
                        this.ttype = -1;
                        return -1;
                    }
                    if (n2 == 13) {
                        if (n9 == 10) {
                            n9 = this.read();
                        }
                        ++this.lineNumber;
                        continue;
                    }
                    if (n2 == 10) {
                        ++this.lineNumber;
                        continue;
                    }
                    if (n2 == 42 && n9 == 47) break;
                }
                this.peekChar = this.read();
                return this.nextToken();
            }
            if (n2 == 47 && this.slashSlashComments) {
                while ((n2 = this.read()) >= 0 && n2 != 13 && n2 != 10) {
                }
                this.peekChar = n2;
                return this.nextToken();
            }
            if (n != 1) {
                this.peekChar = n2;
                this.ttype = 47;
                return 47;
            }
        }
        if (n == 1) {
            while ((n2 = this.read()) >= 0 && n2 != 13 && n2 != 10) {
            }
            this.peekChar = n2;
            return this.nextToken();
        }
        this.peekChar = this.read();
        this.ttype = n2;
        return this.ttype;
    }

    @Override
    protected char handleBackslashInString() {
        try {
            char c;
            switch (this.nextChar) {
                case 97: {
                    c = '\u0007';
                    break;
                }
                case 98: {
                    c = '\b';
                    break;
                }
                case 102: {
                    c = '\f';
                    break;
                }
                case 110: {
                    c = '\n';
                    break;
                }
                case 114: {
                    c = '\r';
                    break;
                }
                case 116: {
                    c = '\t';
                    break;
                }
                case 118: {
                    c = '\u000b';
                    break;
                }
                case 117: {
                    int n = 0;
                    int n2 = 0;
                    while ((n2 = this.read()) == 117) {
                    }
                    block18: for (int i = 0; i < 4; ++i) {
                        switch (n2) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n = (n << 4) + n2 - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n = (n << 4) + 10 + n2 - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n = (n << 4) + 10 + n2 - 65;
                                break;
                            }
                            default: {
                                break block18;
                            }
                        }
                        if (i == 3) continue;
                        n2 = this.read();
                    }
                    n2 = n;
                    c = (char)n2;
                    break;
                }
                default: {
                    c = (char)this.nextChar;
                }
            }
            return c;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }
}

