/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.linkpolicy;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvAbstractCrossingGraphic;
import ilog.views.graphic.linkpolicy.IlvCrossingAwareLinkImage;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvBridgeCrossings
extends IlvAbstractCrossingGraphic {
    private float a = 3.0f;

    public IlvBridgeCrossings(IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage) {
        super(ilvCrossingAwareLinkImage);
    }

    public IlvBridgeCrossings(IlvBridgeCrossings ilvBridgeCrossings) {
        super(ilvBridgeCrossings);
        this.a = ilvBridgeCrossings.a;
    }

    public IlvBridgeCrossings(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readFloat("bridgeLengthFactor");
    }

    @Override
    public IlvGraphic copy() {
        return new IlvBridgeCrossings(this);
    }

    public void setBridgeLengthFactor(float f) {
        this.a = f;
    }

    public final float getBridgeLengthFactor() {
        return this.a;
    }

    @Override
    public void drawCrossing(Graphics graphics, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        graphics.setColor(ilvLinkImage.getForeground());
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, false);
        if (!drawingParameters.e) {
            return;
        }
        IlvGraphicUtil.DrawPolyline(graphics, drawingParameters.a, 2, 0.0f, 0, 1, null, ilvTransformer, true);
        IlvGraphicUtil.DrawPolyline(graphics, drawingParameters.b, 2, 0.0f, 0, 1, null, ilvTransformer, true);
    }

    @Override
    public boolean containsAtCrossing(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvPoint ilvPoint6, float f, float f2, float f3) {
        return false;
    }

    @Override
    public IlvRect expandLinkBoundingBox(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        float f;
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        IlvCrossingAwareLinkImage ilvCrossingAwareLinkImage = this.getRelatedLinkImage();
        float f2 = ilvCrossingAwareLinkImage.getGap();
        if (ilvCrossingAwareLinkImage.isGapZoomable()) {
            f2 = (float)((double)f2 * d);
        }
        if ((f = ilvCrossingAwareLinkImage.getLineWidth()) != 0.0f) {
            float f3 = ilvCrossingAwareLinkImage.getMaximumLineWidth();
            f = IlvStrokeInfo.zoomedLineWidth(f, f3, ilvTransformer, true);
        }
        f = (float)((double)f * d);
        IlvRect ilvRect2 = new IlvRect(0.0f, 0.0f, 2.0f * f2 + f, f2);
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(2.0f * f2 + f, 0.0f);
        this.addCrossingBound(ilvRect2, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        IlvRect ilvRect3 = new IlvRect(0.0f, 0.0f, f2, 2.0f * f2 + f);
        ilvPoint.move(0.0f, 0.0f);
        ilvPoint2.move(0.0f, 2.0f * f2 + f);
        this.addCrossingBound(ilvRect3, ilvTransformer, ilvCrossingAwareLinkImage, ilvCrossingAwareLinkImage, null, ilvPoint, ilvPoint2, null, 0.0f, 0.0f, f2);
        IlvRect ilvRect4 = new IlvRect(ilvRect);
        ilvRect4.x -= 1.5f * ilvRect3.width;
        ilvRect4.y -= 1.5f * ilvRect2.height;
        ilvRect4.width += 3.0f * ilvRect3.width;
        ilvRect4.height += 3.0f * ilvRect2.height;
        return ilvRect4;
    }

    @Override
    public void addCrossingBound(IlvRect ilvRect, IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvLinkImage ilvLinkImage2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, float f2, float f3) {
        DrawingParameters drawingParameters = new DrawingParameters(ilvTransformer, ilvLinkImage, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, f3, true);
        if (!drawingParameters.e) {
            return;
        }
        ilvRect.add(IlvGraphicUtil.PolylineBBox(drawingParameters.a, 2, 0.0f, 0, 1, null));
        ilvRect.add(IlvGraphicUtil.PolylineBBox(drawingParameters.b, 2, 0.0f, 0, 1, null));
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("bridgeLengthFactor", this.a);
    }

    class DrawingParameters {
        IlvPoint[] a;
        IlvPoint[] b;
        float c;
        float d;
        boolean e = true;

        DrawingParameters(IlvTransformer ilvTransformer, IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, float f, boolean bl) {
            float f2;
            double d;
            this.d = ilvLinkImage.getLineWidth();
            int n = ilvLinkImage.getEndCap();
            double d2 = d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (this.d != 0.0f) {
                f2 = ilvLinkImage.getMaximumLineWidth();
                this.d = IlvStrokeInfo.zoomedLineWidth(this.d, f2, ilvTransformer, bl);
            }
            this.c = (float)((double)this.d * d);
            f2 = ilvPoint3.x - ilvPoint2.x;
            float f3 = ilvPoint3.y - ilvPoint2.y;
            double d3 = Math.sqrt(f2 * f2 + f3 * f3);
            if (d3 == 0.0) {
                this.e = false;
                return;
            }
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (n != 0) {
                f4 = (float)((double)(0.5f * this.c * f2) / d3);
                if ((d3 = Math.sqrt((f2 -= 2.0f * f4) * f2 + (f3 -= 2.0f * (f5 = (float)((double)(0.5f * this.c * f3) / d3))) * f3)) == 0.0) {
                    this.e = false;
                    return;
                }
            }
            float f6 = IlvBridgeCrossings.this.a / 2.0f * Math.max(this.c, 1.0f);
            this.a = new IlvPoint[2];
            this.b = new IlvPoint[2];
            float f7 = ilvPoint2.x + f4;
            float f8 = ilvPoint2.y + f5;
            float f9 = ilvPoint3.x - f4;
            float f10 = ilvPoint3.y - f5;
            float f11 = -((float)((double)(f6 * f3) / d3));
            float f12 = (float)((double)(f6 * f2) / d3);
            this.a[0] = new IlvPoint(f7 + f11, f8 + f12);
            this.a[1] = new IlvPoint(f7 - f11, f8 - f12);
            this.b[0] = new IlvPoint(f9 + f11, f10 + f12);
            this.b[1] = new IlvPoint(f9 - f11, f10 - f12);
        }
    }
}

