/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.internal;

import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.internal.IlvLineSegment;
import ilog.views.graphic.composite.internal.IlvPolyPoints;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class IlvPolyline2D
extends IlvPolyPoints
implements Shape,
Cloneable {
    protected IlvPoint _from;
    protected IlvPoint _to;
    static final long serialVersionUID = 2064567278333172392L;

    public IlvPoint getFrom() {
        return this._from;
    }

    public IlvPoint getTo() {
        return this._to;
    }

    public IlvPolyline2D(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        this._from = ilvPoint;
        this._to = ilvPoint2;
    }

    @Override
    public void setNumberOfSegments(int n) {
        if (n == 0 && !this._from.equals(this._to)) {
            throw new Error("start and end point of an IlvPolyline2D are different");
        }
        if (n == this._numsegments && this._points != null) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this._segments[n2] = null;
            }
            for (n2 = 0; n2 <= n; ++n2) {
                this._points[n2] = null;
            }
        } else {
            this._segments = new IlvLineSegment[n];
            this._points = new IlvPoint[n + 1];
            this._numsegments = n;
        }
        if (n == 0) {
            this._points[0] = this._from;
        }
    }

    @Override
    public void setSegment(int n, IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        IlvLineSegment ilvLineSegment;
        this._segments[n] = ilvLineSegment = new IlvLineSegment(ilvPoint, ilvPoint2);
        if (!(n != 0 ? this._segments[n - 1] == null || ilvPoint == this._segments[n - 1].getTo() : ilvPoint == this._from)) {
            throw new Error("starting point of new segment not the same as last point");
        }
        if (!(n != this._numsegments - 1 ? this._segments[n + 1] == null || ilvPoint2 == this._segments[n + 1].getFrom() : ilvPoint2 == this._to)) {
            throw new Error("end point of new segment not the same as next point");
        }
        this._points[n] = ilvPoint;
        this._points[n + 1] = ilvPoint2;
    }

    public Object clone() {
        return new IlvPolyline2D(this._points, false);
    }

    public IlvPolyline2D(IlvPolyline2D ilvPolyline2D) {
        this(ilvPolyline2D._points, false);
    }

    public IlvPolyline2D(IlvPoint[] ilvPointArray, boolean bl) {
        int n = ilvPointArray.length;
        this._from = ilvPointArray[0];
        this._to = ilvPointArray[n - 1];
        this.setNumberOfSegments(n - 1);
        for (int i = 0; i < this._numsegments; ++i) {
            this._segments[i] = new IlvLineSegment(ilvPointArray[i], ilvPointArray[i + 1]);
        }
        System.arraycopy(ilvPointArray, 0, this._points, 0, n);
        if (bl) {
            this.removeRedundantPoints();
        }
    }

    public IlvPolyline2D(IlvPoint[] ilvPointArray) {
        this(ilvPointArray, true);
    }

    @Override
    public int getNumberOfSegments() {
        return super.getNumberOfSegments();
    }

    @Override
    public IlvLineSegment getSegment(int n) {
        return super.getSegment(n);
    }

    @Override
    public IlvLineSegment[] getSegments() {
        return super.getSegments();
    }

    @Override
    public int getNumberOfPoints() {
        return this._numsegments + 1;
    }

    @Override
    public IlvPoint getPoint(int n) {
        return super.getPoint(n);
    }

    @Override
    public IlvPoint[] getPoints() {
        return super.getPoints();
    }

    @Override
    public int getClosestSegment(IlvPoint ilvPoint) {
        return super.getClosestSegment(ilvPoint);
    }

    @Override
    public Rectangle getBounds() {
        return super.getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return super.getBounds2D();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        byte by = objectInputStream.readByte();
        if (by == 1) {
            int n2;
            n = this._points.length;
            this._numsegments = n2 = n - 1;
            if (n2 > 0) {
                this._segments = new IlvLineSegment[n2];
                for (int i = 0; i < n2; ++i) {
                    this._segments[i] = new IlvLineSegment(this._points[i], this._points[i + 1]);
                }
            }
        } else {
            throw new InvalidClassException("Unsupported version " + by + " in readObject of class " + this.getClass());
        }
        this._from = this._points[0];
        this._to = this._points[n - 1];
    }

    @Override
    public boolean contains(double d, double d2) {
        return false;
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5 = d + d3;
        double d6 = d2 + d4;
        for (int i = 0; i < this._numsegments; ++i) {
            if (!this._segments[i].intersects(d, d2, d5, d6)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    @Override
    public PathIterator getPathIterator(final AffineTransform affineTransform) {
        return new PathIterator(){
            private int a = 0;

            @Override
            public int currentSegment(double[] dArray) {
                dArray[0] = IlvPolyline2D.this._points[this.a].x;
                dArray[1] = IlvPolyline2D.this._points[this.a].y;
                if (affineTransform != null) {
                    affineTransform.transform(dArray, 0, dArray, 0, 1);
                }
                return this.a == 0 ? 0 : 1;
            }

            @Override
            public int currentSegment(float[] fArray) {
                fArray[0] = IlvPolyline2D.this._points[this.a].x;
                fArray[1] = IlvPolyline2D.this._points[this.a].y;
                if (affineTransform != null) {
                    affineTransform.transform(fArray, 0, fArray, 0, 1);
                }
                return this.a == 0 ? 0 : 1;
            }

            @Override
            public int getWindingRule() {
                return 1;
            }

            @Override
            public boolean isDone() {
                return this.a >= IlvPolyline2D.this._numsegments;
            }

            @Override
            public void next() {
                ++this.a;
            }
        };
    }

    @Override
    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return this.getPathIterator(affineTransform);
    }

    @Override
    public IlvPolyPoints.PointAndDirection getMedian() {
        return this.getMedian(1.0E-6f);
    }

    protected IlvPolyPoints.PointAndDirection getMedian(float f) {
        int n;
        int n2 = this._numsegments;
        if (n2 == 0) {
            return new IlvPolyPoints.PointAndDirection(this._from, 224, Float.NaN);
        }
        float f2 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            f2 += this._segments[i].length();
        }
        if (f > 0.0f && n2 > 1) {
            float f3 = f2 * f;
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                if (!(this._segments[n].length() < f3)) continue;
                bl = true;
                break;
            }
            if (bl) {
                int n3;
                boolean[] blArray = new boolean[n2 + 1];
                for (n3 = 1; n3 < n2 - 1; ++n3) {
                    if (!(this._segments[n3].length() < f3) || !this._segments[n3 - 1].isParallelVectorTo(this._segments[n3 + 1]) || blArray[n3] || blArray[n3 + 1]) continue;
                    blArray[n3 + 1] = true;
                    blArray[n3] = true;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    if (!(this._segments[n3].length() < f3)) continue;
                    if (n3 == 0) {
                        blArray[1] = true;
                        continue;
                    }
                    if (n3 == n2 - 1) {
                        blArray[n2 - 1] = true;
                        continue;
                    }
                    if (blArray[n3] || blArray[n3 + 1]) continue;
                    blArray[n3] = true;
                }
                n3 = n2 + 1;
                for (int i = 0; i <= n2; ++i) {
                    if (!blArray[i]) continue;
                    --n3;
                }
                IlvPoint[] ilvPointArray = new IlvPoint[n3];
                int n4 = 0;
                for (int i = 0; i <= n2; ++i) {
                    if (blArray[i]) continue;
                    ilvPointArray[n4++] = this._points[i];
                }
                IlvPolyline2D ilvPolyline2D = new IlvPolyline2D(ilvPointArray, true);
                return ilvPolyline2D.getMedian(0.0f);
            }
        }
        float f4 = f2 * 0.5f;
        float f5 = 0.0f;
        for (n = 0; n < n2; ++n) {
            if (!((f5 += this._segments[n].length()) >= f4)) continue;
            IlvLineSegment ilvLineSegment = this._segments[n];
            float f6 = f5 - this._segments[n].length() * 0.5f;
            if (f4 >= f6) {
                if (n + 1 < n2) {
                    if (f4 > f6 + (this._segments[n].length() + this._segments[n + 1].length()) * 0.25f) {
                        ilvLineSegment = this._segments[n + 1];
                    }
                }
            } else if (n > 0) {
                if (f4 < f6 - (this._segments[n].length() + this._segments[n - 1].length()) * 0.25f) {
                    ilvLineSegment = this._segments[n - 1];
                }
            }
            IlvPoint ilvPoint = ilvLineSegment.getFrom();
            IlvPoint ilvPoint2 = ilvLineSegment.getTo();
            return new IlvPolyPoints.PointAndDirection(new IlvPoint((ilvPoint.x + ilvPoint2.x) * 0.5f, (ilvPoint.y + ilvPoint2.y) * 0.5f), ilvLineSegment.getOrientation(), (ilvPoint.y - ilvPoint2.y) / (ilvPoint.x - ilvPoint2.x));
        }
        return null;
    }

    public IlvPolyline2D computeParallel(float f) {
        float f2;
        int n;
        if (f == 0.0f) {
            return this;
        }
        int n2 = this._numsegments;
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            ilvLineSegmentArray[n3] = this._segments[n];
            if (ilvLineSegmentArray[n3].getFrom().equals(ilvLineSegmentArray[n3].getTo())) continue;
            ++n3;
        }
        n2 = n3;
        if (n2 == 0) {
            IlvPolyline2D ilvPolyline2D = new IlvPolyline2D(this._from, this._to);
            ilvPolyline2D.setNumberOfSegments(0);
            return ilvPolyline2D;
        }
        float[] fArray = new float[2 * n2];
        for (n = 0; n < n2; ++n) {
            IlvPoint ilvPoint = ilvLineSegmentArray[n].getFrom();
            IlvPoint ilvPoint2 = ilvLineSegmentArray[n].getTo();
            fArray[2 * n] = ilvPoint2.x - ilvPoint.x;
            fArray[2 * n + 1] = ilvPoint2.y - ilvPoint.y;
        }
        float[] fArray2 = new float[2 * n2];
        for (int i = 0; i < n2; ++i) {
            float f3 = fArray[2 * i];
            float f4 = fArray[2 * i + 1];
            if (f3 == 0.0f) {
                fArray2[2 * i] = 0.0f;
                fArray2[2 * i + 1] = f4 > 0.0f ? 1.0f : (f4 < 0.0f ? -1.0f : 0.0f);
                continue;
            }
            if (f4 == 0.0f) {
                fArray2[2 * i] = f3 > 0.0f ? 1.0f : (f3 < 0.0f ? -1.0f : 0.0f);
                fArray2[2 * i + 1] = 0.0f;
                continue;
            }
            f2 = 1.0f / (float)Math.sqrt(f3 * f3 + f4 * f4);
            fArray2[2 * i] = f2 * f3;
            fArray2[2 * i + 1] = f2 * f4;
        }
        IlvPoint[] ilvPointArray = new IlvPoint[n2 + 1];
        int n4 = 0;
        IlvPoint ilvPoint = this._from;
        f2 = fArray2[0];
        float f5 = fArray2[1];
        ilvPointArray[0] = new IlvPoint(ilvPoint.x - f * f5, ilvPoint.y + f * f2);
        for (int i = 1; i < n2; ++i) {
            IlvPoint ilvPoint3 = ilvLineSegmentArray[i].getFrom();
            f5 = fArray2[2 * i - 2];
            float f6 = fArray2[2 * i - 1];
            float f7 = fArray2[2 * i];
            float f8 = fArray2[2 * i + 1];
            float f9 = f5 + f7;
            float f10 = f6 + f8;
            if (f9 != 0.0f || f10 != 0.0f) {
                float f11 = 1.0f / (1.0f + f5 * f7 + f6 * f8);
                float f12 = f11 * f9;
                float f13 = f11 * f10;
                ilvPointArray[++n4] = new IlvPoint(ilvPoint3.x - f * f13, ilvPoint3.y + f * f12);
                continue;
            }
            ilvPointArray[n4++] = ilvPoint3;
        }
        IlvPoint ilvPoint4 = this._to;
        float f14 = fArray2[2 * n2 - 2];
        f5 = fArray2[2 * n2 - 1];
        ilvPointArray[++n4] = new IlvPoint(ilvPoint4.x - f * f5, ilvPoint4.y + f * f14);
        return new IlvPolyline2D(ilvPointArray);
    }

    public IlvPolyline2D computeParallel(float f, boolean bl) {
        IlvPolyline2D ilvPolyline2D = this.computeParallel(f);
        if (bl) {
            if (ilvPolyline2D == this) {
                ilvPolyline2D = (IlvPolyline2D)ilvPolyline2D.clone();
            }
            ilvPolyline2D.reverse();
        }
        return ilvPolyline2D;
    }

    @Override
    public IlvPolyPoints.TwoPolylines computeThickLinkShape(float f) {
        float f2;
        int n;
        if (f == 0.0f) {
            return new IlvPolyPoints.TwoPolylines(this, this);
        }
        float f3 = f * 0.5f;
        int n2 = this._numsegments;
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            ilvLineSegmentArray[n3] = this._segments[n];
            if (ilvLineSegmentArray[n3].getFrom().equals(ilvLineSegmentArray[n3].getTo())) continue;
            ++n3;
        }
        n2 = n3;
        if (n2 == 0) {
            IlvPolyline2D ilvPolyline2D = new IlvPolyline2D(this._from, this._to);
            ilvPolyline2D.setNumberOfSegments(0);
            return new IlvPolyPoints.TwoPolylines(ilvPolyline2D, ilvPolyline2D);
        }
        float[] fArray = new float[2 * n2];
        for (n = 0; n < n2; ++n) {
            IlvPoint ilvPoint = ilvLineSegmentArray[n].getFrom();
            IlvPoint ilvPoint2 = ilvLineSegmentArray[n].getTo();
            fArray[2 * n] = ilvPoint2.x - ilvPoint.x;
            fArray[2 * n + 1] = ilvPoint2.y - ilvPoint.y;
        }
        float[] fArray2 = new float[2 * n2];
        for (int i = 0; i < n2; ++i) {
            float f4 = fArray[2 * i];
            f2 = fArray[2 * i + 1];
            if (f4 == 0.0f) {
                fArray2[2 * i] = 0.0f;
                fArray2[2 * i + 1] = f2 > 0.0f ? 1.0f : (f2 < 0.0f ? -1.0f : 0.0f);
                continue;
            }
            if (f2 == 0.0f) {
                fArray2[2 * i] = f4 > 0.0f ? 1.0f : (f4 < 0.0f ? -1.0f : 0.0f);
                fArray2[2 * i + 1] = 0.0f;
                continue;
            }
            float f5 = 1.0f / (float)Math.sqrt(f4 * f4 + f2 * f2);
            fArray2[2 * i] = f5 * f4;
            fArray2[2 * i + 1] = f5 * f2;
        }
        int[] nArray = new int[n2 + 1];
        nArray[0] = 0;
        for (int i = 1; i < n2; ++i) {
            f2 = fArray[2 * i - 2] * fArray[2 * i + 1] - fArray[2 * i - 1] * fArray[2 * i];
            nArray[i] = f2 > 0.0f ? 1 : (f2 < 0.0f ? 2 : 0);
        }
        nArray[n2] = 0;
        IlvPoint[] ilvPointArray = new IlvPoint[n2 + 1];
        IlvPoint[] ilvPointArray2 = new IlvPoint[n2 + 1];
        int n4 = 0;
        int n5 = 0;
        IlvPoint ilvPoint = this._from;
        float f6 = fArray2[0];
        float f7 = fArray2[1];
        ilvPointArray[0] = new IlvPoint(ilvPoint.x - f3 * f7, ilvPoint.y + f3 * f6);
        ilvPointArray2[0] = new IlvPoint(ilvPoint.x + f3 * f7, ilvPoint.y - f3 * f6);
        for (int i = 1; i < n2; ++i) {
            IlvPoint ilvPoint3 = ilvLineSegmentArray[i].getFrom();
            f7 = fArray2[2 * i - 2];
            float f8 = fArray2[2 * i - 1];
            float f9 = fArray2[2 * i];
            float f10 = fArray2[2 * i + 1];
            float f11 = f7 + f9;
            float f12 = f8 + f10;
            if (f11 != 0.0f || f12 != 0.0f) {
                float f13 = 1.0f / (1.0f + f7 * f9 + f8 * f10);
                float f14 = f13 * f11;
                float f15 = f13 * f12;
                ilvPointArray[++n4] = new IlvPoint(ilvPoint3.x - f3 * f15, ilvPoint3.y + f3 * f14);
                ilvPointArray2[++n5] = new IlvPoint(ilvPoint3.x + f3 * f15, ilvPoint3.y - f3 * f14);
                continue;
            }
            ilvPointArray[n4++] = ilvPoint3;
            ilvPointArray2[n5++] = ilvPoint3;
        }
        IlvPoint ilvPoint4 = this._to;
        f6 = fArray2[2 * n2 - 2];
        f7 = fArray2[2 * n2 - 1];
        ilvPointArray[++n4] = new IlvPoint(ilvPoint4.x - f3 * f7, ilvPoint4.y + f3 * f6);
        ilvPointArray2[++n5] = new IlvPoint(ilvPoint4.x + f3 * f7, ilvPoint4.y - f3 * f6);
        return new IlvPolyPoints.TwoPolylines(new IlvPolyline2D(ilvPointArray2), new IlvPolyline2D(ilvPointArray));
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null) {
            int n;
            for (n = 0; n <= this._numsegments; ++n) {
                IlvPoint ilvPoint = this._points[n];
                ilvPoint = (IlvPoint)ilvPoint.clone();
                ilvTransformer.apply(ilvPoint);
                this._points[n] = ilvPoint;
            }
            for (n = 0; n < this._numsegments; ++n) {
                this._segments[n] = new IlvLineSegment(this._points[n], this._points[n + 1]);
            }
            this._from = this._points[0];
            this._to = this._points[this._numsegments];
        }
    }

    @Override
    public void reverse() {
        int n;
        for (n = this._numsegments - 1 >> 1; n >= 0; --n) {
            IlvPoint ilvPoint = this._points[n];
            this._points[n] = this._points[this._numsegments - n];
            this._points[this._numsegments - n] = ilvPoint;
        }
        for (n = 0; n < this._numsegments; ++n) {
            this._segments[n] = new IlvLineSegment(this._points[n], this._points[n + 1]);
        }
        this._from = this._points[0];
        this._to = this._points[this._numsegments];
    }

    @Override
    public void insertPoint(int n, IlvPoint ilvPoint) {
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[this._numsegments + 1];
        IlvPoint[] ilvPointArray = new IlvPoint[this._numsegments + 2];
        System.arraycopy(this._points, 0, ilvPointArray, 0, n + 1);
        ilvPointArray[n + 1] = ilvPoint;
        System.arraycopy(this._points, n + 1, ilvPointArray, n + 2, this._numsegments - n);
        if (n == -1) {
            ilvLineSegmentArray[0] = new IlvLineSegment(ilvPoint, ilvPointArray[1]);
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 1, this._numsegments);
        } else if (n == this._numsegments) {
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, this._numsegments);
            ilvLineSegmentArray[this._numsegments] = new IlvLineSegment(ilvPointArray[this._numsegments], ilvPoint);
        } else {
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, n);
            ilvLineSegmentArray[n] = new IlvLineSegment(ilvPointArray[n], ilvPoint);
            ilvLineSegmentArray[n + 1] = new IlvLineSegment(ilvPoint, ilvPointArray[n + 2]);
            System.arraycopy(this._segments, n + 1, ilvLineSegmentArray, n + 2, this._numsegments - n - 1);
        }
        this._segments = ilvLineSegmentArray;
        this._points = ilvPointArray;
        ++this._numsegments;
        this._from = this._points[0];
        this._to = this._points[this._numsegments];
    }

    @Override
    public void insertPoint(IlvPoint ilvPoint) {
        if (this._numsegments == 0) {
            IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[2];
            IlvPoint[] ilvPointArray = new IlvPoint[]{this._from, ilvPoint, this._to};
            ilvLineSegmentArray[0] = new IlvLineSegment(this._from, ilvPoint);
            ilvLineSegmentArray[1] = new IlvLineSegment(ilvPoint, this._to);
            this._segments = ilvLineSegmentArray;
            this._points = ilvPointArray;
            this._numsegments = 2;
        } else {
            int n = this.getClosestSegment(ilvPoint);
            this.insertPoint(n, ilvPoint);
        }
    }

    @Override
    public void movePoint(int n, IlvPoint ilvPoint) {
        if (this._points != null) {
            this._points[n] = ilvPoint;
        }
        if (n == 0) {
            this._from = ilvPoint;
        }
        if (n == this._numsegments) {
            this._to = ilvPoint;
        }
        if (this._segments != null) {
            if (n > 0) {
                this._segments[n - 1] = new IlvLineSegment(this._points[n - 1], ilvPoint);
            }
            if (n < this._numsegments) {
                this._segments[n] = new IlvLineSegment(ilvPoint, this._points[n + 1]);
            }
        }
    }

    @Override
    public void removePoint(int n) {
        if (n < 0 || n > this._numsegments) {
            throw new Error("IlvPolyline2D.removePoint index out of range");
        }
        IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[this._numsegments - 1];
        IlvPoint[] ilvPointArray = new IlvPoint[this._numsegments];
        if (n > 0) {
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, n - 1);
            System.arraycopy(this._points, 0, ilvPointArray, 0, n);
            if (n < this._numsegments) {
                ilvLineSegmentArray[n - 1] = new IlvLineSegment(this._points[n - 1], this._points[n + 1]);
            }
        }
        if (n < this._numsegments) {
            System.arraycopy(this._segments, n + 1, ilvLineSegmentArray, n, this._numsegments - n - 1);
            System.arraycopy(this._points, n + 1, ilvPointArray, n, this._numsegments - n);
        }
        this._segments = ilvLineSegmentArray;
        this._points = ilvPointArray;
        --this._numsegments;
        this._from = this._points[0];
        this._to = this._points[this._numsegments];
    }

    @Override
    public void removeRedundantPoints() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 < this._numsegments && IlvPolyPoints.a(this._points[n], this._points[n2], this._points[n2 + 1])) {
                ++n2;
                continue;
            }
            if (n2 - n == 0) break;
            if (n2 - n == 1) {
                if (n3 < n) {
                    this._points[n3 + 1] = this._points[n2];
                    this._segments[n3] = this._segments[n];
                }
            } else {
                this._points[n3 + 1] = this._points[n2];
                this._segments[n3] = new IlvLineSegment(this._points[n3], this._points[n3 + 1]);
            }
            n = n2;
            ++n3;
        }
        if (n3 < this._numsegments) {
            IlvLineSegment[] ilvLineSegmentArray = new IlvLineSegment[n3];
            IlvPoint[] ilvPointArray = new IlvPoint[n3 + 1];
            System.arraycopy(this._segments, 0, ilvLineSegmentArray, 0, n3);
            System.arraycopy(this._points, 0, ilvPointArray, 0, n3 + 1);
            this._segments = ilvLineSegmentArray;
            this._points = ilvPointArray;
            this._numsegments = n3;
        }
    }

    public void adjustForFromArrow(float f, float f2) {
        IlvPoint[] ilvPointArray = this.adjustForArrow(new IlvLineSegment(this.getSegment(0).getTo(), this.getSegment(0).getFrom()), f, f2);
        if (ilvPointArray.length == 2) {
            if (this.getSegment(0).getTo() != this.getTo()) {
                this.movePoint(1, ilvPointArray[1]);
            } else {
                this.insertPoint(0, ilvPointArray[1]);
            }
        }
        this.insertPoint(0, ilvPointArray[0]);
    }

    public void adjustForToArrow(float f, float f2) {
        IlvPoint[] ilvPointArray = this.adjustForArrow(this.getSegment(this.getNumberOfSegments() - 1), f, f2);
        if (ilvPointArray.length == 2) {
            if (this.getSegment(this.getNumberOfSegments() - 1).getFrom() != this.getFrom()) {
                this.movePoint(this.getNumberOfPoints() - 2, ilvPointArray[1]);
            } else {
                this.insertPoint(this.getNumberOfSegments() - 1, ilvPointArray[1]);
            }
        }
        this.insertPoint(this.getNumberOfSegments() - 1, ilvPointArray[0]);
    }

    public IlvPoint[] adjustForArrow(IlvLineSegment ilvLineSegment, float f, float f2) {
        float f3;
        IlvPoint[] ilvPointArray;
        float f4 = ilvLineSegment.length();
        int n = ilvLineSegment.getDirection();
        if ((double)f4 <= 1.0E-10 && n == 0) {
            n = 1;
        }
        if (f + f2 / 2.0f > f4) {
            ilvPointArray = new IlvPoint[2];
            if (n == 0) {
                f3 = (f + f2 / 2.0f) / f4;
                ilvPointArray[1] = new IlvPoint(ilvLineSegment.getTo().x + f3 * (ilvLineSegment.getTo().x - ilvLineSegment.getFrom().x), ilvLineSegment.getTo().y + f3 * (ilvLineSegment.getTo().y - ilvLineSegment.getFrom().y));
            } else {
                f3 = f + f2 / 2.0f;
                ilvPointArray[1] = new IlvPoint(ilvLineSegment.getTo().x + (n == 1 ? f3 : (n == 2 ? -f3 : 0.0f)), ilvLineSegment.getTo().y + (n == 4 ? f3 : (n == 8 ? -f3 : 0.0f)));
            }
        } else {
            ilvPointArray = new IlvPoint[1];
        }
        if (n == 0) {
            f3 = f / f4;
            ilvPointArray[0] = new IlvPoint(ilvLineSegment.getTo().x - f3 * (ilvLineSegment.getTo().x - ilvLineSegment.getFrom().x), ilvLineSegment.getTo().y - f3 * (ilvLineSegment.getTo().y - ilvLineSegment.getFrom().y));
        } else {
            ilvPointArray[0] = new IlvPoint(ilvLineSegment.getTo().x + (n == 1 ? f : (n == 2 ? -f : 0.0f)), ilvLineSegment.getTo().y + (n == 4 ? f : (n == 8 ? -f : 0.0f)));
        }
        return ilvPointArray;
    }
}

