/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvPolyPoints;
import ilog.views.graphic.IlvSplineSelection;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.util.ArrayList;

public class IlvSpline
extends IlvPolyPoints {
    private float a = -1.0f;
    private Color b;
    private Color c;
    private int d = 2;
    private static final int e = 2;
    private static final int f = 4;
    private static final int g = 8;

    public IlvSpline(IlvPoint[] ilvPointArray) {
        super(ilvPointArray);
    }

    public IlvSpline(IlvPoint[] ilvPointArray, boolean bl) {
        super(ilvPointArray, bl);
    }

    public IlvSpline(IlvPoint[] ilvPointArray, boolean bl, boolean bl2) {
        super(ilvPointArray, bl);
        this.setClosed(bl2);
    }

    public IlvSpline(IlvSpline ilvSpline) {
        super(ilvSpline);
        this.a = ilvSpline.a;
        this.setLineWidth(ilvSpline.getLineWidth());
        this.setMaximumLineWidth(ilvSpline.getMaximumLineWidth());
        this.setEndCap(ilvSpline.getEndCap());
        this.setLineStyle(ilvSpline.getLineStyle());
        this.setForeground(ilvSpline.getForeground());
        this.setBackground(ilvSpline.getBackground());
        this.d = ilvSpline.d;
    }

    public IlvSpline(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        try {
            this.setLineWidth(ilvInputStream.readFloat("lineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumLineWidth(ilvInputStream.readFloat("maximumLineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setEndCap(ilvInputStream.readInt("endCap"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineStyle(ilvInputStream.readFloatArray("lineStyle"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setSmoothness(ilvInputStream.readFloat("smoothness"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.setSmoothness(-1.0f);
        }
        try {
            this.setBackground(ilvInputStream.readColor("background"));
            this.d = ilvInputStream.readInt("flags");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvSpline(this);
    }

    @Override
    protected void computeBBox(IlvRect ilvRect) {
        float f = this.getLineWidth();
        if (!this.isClosed()) {
            if (f == 0.0f) {
                IlvGraphicUtil.BezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null);
            } else {
                f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), null, true);
                IlvGraphicUtil.BezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), null);
            }
        } else if (f == 0.0f) {
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null);
        } else {
            f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), null, true);
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), null);
        }
    }

    @Override
    public boolean pointsInBBox() {
        return false;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return super.boundingBox(ilvTransformer);
        }
        IlvRect ilvRect = new IlvRect();
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, true);
        if (!this.isClosed()) {
            IlvGraphicUtil.BezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), ilvTransformer);
        } else {
            IlvGraphicUtil.ClosedBezierBoundingBox(ilvRect, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), ilvTransformer);
        }
        return ilvRect;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvPoint[] ilvPointArray;
        if (this.isFillOn() && this.inBBox(ilvPoint) && IlvGraphicUtil.PointInFilledBezier(ilvPoint2, ilvPointArray = this.getPoints(), ilvPointArray.length, false, this.getSmoothness(), ilvTransformer)) {
            return true;
        }
        if (this.isStrokeOn()) {
            float f = IlvStrokeInfo.zoomedLineWidth(this.getLineWidth(), this.getMaximumLineWidth(), ilvTransformer, false);
            if (!this.isClosed()) {
                return IlvGraphicUtil.PointInBezier(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), ilvTransformer);
            }
            return IlvGraphicUtil.PointInClosedBezier(ilvPoint2, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), ilvTransformer);
        }
        return false;
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        double d;
        double d2;
        double d3;
        IlvPoint ilvPoint3;
        IlvPoint ilvPoint4;
        int n;
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        boolean bl = !this.isStrokeOn();
        boolean bl2 = this.isFillOn() || this.isClosed();
        float f = this.getSmoothness();
        if (f == -1.0f) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint[] ilvPointArray = IlvGraphicUtil.GetPolyPoints(this, ilvTransformer);
        int n2 = ilvPointArray.length <= 2 ? ilvPointArray.length : (ilvPointArray.length - 2) * 3 + 1;
        IlvPoint[] ilvPointArray2 = IlvGraphicUtil.GetSmoothSpline(ilvPointArray, ilvPointArray.length, f, false, null);
        ArrayList<IlvPoint> arrayList = new ArrayList<IlvPoint>();
        IlvPoint[] ilvPointArray3 = new IlvPoint[3];
        for (n = 0; n < n2 - 3; n += 3) {
            int n3 = IlvClippingUtil.LineIntersectsCubicSpline(ilvPoint, ilvPoint2, ilvPointArray2, n, ilvPointArray3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(ilvPointArray3[i]);
            }
        }
        if (n < n2 - 1 && IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPointArray2[n], ilvPointArray2[n2 - 1], ilvPoint4 = new IlvPoint())) {
            arrayList.add(ilvPoint4);
        }
        if (bl2 && IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPointArray2[n2 - 1], ilvPointArray2[0], ilvPoint3 = new IlvPoint())) {
            arrayList.add(ilvPoint3);
        }
        if (arrayList.size() == 0) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint[] ilvPointArray4 = new IlvPoint[arrayList.size()];
        ilvPointArray4 = arrayList.toArray(ilvPointArray4);
        IlvPoint ilvPoint5 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray4, ilvPointArray4.length);
        double d4 = 0.0;
        if (!bl) {
            if (ilvTransformer == null || ilvTransformer.isIdentity()) {
                d4 = this.getLineWidth();
            } else {
                d3 = ilvTransformer.zoomFactor();
                d4 = (double)this.getLineWidth(ilvTransformer) / d3;
            }
        }
        if (d4 > 0.0 && (d2 = Math.sqrt((d3 = (double)(ilvPoint2.x - ilvPoint.x)) * d3 + (d = (double)(ilvPoint2.y - ilvPoint.y)) * d)) != 0.0) {
            ilvPoint5.x += (float)(0.5 * d4 * d3 / d2);
            ilvPoint5.y += (float)(0.5 * d4 * d / d2);
        }
        return ilvPoint5;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (((IlvPolyPoints)this).a.length == 0) {
            return;
        }
        if (this.isFillOn()) {
            graphics.setColor(this.getBackground());
            IlvGraphicUtil.FillBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), ilvTransformer);
        }
        if (this.isStrokeOn()) {
            float f = this.getLineWidth();
            float[] fArray = this.getLineStyle();
            graphics.setColor(this.getForeground());
            if (f == 0.0f && fArray == null) {
                if (!this.isClosed()) {
                    IlvGraphicUtil.DrawBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null, ilvTransformer, false);
                } else {
                    IlvGraphicUtil.DrawClosedBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), 0.0f, 0, 0, null, ilvTransformer);
                }
            } else {
                float f2 = this.getMaximumLineWidth();
                fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f, f2, ilvTransformer);
                f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
                if (!this.isClosed()) {
                    IlvGraphicUtil.DrawBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), fArray, ilvTransformer, false);
                } else {
                    IlvGraphicUtil.DrawClosedBezier(graphics, ((IlvPolyPoints)this).a, ((IlvPolyPoints)this).a.length, false, this.getSmoothness(), f, 0, this.getEndCap(), fArray, ilvTransformer);
                }
            }
        }
    }

    @Override
    public IlvSelection makeSelection() {
        return new IlvSplineSelection(this);
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.b;
        this.b = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.b == null) {
            return Color.black;
        }
        return this.b;
    }

    @Override
    public void setBackground(Color color) {
        Color color2 = this.c;
        this.c = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getBackground() {
        if (this.c == null) {
            return Color.black;
        }
        return this.c;
    }

    public boolean isFillOn() {
        return (this.d & 4) != 0;
    }

    @Override
    public void setFillOn(boolean bl) {
        this.d = bl ? (this.d |= 4) : (this.d &= 0xFFFFFFFB);
    }

    public boolean isStrokeOn() {
        return (this.d & 2) != 0;
    }

    @Override
    public void setStrokeOn(boolean bl) {
        this.d = bl ? (this.d |= 2) : (this.d &= 0xFFFFFFFD);
    }

    public void setClosed(boolean bl) {
        this.d = bl ? (this.d |= 8) : (this.d &= 0xFFFFFFF7);
    }

    public boolean isClosed() {
        return (this.d & 8) != 0;
    }

    public float getLineWidth() {
        return IlvStrokeInfo.GetLineWidth(this);
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("bad line Width " + f);
        }
        if (f != this.getLineWidth()) {
            IlvStrokeInfo.SetLineWidth(this, f);
            this.a();
        }
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return 1.0f;
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, false);
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return Math.max(1.0f, (float)((double)f * d));
    }

    public int getEndCap() {
        return IlvStrokeInfo.GetEndCap(this);
    }

    public void setEndCap(int n) {
        if (n != 1 && n != 2 && n != 0) {
            throw new IllegalArgumentException("bad end cap");
        }
        if (n != this.getEndCap()) {
            IlvStrokeInfo.SetEndCap(this, n);
            this.a();
        }
    }

    public float getMaximumLineWidth() {
        return IlvStrokeInfo.GetMaximumLineWidth(this);
    }

    public void setMaximumLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("limit must be greater than 0 " + f);
        }
        if (f != this.getMaximumLineWidth()) {
            IlvStrokeInfo.SetMaximumLineWidth(this, f);
            this.a();
        }
    }

    public float[] getLineStyle() {
        return IlvStrokeInfo.GetLineStyle(this);
    }

    public void setLineStyle(float[] fArray) {
        IlvStrokeInfo.SetLineStyle(this, fArray);
    }

    public void setSmoothness(float f) {
        block3: {
            block2: {
                if (f == -1.0f) break block2;
                if (f != -2.0f && (!(f >= 0.0f) || !(f <= 1.0f))) break block3;
            }
            this.a = f;
            this.a();
        }
    }

    public float getSmoothness() {
        return this.a;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float[] fArray;
        int n;
        float f;
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        float f2 = this.getLineWidth();
        if (f2 != 0.0f) {
            ilvOutputStream.write("lineWidth", f2);
        }
        if ((f = this.getMaximumLineWidth()) != 0.0f) {
            ilvOutputStream.write("maximumLineWidth", f);
        }
        if ((n = this.getEndCap()) != 2) {
            ilvOutputStream.write("endCap", n);
        }
        if ((fArray = this.getLineStyle()) != null) {
            ilvOutputStream.write("lineStyle", fArray);
        }
        float f3 = this.getSmoothness();
        if (f3 != -1.0f) {
            ilvOutputStream.write("smoothness", f3);
        }
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("flags", this.d);
    }

    protected void finalize() throws Throwable {
        IlvStrokeInfo.DisposeStroke(this);
    }
}

