/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvReliefRectangle
extends IlvRectangle {
    private static final int a = 2;
    private int b = 2;

    public IlvReliefRectangle() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f));
    }

    public IlvReliefRectangle(IlvRect ilvRect) {
        super(ilvRect);
        super.setFillOn(true);
    }

    public IlvReliefRectangle(IlvRect ilvRect, int n) {
        super(ilvRect);
        this.setThickness(Math.max(0, n));
        super.setFillOn(true);
    }

    public IlvReliefRectangle(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setThickness(ilvInputStream.readInt("thickness"));
    }

    public IlvReliefRectangle(IlvReliefRectangle ilvReliefRectangle) {
        super(ilvReliefRectangle);
        this.setThickness(ilvReliefRectangle.b);
    }

    public int getThickness() {
        return this.b;
    }

    public void setThickness(int n) {
        this.b = Math.max(n, 0);
    }

    @Override
    public IlvGraphic copy() {
        return new IlvReliefRectangle(this);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        int n = this.getThickness();
        graphics.setColor(this.getBackground());
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.applyFloor(ilvRect);
        } else {
            ilvRect.floor();
        }
        graphics.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width + 1, (int)ilvRect.height + 1);
        for (int i = 0; i < n && (int)ilvRect.width - 2 * i > 0 && (int)ilvRect.height - 2 * i > 0; ++i) {
            graphics.draw3DRect((int)ilvRect.x + i, (int)ilvRect.y + i, (int)ilvRect.width - 2 * i, (int)ilvRect.height - 2 * i, true);
        }
        if (ilvRect.width > (float)(2 * n) && ilvRect.height > (float)(2 * n)) {
            ilvRect.x = (int)ilvRect.x + n;
            ilvRect.y = (int)ilvRect.y + n;
            ilvRect.height = (int)ilvRect.height - 2 * n;
            ilvRect.width = (int)ilvRect.width - 2 * n;
            this.drawContent(graphics, ilvRect, ilvTransformer);
        }
    }

    protected void drawContent(Graphics graphics, IlvRect ilvRect, IlvTransformer ilvTransformer) {
    }

    @Override
    public final void setRadius(int n) {
        throw new RuntimeException("could not change radius for IlvReliefRectangle");
    }

    @Override
    public final void setStrokeOn(boolean bl) {
        throw new RuntimeException("could not change stroke on/off for IlvReliefRectangle");
    }

    @Override
    public final void setFillOn(boolean bl) {
        throw new RuntimeException("could not change fill on/off for IlvReliefRectangle");
    }

    @Override
    public final void setCorners(int n) {
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("thickness", this.getThickness());
    }
}

