/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Serializable;

public class IlvPointArray
implements Serializable,
IlvPersistentObject {
    private IlvPoint[] a;
    private boolean b;
    private final IlvRect c = new IlvRect();
    static Boolean d = new Boolean(true);
    static IlvPoint[] e = null;

    public IlvPointArray() {
        this(null, false);
    }

    public IlvPointArray(IlvPoint[] ilvPointArray, boolean bl) {
        this.setPoints(ilvPointArray, bl);
    }

    public IlvPointArray(IlvInputStream ilvInputStream) throws IlvReadFileException {
        this.setPoints(ilvInputStream.readPointArray("points"), false);
    }

    public IlvPointArray(IlvPointArray ilvPointArray) {
        this.setPoints(ilvPointArray.getPoints(), true);
    }

    public int getNumberOfPoints() {
        return this.a != null ? this.a.length : 0;
    }

    public IlvPoint[] getPoints() {
        return this.a;
    }

    public IlvPoint getPoint(int n) {
        return this.a[n];
    }

    public void movePoint(int n, float f, float f2) {
        this.a[n].move(f, f2);
        this.b = false;
    }

    public void addPoints(IlvPoint[] ilvPointArray, int n) {
        if (ilvPointArray == null) {
            throw new IllegalArgumentException("pts is null");
        }
        int n2 = this.a.length;
        if (n > n2) {
            n = n2;
        }
        IlvPoint[] ilvPointArray2 = this.a;
        this.a = new IlvPoint[n2 + ilvPointArray.length];
        if (n != 0) {
            System.arraycopy(ilvPointArray2, 0, this.a, 0, n);
        }
        System.arraycopy(ilvPointArray, 0, this.a, n, ilvPointArray.length);
        if (n < n2) {
            System.arraycopy(ilvPointArray2, n, this.a, n + ilvPointArray.length, n2 - n);
        }
        this.b = false;
    }

    public void removePoints(int n, int n2) {
        if (n2 == 0 || n == 0 && n2 >= this.getNumberOfPoints() || n != 0 && n2 + n > this.getNumberOfPoints()) {
            throw new IllegalArgumentException("bad parameters");
        }
        IlvPoint[] ilvPointArray = this.a;
        int n3 = this.getNumberOfPoints();
        this.a = new IlvPoint[n3 - n2];
        if (n != 0) {
            System.arraycopy(ilvPointArray, 0, this.a, 0, n);
        }
        if (n + n2 < n3) {
            System.arraycopy(ilvPointArray, n + n2, this.a, n, n3 - n - n2);
        }
        this.b = false;
    }

    public void boundingBox(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        this.a(ilvRect);
        if (ilvTransformer != null) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
    }

    public void setPoints(IlvPoint[] ilvPointArray, boolean bl) {
        if (ilvPointArray == null) {
            this.a = null;
        } else if (bl) {
            int n = ilvPointArray.length;
            this.a = new IlvPoint[n];
            for (int i = 0; i < n; ++i) {
                this.a[i] = new IlvPoint(ilvPointArray[i].x, ilvPointArray[i].y);
            }
        } else {
            this.a = ilvPointArray;
        }
        this.b = false;
    }

    public boolean outlineContains(IlvPoint ilvPoint) {
        if (this.a == null) {
            return false;
        }
        switch (this.a.length) {
            case 0: {
                return false;
            }
            case 1: {
                return ilvPoint.x == this.a[0].x && ilvPoint.y == this.a[0].y;
            }
        }
        IlvRect ilvRect = new IlvRect();
        this.a(ilvRect);
        ilvRect.expand(IlvUtil.GetDeltaLine());
        if (!ilvRect.inside(ilvPoint.x, ilvPoint.y)) {
            return false;
        }
        for (int i = 1; i < this.a.length; ++i) {
            if (!IlvUtil.PointInLine(ilvPoint, this.a[i - 1], this.a[i])) continue;
            return true;
        }
        return false;
    }

    public int nbHorizontalIntersection(IlvPoint ilvPoint) {
        if (this.a == null || this.a.length <= 1) {
            return 0;
        }
        int n = 0;
        for (int i = 1; i < this.a.length; ++i) {
            if (!IlvUtility.IntersectHorizontal(ilvPoint, this.a[i - 1], this.a[i])) continue;
            ++n;
        }
        if (this.a.length == 2) {
            return n * 2;
        }
        if (IlvUtility.IntersectHorizontal(ilvPoint, this.a[this.a.length - 1], this.a[0])) {
            ++n;
        }
        return n;
    }

    private void a(IlvRect ilvRect) {
        if (!this.b) {
            if (this.a != null) {
                IlvUtil.BoundingBox(this.c, this.a, this.a.length);
            } else {
                this.c.reshape(0.0f, 0.0f, 0.0f, 0.0f);
            }
            this.b = true;
        }
        ilvRect.reshape(this.c.x, this.c.y, this.c.width, this.c.height);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.a != null) {
            int n = this.a.length;
            for (int i = 0; i < n; ++i) {
                ilvTransformer.apply(this.a[i]);
            }
            this.b = false;
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("points", this.a);
    }

    public static void FillPaths(Graphics graphics, Color color, IlvPointArray[] ilvPointArrayArray) {
        int n;
        int n2 = ilvPointArrayArray.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += ilvPointArrayArray[n].getNumberOfPoints();
        }
        if (n3 == 0) {
            return;
        }
        IlvPoint ilvPoint = ilvPointArrayArray[0].getPoint(0);
        IlvPoint[] ilvPointArray = IlvPointArray.a(n3 += 2 * n2 - 1);
        ilvPointArray[0].move(ilvPoint.x, ilvPoint.y);
        int n4 = 1;
        for (n = 0; n < n2; ++n) {
            IlvPoint ilvPoint2;
            IlvPointArray ilvPointArray2 = ilvPointArrayArray[n];
            for (int i = 0; i < ilvPointArray2.getNumberOfPoints(); ++i) {
                ilvPoint2 = ilvPointArray2.getPoint(i);
                if (ilvPoint2.x == ilvPointArray[n4 - 1].x && ilvPoint2.y == ilvPointArray[n4 - 1].y) continue;
                ilvPointArray[n4].move(ilvPoint2.x, ilvPoint2.y);
                ++n4;
            }
            IlvPoint ilvPoint3 = ilvPointArray2.getPoint(0);
            ilvPoint2 = ilvPointArray2.getPoint(ilvPointArray2.getNumberOfPoints() - 1);
            if (!(ilvPoint3.x == ilvPoint2.x && ilvPoint3.y == ilvPoint2.y || ilvPoint3.x == ilvPointArray[n4 - 1].x && ilvPoint3.y == ilvPointArray[n4 - 1].y)) {
                ilvPointArray[n4].move(ilvPoint3.x, ilvPoint3.y);
                ++n4;
            }
            if (n == 0 || ilvPoint.x == ilvPointArray[n4 - 1].x && ilvPoint.y == ilvPointArray[n4 - 1].y) continue;
            ilvPointArray[n4].move(ilvPoint.x, ilvPoint.y);
            ++n4;
        }
        if (n4 < 3) {
            return;
        }
        IlvPointArray.a(graphics, color, n4 - 1, ilvPointArray, true);
    }

    private static void a(Graphics graphics, Color color, int n, IlvPoint[] ilvPointArray, boolean bl) {
        graphics.setColor(color);
        if (bl) {
            IlvGraphicUtil.FillPolygon(graphics, ilvPointArray, n, null);
        } else {
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, n, 0.0f, 1, 0, null, null);
        }
    }

    public static void DrawPaths(Graphics graphics, Color color, IlvPointArray[] ilvPointArrayArray) {
        int n = ilvPointArrayArray.length;
        for (int i = 0; i < n; ++i) {
            IlvPointArray.a(graphics, color, ilvPointArrayArray[i].getNumberOfPoints(), ilvPointArrayArray[i].getPoints(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final IlvPoint[] a(int n) {
        Boolean bl = d;
        synchronized (bl) {
            int n2;
            if (e != null && e.length >= n) {
                return e;
            }
            IlvPoint[] ilvPointArray = e;
            e = new IlvPoint[n];
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, e, 0, ilvPointArray.length);
            }
            int n3 = n2 = ilvPointArray == null ? 0 : ilvPointArray.length;
            while (n2 < n) {
                IlvPointArray.e[n2] = new IlvPoint();
                ++n2;
            }
            return e;
        }
    }
}

