/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvPolyPointsSelection;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.internal.IlvStrokeInfo;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvLine
extends IlvGraphic
implements IlvPolyPointsInterface {
    private final IlvPoint a = new IlvPoint();
    private final IlvPoint b = new IlvPoint();
    private Color c = null;

    public IlvLine() {
        this(0.0f, 0.0f, 100.0f, 100.0f);
    }

    public IlvLine(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        this(ilvPoint.x, ilvPoint.y, ilvPoint2.x, ilvPoint2.y);
    }

    public IlvLine(float f, float f2, float f3, float f4) {
        this.a.move(f, f2);
        this.b.move(f3, f4);
    }

    public IlvLine(IlvLine ilvLine) {
        super(ilvLine);
        this.a.move(ilvLine.a.x, ilvLine.a.y);
        this.b.move(ilvLine.b.x, ilvLine.b.y);
        this.setForeground(ilvLine.c);
        this.setLineWidth(ilvLine.getLineWidth());
        this.setMaximumLineWidth(ilvLine.getMaximumLineWidth());
        this.setEndCap(ilvLine.getEndCap());
        this.setLineStyle(ilvLine.getLineStyle());
    }

    public IlvLine(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        Color color = ilvInputStream.readColor("foreground");
        IlvPoint ilvPoint = ilvInputStream.readPoint("from");
        IlvPoint ilvPoint2 = ilvInputStream.readPoint("to");
        this.setForeground(color);
        this.a.move(ilvPoint.x, ilvPoint.y);
        this.b.move(ilvPoint2.x, ilvPoint2.y);
        try {
            this.setLineWidth(ilvInputStream.readFloat("lineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMaximumLineWidth(ilvInputStream.readFloat("maximumLineWidth"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setEndCap(ilvInputStream.readInt("endCap"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setLineStyle(ilvInputStream.readFloatArray("lineStyle"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvLine(this);
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            IlvPoint ilvPoint3 = new IlvPoint(this.a.x, this.a.y);
            IlvPoint ilvPoint4 = new IlvPoint(this.b.x, this.b.y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint3);
                ilvTransformer.apply(ilvPoint4);
            }
            return IlvUtil.PointInLine(ilvPoint2, ilvPoint3, ilvPoint4, false);
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, false);
        IlvPoint[] ilvPointArray = new IlvPoint[]{this.a, this.b};
        return IlvGraphicUtil.PointInPolyline(ilvPoint2, ilvPointArray, 2, f, 1, this.getEndCap(), ilvTransformer);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        float[] fArray = this.getLineStyle();
        graphics.setColor(this.getForeground());
        if (f == 0.0f && fArray == null) {
            IlvPoint[] ilvPointArray = new IlvPoint[]{this.a, this.b};
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, 2, 0.0f, 1, 0, null, ilvTransformer);
        } else {
            float f2 = this.getMaximumLineWidth();
            fArray = IlvStrokeInfo.zoomedLineStyle(fArray, f, f2, ilvTransformer);
            f = IlvStrokeInfo.zoomedLineWidth(f, f2, ilvTransformer, false);
            IlvPoint[] ilvPointArray = new IlvPoint[]{this.a, this.b};
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, 2, f, 1, this.getEndCap(), fArray, ilvTransformer);
        }
    }

    @Override
    public boolean pointsInBBox() {
        return true;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        float f = this.getLineWidth();
        if (f == 0.0f) {
            ilvRect = new IlvRect();
            IlvPoint ilvPoint = new IlvPoint(this.a.x, this.a.y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            float f2 = ilvPoint.x;
            float f3 = ilvPoint.y;
            ilvPoint.x = this.b.x;
            ilvPoint.y = this.b.y;
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            ilvRect.move(Math.min(f2, ilvPoint.x), Math.min(f3, ilvPoint.y));
            ilvRect.resize(Math.abs(Math.max(f2, ilvPoint.x) - ilvRect.x), Math.abs(Math.max(f3, ilvPoint.y) - ilvRect.y));
        } else {
            f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, true);
            IlvPoint[] ilvPointArray = new IlvPoint[]{this.a, this.b};
            ilvRect = IlvGraphicUtil.PolylineBBox(ilvPointArray, 2, f, 1, this.getEndCap(), ilvTransformer);
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        return ilvRect;
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        ilvTransformer.apply(this.a);
        ilvTransformer.apply(this.b);
    }

    public IlvPoint getFrom() {
        return new IlvPoint(this.a.x, this.a.y);
    }

    public IlvPoint getTo() {
        return new IlvPoint(this.b.x, this.b.y);
    }

    public void setTo(IlvPoint ilvPoint) {
        this.b.move(ilvPoint.x, ilvPoint.y);
    }

    public void setFrom(IlvPoint ilvPoint) {
        this.a.move(ilvPoint.x, ilvPoint.y);
    }

    public float getLineWidth() {
        return IlvStrokeInfo.GetLineWidth(this);
    }

    public void setLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("bad line Width " + f);
        }
        if (f != this.getLineWidth()) {
            IlvStrokeInfo.SetLineWidth(this, f);
        }
    }

    public float getLineWidth(IlvTransformer ilvTransformer) {
        float f = this.getLineWidth();
        if (f == 0.0f) {
            return 1.0f;
        }
        f = IlvStrokeInfo.zoomedLineWidth(f, this.getMaximumLineWidth(), ilvTransformer, false);
        double d = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        return Math.max(1.0f, (float)((double)f * d));
    }

    public int getEndCap() {
        return IlvStrokeInfo.GetEndCap(this);
    }

    public void setEndCap(int n) {
        if (n != 1 && n != 2 && n != 0) {
            throw new IllegalArgumentException("bad end cap");
        }
        if (n != this.getEndCap()) {
            IlvStrokeInfo.SetEndCap(this, n);
        }
    }

    public float getMaximumLineWidth() {
        return IlvStrokeInfo.GetMaximumLineWidth(this);
    }

    public void setMaximumLineWidth(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("limit must be greater than 0 " + f);
        }
        if (f != this.getMaximumLineWidth()) {
            IlvStrokeInfo.SetMaximumLineWidth(this, f);
        }
    }

    public float[] getLineStyle() {
        return IlvStrokeInfo.GetLineStyle(this);
    }

    public void setLineStyle(float[] fArray) {
        IlvStrokeInfo.SetLineStyle(this, fArray);
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.c;
        this.c = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getForeground() {
        if (this.c != null) {
            return this.c;
        }
        return Color.black;
    }

    @Override
    public IlvPoint getPointAt(int n, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint;
        if (n == 0) {
            ilvPoint = this.getFrom();
        } else if (n == 1) {
            ilvPoint = this.getTo();
        } else {
            throw new IllegalArgumentException("bad index: " + n);
        }
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        return ilvPoint;
    }

    @Override
    public int getPointsCardinal() {
        return 2;
    }

    @Override
    public void movePoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
        if (n == 0) {
            this.a.x = f;
            this.a.y = f2;
        } else if (n == 1) {
            this.b.x = f;
            this.b.y = f2;
        } else {
            throw new IllegalArgumentException("bad index: " + n);
        }
    }

    @Override
    public final boolean allowsPointInsertion() {
        return false;
    }

    @Override
    public final boolean allowsPointRemoval() {
        return false;
    }

    @Override
    public boolean allowsPointMove(int n) {
        return true;
    }

    @Override
    public final void insertPoint(int n, float f, float f2, IlvTransformer ilvTransformer) {
    }

    @Override
    public final void removePoint(int n, IlvTransformer ilvTransformer) {
    }

    @Override
    public IlvSelection makeSelection() {
        return new IlvPolyPointsSelection(this);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float[] fArray;
        int n;
        float f;
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("from", this.a);
        ilvOutputStream.write("to", this.b);
        float f2 = this.getLineWidth();
        if (f2 != 0.0f) {
            ilvOutputStream.write("lineWidth", f2);
        }
        if ((f = this.getMaximumLineWidth()) != 0.0f) {
            ilvOutputStream.write("maximumLineWidth", f);
        }
        if ((n = this.getEndCap()) != 2) {
            ilvOutputStream.write("endCap", n);
        }
        if ((fArray = this.getLineStyle()) != null) {
            ilvOutputStream.write("lineStyle", fArray);
        }
    }

    protected void finalize() throws Throwable {
        IlvStrokeInfo.DisposeStroke(this);
    }
}

