/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvBidiGraphic;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGraphicVector;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.IlvTransformer;
import ilog.views.event.GraphicBagHierarchyEvent;
import ilog.views.event.GraphicBagHierarchyEventReceiver;
import ilog.views.event.GraphicBagHierarchyListener;
import ilog.views.event.ManagerViewsChangedEvent;
import ilog.views.event.ManagerViewsChangedListener;
import ilog.views.event.ManagerViewsHierarchyEventReceiver;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.impl.IlvEmptyGraphicEnumeration;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.swing.IlvPopupMenuManager;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;

public class IlvGraphicSet
extends IlvBidiGraphic
implements IlvGraphicBag,
GraphicBagHierarchyEventReceiver,
ManagerViewsHierarchyEventReceiver {
    private HashMap a;
    private float b = 1.0f;
    private EventListenerList c;
    private EventListenerList d;
    private int e = 0;
    private short f;
    private static final short g = 1;
    private static final short h = 2;
    private static final short i = 4;
    private static final short j = 8;
    private static final short k = 16;
    private static final short l = 32;
    private static final short m = 64;
    private static final short n = 128;
    protected IlvGraphicVector list = new IlvGraphicVector(10);

    public IlvGraphicSet() {
        this.a((short)2, false);
        this.a((short)8, false);
        this.a((short)32, false);
    }

    public IlvGraphicSet(IlvGraphicSet ilvGraphicSet) {
        this(ilvGraphicSet, true);
    }

    public IlvGraphicSet(IlvGraphicSet ilvGraphicSet, boolean bl) {
        super(ilvGraphicSet);
        this.a((short)2, false);
        this.a((short)8, false);
        this.a((short)32, false);
        if (bl) {
            int n = ilvGraphicSet.list.size();
            for (int i = 0; i < n; ++i) {
                IlvGraphic ilvGraphic = ilvGraphicSet.list.elementAt(i);
                IlvGraphic ilvGraphic2 = ilvGraphic.copy();
                if (ilvGraphic2 == null) continue;
                this.addObject(ilvGraphic2, false);
                String string = ilvGraphicSet.getObjectName(ilvGraphic);
                if (string == null) continue;
                this.setObjectName(ilvGraphic2, string);
            }
        }
        this.setClip(ilvGraphicSet.getClip());
        this.setAlpha(ilvGraphicSet.getAlpha());
    }

    public IlvGraphicSet(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a((short)2, false);
        this.a((short)8, false);
        this.a((short)32, false);
        IlvGraphic[] ilvGraphicArray = ilvInputStream.readObjects("objects");
        for (int i = 0; i < ilvGraphicArray.length; ++i) {
            this.addObject(ilvGraphicArray[i], false);
        }
        try {
            this.setClip(ilvInputStream.readShape("clip", "clipRule"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setAlpha(ilvInputStream.readFloat("alpha"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        Object object;
        this.a(this.getGraphicBag(), 2);
        IlvGraphicBag ilvGraphicBag2 = null;
        if (this.needsGraphicBagHierarchyEvent()) {
            ilvGraphicBag2 = this.a();
        }
        super.setGraphicBag(ilvGraphicBag);
        if (ilvGraphicBag instanceof GraphicBagHierarchyEventReceiver && this.needsGraphicBagHierarchyEvent()) {
            object = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag);
            object.enableGraphicBagHierarchyEventForwarding();
        }
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver && this.needsManagerViewsHierarchyEvent()) {
            object = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            object.enableManagerViewsHierarchyEventForwarding();
        }
        this.a(this.getGraphicBag(), 1);
        this.b(ilvGraphicBag2);
    }

    @Override
    public void addObject(IlvGraphic ilvGraphic, boolean bl) {
        this.addObjectAt(ilvGraphic, -1, bl);
    }

    public void addObjectAt(IlvGraphic ilvGraphic, int n, boolean bl) {
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("cannot add null");
        }
        if (ilvGraphic == this || this.getTopLevelGraphicBag() == ilvGraphic) {
            throw new IllegalArgumentException("cannot create circularity");
        }
        if (ilvGraphic.getGraphicBag() != null) {
            throw new IllegalArgumentException("object already in a bag");
        }
        if (this.getGraphicBag() != null && this.e == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            final int n2 = n;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, n2, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, n, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, int n, boolean bl) {
        String string;
        ilvGraphic.setGraphicBag(this);
        if (n < 0) {
            this.list.addElement(ilvGraphic);
        } else {
            this.list.insertElementAt(ilvGraphic, n);
        }
        if (ilvGraphic.isLocaleSensitive()) {
            this.a((short)1, true);
            this.a((short)2, true);
        }
        if (ilvGraphic.isComponentOrientationSensitive()) {
            this.a((short)4, true);
            this.a((short)8, true);
        }
        if (ilvGraphic.isBaseTextDirectionSensitive()) {
            this.a((short)16, true);
            this.a((short)32, true);
        }
        if ((string = ilvGraphic.getName()) != null) {
            this.setObjectName(ilvGraphic, string);
        }
        this.invalidateBBoxCache();
        if (bl) {
            this.reDrawObj(ilvGraphic);
        }
    }

    @Override
    public void removeObject(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic.getGraphicBag() != this) {
            throw new IllegalArgumentException("object not in this bag");
        }
        if (this.getGraphicBag() != null && this.e == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, boolean bl) {
        Object object;
        IlvRegion ilvRegion = null;
        if (bl && ilvGraphic.isVisible() && this.getGraphicBag() != null) {
            object = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add((IlvRect)object);
        }
        ilvGraphic.setGraphicBag(null);
        if (this.a != null && (object = this.getObjectName(ilvGraphic)) != null) {
            this.a.remove(object);
        }
        this.list.removeElement(ilvGraphic);
        if (ilvGraphic.isLocaleSensitive()) {
            this.a((short)2, false);
        }
        if (ilvGraphic.isComponentOrientationSensitive()) {
            this.a((short)8, false);
        }
        if (ilvGraphic.isBaseTextDirectionSensitive()) {
            this.a((short)32, false);
        }
        this.invalidateBBoxCache();
        if (ilvRegion != null && this.getGraphicBag() != null) {
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public void removeObjectAt(int n, boolean bl) {
        this.removeObject(this.getObject(n), bl);
    }

    public void removeAll(boolean bl) {
        if (this.getGraphicBag() != null && this.e == 0) {
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(false);
                }
            }, null, bl);
        } else {
            this.a(bl);
        }
    }

    private void a(boolean bl) {
        IlvRect ilvRect = bl && this.getGraphicBag() != null && this.isVisible() ? this.boundingBox(null) : null;
        this.a = null;
        if (this.list != null) {
            this.list.removeAllElements();
        }
        this.a((short)2, true);
        this.a((short)8, true);
        this.a((short)32, true);
        this.a((short)1, false);
        this.a((short)4, false);
        this.a((short)16, false);
        this.invalidateBBoxCache();
        if (ilvRect != null) {
            IlvRegion ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    public final IlvGraphic getObject(int n) {
        return this.list.elementAt(n);
    }

    public final int getIndex(IlvGraphic ilvGraphic) {
        return this.list.indexOf(ilvGraphic);
    }

    public final boolean contains(IlvGraphic ilvGraphic) {
        return ilvGraphic.getGraphicBag() == this;
    }

    @Override
    public final IlvGraphicEnumeration getObjects() {
        if (this.list == null) {
            return IlvEmptyGraphicEnumeration.instance;
        }
        return this.list.elements();
    }

    public final int getCardinal() {
        return this.list.size();
    }

    @Override
    public void reDrawObj(IlvGraphic ilvGraphic) {
        if (!ilvGraphic.isVisible()) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag != null) {
            IlvRect ilvRect = ilvGraphic.boundingBox(null);
            IlvRegion ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
            ilvGraphicBag.reDrawRegion(ilvRegion);
        }
    }

    @Override
    public void reDrawRegion(IlvRegion ilvRegion) {
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag != null) {
            ilvGraphicBag.reDrawRegion(ilvRegion);
        }
    }

    @Override
    public void reshapeObject(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        if (this.getGraphicBag() != null && this.e == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            final IlvRect ilvRect2 = ilvRect;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, ilvRect2, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, ilvRect, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, IlvRect ilvRect, boolean bl) {
        IlvRect ilvRect2;
        IlvRegion ilvRegion = null;
        if (ilvGraphic.isVisible() && bl && this.getGraphicBag() != null) {
            ilvRect2 = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect2);
        }
        ilvGraphic.move(ilvRect.x, ilvRect.y);
        ilvGraphic.resize(ilvRect.width, ilvRect.height);
        this.invalidateBBoxCache();
        if (ilvRegion != null) {
            ilvRect2 = ilvGraphic.boundingBox(null);
            ilvRegion.add(ilvRect2);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    @Override
    public void moveObject(IlvGraphic ilvGraphic, float f, float f2, boolean bl) {
        if (this.getGraphicBag() != null && this.e == 0) {
            final IlvGraphic ilvGraphic2 = ilvGraphic;
            final float f3 = f;
            final float f4 = f2;
            this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvGraphicSet.this.a(ilvGraphic2, f3, f4, false);
                }
            }, null, bl);
        } else {
            this.a(ilvGraphic, f, f2, bl);
        }
    }

    private void a(IlvGraphic ilvGraphic, float f, float f2, boolean bl) {
        IlvRect ilvRect;
        IlvRegion ilvRegion = null;
        if (ilvGraphic.isVisible() && bl && this.getGraphicBag() != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
        }
        ilvGraphic.move(f, f2);
        this.invalidateBBoxCache();
        if (ilvRegion != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion.add(ilvRect);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyToObject(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        boolean bl2 = ilvGraphic.setInApplyToObject(true);
        try {
            if (bl2 && this.getGraphicBag() != null) {
                final IlvGraphic ilvGraphic2 = ilvGraphic;
                final IlvApplyObject ilvApplyObject2 = ilvApplyObject;
                this.getGraphicBag().applyToObject(this, new IlvApplyObject(){

                    @Override
                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        IlvGraphicSet.this.applyToObjectImpl(ilvGraphic2, ilvApplyObject2, object, false);
                    }
                }, object, bl);
            } else {
                this.applyToObjectImpl(ilvGraphic, ilvApplyObject, object, bl);
            }
        }
        finally {
            ilvGraphic.setInApplyToObject(false);
        }
    }

    protected void applyToObjectImpl(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, boolean bl) {
        boolean bl2;
        IlvRegion ilvRegion = null;
        IlvRect ilvRect = null;
        IlvRect ilvRect2 = null;
        boolean bl3 = ilvGraphic.isVisible();
        if (bl3 && bl && this.getGraphicBag() != null) {
            ilvRect = ilvGraphic.boundingBox(null);
            ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
        }
        boolean bl4 = ilvGraphic.isLocaleSensitive();
        boolean bl5 = ilvGraphic.isComponentOrientationSensitive();
        boolean bl6 = ilvGraphic.isBaseTextDirectionSensitive();
        ilvRect2 = this.invalidateAndApplyToObject(ilvGraphic, ilvApplyObject, object, ilvRect, ilvRect2);
        if (ilvGraphic.isLocaleSensitive()) {
            this.a((short)1, true);
            this.a((short)2, true);
        } else if (bl4) {
            this.a((short)2, false);
        }
        if (ilvGraphic.isComponentOrientationSensitive()) {
            this.a((short)4, true);
            this.a((short)8, true);
        } else if (bl5) {
            this.a((short)8, false);
        }
        if (ilvGraphic.isBaseTextDirectionSensitive()) {
            this.a((short)16, true);
            this.a((short)32, true);
        } else if (bl6) {
            this.a((short)32, false);
        }
        boolean bl7 = bl2 = !bl3 && !ilvGraphic.isVisible();
        if (!bl2 && bl && this.getGraphicBag() != null) {
            if (ilvRect2 == null) {
                ilvRect2 = ilvGraphic.boundingBox(null);
            }
            if (ilvRegion == null) {
                ilvRegion = new IlvRegion();
            }
            ilvRegion.add(ilvRect2);
            this.getGraphicBag().reDrawRegion(ilvRegion);
        }
    }

    protected IlvRect invalidateAndApplyToObject(IlvGraphic ilvGraphic, IlvApplyObject ilvApplyObject, Object object, IlvRect ilvRect, IlvRect ilvRect2) {
        ilvApplyObject.apply(ilvGraphic, object);
        this.invalidateBBoxCache();
        return ilvRect2;
    }

    @Override
    public IlvGraphic copy() {
        return new IlvGraphicSet(this);
    }

    @Override
    public IlvGraphic getObject(String string) {
        if (this.a == null) {
            return null;
        }
        return (IlvGraphic)this.a.get(string);
    }

    public String getObjectName(IlvGraphic ilvGraphic) {
        return ilvGraphic.getName();
    }

    @Override
    public boolean setObjectName(IlvGraphic ilvGraphic, String string) {
        String string2 = ilvGraphic.getName();
        if (string != null) {
            IlvGraphic ilvGraphic2;
            IlvGraphic ilvGraphic3 = ilvGraphic2 = this.a == null ? null : (IlvGraphic)this.a.get(string);
            if (ilvGraphic2 != null) {
                if (ilvGraphic2 == ilvGraphic) {
                    if (string.equals(string2)) {
                        return true;
                    }
                    ilvGraphic.setNameImpl(string);
                    return true;
                }
                if (string2 != null) {
                    if (string.equals(string2)) {
                        ilvGraphic.setNameImpl(null);
                        return false;
                    }
                    IlvGraphic ilvGraphic4 = ilvGraphic2 = this.a == null ? null : (IlvGraphic)this.a.get(string2);
                    if (ilvGraphic2 != null) {
                        if (ilvGraphic2 == ilvGraphic) {
                            return false;
                        }
                        ilvGraphic.setNameImpl(null);
                    }
                }
                return false;
            }
            if (string2 != null && this.a != null && (ilvGraphic2 = (IlvGraphic)this.a.get(string2)) == ilvGraphic) {
                this.a.remove(string2);
                if (this.a.size() == 0) {
                    this.a = null;
                }
            }
            ilvGraphic.setNameImpl(string);
            if (this.a == null) {
                this.a = new HashMap(10);
            }
            this.a.put(string, ilvGraphic);
        } else {
            if (string2 != null && this.a != null && this.a.get(string2) == ilvGraphic) {
                if (this.a.size() == 0) {
                    this.a = null;
                }
                this.a.remove(string2);
            }
            ilvGraphic.setNameImpl(null);
        }
        return true;
    }

    public void setClip(Shape shape) {
        this.setProperty("__ClipProperty", shape);
    }

    public Shape getClip() {
        return (Shape)this.getProperty("__ClipProperty");
    }

    public void setAlpha(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0,1.0]");
        }
        this.b = f;
    }

    public float getAlpha() {
        return this.b;
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f = this.getAlpha();
        boolean bl = false;
        Composite composite = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f != 1.0f) {
            composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite && composite != AlphaComposite.Xor) {
                bl = true;
            }
            if (bl) {
                IlvUtility2D.SetAlphaComposite(graphics, f);
            }
        }
        if (bl) {
            this.b = 1.0f;
            IlvDrawWithBufferedImage.drawWithBufferedImage(this, graphics2D, ilvTransformer);
            this.b = f;
        } else {
            this.drawCore(graphics2D, ilvTransformer);
        }
        if (bl && f != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    protected void drawCore(Graphics2D graphics2D, IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        Shape shape;
        Shape shape2 = null;
        Shape shape3 = this.getClip();
        if (shape3 != null) {
            shape2 = IlvGraphicUtil.AddClip(graphics2D, IlvGraphicUtil.CreateTransformedShape(shape3, ilvTransformer));
        }
        Rectangle rectangle = (shape = graphics2D.getClip()) != null ? shape.getBounds() : null;
        IlvRect ilvRect2 = ilvRect = rectangle != null ? new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height) : null;
        if (ilvRect != null) {
            IlvRect ilvRect3 = new IlvRect(ilvRect);
            if (ilvTransformer != null) {
                ilvTransformer.boundingBox(ilvRect3, true);
            }
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                IlvGraphic ilvGraphic = this.list.elementAt(i);
                if (!ilvGraphic.isVisible() || !ilvGraphic.intersects(ilvRect3, ilvRect, ilvTransformer)) continue;
                ilvGraphic.callDraw(graphics2D, ilvTransformer);
            }
        } else {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                IlvGraphic ilvGraphic = this.list.elementAt(i);
                if (!ilvGraphic.isVisible()) continue;
                ilvGraphic.callDraw(graphics2D, ilvTransformer);
            }
        }
        if (shape3 != null) {
            graphics2D.setClip(shape2);
        }
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.getClip() != null) {
            this.setClip(IlvGraphicUtil.CreateTransformedShape(this.getClip(), ilvTransformer));
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            ilvGraphic.applyTransform(ilvTransformer);
        }
        this.invalidateBBoxCache();
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = null;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (!ilvGraphic.isVisible()) continue;
            IlvRect ilvRect2 = ilvGraphic.boundingBox(ilvTransformer);
            if (ilvRect == null) {
                ilvRect = ilvRect2;
                continue;
            }
            ilvRect.add(ilvRect2);
        }
        if (ilvRect == null) {
            ilvRect = new IlvRect();
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
        return ilvRect;
    }

    @Override
    public boolean zoomable() {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (ilvGraphic.zoomable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.getClip() != null && !IlvGraphicUtil.PointInShape(ilvPoint, this.getClip())) {
            return false;
        }
        return this.firstContains(ilvPoint, ilvPoint2, ilvTransformer) != null;
    }

    public IlvGraphic firstContains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint, ilvPoint2, ilvTransformer)) continue;
            return ilvGraphic;
        }
        return null;
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        int n = this.list.size();
        if (n == 0) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint[] ilvPointArray = new IlvPoint[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (!ilvGraphic.isVisible()) continue;
            ilvPointArray[n2++] = ilvGraphic.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
        }
        if (n2 == 0) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint ilvPoint3 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n2);
        Shape shape = this.getClip();
        if (shape == null) {
            return ilvPoint3;
        }
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint3);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint4);
        }
        if (IlvGraphicUtil.PointInShape(ilvPoint4, shape)) {
            return ilvPoint3;
        }
        return IlvClippingUtil.getClippedPoint(shape.getPathIterator(null), ilvTransformer, 0.0f, ilvPoint, ilvPoint2);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        float f;
        super.write(ilvOutputStream);
        ilvOutputStream.write("objects", this.getObjects());
        if (this.getClip() != null) {
            ilvOutputStream.write("clip", "clipRule", this.getClip());
        }
        if ((f = this.getAlpha()) != 1.0f) {
            ilvOutputStream.write("alpha", f);
        }
    }

    @Override
    public boolean isPersistent() {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (ilvGraphic.isPersistent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        ilvTransformer.inverse(ilvPoint2);
        int n = this.list.size();
        for (int i = n - 1; i >= 0; --i) {
            String string;
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint2, ilvPoint, ilvTransformer) || (string = ilvGraphic.getToolTipText(ilvPoint, ilvTransformer)) == null) continue;
            return string;
        }
        return this.getToolTipText();
    }

    @Override
    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        ilvTransformer.inverse(ilvPoint2);
        int n = this.list.size();
        for (int i = n - 1; i >= 0; --i) {
            JPopupMenu jPopupMenu;
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (!ilvGraphic.isVisible() || !ilvGraphic.contains(ilvPoint2, ilvPoint, ilvTransformer) || (jPopupMenu = ilvGraphic.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager)) == null) continue;
            return jPopupMenu;
        }
        return this.getOriginalPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    protected JPopupMenu getOriginalPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        return super.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    IlvGraphic a(int n, int n2, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint(n, n2);
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null) {
            ilvTransformer.inverse(ilvPoint2);
        }
        int n3 = this.list.size();
        for (int i = n3 - 1; i >= 0; --i) {
            IlvGraphic ilvGraphic = this.list.elementAt(i);
            if (!ilvGraphic.contains(ilvPoint2, ilvPoint, ilvTransformer)) continue;
            return ilvGraphic;
        }
        return null;
    }

    @Override
    public void addGraphicBagHierarchyListener(GraphicBagHierarchyListener graphicBagHierarchyListener) {
        if (this.c == null) {
            this.c = new EventListenerList();
        }
        this.c.add(GraphicBagHierarchyListener.class, graphicBagHierarchyListener);
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof GraphicBagHierarchyEventReceiver) {
            GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag);
            graphicBagHierarchyEventReceiver.enableGraphicBagHierarchyEventForwarding();
        }
    }

    @Override
    public void removeGraphicBagHierarchyListener(GraphicBagHierarchyListener graphicBagHierarchyListener) {
        if (this.c != null) {
            this.c.remove(GraphicBagHierarchyListener.class, graphicBagHierarchyListener);
            if (this.c.getListenerCount() == 0) {
                this.c = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableGraphicBagHierarchyEventForwarding() {
        if (this.b((short)64)) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.a();
        synchronized (ilvGraphicBag) {
            this.a((short)64, true);
            IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
            if (ilvGraphicBag2 instanceof GraphicBagHierarchyEventReceiver) {
                GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphicBag2);
                graphicBagHierarchyEventReceiver.enableGraphicBagHierarchyEventForwarding();
            }
        }
    }

    @Override
    public boolean needsGraphicBagHierarchyEvent() {
        return this.c != null || this.b((short)64);
    }

    private IlvGraphicBag a() {
        IlvGraphicBag ilvGraphicBag = this;
        while (ilvGraphicBag.getGraphicBag() != null) {
            if (ilvGraphicBag instanceof IlvManager) {
                return (IlvGraphicBag)((IlvManager)ilvGraphicBag).getTreeLock();
            }
            ilvGraphicBag = ilvGraphicBag.getGraphicBag();
        }
        return ilvGraphicBag;
    }

    private void b(IlvGraphicBag ilvGraphicBag) {
        if (!this.needsGraphicBagHierarchyEvent()) {
            return;
        }
        IlvGraphicBag ilvGraphicBag2 = this.a();
        GraphicBagHierarchyEvent graphicBagHierarchyEvent = new GraphicBagHierarchyEvent(this, ilvGraphicBag, ilvGraphicBag2);
        this.fireGraphicBagHierarchyEvent(graphicBagHierarchyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireGraphicBagHierarchyEvent(GraphicBagHierarchyEvent graphicBagHierarchyEvent) {
        int n;
        Object object;
        if (this.c != null) {
            object = this.c.getListenerList();
            n = ((Object[])object).length;
            for (int i = n - 1; i >= 0; i -= 2) {
                ((GraphicBagHierarchyListener)object[i]).hierarchyChanged(graphicBagHierarchyEvent);
            }
        }
        if (this.b((short)64)) {
            object = this.getObjects();
            while (object.hasMoreElements()) {
                GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver;
                IlvGraphic ilvGraphic = object.nextElement();
                if (!(ilvGraphic instanceof GraphicBagHierarchyEventReceiver) || !(graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphic)).needsGraphicBagHierarchyEvent()) continue;
                graphicBagHierarchyEventReceiver.fireGraphicBagHierarchyEvent(graphicBagHierarchyEvent);
            }
            object = graphicBagHierarchyEvent.getNewRootBag();
            synchronized (object) {
                n = 0;
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    GraphicBagHierarchyEventReceiver graphicBagHierarchyEventReceiver;
                    IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                    if (!(ilvGraphic instanceof GraphicBagHierarchyEventReceiver) || !(graphicBagHierarchyEventReceiver = (GraphicBagHierarchyEventReceiver)((Object)ilvGraphic)).needsGraphicBagHierarchyEvent()) continue;
                    n = 1;
                }
                this.a((short)64, n != 0);
            }
        }
    }

    @Override
    public void addManagerViewsHierarchyListener(ManagerViewsChangedListener managerViewsChangedListener) {
        if (this.d == null) {
            this.d = new EventListenerList();
        }
        this.d.add(ManagerViewsChangedListener.class, managerViewsChangedListener);
        IlvGraphicBag ilvGraphicBag = this.getGraphicBag();
        if (ilvGraphicBag instanceof ManagerViewsHierarchyEventReceiver) {
            ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag);
            managerViewsHierarchyEventReceiver.enableManagerViewsHierarchyEventForwarding();
        }
    }

    @Override
    public void removeManagerViewsHierarchyListener(ManagerViewsChangedListener managerViewsChangedListener) {
        if (this.d != null) {
            this.d.remove(ManagerViewsChangedListener.class, managerViewsChangedListener);
            if (this.d.getListenerCount() == 0) {
                this.d = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableManagerViewsHierarchyEventForwarding() {
        if (this.b((short)128)) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = this.a();
        synchronized (ilvGraphicBag) {
            this.a((short)128, true);
            IlvGraphicBag ilvGraphicBag2 = this.getGraphicBag();
            if (ilvGraphicBag2 instanceof ManagerViewsHierarchyEventReceiver) {
                ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphicBag2);
                managerViewsHierarchyEventReceiver.enableManagerViewsHierarchyEventForwarding();
            }
        }
    }

    @Override
    public boolean needsManagerViewsHierarchyEvent() {
        return this.d != null || this.b((short)128);
    }

    private void a(IlvGraphicBag ilvGraphicBag, int n) {
        if (ilvGraphicBag == null || !this.needsManagerViewsHierarchyEvent()) {
            return;
        }
        while (ilvGraphicBag != null) {
            if (ilvGraphicBag instanceof IlvManager) {
                IlvManager ilvManager = (IlvManager)ilvGraphicBag;
                Enumeration enumeration = ilvManager.getViews();
                while (enumeration.hasMoreElements()) {
                    IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                    if (ilvManagerView == null) continue;
                    ManagerViewsChangedEvent managerViewsChangedEvent = new ManagerViewsChangedEvent(ilvManager, ilvManagerView, n);
                    this.fireManagerViewsHierarchyEvent(managerViewsChangedEvent);
                }
            }
            ilvGraphicBag = ilvGraphicBag.getGraphicBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireManagerViewsHierarchyEvent(ManagerViewsChangedEvent managerViewsChangedEvent) {
        int n;
        Object object;
        if (this.d != null) {
            object = this.d.getListenerList();
            n = ((Object[])object).length;
            for (int i = n - 1; i >= 0; i -= 2) {
                ((ManagerViewsChangedListener)object[i]).viewChanged(managerViewsChangedEvent);
            }
        }
        if (this.b((short)128)) {
            object = this.getObjects();
            while (object.hasMoreElements()) {
                ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver;
                IlvGraphic ilvGraphic = object.nextElement();
                if (!(ilvGraphic instanceof ManagerViewsHierarchyEventReceiver) || !(managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphic)).needsManagerViewsHierarchyEvent()) continue;
                managerViewsHierarchyEventReceiver.fireManagerViewsHierarchyEvent(managerViewsChangedEvent);
            }
            object = this.a();
            synchronized (object) {
                n = 0;
                IlvGraphicEnumeration ilvGraphicEnumeration = this.getObjects();
                while (ilvGraphicEnumeration.hasMoreElements()) {
                    ManagerViewsHierarchyEventReceiver managerViewsHierarchyEventReceiver;
                    IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                    if (!(ilvGraphic instanceof ManagerViewsHierarchyEventReceiver) || !(managerViewsHierarchyEventReceiver = (ManagerViewsHierarchyEventReceiver)((Object)ilvGraphic)).needsManagerViewsHierarchyEvent()) continue;
                    n = 1;
                }
                this.a((short)128, n != 0);
            }
        }
    }

    @Override
    protected void invalidateBBoxCache() {
    }

    protected void setInsideApply(boolean bl) {
        this.e = bl ? ++this.e : --this.e;
    }

    @Override
    public boolean isLocaleSensitive() {
        if (this.b((short)2)) {
            return this.b((short)1);
        }
        boolean bl = super.isLocaleSensitive();
        this.a((short)1, bl);
        this.a((short)2, true);
        return bl;
    }

    @Override
    public boolean isComponentOrientationSensitive() {
        if (this.b((short)8)) {
            return this.b((short)4);
        }
        boolean bl = super.isComponentOrientationSensitive();
        this.a((short)4, bl);
        this.a((short)8, true);
        return bl;
    }

    @Override
    public boolean isBaseTextDirectionSensitive() {
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            return false;
        }
        if (this.b((short)32)) {
            return this.b((short)16);
        }
        boolean bl = super.isBaseTextDirectionSensitive();
        this.a((short)16, bl);
        this.a((short)32, true);
        return bl;
    }

    @Override
    public void setBaseTextDirection(int n, boolean bl) {
        boolean bl2 = n != this.getBaseTextDirection();
        super.setBaseTextDirection(n, bl);
        if (bl2) {
            boolean bl3 = super.isComponentOrientationSensitive();
            this.a((short)4, bl3);
        }
    }

    @Override
    public void baseTextDirectionChanged(int n, int n2) {
        super.baseTextDirectionChanged(n, n2);
        this.invalidateBBoxCache();
    }

    @Override
    public void componentOrientationChanged(ComponentOrientation componentOrientation, ComponentOrientation componentOrientation2) {
        super.componentOrientationChanged(componentOrientation, componentOrientation2);
        if (this.getResolvedBaseTextDirection() == 527) {
            this.invalidateBBoxCache();
        }
    }

    final boolean b(short s) {
        return (this.f & s) != 0;
    }

    final void a(short s, boolean bl) {
        this.f = bl ? (short)(this.f | s) : (short)(this.f & ~s);
    }

    public static class DelegateObjectInteractor
    extends IlvObjectInteractor {
        private transient IlvGraphic a;
        private transient boolean b;
        private transient boolean c;
        private transient int d;
        private transient int e;

        @Override
        public boolean processEvent(IlvGraphic ilvGraphic, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
            IlvObjectInteractor ilvObjectInteractor;
            if (!(ilvGraphic instanceof IlvGraphicSet)) {
                return false;
            }
            IlvGraphicSet ilvGraphicSet = (IlvGraphicSet)ilvGraphic;
            if (this.a != null && this.a.getGraphicBag() != ilvGraphicSet) {
                this.a = null;
            }
            IlvGraphic ilvGraphic2 = this.a;
            switch (aWTEvent.getID()) {
                case 501: {
                    if (((MouseEvent)aWTEvent).getClickCount() <= 1) {
                        this.b = false;
                    }
                    if (this.b && this.a != null) break;
                    this.b = true;
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                    ilvGraphic2 = this.a = ilvGraphicSet.a(this.d, this.e, ilvObjectInteractorContext.getTransformer());
                    break;
                }
                case 502: {
                    if (!this.b || !this.c) break;
                    this.c = false;
                    this.b = false;
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                    this.a = null;
                    break;
                }
                case 500: {
                    if (!this.b) break;
                    this.b = false;
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                    this.a = null;
                    break;
                }
                case 506: {
                    if (!this.b) break;
                    this.c = true;
                    break;
                }
                case 503: {
                    this.d = ((MouseEvent)aWTEvent).getX();
                    this.e = ((MouseEvent)aWTEvent).getY();
                }
                case 401: 
                case 402: {
                    if (ilvGraphic2 != null) break;
                    ilvGraphic2 = ilvGraphicSet.a(this.d, this.e, ilvObjectInteractorContext.getTransformer());
                }
            }
            if (ilvGraphic2 != null && (ilvObjectInteractor = ilvGraphic2.getObjectInteractor()) != null) {
                return ilvObjectInteractor.processEvent(ilvGraphic2, aWTEvent, ilvObjectInteractorContext);
            }
            return false;
        }

        @Override
        public void handleExpose(IlvGraphic ilvGraphic, Graphics graphics, IlvObjectInteractorContext ilvObjectInteractorContext) {
            IlvObjectInteractor ilvObjectInteractor;
            IlvGraphic ilvGraphic2;
            if (!(ilvGraphic instanceof IlvGraphicSet)) {
                return;
            }
            if (this.a != null && this.a.getGraphicBag() != ilvGraphic) {
                this.a = null;
            }
            if ((ilvGraphic2 = this.a) != null && (ilvObjectInteractor = ilvGraphic2.getObjectInteractor()) != null) {
                ilvObjectInteractor.handleExpose(ilvGraphic2, graphics, ilvObjectInteractorContext);
            }
        }
    }
}

