/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvBridgeCrossings;
import ilog.views.graphic.linkpolicy.IlvCrossingAwareLinkImage;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicy;
import ilog.views.graphic.linkpolicy.IlvLinkShapePolicyUtil;
import ilog.views.graphic.linkpolicy.IlvTunnelCrossings;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;

public class IlvEnhancedPolylineLinkImage
extends IlvCrossingAwareLinkImage {
    private boolean a = false;
    private boolean b = false;
    private int c = 0;
    private float d = 1.0f;
    private boolean e = true;
    public static final int NO_CROSSINGS = 0;
    public static final int TUNNEL_CROSSINGS = 1;
    public static final int BRIDGE_CROSSINGS = 2;

    public IlvEnhancedPolylineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl, ilvPointArray);
        this.d();
    }

    private void d() {
        this.a = false;
        this.b = false;
        this.c = 0;
        this.d = 1.0f;
        this.e = true;
    }

    public IlvEnhancedPolylineLinkImage(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2, boolean bl, boolean bl2, IlvPoint[] ilvPointArray) {
        super(ilvGraphic, ilvGraphic2, bl, bl2, ilvPointArray);
        this.d();
    }

    public IlvEnhancedPolylineLinkImage(IlvEnhancedPolylineLinkImage ilvEnhancedPolylineLinkImage) {
        super(ilvEnhancedPolylineLinkImage);
        this.d();
        this.setOrthogonal(ilvEnhancedPolylineLinkImage.isOrthogonal());
        this.setMultiLinkBundled(ilvEnhancedPolylineLinkImage.isMultiLinkBundled());
        this.setCrossingMode(ilvEnhancedPolylineLinkImage.getCrossingMode());
        this.d = ilvEnhancedPolylineLinkImage.d;
        this.e = ilvEnhancedPolylineLinkImage.e;
    }

    public IlvEnhancedPolylineLinkImage(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.d();
        try {
            this.setOrthogonal(ilvInputStream.readBoolean("orthogonal"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setMultiLinkBundled(ilvInputStream.readBoolean("multiLinkBundled"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.setCrossingMode(ilvInputStream.readInt("crossingMode"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.d = ilvInputStream.readFloat("alpha");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.e = ilvInputStream.readBoolean("useAlphaBuffer");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("orthogonal", this.isOrthogonal());
        ilvOutputStream.write("multiLinkBundled", this.isMultiLinkBundled());
        ilvOutputStream.write("crossingMode", this.getCrossingMode());
        ilvOutputStream.write("alpha", this.d);
        ilvOutputStream.write("useAlphaBuffer", this.e);
    }

    @Override
    public IlvGraphic copy() {
        return new IlvEnhancedPolylineLinkImage(this);
    }

    @Override
    public void setLineWidth(float f) {
        super.setLineWidth(f);
        if (this.isMultiLinkBundled()) {
            this.setMultiLinkBundled(false);
            this.setMultiLinkBundled(true);
        }
    }

    @Override
    public void setMaximumLineWidth(float f) {
        super.setMaximumLineWidth(f);
        if (this.isMultiLinkBundled()) {
            this.setMultiLinkBundled(false);
            this.setMultiLinkBundled(true);
        }
    }

    public void setAlpha(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0,1.0]");
        }
        this.d = f;
    }

    public float getAlpha() {
        return this.d;
    }

    public void setAlphaBufferEnabled(boolean bl) {
        this.e = bl;
        if (!bl) {
            IlvDrawWithBufferedImage.clearCache();
        }
    }

    public boolean isAlphaBufferEnabled() {
        return this.e;
    }

    public void setOrthogonal(boolean bl) {
        if (this.a != bl) {
            this.a = bl;
            this.b(this.getGraphicBag());
        }
    }

    public final boolean isOrthogonal() {
        return this.a;
    }

    public void setMultiLinkBundled(boolean bl) {
        if (this.b != bl) {
            this.b = bl;
            this.b(this.getGraphicBag());
        }
    }

    public final boolean isMultiLinkBundled() {
        return this.b;
    }

    public void setCrossingMode(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Unsupported mode: " + n);
        }
        if (this.c != n) {
            this.c = n;
            this.b(this.getGraphicBag());
        }
    }

    public final int getCrossingMode() {
        return this.c;
    }

    private void b(IlvGraphicBag ilvGraphicBag) {
        if (ilvGraphicBag == null) {
            return;
        }
        if (!(ilvGraphicBag instanceof IlvGrapher)) {
            return;
        }
        switch (this.getCrossingMode()) {
            case 1: {
                this.c(this.createCrossingGraphic(1));
                this.setCrossingEnabled(true);
                break;
            }
            case 2: {
                this.c(this.createCrossingGraphic(2));
                this.setCrossingEnabled(true);
                break;
            }
            default: {
                this.setCrossingGraphic(null);
                this.setCrossingEnabled(false);
            }
        }
        this.setLinkShapePolicy(this.getDefaultLinkShapePolicy(ilvGraphicBag));
    }

    protected IlvLinkShapePolicy getDefaultLinkShapePolicy(IlvGraphicBag ilvGraphicBag) {
        if (ilvGraphicBag == null) {
            return null;
        }
        if (!(ilvGraphicBag instanceof IlvGrapher)) {
            return null;
        }
        IlvLinkShapePolicy ilvLinkShapePolicy = null;
        IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphicBag;
        switch (this.getCrossingMode()) {
            case 1: {
                int n = 1;
                if (this.isOrthogonal()) {
                    n |= 2;
                }
                if (this.isMultiLinkBundled()) {
                    n |= 4;
                }
                ilvLinkShapePolicy = IlvLinkShapePolicyUtil.GetLinkShapePolicy(n, ilvGrapher);
                break;
            }
            case 2: {
                int n = 1;
                if (this.isOrthogonal()) {
                    n |= 2;
                }
                if (this.isMultiLinkBundled()) {
                    n |= 4;
                }
                ilvLinkShapePolicy = IlvLinkShapePolicyUtil.GetLinkShapePolicy(n, ilvGrapher);
                break;
            }
            default: {
                int n = 0;
                if (this.isOrthogonal()) {
                    n |= 2;
                }
                if (this.isMultiLinkBundled()) {
                    n |= 4;
                }
                ilvLinkShapePolicy = IlvLinkShapePolicyUtil.GetLinkShapePolicy(n, ilvGrapher);
            }
        }
        return ilvLinkShapePolicy;
    }

    private void c(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            this.setCrossingGraphic(null);
        } else if (this.getCrossingGraphic() == null) {
            this.setCrossingGraphic(ilvGraphic);
        } else if (this.getCrossingGraphic().getClass() != ilvGraphic.getClass()) {
            this.setCrossingGraphic(ilvGraphic);
        }
    }

    protected IlvGraphic createCrossingGraphic(int n) {
        switch (n) {
            case 1: {
                return new IlvTunnelCrossings(this);
            }
            case 2: {
                return new IlvBridgeCrossings(this);
            }
        }
        return null;
    }

    @Override
    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        if (ilvGraphicBag == null) {
            this.setLinkShapePolicy(null);
        } else {
            this.b(ilvGraphicBag);
        }
        super.setGraphicBag(ilvGraphicBag);
    }

    @Override
    public void setBackOriented(boolean bl) {
        super.setBackOriented(bl);
    }

    @Override
    public boolean isBackOriented() {
        return super.isBackOriented();
    }

    @Override
    public void setForeground(Color color) {
        IlvGraphicBag ilvGraphicBag;
        super.setForeground(color);
        if (this.getCrossingGraphic() != null && this.getCrossingGraphic().getGraphicBag() != null && (ilvGraphicBag = this.getCrossingGraphic().getGraphicBag()) instanceof IlvManager) {
            ((IlvManager)ilvGraphicBag).invalidateRegion(this.getCrossingGraphic());
        }
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f = this.getAlpha();
        boolean bl = false;
        Composite composite = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f != 1.0f) {
            composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite && composite != AlphaComposite.Xor) {
                bl = true;
            }
            if (bl) {
                IlvUtility2D.SetAlphaComposite(graphics, f);
            }
        }
        if (bl && this.isAlphaBufferEnabled()) {
            this.d = 1.0f;
            IlvDrawWithBufferedImage.drawWithBufferedImage(this, graphics2D, ilvTransformer);
            this.d = f;
        } else {
            this.drawCore(graphics2D, ilvTransformer);
        }
        if (bl && f != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    protected void drawCore(Graphics2D graphics2D, IlvTransformer ilvTransformer) {
        super.draw(graphics2D, ilvTransformer);
    }
}

