/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvGeneralPath;
import ilog.views.graphic.IlvZoomableLabel;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.util.text.IlvBidiUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.IOException;

public class IlvDefaultCollapsedGraphic
extends IlvGeneralPath
implements IlvLabelInterface {
    private static final float a = 30.0f;
    private static final float b = 20.0f;
    private IlvZoomableLabel c;
    private int d;

    public IlvDefaultCollapsedGraphic() {
        super(IlvDefaultCollapsedGraphic.b());
        this.setPointEditionAllowed(false);
        this.setFillPaint(Color.yellow);
        this.setStrokePaint(Color.black);
        this.d = 513;
        this.c = new IlvZoomableLabel(new IlvPoint(0.0f, 0.0f), "Untitled", false);
        this.c.setAntialiasing(true);
        this.c.setBaseTextDirection(this.getResolvedBaseTextDirection());
        this.setLabel("Untitled");
    }

    public IlvDefaultCollapsedGraphic(IlvDefaultCollapsedGraphic ilvDefaultCollapsedGraphic) {
        super(ilvDefaultCollapsedGraphic);
        this.d = ilvDefaultCollapsedGraphic.d;
        this.c = (IlvZoomableLabel)ilvDefaultCollapsedGraphic.c.copy();
        this.c.setBaseTextDirection(this.getResolvedBaseTextDirection());
        this.registerBlinkingResource(null, this.getLabelFillPaint());
    }

    public IlvDefaultCollapsedGraphic(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        super(ilvInputStream);
        this.c = (IlvZoomableLabel)ilvInputStream.readObject("label");
        this.c.setBaseTextDirection(this.getResolvedBaseTextDirection());
        this.registerBlinkingResource(null, this.getLabelFillPaint());
    }

    @Override
    public IlvGraphic copy() {
        return new IlvDefaultCollapsedGraphic(this);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("label", this.c);
    }

    @Override
    public void setLabel(String string) {
        IlvRect ilvRect = super.boundingBox(null);
        this.c.setLabel(string != null ? string : "");
        IlvRect ilvRect2 = this.c.boundingBox();
        this.c.move(ilvRect.x + ilvRect.width / 2.0f - ilvRect2.width / 2.0f, ilvRect.y + ilvRect.height + 2.0f);
    }

    @Override
    public String getLabel() {
        return this.c.getLabel();
    }

    @Override
    public boolean supportMultiline() {
        return this.c.supportMultiline();
    }

    @Override
    public IlvRect getLabelBBox(IlvTransformer ilvTransformer) {
        return this.c.getLabelBBox(ilvTransformer);
    }

    public void setFont(Font font) {
        this.c.setFont(font);
    }

    public Font getFont() {
        return this.c.getFont();
    }

    public void setLabelFillPaint(Paint paint) {
        Paint paint2 = this.getLabelFillPaint();
        this.c.setFillPaint(paint);
        this.registerBlinkingResource(paint2, paint);
    }

    public Paint getLabelFillPaint() {
        return this.c.getFillPaint();
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        super.draw(graphics, ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            this.c.callDraw(graphics, ilvTransformer);
        }
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        super.applyTransform(ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            this.c.applyTransform(ilvTransformer);
        }
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (super.contains(ilvPoint, ilvPoint2, ilvTransformer)) {
            return true;
        }
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            return this.c.contains(ilvPoint, ilvPoint2, ilvTransformer);
        }
        return false;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = super.boundingBox(ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            ilvRect.add(this.c.boundingBox(ilvTransformer));
        }
        return ilvRect;
    }

    @Override
    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint ilvPoint3 = super.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
        if (this.getLabel() != null && this.getLabel().length() != 0) {
            IlvPoint ilvPoint4 = this.c.getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer);
            IlvPoint[] ilvPointArray = new IlvPoint[]{ilvPoint3, ilvPoint4};
            ilvPoint3 = IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, 2);
        }
        return ilvPoint3;
    }

    private static Shape b() {
        GeneralPath generalPath = new GeneralPath();
        float f = 2.0f;
        generalPath.moveTo(0.0f, f);
        generalPath.quadTo(0.0f, 0.0f, f, 0.0f);
        generalPath.lineTo(30.0f - f, 0.0f);
        generalPath.quadTo(30.0f, 0.0f, 30.0f, f);
        generalPath.lineTo(30.0f, 20.0f - f);
        generalPath.quadTo(30.0f, 20.0f, 30.0f - f, 20.0f);
        generalPath.lineTo(f, 20.0f);
        generalPath.quadTo(0.0f, 20.0f, 0.0f, 20.0f - f);
        generalPath.closePath();
        float f2 = 1.0f;
        float f3 = 19.800001f;
        float f4 = 4.0f;
        generalPath.moveTo(f2, 0.0f);
        generalPath.quadTo(f2, -f4, f2 + f4, -f4);
        generalPath.lineTo(f2 + f3 - f4, -f4);
        generalPath.quadTo(f2 + f3, -f4, f2 + f3, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public void setBaseTextDirection(int n) {
        IlvBidiUtil.checkBaseTextDirectionChoice(n, false, false);
        if (this.c == null) {
            this.d = n;
        } else {
            IlvRect ilvRect = super.boundingBox(null);
            this.d = n;
            this.c.setBaseTextDirection(this.getResolvedBaseTextDirection());
            IlvRect ilvRect2 = this.c.boundingBox();
            this.c.move(ilvRect.x + ilvRect.width / 2.0f - ilvRect2.width / 2.0f, ilvRect.y + ilvRect.height + 2.0f);
        }
    }

    @Override
    public int getBaseTextDirection() {
        return this.d;
    }

    @Override
    public boolean isBaseTextDirectionSensitive() {
        if (this.c == null) {
            return false;
        }
        return this.c.isBaseTextDirectionSensitive();
    }

    @Override
    public boolean usesBidiMarkers() {
        if (this.c == null) {
            return false;
        }
        return this.c.usesBidiMarkers();
    }

    @Override
    public void baseTextDirectionChanged(int n, int n2) {
        if (!IlvBidiUtil.isAdvancedBidiOn()) {
            return;
        }
        super.baseTextDirectionChanged(n, n2);
        if (this.c != null) {
            IlvRect ilvRect = super.boundingBox(null);
            this.c.setBaseTextDirection(n2);
            IlvRect ilvRect2 = this.c.boundingBox();
            this.c.move(ilvRect.x + ilvRect.width / 2.0f - ilvRect2.width / 2.0f, ilvRect.y + ilvRect.height + 2.0f);
        }
    }
}

