/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.graphic.IlvArcUtil;
import ilog.views.graphic.IlvScale;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;

public class IlvCircularScale
extends IlvScale
implements IlvDefinitionRectInterface {
    private static final int a = 2;
    private boolean b;
    private float c;
    private float d;
    private int e = BOTH;
    public static int FIRST = 1;
    public static int LAST = 2;
    public static int BOTH = FIRST | LAST;

    public IlvCircularScale() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), "0", 0.0f, 100.0f, 200.0f, -220.0f, true, 6, 5, 5.0f, 5.0f);
    }

    public IlvCircularScale(IlvRect ilvRect, String string, float f, float f2, float f3, float f4, boolean bl, int n, int n2, float f5, float f6) {
        super(ilvRect, n, n2, f5, f6, f, f2, string);
        this.b = bl;
        this.c = f3;
        this.d = f4;
    }

    public IlvCircularScale(IlvRect ilvRect, String[] stringArray, float f, float f2, boolean bl, int n, float f3, float f4) {
        super(ilvRect, stringArray, n, f3, f4);
        this.b = bl;
        this.c = f;
        this.d = f2;
    }

    public IlvCircularScale(IlvCircularScale ilvCircularScale) {
        super(ilvCircularScale);
        this.b = ilvCircularScale.b;
        this.c = ilvCircularScale.c;
        this.d = ilvCircularScale.d;
        this.e = ilvCircularScale.e;
    }

    public IlvCircularScale(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.b = ilvInputStream.readBoolean("inside");
        this.c = ilvInputStream.readFloat("start");
        this.d = ilvInputStream.readFloat("range");
        try {
            this.e = ilvInputStream.readInt("labelPolicy");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public IlvGraphic copy() {
        return new IlvCircularScale(this);
    }

    @Override
    public final IlvRect getDefinitionRect() {
        return new IlvRect(((IlvScale)this).a);
    }

    @Override
    public final void setDefinitionRect(IlvRect ilvRect) {
        ((IlvScale)this).a.setRect(ilvRect);
    }

    @Override
    public IlvTransformer getDefinitionTransformer() {
        return null;
    }

    public final float getStart() {
        return this.c;
    }

    public final void setStart(float f) {
        this.c = f;
        while (this.c < 0.0f) {
            this.c += 360.0f;
        }
        while (this.c >= 360.0f) {
            this.c -= 360.0f;
        }
    }

    public final float getRange() {
        return this.d;
    }

    public final void setRange(float f) {
        this.d = f;
        while (this.d < -360.0f) {
            this.d += 360.0f;
        }
        while (this.d > 360.0f) {
            this.d -= 360.0f;
        }
    }

    public final boolean getLabelsInside() {
        return this.b;
    }

    public final void setLabelsInside(boolean bl) {
        this.b = bl;
    }

    public void setLabelPolicy(int n) {
        if (n != 0 && n != FIRST && n != LAST && n != (FIRST | LAST)) {
            throw new IllegalArgumentException("Bad label visibility policy!");
        }
        this.e = n;
    }

    public int getLabelPolicy() {
        return this.e;
    }

    @Override
    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        IlvRect ilvRect2 = new IlvRect();
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        IlvArcUtil.ComputeArcBBox(ilvRect, this.c, this.d, ilvRect2);
        if (this.d >= 360.0f && this.b) {
            return ilvRect2;
        }
        int n = this.getNumberOfSteps() > 1 ? this.getNumberOfSteps() - 1 : this.getNumberOfSteps();
        int n2 = this.getNumberOfSubSteps();
        String[] stringArray = this.getLabels();
        float f = this.c;
        float f2 = n != 0 ? this.d / (float)n : this.d;
        float f3 = n != 0 && this.getNumberOfSubSteps() > 1 ? f2 / (float)this.getNumberOfSubSteps() : 0.0f;
        float f4 = ilvRect.width / 2.0f;
        float f5 = ilvRect.height / 2.0f;
        float f6 = this.getStepSize();
        float f7 = this.getSubStepSize();
        float f8 = this.b ? f4 - f6 : f4 + f6;
        float f9 = this.b ? f5 - f6 : f5 + f6;
        float f10 = this.b ? f4 - f7 : f4 + f7;
        float f11 = this.b ? f5 - f7 : f5 + f7;
        float f12 = this.b ? f8 - 2.0f : f8 + 2.0f;
        float f13 = this.b ? f9 - 2.0f : f9 + 2.0f;
        IlvRect ilvRect3 = new IlvRect();
        for (int i = 0; i <= n; ++i) {
            float f14;
            double d = Math.cos(IlvUtil.degreesToRadians(f));
            double d2 = Math.sin(IlvUtil.degreesToRadians(f));
            int n3 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f4);
            int n4 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f5);
            int n5 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f8);
            int n6 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f9);
            ilvRect2.add(n3, n4);
            ilvRect2.add(n5, n6);
            if (stringArray != null) {
                float f15 = this.a(i);
                float f16 = this.b(i);
                float f17 = this.c(i);
                float f18 = (float)Math.min(d == 0.0 ? 100000.0 : Math.abs((double)(f15 / 2.0f) / d), d2 == 0.0 ? 100000.0 : Math.abs((double)(f16 / 2.0f) / d2));
                if (!this.b) {
                    f18 = -f18;
                }
                f14 = ilvRect.x + ilvRect.width / 2.0f - f15 / 2.0f + (float)((double)(f12 - f18) * d);
                float f19 = ilvRect.y + ilvRect.height / 2.0f + f16 / 2.0f + (float)((double)(-(f13 - f18)) * d2 - (double)f17);
                ilvRect3.move(f14, f19 - f16 + f17);
                ilvRect3.resize(f15, f16);
                if (this.d(i)) {
                    ilvRect2.add(ilvRect3);
                }
            }
            if (i != n) {
                f14 = f + f3;
                for (int j = 1; j < n2; ++j) {
                    d = Math.cos(IlvUtil.degreesToRadians(f14));
                    d2 = Math.sin(IlvUtil.degreesToRadians(f14));
                    n3 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f4);
                    n4 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f5);
                    n5 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f10);
                    n6 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f11);
                    ilvRect2.add(n3, n4);
                    ilvRect2.add(n5, n6);
                    f14 += f3;
                }
            }
            f += f2;
        }
        ilvRect2.expand(1.0f);
        return ilvRect2;
    }

    @Override
    public IlvPoint getCenter(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        return new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
    }

    @Override
    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Rectangle rectangle;
        if (this.getNumberOfSteps() < 1) {
            return;
        }
        int n = this.getNumberOfSteps() - 1;
        int n2 = this.getNumberOfSubSteps();
        String[] stringArray = this.getLabels();
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.applyFloor(ilvRect);
        }
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        Shape shape = null;
        IlvRect ilvRect2 = this.boundingBox(ilvTransformer);
        shape = graphics.getClip();
        Rectangle rectangle2 = shape != null ? shape.getBounds() : null;
        Rectangle rectangle3 = rectangle = rectangle2 != null ? rectangle2.intersection(new Rectangle((int)ilvRect2.x, (int)ilvRect2.y, (int)ilvRect2.width, (int)ilvRect2.height)) : new Rectangle((int)ilvRect2.x, (int)ilvRect2.y, (int)ilvRect2.width, (int)ilvRect2.height);
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        graphics.drawArc(ilvRect.xFloor(), ilvRect.yFloor(), ilvRect.widthFloor(), ilvRect.heightFloor(), (int)Math.floor(this.c), (int)Math.ceil(this.d) + 1);
        if (this.b && ilvRect.width <= 2.0f || ilvRect.height <= 2.0f) {
            graphics.setClip(shape);
            return;
        }
        float f = this.c;
        float f2 = n != 0 ? this.d / (float)n : this.d;
        float f3 = n != 0 && n2 > 1 ? f2 / (float)n2 : 0.0f;
        float f4 = ilvRect.width / 2.0f;
        float f5 = ilvRect.height / 2.0f;
        float f6 = this.getStepSize();
        float f7 = this.getSubStepSize();
        float f8 = this.b ? f4 - f6 : f4 + f6;
        float f9 = this.b ? f5 - f6 : f5 + f6;
        float f10 = this.b ? f4 - f7 : f4 + f7;
        float f11 = this.b ? f5 - f7 : f5 + f7;
        float f12 = this.b ? f8 - 2.0f : f8 + 2.0f;
        float f13 = this.b ? f9 - 2.0f : f9 + 2.0f;
        boolean bl = this.isAntialiasing();
        ilvRect.width += 1.0f;
        ilvRect.height += 1.0f;
        for (int i = 0; i <= n; ++i) {
            float f14;
            double d = Math.cos(IlvUtil.degreesToRadians(f));
            double d2 = Math.sin(IlvUtil.degreesToRadians(f));
            int n3 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f4);
            int n4 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f5);
            int n5 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f8);
            int n6 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f9);
            graphics.drawLine(n3, n4, n5, n6);
            if (stringArray != null) {
                float f15 = this.a(i);
                float f16 = this.b(i);
                float f17 = (float)Math.min(d == 0.0 ? 100000.0 : Math.abs((double)(f15 / 2.0f) / d), d2 == 0.0 ? 100000.0 : Math.abs((double)(f16 / 2.0f) / d2));
                if (!this.b) {
                    f17 = -f17;
                }
                f14 = ilvRect.x + ilvRect.width / 2.0f - f15 / 2.0f + (float)((double)(f12 - f17) * d);
                float f18 = ilvRect.y + ilvRect.height / 2.0f + f16 / 2.0f + (float)((double)(-(f13 - f17)) * d2);
                if (this.d(i)) {
                    IlvGraphicUtil.DrawString(this, graphics, stringArray[i], (int)Math.floor(f14), (int)Math.floor(f18), bl);
                }
            }
            if (i != n) {
                f14 = f + f3;
                for (int j = 1; j < n2; ++j) {
                    d = Math.cos(IlvUtil.degreesToRadians(f14));
                    d2 = Math.sin(IlvUtil.degreesToRadians(f14));
                    n3 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f4);
                    n4 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f5);
                    n5 = (int)((double)ilvRect.x + (double)ilvRect.width / 2.0 + d * (double)f10);
                    n6 = (int)((double)ilvRect.y + (double)ilvRect.height / 2.0 - d2 * (double)f11);
                    graphics.drawLine(n3, n4, n5, n6);
                    f14 += f3;
                }
            }
            f += f2;
        }
        graphics.setClip(shape);
    }

    private boolean d(int n) {
        if (this.e == BOTH) {
            return true;
        }
        if (n == 0 && (this.e & FIRST) == 0) {
            return false;
        }
        return n != this.getNumberOfSteps() - 1 || (this.e & LAST) != 0;
    }

    @Override
    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        String[] stringArray;
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        IlvRect ilvRect2 = new IlvRect(((IlvScale)this).a);
        float f = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.b) {
            ilvRect2.x += f;
            ilvRect2.y += f;
            ilvRect2.width -= 2.0f * f;
            ilvRect2.height -= 2.0f * f;
        } else {
            ilvRect2.x -= f;
            ilvRect2.y -= f;
            ilvRect2.width += 2.0f * f;
            ilvRect2.height += 2.0f * f;
        }
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
            ilvTransformer.apply(ilvRect2);
        }
        if ((stringArray = this.getLabels()) != null) {
            float f2 = this.c;
            float f3 = this.getNumberOfSteps() > 1 ? this.d / (float)(this.getNumberOfSteps() - 1) : this.d;
            float f4 = this.getStepSize();
            float f5 = ilvRect.width / 2.0f;
            float f6 = ilvRect.height / 2.0f;
            float f7 = this.b ? f5 - f4 - 2.0f : f5 + f4 + 2.0f;
            float f8 = this.b ? f6 - f4 - 2.0f : f6 + f4 + 2.0f;
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.d(i) && stringArray[i] != null) {
                    double d = Math.cos(IlvUtil.degreesToRadians(f2));
                    double d2 = Math.sin(IlvUtil.degreesToRadians(f2));
                    int n = this.a(i);
                    int n2 = this.b(i);
                    int n3 = this.c(i);
                    float f9 = (float)Math.min(d == 0.0 ? 100000.0 : Math.abs((double)(n / 2) / d), d2 == 0.0 ? 100000.0 : Math.abs((double)(n2 / 2) / d2));
                    if (!this.b) {
                        f9 = -f9;
                    }
                    float f10 = ilvRect.x + ilvRect.width / 2.0f - (float)(n / 2) + (float)((double)(f7 - f9) * d);
                    float f11 = ilvRect.y + ilvRect.height / 2.0f - (float)(n2 / 2 + n3) + (float)((double)(-(f8 - f9)) * d2 - (double)n3);
                    if (ilvPoint2.x >= f10 && ilvPoint2.x <= f10 + (float)n && ilvPoint2.y >= f11 && ilvPoint2.y <= f11 + (float)n2) {
                        return true;
                    }
                }
                f2 += f3;
            }
        }
        if (this.b) {
            return IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect, this.c, this.d) && !IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect2, this.c, this.d);
        }
        return IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect2, this.c, this.d) && !IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect, this.c, this.d);
    }

    @Override
    public void applyTransform(IlvTransformer ilvTransformer) {
        if (ilvTransformer != null) {
            ilvTransformer.apply(((IlvScale)this).a);
        }
        if (((IlvScale)this).a.width < 1.0E-20f) {
            ((IlvScale)this).a.width = 1.0E-20f;
        }
        if (((IlvScale)this).a.height < 1.0E-20f) {
            ((IlvScale)this).a.height = 1.0E-20f;
        }
    }

    @Override
    public void moveResize(IlvRect ilvRect) {
        super.moveResize(ilvRect);
        IlvUtility.correctMoveResizeNonzoomableGraphic(this, ilvRect, true, true);
    }

    @Override
    public boolean zoomable() {
        return false;
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("inside", this.b);
        ilvOutputStream.write("start", this.c);
        ilvOutputStream.write("range", this.d);
        ilvOutputStream.write("labelPolicy", this.e);
    }
}

