/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.css.swing;

import ilog.views.css.model.IlvRule;
import ilog.views.css.selector.IlvSelectorContext;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.css.parser.Rule;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvCSSFunction;
import ilog.views.util.swing.IlvJComboBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.text.JTextComponent;

public abstract class IlvCSSExpressionEditor
extends IlvJComboBox {
    private DefaultComboBoxModel a;
    private Pattern[] b;
    private String c;
    private int d;
    private MyCombo e;
    private static final String f = "+,-/*%^=!<>&|(";
    private static final String[] g;
    private static final boolean h = true;
    private static final boolean i = false;
    private static ResourceBundle j;
    private boolean k;
    private boolean l = false;

    public IlvCSSExpressionEditor(String string) {
        if (string == null) {
            string = "";
        } else if (string.startsWith("@|")) {
            string = string.substring(2);
        }
        this.a(string);
        this.a = new DefaultComboBoxModel<String>(new String[]{string});
        this.setModel(this.a);
        this.a();
        this.addItemListener(new ItemListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) return;
                String string = itemEvent.getItem().toString();
                if (string != null) {
                    if (string.equals("")) {
                        IlvCSSExpressionEditor.this.setToolTipText(null);
                        return;
                    }
                }
                IlvCSSExpressionEditor.this.setToolTipText(string);
            }
        });
    }

    protected abstract IlvSelectorContext getSelectorContext();

    protected abstract IlvCSSFunction[] getCSSFunctions();

    protected abstract IlvCSSDeclaration[] getVariableDefinitions();

    protected abstract IlvRule getRule();

    protected abstract void validateEditor();

    private void a(String string) {
        this.getTextComponent().setText(string);
        this.d = string.length();
        this.c = string;
    }

    private void a() {
        this.setEditable(true);
        MyListener myListener = new MyListener();
        this.addItemListener(myListener);
        this.getTextComponent().addKeyListener(myListener);
    }

    public void refresh() {
        this.k = false;
    }

    private void b() {
        int n;
        Object[] objectArray;
        Object object;
        if (this.k) {
            return;
        }
        this.k = true;
        IlvRule ilvRule = this.getRule();
        IlvSelectorContext ilvSelectorContext = this.getSelectorContext();
        String[] stringArray = ilvSelectorContext.getAllowedAttributes(ilvRule);
        IlvCSSFunction[] ilvCSSFunctionArray = this.getCSSFunctions();
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        if (stringArray != null) {
            object = j.getString("Expression.modelAttribute.descr");
            objectArray = new Object[1];
            for (n = 0; n < stringArray.length; ++n) {
                Class clazz = ilvSelectorContext.getAttributeType(ilvRule, stringArray[n]);
                objectArray[0] = clazz == null ? j.getString("Expression.undefinedAttributeType") : clazz.toString();
                arrayList.add(new Pattern("@" + stringArray[n], MessageFormat.format((String)object, objectArray), 1000.5f));
            }
            arrayList.add(new Separator(1000.4f));
        }
        if ((object = this.getVariableDefinitions()) != null) {
            objectArray = j.getString("Expression.variable.descr");
            Object[] objectArray2 = new Object[1];
            for (int i = 0; i < ((IlvCSSDeclaration[])object).length; ++i) {
                objectArray2[0] = object[i].getValue();
                arrayList.add(new VariablePattern(object[i], MessageFormat.format((String)objectArray, objectArray2), 1000.3f));
            }
            arrayList.add(new Separator(1000.2f));
        }
        float f = 2.0f;
        if (ilvCSSFunctionArray != null) {
            n = ilvCSSFunctionArray.length;
            for (int i = 0; i < n; ++i) {
                IlvCSSFunction ilvCSSFunction = ilvCSSFunctionArray[i];
                if (!((double)ilvCSSFunction.getImportance() >= 0.5)) continue;
                arrayList.add(new Pattern(ilvCSSFunction.getName() + "()", ilvCSSFunction.getShortDescription(), ilvCSSFunction.getImportance()));
                if (!(ilvCSSFunction.getImportance() < f)) continue;
                f = ilvCSSFunction.getImportance();
            }
        }
        if (f != 2.0f) {
            arrayList.add(new Separator(-0.1f));
        }
        for (n = 0; n < g.length; ++n) {
            String string = g[n];
            arrayList.add(new Pattern(string, j.getString("Expression.Builtin.Descr." + string.substring(0, string.length() - 2)), -1.0f));
        }
        this.b = arrayList.toArray(new Pattern[arrayList.size()]);
        Arrays.sort(this.b, new Comparator<Pattern>(){

            @Override
            public int compare(Pattern pattern, Pattern pattern2) {
                if (pattern.d == pattern2.d) {
                    return pattern.b.compareTo(pattern2.b);
                }
                float f = pattern.d - pattern2.d;
                return f == 0.0f ? 0 : (f > 0.0f ? -1 : 1);
            }
        });
    }

    protected void update(String string) {
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        string = Rule.escape(string);
        String string2 = jTextComponent.getText();
        if (!IlvCSSExpressionEditor.a(string2, string)) {
            this.a(string);
            this.a(this.getTextComponent());
            super.setPopupVisible(false);
        }
    }

    public JTextComponent getTextComponent() {
        return (JTextComponent)this.getEditor().getEditorComponent();
    }

    @Override
    public void setEditor(ComboBoxEditor comboBoxEditor) {
        this.e = new MyCombo(comboBoxEditor);
        super.setEditor(this.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(JTextComponent jTextComponent) {
        this.l = true;
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = this.getMinimumSize();
        try {
            this.b();
            IlvCSSExpressionEditor ilvCSSExpressionEditor = this;
            int n = jTextComponent.getCaretPosition();
            int n2 = n - 1;
            String string = jTextComponent.getText();
            this.d = n;
            this.c = string;
            this.a.removeAllElements();
            this.a.addElement("");
            boolean bl = this.a(string, n2, true);
            boolean bl2 = this.a(string, n, false);
            if (string == null || string.length() == 0 || bl && bl2) {
                for (int i = 0; i < this.b.length; ++i) {
                    this.a.addElement(this.b[i]);
                }
            } else if (bl2 && !bl) {
                int n3;
                for (n3 = n2; n3 >= 0 && Character.isJavaIdentifierPart(string.charAt(n3)); --n3) {
                }
                if (n3 >= 0 && n3 < n2) {
                    if (n3 > 0 && string.charAt(n3) != '@') {
                        ++n3;
                    }
                    String string2 = string.substring(n3, n);
                    for (int i = 0; i < this.b.length; ++i) {
                        Pattern pattern = this.b[i];
                        if (!pattern.hasPrefix(string2)) continue;
                        this.a.addElement(new PartialPattern(this.b[i], string2.length()));
                    }
                }
            }
            ilvCSSExpressionEditor.setPopupVisible(false);
            if (this.a.getSize() > 1) {
                ilvCSSExpressionEditor.setPopupVisible(true);
            }
        }
        finally {
            this.l = false;
            this.setPreferredSize(dimension);
            this.setMinimumSize(dimension2);
        }
    }

    private boolean a(String string, int n, boolean bl) {
        int n2;
        if (string == null || string.length() == 0 || n == -1) {
            return true;
        }
        if (bl) {
            while (n >= 0 && string.charAt(n) == ' ') {
                --n;
            }
            if (n == -1) {
                return true;
            }
        } else {
            n2 = string.length();
            while (n < n2 && string.charAt(n) == ' ') {
                ++n;
            }
            if (n == n2) {
                return true;
            }
        }
        n2 = string.charAt(n);
        boolean bl2 = f.indexOf(n2) != -1;
        return bl2 |= !bl && n2 == 41;
    }

    public String getText() {
        String string;
        block7: {
            block6: {
                string = this.getTextComponent().getText();
                if (string == null) break block6;
                if (string.length() != 0) break block7;
            }
            return "";
        }
        if (string.startsWith("@|")) {
            if (string.charAt(2) == '@' && this.a(string, 3)) {
                return string.substring(2);
            }
            return string;
        }
        if (string.startsWith("@") && this.a(string, 1)) {
            return string;
        }
        return "@|" + string;
    }

    private boolean a(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && Character.isJavaIdentifierPart(string.charAt(n2)); ++n2) {
        }
        return n2 == string.length();
    }

    public void setText(String string) {
        JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
        string = Rule.escape(string);
        String string2 = jTextComponent.getText();
        if (!IlvCSSExpressionEditor.a(string2, string)) {
            jTextComponent.setText(string);
        }
    }

    private static boolean a(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return object2 == null;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public String getEditAsTextHelpMessage() {
        return IlvCSSExpressionEditor.getEditAsTextHelpMessage(this.getSelectorContext(), this.getRule());
    }

    public static String getEditAsTextHelpMessage(IlvSelectorContext ilvSelectorContext, IlvRule ilvRule) {
        String string = j.getString("Expression.helpMessage");
        String[] stringArray = ilvSelectorContext == null ? null : ilvSelectorContext.getAllowedAttributes(ilvRule);
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                stringBuffer.append(string2).append(" ");
            }
        }
        if (stringBuffer.length() == 0) {
            stringBuffer.append(j.getString("Expression.noAttribute"));
        }
        try {
            return MessageFormat.format(string, stringBuffer.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string;
        }
    }

    @Override
    protected void fireActionEvent() {
        if (!this.l) {
            super.fireActionEvent();
        }
    }

    @Override
    public void setSelectedItem(Object object) {
        boolean bl = this.l;
        this.l = true;
        try {
            super.setSelectedItem(object);
        }
        finally {
            this.l = bl;
        }
    }

    static {
        String[] stringArray = new String[14];
        stringArray[0] = "abs()";
        stringArray[1] = "acos()";
        stringArray[2] = "asin()";
        stringArray[3] = "atan()";
        stringArray[4] = "ceil()";
        stringArray[5] = "cos()";
        stringArray[6] = "exp()";
        stringArray[7] = "floor()";
        stringArray[8] = "log()";
        stringArray[9] = "rint()";
        stringArray[10] = "round()";
        stringArray[11] = "sin()";
        stringArray[12] = "sqrt()";
        stringArray[13] = "tan()";
        g = stringArray;
        j = IlvResourceUtil.getBundle("text", IlvCSSExpressionEditor.class, IlvLocaleUtil.getCurrentLocale());
    }

    private static class MyCombo
    implements ComboBoxEditor {
        ComboBoxEditor a;
        Object b;

        public MyCombo(ComboBoxEditor comboBoxEditor) {
            this.a = comboBoxEditor;
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.a.addActionListener(actionListener);
        }

        @Override
        public Component getEditorComponent() {
            return this.a.getEditorComponent();
        }

        @Override
        public Object getItem() {
            return this.b;
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.a.removeActionListener(actionListener);
        }

        @Override
        public void selectAll() {
            this.a.getEditorComponent().requestFocus();
        }

        @Override
        public void setItem(Object object) {
            this.b = object;
        }
    }

    private static class Separator
    extends Pattern {
        public Separator(float f) {
            super("", "", f);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    private static class PartialPattern {
        Pattern a;
        int b;

        public PartialPattern(Pattern pattern, int n) {
            this.a = pattern;
            this.b = n;
        }

        public String toString() {
            return this.a.toString();
        }

        public int getOffset() {
            return this.b;
        }

        public String getBase() {
            return this.a.getBase();
        }

        public String getPartialPattern() {
            return this.getBase().substring(this.getOffset());
        }
    }

    private static class VariablePattern
    extends Pattern {
        public VariablePattern(IlvCSSDeclaration ilvCSSDeclaration, String string, float f) {
            super(ilvCSSDeclaration.getProperty(), string, f);
        }

        @Override
        public String getBase() {
            return "variable(" + super.getBase() + ")";
        }
    }

    private static class Pattern {
        private String a;
        private String b;
        private String c;
        private final float d;

        public Pattern(String string, String string2, float f) {
            this.b = string;
            if (this.b.indexOf(40) != -1) {
                this.c = this.b.substring(0, this.b.indexOf(40));
            }
            this.a = string + " - " + string2;
            this.d = f;
        }

        public String toString() {
            return this.a;
        }

        public String getBase() {
            return this.b;
        }

        public boolean hasPrefix(String string) {
            return this.b.startsWith(string) && !this.a(string);
        }

        private boolean a(String string) {
            return this.c == null ? this.b.equals(string) : this.c.equals(string);
        }
    }

    private class MyListener
    extends KeyAdapter
    implements ItemListener {
        private MyListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                if (IlvCSSExpressionEditor.this.getSelectedIndex() < 0) {
                    return;
                }
                JTextComponent jTextComponent = IlvCSSExpressionEditor.this.getTextComponent();
                StringBuffer stringBuffer = new StringBuffer(IlvCSSExpressionEditor.this.c);
                if (itemEvent.getItem() instanceof PartialPattern) {
                    PartialPattern partialPattern = (PartialPattern)itemEvent.getItem();
                    stringBuffer.insert(IlvCSSExpressionEditor.this.d, partialPattern.getPartialPattern());
                    jTextComponent.setText(stringBuffer.toString());
                    jTextComponent.setCaretPosition(IlvCSSExpressionEditor.this.d + partialPattern.getBase().length() - partialPattern.getOffset());
                } else if (itemEvent.getItem() instanceof Pattern) {
                    String string = ((Pattern)itemEvent.getItem()).getBase();
                    stringBuffer.insert(IlvCSSExpressionEditor.this.d, string);
                    jTextComponent.setText(stringBuffer.toString());
                    jTextComponent.setCaretPosition(IlvCSSExpressionEditor.this.d + string.length());
                } else {
                    stringBuffer.insert(IlvCSSExpressionEditor.this.d, itemEvent.getItem().toString());
                    jTextComponent.setText(stringBuffer.toString());
                    jTextComponent.setCaretPosition(IlvCSSExpressionEditor.this.d + itemEvent.getItem().toString().length());
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 38: 
                case 40: {
                    return;
                }
                case 10: {
                    IlvCSSExpressionEditor.this.validateEditor();
                    break;
                }
                default: {
                    IlvCSSExpressionEditor.this.a(IlvCSSExpressionEditor.this.getTextComponent());
                }
            }
        }
    }
}

