/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.css.model;

import ilog.views.css.model.IlvConfigNode;
import ilog.views.css.model.IlvRule;
import ilog.views.css.model.IlvRuleModelStrategy;
import ilog.views.css.model.IlvSelector;
import ilog.views.css.model.event.CSSChangeListener;
import ilog.views.util.css.event.RuleSetEvent;
import ilog.views.util.cssbeans.IlvCSSBeans;
import ilog.views.util.styling.IlvCSSDeclaration;
import ilog.views.util.styling.IlvStylingException;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public interface IlvRuleModel {
    public static final String RULE_EVENT_NAME = "XX-rule-event";
    public static final String DECLARATION_EVENT_NAME = "XX-declaration-event";
    public static final String EDITABLE_METADATA = "_EDITABLE";
    public static final boolean WITH_DISABLED = true;
    public static final int LOCAL_DECLARATION = 0;
    public static final int CHANGED_DECLARATION = 1;
    public static final int INHERITED_DECLARATION = 2;
    public static final int DEFAULT_DECLARATION = 3;
    public static final int OVERRIDEN_DECLARATION = 4;
    public static final RulesSubset ALL_RULES = new RulesSubset(){

        @Override
        public Collection<IlvRule> filter(Collection<IlvRule> collection, IlvRuleModel ilvRuleModel) {
            return collection;
        }

        @Override
        public IlvRule firstFiltered(List<IlvRule> list, IlvRuleModel ilvRuleModel) {
            if (!list.isEmpty()) {
                return list.get(0);
            }
            return null;
        }
    };
    public static final RulesSubset ENABLED_RULES = new RulesSubset(){

        @Override
        public Collection<IlvRule> filter(Collection<IlvRule> collection, IlvRuleModel ilvRuleModel) {
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
            for (IlvRule ilvRule : collection) {
                if (ilvRule.isDisabled()) continue;
                arrayList.add(ilvRule);
            }
            return arrayList;
        }

        @Override
        public IlvRule firstFiltered(List<IlvRule> list, IlvRuleModel ilvRuleModel) {
            for (IlvRule ilvRule : list) {
                if (ilvRule.isDisabled()) continue;
                return ilvRule;
            }
            return null;
        }
    };
    public static final RulesSubset VISIBLE_RULES = new RulesSubset(){

        @Override
        public Collection<IlvRule> filter(Collection<IlvRule> collection, IlvRuleModel ilvRuleModel) {
            IlvRuleModelStrategy ilvRuleModelStrategy = ilvRuleModel.getCSSStrategy();
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
            for (IlvRule ilvRule : collection) {
                if (!ilvRuleModelStrategy.isVisible(ilvRule)) continue;
                arrayList.add(ilvRule);
            }
            return arrayList;
        }

        @Override
        public IlvRule firstFiltered(List<IlvRule> list, IlvRuleModel ilvRuleModel) {
            IlvRuleModelStrategy ilvRuleModelStrategy = ilvRuleModel.getCSSStrategy();
            for (IlvRule ilvRule : list) {
                if (!ilvRuleModelStrategy.isVisible(ilvRule)) continue;
                return ilvRule;
            }
            return null;
        }
    };
    public static final RulesSubset VISIBLE_ENABLED_RULES = new RulesSubset(){

        @Override
        public Collection<IlvRule> filter(Collection<IlvRule> collection, IlvRuleModel ilvRuleModel) {
            IlvRuleModelStrategy ilvRuleModelStrategy = ilvRuleModel.getCSSStrategy();
            ArrayList<IlvRule> arrayList = new ArrayList<IlvRule>();
            for (IlvRule ilvRule : collection) {
                if (!ilvRuleModelStrategy.isVisible(ilvRule) || ilvRule.isDisabled()) continue;
                arrayList.add(ilvRule);
            }
            return arrayList;
        }

        @Override
        public IlvRule firstFiltered(List<IlvRule> list, IlvRuleModel ilvRuleModel) {
            IlvRuleModelStrategy ilvRuleModelStrategy = ilvRuleModel.getCSSStrategy();
            for (IlvRule ilvRule : list) {
                if (!ilvRuleModelStrategy.isVisible(ilvRule) || ilvRule.isDisabled()) continue;
                return ilvRule;
            }
            return null;
        }
    };

    public IlvRule[] getAllRules(boolean var1);

    public IlvRule[] getVisibleRules(boolean var1);

    public IlvRule[] getRules(RulesSubset var1);

    public void setRules(IlvRule[] var1);

    public IlvConfigNode getConfig();

    public IlvRuleModelStrategy getCSSStrategy();

    public void buildTree();

    public IlvCSSBeans getCSSBeans();

    public IlvRule[] getParentRules(IlvRule var1);

    public IlvRule[] getParentRules(IlvRule var1, boolean var2);

    public IlvRule getParentRule(IlvRule var1);

    public void updateInheritanceIcons(IlvRule var1);

    public Object[] getMatchingObjects(IlvRule var1);

    public HashSet<IlvRule> getAdditionalRules(IlvRule var1, IlvRule[] var2, HashSet<IlvRule> var3, boolean var4);

    public IlvRule[] getAdditionalRules(IlvRule[] var1);

    public IlvRule getRuleWithDeclaration(IlvRule var1, String var2);

    public IlvRule getSameRule(IlvRule var1);

    public IlvRule getSameRule(IlvRule var1, boolean var2);

    public IlvRule getSameRule(IlvRule var1, boolean var2, boolean var3);

    public Collection<IlvRule> getRulesFromIdAsList(RulesSubset var1, String var2);

    public IlvRule[] getRulesFromId(RulesSubset var1, String var2);

    public IlvRule[] getRootRules(boolean var1);

    public IlvRule[] getRootRules(boolean var1, boolean var2);

    public IlvRule getRootRule();

    public IlvRule getToplevelRule(IlvRule var1);

    public Map<String, String> getDeclarations(IlvRule var1);

    public String getDeclarationValue(IlvRule var1, String var2);

    public void setDeclarationValue(IlvRule var1, String var2, String var3);

    public String getDeclarationValue(IlvRule var1, String var2, boolean var3);

    public void setDeclarationValueAndUpdateUnusedSharpRules(IlvRule var1, String var2, String var3);

    public Object makeBeanFromRule(IlvRule var1);

    public Collection<IlvRule> getMoreSpecificRules(IlvRule var1, boolean var2);

    public IlvRule[] withoutOverridingRules(IlvRule var1);

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public Object setProperty(String var1, Object var2);

    public Object getProperty(String var1);

    public void addRule(IlvRule var1);

    public void removeRule(IlvRule var1);

    public IlvRule getRule(String var1, boolean var2) throws IlvStylingException;

    public IlvRule getRule(String var1, boolean var2, boolean var3) throws IlvStylingException;

    public void setSelector(IlvRule var1, IlvSelector[] var2);

    public void setSelector(IlvRule var1, IlvSelector var2);

    public void removeDeclaration(IlvRule var1, String var2);

    public void removeMetaDeclaration(IlvRule var1, String var2);

    public void removeDeclarationAndUpdateUnusedSharpRules(IlvRule var1, String var2);

    public String getLayoutId(IlvRule var1);

    public IlvRule getTopCompositeRule(IlvRule var1);

    public String getAttachmentIdFromIndex(int var1, IlvRule var2);

    public String getDecoAvailableId();

    public String getAttachmentAvailableId();

    public int getSharpRuleUsageCount(String var1);

    public void removeSharpRule(String var1);

    public void collectSharpRules(IlvRule var1, ArrayList<IlvRule> var2);

    public void removeRulesUsingAttributeName(String var1);

    public List<IlvRule> getRulesUsingAttributeName(String var1);

    public List<IlvCSSDeclaration> getDeclarationsUsingAttributeName(String var1);

    public void removeDeclarationsUsingAttributeName(String var1);

    public void setAdjusting(boolean var1);

    public boolean isAdjusting();

    public void addStyleChangeListener(CSSChangeListener var1);

    public void removeStyleChangeListener(CSSChangeListener var1);

    public void setDebugMode(boolean var1);

    public void rulesChanged(RuleSetEvent var1);

    public static interface RulesSubset {
        public Collection<IlvRule> filter(Collection<IlvRule> var1, IlvRuleModel var2);

        public IlvRule firstFiltered(List<IlvRule> var1, IlvRuleModel var2);
    }
}

