/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.wizard;

import ilog.views.applications.util.wizard.IlvBoxUtils;
import ilog.views.applications.util.wizard.IlvWizardPage;
import ilog.views.applications.util.wizard.IlvWizardPanel;
import ilog.views.builder.wizard.IlvBuilderWizardPage;
import ilog.views.util.IlvLocaleUtil;
import ilog.views.util.IlvResourceUtil;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.swing.IlvJComboBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class IlvThemePage
extends IlvBuilderWizardPage
implements ItemListener {
    private static final String a = "data/themes/";
    private static final String b = "ShortDescription";
    private static final String c = "LongDescription";
    private Object[] d;
    private String[] e;
    private String[] f;
    private JComboBox g;
    private JTextArea h;
    private boolean i;
    private boolean j = false;
    protected int lastSelectedChoiceIndex = -1;

    public IlvThemePage() {
        this(true);
    }

    public IlvThemePage(boolean bl) {
        this("IlvThemePage", bl);
    }

    public IlvThemePage(String string, boolean bl) {
        super(string);
        this.setTitle(IlvWizardPanel.getMessage("ThemePage.Title"));
        this.hidePreview(false);
        this.i = bl;
    }

    @Override
    public void init() {
        super.init();
        this.j = true;
        IlvWizardPage.vspace(this, 1);
        this.addChooseThemeMessage();
        this.vspace();
        this.g = new IlvJComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
            }
        };
        this.g.setBackground(this.getBackground());
        this.g.addItemListener(this);
        this.add(this.g);
        this.vspace();
        this.setMinimumSize(this.g.getPreferredSize());
        this.h = IlvBuilderWizardPage.createTextArea(true);
        this.addChooseThemeDescription(this.h);
        IlvBoxUtils.alignLeft(this);
        this.setFinishEnabled(true);
        this.setNextPageName("Wizard_End_Page");
        this.a();
        this.g.setModel(new DefaultComboBoxModel<String>(this.e));
        this.add(Box.createVerticalGlue());
        IlvBoxUtils.alignTop(this);
        this.j = false;
    }

    @Override
    public void enterDone() {
        super.enterDone();
        if (this.d.length > 0) {
            int n = this.getInitialSelectedThemeIndex(this.d);
            this.g.setSelectedIndex(n);
            this.a(n);
        } else {
            this.displayError("No themes were found in the directory " + this.getThemeDirectory());
        }
    }

    protected void addChooseThemeMessage() {
        String string = this.getChooseThemeMessage();
        JTextArea jTextArea = IlvBuilderWizardPage.createTextArea(true);
        jTextArea.setText(string);
        JComponent jComponent = IlvBuilderWizardPage.createTextAreaPane(jTextArea);
        this.add(jComponent);
    }

    protected void addChooseThemeDescription(JTextArea jTextArea) {
        JComponent jComponent = IlvBuilderWizardPage.createTextAreaPane(jTextArea);
        this.add(jComponent);
    }

    protected boolean isDuringInitialization() {
        return this.j;
    }

    protected int getInitialSelectedThemeIndex(Object[] objectArray) {
        if (this.lastSelectedChoiceIndex == -1) {
            return objectArray != null && objectArray.length > 0 ? objectArray.length - 1 : 0;
        }
        return this.lastSelectedChoiceIndex;
    }

    protected String getChooseThemeMessage() {
        return IlvWizardPanel.getMessage("ThemePage.ChooseTheme");
    }

    private void a() {
        Serializable serializable;
        Object[] objectArray = null;
        try {
            serializable = new File(this.getThemeDirectory());
            objectArray = ((File)serializable).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return IlvThemePage.this.acceptFile(string);
                }
            });
        }
        catch (Exception exception) {
            objectArray = null;
            exception.printStackTrace();
        }
        serializable = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        if (objectArray != null) {
            if (this.isThemeSortEnabled()) {
                Arrays.sort(objectArray);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                try {
                    URL uRL = IlvURLUtil.convertFileToAbsoluteURL((File)object);
                    arrayList2.add(uRL);
                    try {
                        ((ArrayList)serializable).add(this.a(uRL, b));
                    }
                    catch (MissingResourceException missingResourceException) {
                        ((ArrayList)serializable).add(((File)object).getName());
                    }
                    try {
                        arrayList.add(this.a(uRL, c));
                    }
                    catch (MissingResourceException missingResourceException) {
                        arrayList.add(IlvWizardPanel.getMessage("TemplatePage.NoThemeProperties.Desc"));
                    }
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        }
        if (this.i) {
            arrayList2.add(null);
            ((ArrayList)serializable).add(IlvWizardPanel.getMessage("ThemePage.NoTheme.Title"));
            arrayList.add(IlvWizardPanel.getMessage("ThemePage.NoTheme.Desc"));
        }
        this.d = this.createThemeModel(arrayList2);
        this.e = ((ArrayList)serializable).toArray(new String[0]);
        this.f = arrayList.toArray(new String[0]);
    }

    protected boolean isThemeSortEnabled() {
        return false;
    }

    protected String getThemeDirectory() {
        return a;
    }

    protected Object[] createThemeModel(List list) {
        return list.toArray(new URL[list.size()]);
    }

    protected boolean acceptFile(String string) {
        return string.endsWith(".css");
    }

    private Object a(URL uRL, String string) {
        return this.a(uRL, string, IlvLocaleUtil.getCurrentLocale());
    }

    private Object a(URL uRL, String string, Locale locale) {
        ResourceBundle resourceBundle;
        String string2 = IlvURLUtil.convertFileURLToFile(uRL).getName();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        String string3 = this.getThemeDirectory() + string2;
        try {
            resourceBundle = IlvResourceUtil.getBundle(string3, locale, this.getClass().getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            String string4 = uRL.toExternalForm();
            string4 = string4.substring(0, string4.lastIndexOf("/") + 1);
            resourceBundle = IlvBuilderWizardPage.getPropertiesBundle(string4, string2, locale);
        }
        if (resourceBundle != null) {
            return resourceBundle.getObject(string);
        }
        return null;
    }

    @Override
    public final void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && !this.j) {
            this.a(this.g.getSelectedIndex());
        }
    }

    private void a(int n) {
        this.h.setText(this.f[n]);
        this.themeSelected(this.d[n]);
        this.lastSelectedChoiceIndex = n;
    }

    protected void themeSelected(Object object) {
    }

    protected int getSelectedIndex() {
        return this.g.getSelectedIndex();
    }

    protected void displayError(String string) {
        this.h.setText(string);
        this.h.setForeground(Color.red);
        this.setNextEnabled(false);
        this.setFinishEnabled(false);
    }
}

