/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.editor;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.swing.util.IlvButton;
import ilog.views.applications.util.wizard.IlvMessagesSupport;
import ilog.views.builder.docview.IlvBuilderDocument;
import ilog.views.builder.editor.IlvCSSCustomizer;
import ilog.views.builder.editor.IlvCSSMicroCustomizer;
import ilog.views.builder.event.IlvStyleChangeSupport;
import ilog.views.builder.event.StyleChangeListener;
import ilog.views.css.model.IlvRule;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class IlvRuleDeclarationEditorSupport {
    private IlvStyleChangeSupport a;
    protected static IlvMessagesSupport MSG_SUPPORT = new IlvMessagesSupport("ilog.views.builder.gui.editors");
    protected HashMap labels = new HashMap();
    protected Map<JLabel, JButton> labelButtons = new HashMap<JLabel, JButton>();
    protected Map<String, JButton> buttons = new HashMap<String, JButton>();
    private IlvBuilderDocument b;
    private boolean c = true;
    private IlvRule d;
    public static final String ICON_KEY = "icon";
    public static final String INHERITABLE_PROPERTY = "inheritable";
    private static String e;
    private static String f;
    public static String INHERITED_ICON_TOOLTIPTEXT;

    public IlvRuleDeclarationEditorSupport(Object object) {
        this.a = new IlvStyleChangeSupport(object);
    }

    public static void initToolTipTexts(IlvApplication ilvApplication) {
        INHERITED_ICON_TOOLTIPTEXT = ilvApplication.getString("Builder.PropertySheetView.InheritedToolTip");
        f = ilvApplication.getString("Builder.PropertySheetView.DefaultToolTip");
        e = ilvApplication.getString("Builder.PropertySheetView.LocalToolTip");
    }

    public void clean() {
        this.labels.clear();
        this.labelButtons.clear();
        this.buttons.clear();
    }

    public IlvStyleChangeSupport getStyleChangeSupport() {
        return this.a;
    }

    public void setFiringEvents(boolean bl) {
        this.c = bl;
    }

    public boolean isFiringEvents() {
        return this.c;
    }

    public IlvRule getEventTarget() {
        return this.d;
    }

    public void setEventTarget(IlvRule ilvRule) {
        this.d = ilvRule;
    }

    public IlvBuilderDocument getDocument() {
        return this.b;
    }

    public void setDocument(IlvBuilderDocument ilvBuilderDocument) {
        this.b = ilvBuilderDocument;
    }

    public void addStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.a.addStyleChangeListener(styleChangeListener);
    }

    public void removeStyleChangeListener(StyleChangeListener styleChangeListener) {
        this.a.removeStyleChangeListener(styleChangeListener);
    }

    public void addLabel(String string, JLabel jLabel) {
        Object v = this.labels.get(string);
        if (v instanceof Collection) {
            ((Collection)v).add(jLabel);
        } else if (v instanceof JLabel) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(jLabel);
            this.labels.put(string, arrayList);
        } else {
            if (v != null) {
                throw new RuntimeException("Unexpected value type: " + v.getClass().getName());
            }
            this.labels.put(string, jLabel);
        }
    }

    public Collection getLabels(String string) {
        Object v = this.labels.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Collection) {
            return (Collection)v;
        }
        if (v instanceof JLabel) {
            SingleElementImmutableCollection singleElementImmutableCollection = new SingleElementImmutableCollection(v);
            return singleElementImmutableCollection;
        }
        throw new RuntimeException("Unexpected value type: " + v.getClass().getName());
    }

    public void removeLabelsAndInheritanceButtons(String string) {
        Collection collection = this.getLabels(string);
        this.labels.remove(string);
        this.buttons.remove(string);
        if (collection != null) {
            for (Object e : collection) {
                this.labelButtons.remove(e);
            }
        }
    }

    public void updateDeclarationIcons(IlvCSSCustomizer ilvCSSCustomizer, IlvBuilderDocument ilvBuilderDocument) {
        Object object;
        if (ilvBuilderDocument == null) {
            return;
        }
        this.setDocument(ilvBuilderDocument);
        for (String object2 : this.labels.keySet()) {
            object = ilvCSSCustomizer.getRuleForProperty(object2);
            this.a((IlvRule)object, object2);
        }
        for (Map.Entry entry : this.buttons.entrySet()) {
            object = (String)entry.getKey();
            IlvRule ilvRule = ilvCSSCustomizer.getRuleForProperty((String)object);
            int n = this.getDeclarationStatus(ilvRule, (String)object);
            ImageIcon imageIcon = IlvCSSCustomizer.INHERITANCE_ICONS[n];
            ((JButton)entry.getValue()).setIcon(imageIcon);
        }
    }

    protected int getDeclarationStatus(IlvRule ilvRule, String string) {
        if (this.b != null) {
            return this.b.getDeclarationStatus(ilvRule, string);
        }
        return 3;
    }

    private void a(IlvRule ilvRule, String string) {
        int n = this.getDeclarationStatus(ilvRule, string);
        this.updateDeclarationLabelIcon(string, n);
    }

    public void updateDeclarationLabelIcon(String string, int n) {
        ImageIcon imageIcon = IlvCSSCustomizer.INHERITANCE_ICONS[n];
        Collection collection = this.getLabels(string);
        if (collection != null) {
            for (JLabel jLabel : collection) {
                if (jLabel == null) continue;
                String string2 = jLabel.getToolTipText();
                string2 = this.a(string, string2, n);
                JButton jButton = this.labelButtons.get(jLabel);
                if (jButton != null) {
                    jButton.setIcon(imageIcon);
                } else {
                    Boolean bl = (Boolean)jLabel.getClientProperty(INHERITABLE_PROPERTY);
                    if (bl == null || Boolean.TRUE.equals(bl)) {
                        jLabel.setIcon(imageIcon);
                    }
                }
                jLabel.setToolTipText(string2);
            }
        }
    }

    public JButton createInheritanceButton(final String string, final IlvCSSMicroCustomizer ilvCSSMicroCustomizer, JLabel jLabel) {
        final IlvButton ilvButton = new IlvButton();
        ilvButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(IlvRuleDeclarationEditorSupport.ICON_KEY)) {
                    Object object = propertyChangeEvent.getNewValue();
                    int n = 0;
                    if (object == IlvCSSCustomizer.INHERITANCE_ICONS[3]) {
                        n = 3;
                    } else if (object == IlvCSSCustomizer.INHERITANCE_ICONS[2]) {
                        n = 2;
                    }
                    ((JButton)propertyChangeEvent.getSource()).setToolTipText(IlvRuleDeclarationEditorSupport.this.getButtonTooltip(string, n));
                }
            }
        });
        ilvButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IlvRuleDeclarationEditorSupport.this.iconCallback(string, ilvButton, ilvCSSMicroCustomizer);
            }
        });
        ImageIcon imageIcon = null;
        int n = this.getDeclarationStatus(this.getEventTarget(), string);
        imageIcon = IlvCSSCustomizer.INHERITANCE_ICONS[n];
        ilvButton.setIcon(imageIcon);
        ilvButton.setMargin(new Insets(0, 0, 0, 0));
        if (jLabel != null) {
            this.labelButtons.put(jLabel, ilvButton);
        } else {
            this.buttons.put(string, ilvButton);
        }
        return ilvButton;
    }

    public JButton getInheritanceButton(String string, JLabel jLabel) {
        JButton jButton = jLabel == null ? this.buttons.get(string) : this.labelButtons.get(jLabel);
        return jButton;
    }

    protected void iconCallback(String string, JButton jButton, IlvCSSMicroCustomizer ilvCSSMicroCustomizer) {
        boolean bl = true;
        Icon icon = jButton.getIcon();
        if (icon == IlvCSSCustomizer.INHERITANCE_ICONS[0] || icon == IlvCSSCustomizer.INHERITANCE_ICONS[1]) {
            bl = false;
        }
        if (ilvCSSMicroCustomizer != null) {
            ilvCSSMicroCustomizer.fireStyleChangeEvent(bl);
        }
    }

    private String a(String string, String string2, int n) {
        String string3;
        String string4 = this.getDeclarationStatusTooltip(string, n);
        String string5 = null;
        String string6 = null;
        if (string2 != null && string2.trim().length() > 0) {
            String string7 = string2.toLowerCase();
            int n2 = string7.indexOf("<html>");
            if (n2 >= 0) {
                int n3 = string7.indexOf("</html>");
                if (n3 < 0) {
                    throw new RuntimeException("Expected </html> on tooltip: " + string2);
                }
                if (n3 < n2) {
                    throw new RuntimeException("Unexpected: </html> before <html> on tooltip: " + string2);
                }
                int n4 = string7.lastIndexOf("<span>");
                if (n4 >= 0) {
                    int n5 = string7.lastIndexOf("</span>");
                    if (n5 < 0) {
                        throw new RuntimeException("Expected </span> on tooltip: " + string2);
                    }
                    int n6 = n2 + 6;
                    int n7 = n4;
                    int n8 = n5 + 7;
                    int n9 = n3;
                    string6 = (n7 >= n6 ? string2.substring(n6, n7) : "") + (n9 >= n8 ? string2.substring(n8, n9) : "");
                } else {
                    string6 = string2.substring(n2 + 6, n3);
                }
            } else {
                string6 = string2;
            }
        }
        if (string6 != null && string6.length() > 0) {
            Object[] objectArray = new Object[4];
            objectArray[0] = string6;
            objectArray[1] = "<span>";
            objectArray[2] = string4;
            objectArray[3] = "</span>";
            string3 = MSG_SUPPORT.formatMessage("XXdeclaration_tooltip2", objectArray);
        } else {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<span>" + string4 + "</span>";
            string3 = MSG_SUPPORT.formatMessage("XXdeclaration_tooltip1", objectArray);
        }
        string5 = string3;
        return "<html>" + string5 + "</html>";
    }

    protected String getDeclarationStatusTooltip(String string, int n) {
        String string2 = null;
        switch (n) {
            case 3: {
                string2 = MSG_SUPPORT.getMessage("XXdefault_declaration_tooltip");
                break;
            }
            case 2: {
                string2 = MSG_SUPPORT.getMessage("XXinherited_declaration_tooltip");
                break;
            }
            case 0: {
                string2 = MSG_SUPPORT.getMessage("XXlocal_declaration_tooltip");
                break;
            }
            case 1: {
                string2 = MSG_SUPPORT.getMessage("XXchanged_declaration_tooltip");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported declaration status: " + n);
            }
        }
        return MSG_SUPPORT.formatMessage("XXdeclaration_status_tooltip", string2);
    }

    protected String getButtonTooltip(String string, int n) {
        if (n == 3) {
            return f;
        }
        if (n == 2) {
            return INHERITED_ICON_TOOLTIPTEXT;
        }
        return e;
    }

    private static class SingleElementImmutableCollection
    extends AbstractCollection {
        private Object a;

        SingleElementImmutableCollection(Object object) {
            this.a = object;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Iterator iterator() {
            return new Itr();
        }

        private class Itr
        implements Iterator {
            private boolean a = false;

            private Itr() {
            }

            @Override
            public boolean hasNext() {
                return !this.a;
            }

            public Object next() {
                if (this.a) {
                    throw new NoSuchElementException();
                }
                this.a = true;
                return SingleElementImmutableCollection.this.a;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Unsupported operation");
            }
        }
    }
}

