/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.builder.data;

import ilog.views.applications.util.IlvApplicationsUtil;
import ilog.views.applications.util.wizard.IlvWizardPanel;
import ilog.views.applications.util.wizard.IlvWizardUtil;
import ilog.views.builder.data.PreviewTable;
import ilog.views.util.data.IlvCSVReader;
import ilog.views.util.data.IlvCSVTableModel;
import ilog.views.util.data.IlvTableModel;
import ilog.views.util.swing.IlvSwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public abstract class IlvModelTablePanel
extends JPanel
implements SwingConstants {
    private TableModel[] a;
    private TableModel[] b;
    private PreviewTable[] c;
    private Component[] d;
    private boolean[] e;
    private boolean f = true;
    private int g;
    private int h;
    private JComponent i;
    private int j;
    private List<ChangeListener> k;
    private List<ListSelectionListener> l;
    private List<TableModelListener> m;
    private boolean n = false;
    private boolean o = false;

    public IlvModelTablePanel() {
        this.setLayout(new BorderLayout());
        this.j = 1;
        this.g = 0;
        this.h = 0;
        this.setBackground(IlvApplicationsUtil.WIZARD_DEFAULT_BACKGROUND);
        TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = IlvModelTablePanel.this.getCurrentTableIndex();
                if (n >= 0) {
                    ((IlvModelTablePanel)IlvModelTablePanel.this).e[n] = true;
                }
            }
        };
        this.m = new ArrayList<TableModelListener>();
        this.m.add(tableModelListener);
    }

    protected TableModel copyTableModel(TableModel tableModel) {
        if (tableModel == null) {
            return new TypedTableModel(null, new Object[0], new Class[0]);
        }
        int n = tableModel.getRowCount();
        int n2 = tableModel.getColumnCount();
        Object[] objectArray = new Object[n2];
        Class[] classArray = new Class[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = tableModel.getColumnName(i);
            classArray[i] = tableModel.getColumnClass(i);
        }
        Object[][] objectArray2 = new Object[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectArray2[i][j] = tableModel.getValueAt(i, j);
            }
        }
        return new TypedTableModel(objectArray2, objectArray, classArray);
    }

    private JComponent a(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        return jScrollPane;
    }

    private PreviewTable a(TableModel tableModel) {
        return this.createTable(tableModel);
    }

    protected PreviewTable createTable(TableModel tableModel) {
        PreviewTable previewTable = new PreviewTable(tableModel);
        previewTable.setEditable(this.f);
        previewTable.setColumnSelectionAllowed(this.o);
        previewTable.setRowSelectionAllowed(true);
        previewTable.getSelectionModel().setSelectionMode(this.g);
        previewTable.getColumnModel().getSelectionModel().setSelectionMode(this.h);
        previewTable.setTableHeaderSelectable(this.n);
        return previewTable;
    }

    public boolean isEditable() {
        return this.f;
    }

    public void setEditable(boolean bl) {
        if (this.f == bl) {
            return;
        }
        this.f = bl;
        if (this.b == null || this.b.length == 0) {
            return;
        }
        for (int i = 0; i < this.b.length; ++i) {
            TableModel tableModel = this.b[i];
            for (TableModelListener tableModelListener : this.m) {
                tableModel.removeTableModelListener(tableModelListener);
            }
            this.b[i] = bl ? this.copyTableModel(this.a[i]) : this.a[i];
            for (TableModelListener tableModelListener : this.m) {
                this.b[i].addTableModelListener(tableModelListener);
            }
            this.c[i].setModel(this.b[i]);
            this.c[i].setEditable(bl);
        }
    }

    public void setTableHeaderSelectable(boolean bl) {
        if (this.n == bl) {
            return;
        }
        this.n = bl;
        this.clearSelection();
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i].setTableHeaderSelectable(bl);
            }
        }
    }

    public void setColumnSelectionAllowed(boolean bl) {
        if (this.o == bl) {
            return;
        }
        this.o = bl;
        this.clearSelection();
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i].setColumnSelectionAllowed(bl);
            }
        }
    }

    public int getTabPlacement() {
        return this.j;
    }

    public void setTabPlacement(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("Tab placement must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        this.j = n;
        if (this.i instanceof JTabbedPane) {
            ((JTabbedPane)this.i).setTabPlacement(n);
        }
    }

    public TableModel getTableModel(int n) {
        if (this.c == null || this.c.length == 0) {
            return null;
        }
        return this.b[n];
    }

    public TableModel getTableModelCopy(int n) {
        TableModel tableModel = this.getTableModel(n);
        return this.copyTableModel(tableModel);
    }

    public void setTableModels(TableModel[] tableModelArray, String[] stringArray) {
        this.setTableModels(tableModelArray, stringArray, null, null);
    }

    public void setTableModels(TableModel[] tableModelArray, String[] stringArray, Icon[] iconArray, String[] stringArray2) {
        Iterator<EventListener> iterator;
        if (this.i != null) {
            if (this.i instanceof JTabbedPane) {
                JTabbedPane jTabbedPane = (JTabbedPane)this.i;
                if (this.k != null) {
                    iterator = this.k.iterator();
                    while (iterator.hasNext()) {
                        jTabbedPane.removeChangeListener((ChangeListener)iterator.next());
                    }
                }
            }
            this.remove(this.i);
            this.i = null;
        }
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                iterator = this.c[i];
                if (this.l != null) {
                    for (ListSelectionListener listSelectionListener : this.l) {
                        ((JTable)((Object)iterator)).getSelectionModel().removeListSelectionListener(listSelectionListener);
                        ((JTable)((Object)iterator)).getColumnModel().getSelectionModel().removeListSelectionListener(listSelectionListener);
                    }
                }
                for (TableModelListener tableModelListener : this.m) {
                    ((JTable)((Object)iterator)).getModel().removeTableModelListener(tableModelListener);
                }
            }
        }
        if (tableModelArray == null) {
            tableModelArray = new TableModel[]{};
        }
        this.a = tableModelArray;
        this.e = new boolean[tableModelArray.length];
        this.b = new TableModel[tableModelArray.length];
        this.d = new Component[tableModelArray.length];
        for (int i = 0; i < tableModelArray.length; ++i) {
            this.b[i] = this.isEditable() ? this.copyTableModel(tableModelArray[i]) : tableModelArray[i];
            this.e[i] = false;
            for (TableModelListener tableModelListener : this.m) {
                this.b[i].addTableModelListener(tableModelListener);
            }
        }
        this.c = new PreviewTable[tableModelArray.length];
        if (this.b.length == 1) {
            this.c[0] = this.a(this.b[0]);
            this.i = this.a(this.c[0]);
            this.i.setBackground(IlvApplicationsUtil.METAL_GRAY);
            this.i.setBorder(IlvWizardUtil.TABLE_BORDER);
            this.d[0] = this.i;
        } else if (this.b.length > 1) {
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.i = jTabbedPane;
            jTabbedPane.setTabPlacement(this.getTabPlacement());
            for (int i = 0; i < this.b.length; ++i) {
                this.c[i] = this.a(this.b[i]);
                JComponent jComponent = this.a(this.c[i]);
                Icon icon = iconArray != null ? iconArray[i] : null;
                String string = stringArray2 != null ? stringArray2[i] : null;
                jTabbedPane.addTab(stringArray[i], icon, jComponent, string);
                this.d[i] = jComponent;
            }
            if (this.k != null) {
                Iterator<ChangeListener> iterator2 = this.k.iterator();
                while (iterator2.hasNext()) {
                    jTabbedPane.addChangeListener(iterator2.next());
                }
            }
        }
        if (this.l != null) {
            for (int i = 0; i < this.c.length; ++i) {
                for (ListSelectionListener listSelectionListener : this.l) {
                    this.c[i].getSelectionModel().addListSelectionListener(listSelectionListener);
                    this.c[i].getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
                }
            }
        }
        if (this.i != null) {
            this.add((Component)this.i, "Center");
        }
    }

    public JTable getTable(int n) {
        if (this.c == null || this.c.length == 0) {
            return null;
        }
        return this.c[n];
    }

    public JTable getCurrentTable() {
        if (this.c == null || this.c.length == 0) {
            return null;
        }
        int n = this.getCurrentTableIndex();
        if (n < 0) {
            return null;
        }
        return this.getTable(n);
    }

    public int getCurrentTableIndex() {
        if (this.c == null || this.c.length == 0) {
            return -1;
        }
        JTabbedPane jTabbedPane = this.getTabbedPane();
        if (jTabbedPane == null) {
            return 0;
        }
        Component component = jTabbedPane.getSelectedComponent();
        if (this.d != null) {
            for (int i = 0; i < this.d.length; ++i) {
                if (component != this.d[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public JTabbedPane getTabbedPane() {
        return this.i instanceof JTabbedPane ? (JTabbedPane)this.i : null;
    }

    public void addTabbedPaneChangeListener(ChangeListener changeListener) {
        if (this.k == null) {
            this.k = new ArrayList<ChangeListener>();
        }
        this.k.add(changeListener);
        JTabbedPane jTabbedPane = this.getTabbedPane();
        if (jTabbedPane != null) {
            jTabbedPane.addChangeListener(changeListener);
        }
    }

    public void removeTabbedPaneChangeListener(ChangeListener changeListener) {
        JTabbedPane jTabbedPane;
        if (this.k != null) {
            this.k.remove(changeListener);
        }
        if ((jTabbedPane = this.getTabbedPane()) != null) {
            jTabbedPane.removeChangeListener(changeListener);
        }
    }

    public void clearSelection() {
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i].clearSelection();
            }
        }
    }

    public int getRowSelectionMode() {
        return this.g;
    }

    public void setRowSelectionMode(int n) {
        if (this.g == n) {
            return;
        }
        this.clearSelection();
        this.g = n;
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i].getSelectionModel().setSelectionMode(this.g);
            }
        }
    }

    public int getColumnSelectionMode() {
        return this.h;
    }

    public void setColumnSelectionMode(int n) {
        if (this.h == n) {
            return;
        }
        this.clearSelection();
        this.h = n;
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i].getColumnModel().getSelectionModel().setSelectionMode(this.h);
            }
        }
    }

    public void addTableRowSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.l == null) {
            this.l = new ArrayList<ListSelectionListener>();
        }
        this.l.add(listSelectionListener);
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i].getSelectionModel().addListSelectionListener(listSelectionListener);
                this.c[i].getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
            }
        }
    }

    public void removeTableRowSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.l != null) {
            this.l.remove(listSelectionListener);
        }
        if (this.c != null) {
            for (int i = 0; i < this.c.length; ++i) {
                this.c[i].getSelectionModel().removeListSelectionListener(listSelectionListener);
                this.c[i].getColumnModel().getSelectionModel().removeListSelectionListener(listSelectionListener);
            }
        }
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.m.add(tableModelListener);
        if (this.b != null) {
            for (TableModel tableModel : this.b) {
                tableModel.addTableModelListener(tableModelListener);
            }
        }
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        if (this.b != null) {
            for (TableModel tableModel : this.b) {
                tableModel.removeTableModelListener(tableModelListener);
            }
        }
        this.m.remove(tableModelListener);
    }

    public boolean isAddRowEnabled() {
        return this.isEditable() && this.getCurrentTable() != null;
    }

    public void addRow() {
        int n = this.getCurrentTableIndex();
        JTable jTable = this.getCurrentTable();
        if (jTable == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (jTable.getCellEditor() != null) {
            jTable.getCellEditor().stopCellEditing();
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.b[n];
        int n2 = this.c[n].getSelectedRow();
        if (n2 < 0) {
            n2 = defaultTableModel.getRowCount() - 1;
        }
        Object[] objectArray = new Object[defaultTableModel.getColumnCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = n2 >= 0 ? defaultTableModel.getValueAt(n2, i) : this.getDefaultValue(n, defaultTableModel, n2, i);
        }
        if (n2 < defaultTableModel.getRowCount() - 1) {
            defaultTableModel.insertRow(n2, objectArray);
        } else {
            defaultTableModel.addRow(objectArray);
            n2 = defaultTableModel.getRowCount() - 1;
        }
        jTable.setRowSelectionInterval(n2, n2);
        Rectangle rectangle = jTable.getCellRect(n2, jTable.getSelectedColumn(), false);
        jTable.scrollRectToVisible(rectangle);
    }

    protected Object getDefaultValue(int n, DefaultTableModel defaultTableModel, int n2, int n3) {
        return "";
    }

    public boolean isRemoveRowEnabled() {
        JTable jTable = this.getCurrentTable();
        return this.isEditable() && jTable != null && jTable.getSelectedRow() >= 0;
    }

    public void removeRow() {
        int n = this.getCurrentTableIndex();
        JTable jTable = this.getCurrentTable();
        if (jTable == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (jTable.getCellEditor() != null) {
            jTable.getCellEditor().stopCellEditing();
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.b[n];
        int n2 = this.c[n].getSelectedRow();
        defaultTableModel.removeRow(n2);
        if (n2 < defaultTableModel.getRowCount()) {
            this.c[n].getSelectionModel().setSelectionInterval(n2, n2);
        } else {
            int n3 = this.c[n].getRowCount() - 1;
            if (n3 >= 0) {
                this.c[n].setRowSelectionInterval(n3, n3);
            }
        }
    }

    public boolean isAddColumnEnabled() {
        return this.isEditable() && this.getCurrentTable() != null;
    }

    public void addColumn() {
        int n = this.getCurrentTableIndex();
        if (n < 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.b[n];
        String string = this.a(defaultTableModel, null, IlvWizardPanel.getMessage("MemoryPage.EnterColumnName.Title"), IlvWizardPanel.getMessage("MemoryPage.EnterColumnName.Label"));
        if (string != null) {
            Vector<Object> vector = new Vector<Object>();
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                Object object = this.getDefaultValue(n, defaultTableModel, i, -1);
                vector.addElement(object);
            }
            defaultTableModel.addColumn((Object)string, vector);
            JTable jTable = this.getCurrentTable();
            int n2 = jTable.getColumnModel().getColumnIndex(string);
            jTable.setColumnSelectionInterval(n2, n2);
        }
    }

    public boolean isRemoveColumnEnabled() {
        JTable jTable = this.getCurrentTable();
        return this.isEditable() && jTable != null && jTable.getSelectedColumn() >= 0;
    }

    public void removeColumn() {
        int n;
        int n2 = this.getCurrentTableIndex();
        if (n2 < 0) {
            return;
        }
        JTable jTable = this.getCurrentTable();
        if (jTable.getCellEditor() != null) {
            jTable.getCellEditor().stopCellEditing();
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.b[n2];
        int n3 = this.c[n2].getSelectedColumn();
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        int n4 = defaultTableModel.getRowCount();
        int n5 = defaultTableModel.getColumnCount();
        for (n = 0; n < n5; ++n) {
            if (n == n3) continue;
            vector.addElement(defaultTableModel.getColumnName(n));
            vector3.addElement(defaultTableModel.getColumnClass(n));
        }
        for (n = 0; n < n4; ++n) {
            Vector<Object> vector4 = new Vector<Object>();
            vector2.addElement(vector4);
            for (int i = 0; i < n5; ++i) {
                if (i == n3) continue;
                vector4.addElement(defaultTableModel.getValueAt(n, i));
            }
        }
        if (defaultTableModel instanceof TypedTableModel) {
            ((TypedTableModel)defaultTableModel).setColumnClass(vector3.toArray(new Class[vector3.size()]));
        }
        defaultTableModel.setDataVector(vector2, vector);
    }

    public boolean isRenameColumnEnabled() {
        JTable jTable = this.getCurrentTable();
        return this.isEditable() && jTable != null && jTable.getSelectedColumn() >= 0;
    }

    public void renameColumn() {
        int n = this.getCurrentTableIndex();
        if (n < 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.b[n];
        int n2 = this.c[n].getSelectedColumn();
        String string = this.a(defaultTableModel, defaultTableModel.getColumnName(n2), IlvWizardPanel.getMessage("MemoryPage.ChangeColumnName.Title"), IlvWizardPanel.getMessage("MemoryPage.ChangeColumnName.Label"));
        if (string != null) {
            this.a(defaultTableModel, n2, string);
        }
    }

    private void a(DefaultTableModel defaultTableModel, int n, String string) {
        Object[] objectArray = new String[Math.max(defaultTableModel.getColumnCount(), n + 1)];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = defaultTableModel.getColumnName(i);
        }
        objectArray[n] = string;
        defaultTableModel.setColumnIdentifiers(objectArray);
    }

    public boolean isPasteFromClipboardEnabled() {
        return this.isEditable() && this.getCurrentTable() != null && this.a(true) != null;
    }

    public void pasteFromClipboard(Component component) {
        int n = this.getCurrentTableIndex();
        if (n < 0) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.b[n];
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(5));
        box.add(new JLabel(IlvWizardPanel.getMessage("MemoryPage.PasteFromClipboard.Message")));
        box.add(Box.createVerticalStrut(15));
        box.add(new JLabel(IlvWizardPanel.getMessage("MemoryPage.UseFirstRowAsColumnNames.Message")));
        box.add(Box.createVerticalStrut(5));
        JCheckBox jCheckBox = new JCheckBox(IlvWizardPanel.getMessage("MemoryPage.UseFirstRowAsColumnNames.Title"));
        jCheckBox.setSelected(true);
        box.add(jCheckBox);
        box.add(Box.createVerticalStrut(5));
        if (JOptionPane.showOptionDialog(component, box, IlvWizardPanel.getMessage("MemoryPage.PasteFromClipboard.Title"), 2, 2, null, null, null) == 0) {
            JTable jTable = this.getCurrentTable();
            if (jTable.getCellEditor() != null) {
                jTable.getCellEditor().cancelCellEditing();
            }
            boolean bl = jCheckBox.isSelected();
            this.a(defaultTableModel, bl);
        }
    }

    private void a(DefaultTableModel defaultTableModel, boolean bl) {
        IlvCSVTableModel ilvCSVTableModel = this.a(bl);
        if (ilvCSVTableModel != null) {
            int n;
            this.clear();
            int n2 = ilvCSVTableModel.getRowCount();
            int n3 = ilvCSVTableModel.getColumnCount();
            Class[] classArray = new Class[n3];
            for (n = 0; n < n3; ++n) {
                this.a(defaultTableModel, n, ilvCSVTableModel.getColumnName(n));
                classArray[n] = ilvCSVTableModel.getColumnClass(n);
            }
            defaultTableModel.setColumnCount(n3);
            defaultTableModel.setRowCount(n2);
            if (defaultTableModel instanceof TypedTableModel) {
                ((TypedTableModel)defaultTableModel).setColumnClass(classArray);
            }
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < n3; ++i) {
                    defaultTableModel.setValueAt(ilvCSVTableModel.getValueAt(n, i), n, i);
                }
            }
        }
    }

    private IlvCSVTableModel a(boolean bl) {
        try {
            String string;
            Transferable transferable;
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (clipboard != null && (transferable = clipboard.getContents(null)) != null && (string = (String)transferable.getTransferData(DataFlavor.stringFlavor)) != null && string.trim().length() > 0) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                IlvCSVTableModel ilvCSVTableModel = IlvCSVReader.getInstance('\uf004', bl ? 0 : -1).read(bufferedReader);
                if (ilvCSVTableModel.getColumnCount() > 0 && ilvCSVTableModel.getRowCount() > 0) {
                    return ilvCSVTableModel;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isClearEnabled() {
        if (this.isEditable() && this.getCurrentTable() != null) {
            TableModel tableModel = this.getCurrentTable().getModel();
            return tableModel.getRowCount() > 0;
        }
        return false;
    }

    public void clear() {
        int n = this.getCurrentTableIndex();
        if (n < 0) {
            return;
        }
        JTable jTable = this.getCurrentTable();
        if (jTable == null) {
            return;
        }
        if (jTable.getCellEditor() != null) {
            jTable.getCellEditor().cancelCellEditing();
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.b[n];
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
    }

    public boolean isResetEnabled() {
        if (this.isEditable() && this.getCurrentTable() != null) {
            int n = this.getCurrentTableIndex();
            if (n < 0) {
                return false;
            }
            return this.e[n];
        }
        return false;
    }

    public void reset() {
        int n = this.getCurrentTableIndex();
        if (n < 0) {
            return;
        }
        JTable jTable = this.getCurrentTable();
        if (jTable == null) {
            return;
        }
        if (jTable.getCellEditor() != null) {
            jTable.getCellEditor().cancelCellEditing();
        }
        Object object = this.m.iterator();
        while (object.hasNext()) {
            TableModelListener tableModelListener = object.next();
            this.b[n].removeTableModelListener(tableModelListener);
        }
        this.b[n] = object = this.copyTableModel(this.a[n]);
        for (TableModelListener tableModelListener : this.m) {
            this.b[n].addTableModelListener(tableModelListener);
        }
        this.e[n] = false;
        this.c[n].setModel((TableModel)object);
    }

    public boolean isModified() {
        for (boolean bl : this.e) {
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private String a(DefaultTableModel defaultTableModel, String string, String string2, String string3) {
        String string4 = (String)IlvSwingUtil.showInputDialog(this, string3, string2, -1, null, null, string);
        if (string4 != null && string4.length() > 0) {
            for (int i = 0; i < defaultTableModel.getColumnCount(); ++i) {
                if (!string4.equals(defaultTableModel.getColumnName(i))) continue;
                JOptionPane.showMessageDialog(this, IlvWizardPanel.getMessage("MemoryPage.ColumnAlreadyExists.Label"), IlvWizardPanel.getMessage("MemoryPage.ColumnAlreadyExists.Title"), 0);
                string4 = null;
                break;
            }
        }
        return string4;
    }

    public static class TypedTableModel
    extends DefaultTableModel
    implements IlvTableModel {
        private Class<?>[] a;

        public TypedTableModel(Object[][] objectArray, Object[] objectArray2, Class<?>[] classArray) {
            super(objectArray, objectArray2);
            this.a = classArray;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.a[n];
        }

        public void setColumnClass(Class<?>[] classArray) {
            this.a = classArray;
        }

        public void addColumn(Object object, Vector vector) {
            Class[] classArray = new Class[this.a.length + 1];
            System.arraycopy(this.a, 0, classArray, 0, this.a.length);
            Class clazz = Object.class;
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (e == null) continue;
                    clazz = e.getClass();
                    break;
                }
            }
            classArray[this.a.length] = clazz;
            this.a = classArray;
            super.addColumn(object, vector);
        }
    }
}

