/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.applications.util.wizard;

import ilog.views.util.swing.SwingFactories;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class IlvBoxUtils {
    public static final Font plainFont = new Font("sans-serif", 0, 12);
    public static final Font boldFont = IlvBoxUtils.deriveFont(plainFont, 1);

    public static Font deriveFont(Font font, int n) {
        return new Font(font.getName(), n, font.getSize());
    }

    public static Font deriveFont(Font font, float f) {
        return new Font(font.getName(), font.getStyle(), (int)f);
    }

    public static void addLabel(Container container, JLabel jLabel) {
        jLabel.setForeground(Color.black);
        jLabel.setFont(plainFont);
        if (jLabel.getText().startsWith("W")) {
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        }
        container.add(jLabel);
    }

    public static void addBoldLabel(Container container, JLabel jLabel) {
        jLabel.setForeground(Color.black);
        jLabel.setFont(boldFont);
        container.add(jLabel);
    }

    public static void add(Container container, String string) {
        IlvBoxUtils.addLabel(container, new JLabel(string));
    }

    public static void addBold(Container container, String string) {
        IlvBoxUtils.addBoldLabel(container, new JLabel(string));
    }

    public static void add(Container container, String string, String string2, String string3) {
        Box box = IlvBoxUtils.hbox();
        IlvBoxUtils.add(box, string);
        IlvBoxUtils.addBold(box, string2);
        IlvBoxUtils.add(box, string3);
        container.add(box);
    }

    public static void add(Container container, String string, String string2, String string3, String string4, String string5) {
        Box box = IlvBoxUtils.hbox();
        IlvBoxUtils.add(box, string);
        IlvBoxUtils.addBold(box, string2);
        IlvBoxUtils.add(box, string3);
        IlvBoxUtils.addBold(box, string4);
        IlvBoxUtils.add(box, string5);
        container.add(box);
    }

    public static Box createLabeledComp(String string, JComponent jComponent, int n, int n2) {
        Box box = SwingFactories.createHorizontalBox();
        if (n2 > 0) {
            box.add(Box.createHorizontalStrut(n2));
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        switch (n) {
            case 10: {
                box.add(jLabel);
                box.add(Box.createHorizontalStrut(8));
                box.add(jComponent);
                break;
            }
            default: {
                box.add(jComponent);
                box.add(Box.createHorizontalStrut(8));
                box.add(jLabel);
            }
        }
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public static void vspace(Container container, int n) {
        container.add(Box.createVerticalStrut(n * 5));
    }

    public static void vspace(Container container) {
        IlvBoxUtils.vspace(container, 4);
    }

    public static void hspace(Container container, int n) {
        container.add(Box.createHorizontalStrut(n * 5));
    }

    public static void hspace(Container container) {
        IlvBoxUtils.hspace(container, 4);
    }

    public static void glue(Container container) {
        container.add(Box.createGlue());
    }

    private static void a(Container container, float f) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).setAlignmentX(f);
        }
    }

    public static void alignLeft(Container container) {
        IlvBoxUtils.a(container, 0.0f);
    }

    public static void alignCenter(Container container) {
        IlvBoxUtils.a(container, 0.5f);
    }

    public static void alignRight(Container container) {
        IlvBoxUtils.a(container, 1.0f);
    }

    private static void b(Container container, float f) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JComponent)) continue;
            ((JComponent)componentArray[i]).setAlignmentY(f);
        }
    }

    public static void alignTop(Container container) {
        IlvBoxUtils.b(container, 0.0f);
    }

    public static void alignCenterY(Container container) {
        IlvBoxUtils.b(container, 0.5f);
    }

    public static void alignBottom(Container container) {
        IlvBoxUtils.b(container, 1.0f);
    }

    public static Box hbox() {
        return IlvBoxUtils.box(0);
    }

    public static Box vbox() {
        return IlvBoxUtils.box(1);
    }

    public static Box box(int n) {
        return new Box(n){

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }
        };
    }
}

