/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.applications.util.palettebar;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvIcon;
import ilog.views.util.internal.IlvURLUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class IlvMakeIconInteractor
extends IlvManagerViewInteractor {
    private Component a;
    private ResourceBundle b;
    private JFileChooser c;
    private Cursor d;
    private Cursor e = Cursor.getPredefinedCursor(1);
    private boolean f = false;

    public IlvMakeIconInteractor(Component component, ResourceBundle resourceBundle) {
        this.a = component;
        this.b = resourceBundle;
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 500) {
            JFileChooser jFileChooser = this.b();
            int n = jFileChooser.showOpenDialog(this.a);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                String string = null;
                if (file != null) {
                    string = file.toString();
                }
                if (string != null && string.length() > 0) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
                    IlvTransformer ilvTransformer = this.getManagerView().getTransformer();
                    if (ilvTransformer != null) {
                        ilvTransformer.inverse(ilvPoint);
                    }
                    IlvManager ilvManager = this.getManager();
                    try {
                        URL uRL = IlvURLUtil.convertFilenameToURL(string);
                        MediaTracker mediaTracker = new MediaTracker(this.getManagerView());
                        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                        mediaTracker.addImage(image, 0);
                        try {
                            mediaTracker.waitForAll();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        int n2 = image.getWidth(this.getManagerView());
                        int n3 = image.getHeight(this.getManagerView());
                        if (n2 > 0 && n3 > 0) {
                            IlvRect ilvRect = new IlvRect(ilvPoint.x - (float)(n2 / 2), ilvPoint.y - (float)(n3 / 2), n2, n3);
                            IlvIcon ilvIcon = new IlvIcon(uRL, ilvRect);
                            this.addObject(ilvIcon);
                        } else {
                            String string2 = this.b.getString("GraphicPalette.MakeIconInteractor.CouldNotReadMsg");
                            String string3 = this.b.getString("GraphicPalette.MakeIconInteractor.CouldNotReadTitle");
                            JOptionPane.showMessageDialog(this.a, string2, string3, 0);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (!this.f) {
                this.getManagerView().popInteractor();
            }
        }
    }

    @Override
    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        this.d = ilvManagerView.isCursorSet() ? ilvManagerView.getCursor() : null;
        ilvManagerView.setCursor(this.e);
    }

    @Override
    protected void detach() {
        this.getManagerView().setCursor(this.d);
        this.d = null;
        super.detach();
    }

    private JFileChooser b() {
        if (this.c == null) {
            this.c = new JFileChooser();
            this.c.setDialogType(0);
            this.c.setDialogTitle(this.b.getString("GraphicPalette.IconFileChooser.Title"));
        }
        return this.c;
    }

    public void setPermanent(boolean bl) {
        this.f = bl;
    }

    public boolean isPermanent() {
        return this.f;
    }

    Cursor a() {
        return this.e;
    }

    void a(Cursor cursor) {
        this.e = cursor;
    }

    protected void addObject(IlvGraphic ilvGraphic) {
        this.getManager().addObject(ilvGraphic, true);
    }
}

