/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.util;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.docview.IlvDocument;
import ilog.views.appframe.docview.IlvDocumentView;
import ilog.views.appframe.docview.IlvMDIViewContainer;
import ilog.views.appframe.docview.IlvViewContainer;
import ilog.views.appframe.swing.mdi.IlvInternalFrame;
import ilog.views.appframe.swing.mdi.IlvMDITabbedPane;
import ilog.views.util.filter.IlvFilter;
import ilog.views.util.filter.event.FilterListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class IlvFocusManager {
    static HashMap<IlvApplication, IlvFocusManager> a = new HashMap();
    public static final String FOCUS_MANAGER_PROPERTY = "focusManager";
    static final String b = "lastFocusedComponent";
    public static final int FOCUS_LISTENER_INSTALLED = 1;
    public static final int ROUTER_LISTENER_INSTALLED = 2;
    public static final String ACTIVABLE_PROPERTY = "ActivableByClick";
    static final String c = "ActivableListener";
    IlvApplication d;
    HashMap<Component, FocusRouter> e = new HashMap();
    HashMap<Container, ContainerListener> f = new HashMap();
    ArrayList<Component> g;
    PropertyChangeListener h;
    private int i;
    static IlvFilter j = new IlvFilter(){

        @Override
        public boolean evaluate(Object object) {
            return object instanceof IlvDocumentView;
        }

        @Override
        public void addFilterListener(FilterListener filterListener) {
        }

        @Override
        public void removeFilterListener(FilterListener filterListener) {
        }
    };
    private static final boolean k = false;
    private static FocusListener l = null;

    public static IlvFocusManager GetFocusManager(IlvApplication ilvApplication) {
        IlvFocusManager ilvFocusManager = a.get(ilvApplication);
        if (ilvFocusManager != null) {
            return ilvFocusManager;
        }
        ilvFocusManager = new IlvFocusManager(ilvApplication);
        a.put(ilvApplication, ilvFocusManager);
        return ilvFocusManager;
    }

    public static IlvFocusManager RemoveFocusManager(IlvApplication ilvApplication) {
        IlvFocusManager ilvFocusManager = a.remove(ilvApplication);
        return ilvFocusManager;
    }

    public static void SetActivable(JComponent jComponent, IlvApplication ilvApplication, boolean bl) {
        IlvFocusManager ilvFocusManager = IlvFocusManager.GetFocusManager(ilvApplication);
        if (ilvFocusManager != null) {
            ilvFocusManager.setActivable(jComponent, bl);
        }
    }

    public static boolean IsActivable(JComponent jComponent, IlvApplication ilvApplication) {
        IlvFocusManager ilvFocusManager = IlvFocusManager.GetFocusManager(ilvApplication);
        return ilvFocusManager != null ? ilvFocusManager.isActivable(jComponent) : true;
    }

    private IlvFocusManager(IlvApplication ilvApplication) {
        this.a(ilvApplication);
    }

    private void a(IlvApplication ilvApplication) {
        this.d = ilvApplication;
        if (ilvApplication != null) {
            ilvApplication.setProperty(FOCUS_MANAGER_PROPERTY, this);
        }
    }

    public void addFocusListener(Component component, IlvViewContainer ilvViewContainer) {
        ContainerListener containerListener;
        if (!this.isActivable(component)) {
            return;
        }
        FocusRouter focusRouter = this.e.get(ilvViewContainer);
        if (focusRouter == null) {
            focusRouter = this.createFocusRouter(ilvViewContainer, component);
        }
        if ((containerListener = this.f.get(ilvViewContainer)) == null) {
            containerListener = new FocusContainerListener(this, focusRouter);
        }
        this.addFocusListener(component, focusRouter, containerListener);
    }

    public int addFocusListener(final Component component, final FocusRouter focusRouter, ContainerListener containerListener) {
        if (!this.isActivable(component)) {
            return 0;
        }
        if (component instanceof JTabbedPane) {
            if (!(component instanceof IlvMDITabbedPane)) {
                ((JTabbedPane)component).addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        Component component2 = ((JTabbedPane)component).getSelectedComponent();
                        focusRouter.componentActivated(component2 == null ? component : component2);
                    }
                });
            }
        } else if (component instanceof JInternalFrame) {
            if (!(component instanceof IlvInternalFrame)) {
                ((JInternalFrame)component).addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                        focusRouter.componentActivated(component);
                    }
                });
            }
            return this.addFocusListener(((JInternalFrame)component).getRootPane(), focusRouter, containerListener);
        }
        this.installFocusRouter(component, focusRouter);
        if (component instanceof Container) {
            Container container = (Container)component;
            if (this.f.get(component) == null) {
                container.addContainerListener(containerListener);
                this.f.put(container, containerListener);
            }
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.addFocusListener(container.getComponent(i), focusRouter, containerListener);
            }
        }
        return 2;
    }

    public void removeFocusListener(Component component) {
        this.removeFocusRouter(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            ContainerListener containerListener = this.f.remove(container);
            if (containerListener != null) {
                container.removeContainerListener(containerListener);
            }
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.removeFocusListener(container.getComponent(i));
            }
        }
    }

    protected FocusRouter createFocusRouter(IlvViewContainer ilvViewContainer, Component component) {
        return new FocusRouter(ilvViewContainer, component);
    }

    protected void installFocusRouter(Component component, FocusRouter focusRouter) {
        if (component != null && this.e.get(component) == null) {
            component.addMouseListener(focusRouter);
            this.e.put(component, focusRouter);
        }
    }

    protected FocusRouter removeFocusRouter(Component component) {
        FocusRouter focusRouter = this.e.remove(component);
        if (focusRouter != null) {
            component.removeMouseListener(focusRouter);
        }
        return focusRouter;
    }

    public void setActivable(JComponent jComponent, boolean bl) {
        if (jComponent.getClientProperty(c) == null) {
            PropertyChangeListener propertyChangeListener = this.a();
            jComponent.putClientProperty(c, propertyChangeListener);
            jComponent.addPropertyChangeListener(ACTIVABLE_PROPERTY, propertyChangeListener);
        }
        jComponent.putClientProperty(ACTIVABLE_PROPERTY, bl ? null : Boolean.FALSE);
    }

    private void a(JComponent jComponent, boolean bl) {
        if (bl) {
            if (this.g == null) {
                return;
            }
            this.g.remove(jComponent);
            this.addFocusListener(jComponent, null);
        } else {
            if (this.g == null) {
                this.g = new ArrayList();
            }
            this.g.add(jComponent);
            this.removeFocusListener(jComponent);
        }
    }

    public boolean isActivable(Component component) {
        block2: {
            block3: {
                if (component == null) break block2;
                String string = component.getClass().getName();
                if (string.endsWith("TabbedPaneUI$ScrollableTabPanel")) break block3;
                if (!string.endsWith("TabbedPaneUI$ScrollableTabViewport")) break block2;
            }
            return false;
        }
        return this.g == null || !this.g.contains(component);
    }

    private PropertyChangeListener a() {
        if (this.h == null) {
            this.h = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (IlvFocusManager.ACTIVABLE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
                        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                        IlvFocusManager.this.a((JComponent)propertyChangeEvent.getSource(), bl == null || !bl.equals(Boolean.FALSE));
                    }
                }
            };
        }
        return this.h;
    }

    public void setComponentFocus(Component component) {
        if ((component = IlvFocusManager.GetFirstFocusableComponent(component, component instanceof Container ? (Container)component : null)) != null) {
            component.requestFocusInWindow();
        }
    }

    public void setActiveClosestView(Component component, Container container) {
        IlvDocumentView ilvDocumentView = IlvFocusManager.GetFirstFocusableDocumentView(component, container);
        if (this.d != null) {
            boolean bl = false;
            if (ilvDocumentView != null) {
                bl = ilvDocumentView.getProperty("ViewContainer") instanceof IlvMDIViewContainer;
            }
            this.d.setActiveView(ilvDocumentView, bl);
        }
    }

    public static Component ActivateContainerView(IlvViewContainer ilvViewContainer, boolean bl) {
        IlvDocumentView[] ilvDocumentViewArray;
        Object object;
        Component component = (Component)ilvViewContainer.getProperty(b);
        IlvDocumentView ilvDocumentView = (IlvDocumentView)ilvViewContainer.getProperty("ActiveView");
        if (ilvDocumentView == null) {
            ilvDocumentView = (IlvDocumentView)ilvViewContainer.getProperty("ActiveView");
            if (ilvDocumentView == null) {
                object = IlvFocusManager.a(component, ilvViewContainer);
                if (object != null) {
                    ilvDocumentView = IlvFocusManager.GetFirstFocusableDocumentView((Component)(component == null ? object : component), (Container)object);
                }
                if (ilvDocumentView == null) {
                    ilvDocumentViewArray = ilvViewContainer.getViews();
                    IlvDocumentView ilvDocumentView2 = ilvDocumentView = ilvDocumentViewArray != null && ilvDocumentViewArray.length != 0 ? ilvDocumentViewArray[0] : null;
                }
            }
        }
        if (ilvDocumentView != null) {
            if (component == null && ilvDocumentView instanceof Component) {
                component = IlvFocusManager.GetFirstFocusableComponent((Component)((Object)ilvDocumentView), IlvFocusManager.a((Component)((Object)ilvDocumentView), ilvViewContainer));
                ilvViewContainer.setProperty(b, component);
            }
            object = (IlvApplication)ilvViewContainer.getProperty("Application");
            if (object != null) {
                Object object2 = ilvDocumentViewArray = ilvDocumentView == null ? null : (Boolean)ilvDocumentView.getProperty("StaticView");
                ((IlvApplication)object).setActiveView(ilvDocumentView, ilvDocumentViewArray == null ? false : !ilvDocumentViewArray.booleanValue());
            }
        }
        if (component != null && bl) {
            component.requestFocusInWindow();
        }
        return component;
    }

    public static Component GetFirstFocusableComponent(Component component, Container container) {
        if (component == null) {
            return null;
        }
        if (component.isFocusable()) {
            return component;
        }
        Container container2 = component instanceof Container ? (Container)component : component.getParent();
        return IlvFocusManager.a(container2, container);
    }

    private static Component a(Container container, Container container2) {
        Component component = IlvFocusManager.a(container);
        if (component == null) {
            if (container == container2 || container2 == null) {
                return null;
            }
            component = IlvFocusManager.b(container.getParent(), container2);
        }
        return component;
    }

    private static Component a(Container container) {
        if (container instanceof JTabbedPane) {
            Component component = ((JTabbedPane)container).getSelectedComponent();
            return component == null ? null : (component instanceof Container ? IlvFocusManager.a((Container)component) : (component.isFocusable() ? component : null));
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy != null) {
            return focusTraversalPolicy.getFirstComponent(container);
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component;
            Component component2 = container.getComponent(i);
            if (!(component2 instanceof Container) || (component = IlvFocusManager.a((Container)component2)) == null) continue;
            return component;
        }
        return null;
    }

    private static Component b(Container container, Container container2) {
        Component component;
        if (container == null) {
            return null;
        }
        if (container.isFocusable()) {
            return container;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy != null && (component = focusTraversalPolicy.getFirstComponent(container)) != null) {
            return component;
        }
        if (container != container2) {
            return IlvFocusManager.b(container.getParent(), container2);
        }
        return null;
    }

    public static IlvDocumentView GetFirstFocusableDocumentView(Component component, Container container) {
        return (IlvDocumentView)((Object)IlvFocusManager.a(component, container, j));
    }

    private static Component a(Component component, Container container, IlvFilter ilvFilter) {
        if (component == null) {
            return null;
        }
        if (ilvFilter.evaluate(component)) {
            return component;
        }
        Container container2 = component instanceof Container ? (Container)component : component.getParent();
        if ((component = IlvFocusManager.a(container2, ilvFilter)) == null) {
            if (container2 == container || container == null) {
                return null;
            }
            component = IlvFocusManager.a(container2.getParent(), container, container2, ilvFilter);
        }
        return component;
    }

    private static Component a(Container container, Container container2, Container container3, IlvFilter ilvFilter) {
        if (ilvFilter.evaluate(container)) {
            return container;
        }
        if (container == null) {
            return null;
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component == container3) continue;
            if (ilvFilter.evaluate(component)) {
                return component;
            }
            if (!(component instanceof Container) || (component = IlvFocusManager.a((Container)component, ilvFilter)) == null) continue;
            return component;
        }
        if (container != container2 && container.getParent() != null) {
            return IlvFocusManager.a(container.getParent(), container2, container, ilvFilter);
        }
        return null;
    }

    private static Component a(Container container, IlvFilter ilvFilter) {
        Component component;
        int n;
        if (container instanceof JTabbedPane) {
            Component component2 = ((JTabbedPane)container).getSelectedComponent();
            return component2 == null ? null : (component2 instanceof Container ? IlvFocusManager.a((Container)component2, ilvFilter) : (ilvFilter.evaluate(component2) ? component2 : null));
        }
        int n2 = container.getComponentCount();
        for (n = 0; n < n2; ++n) {
            component = container.getComponent(n);
            if (!ilvFilter.evaluate(component)) continue;
            return component;
        }
        for (n = 0; n < n2; ++n) {
            Component component3;
            component = container.getComponent(n);
            if (!(component instanceof Container) || (component3 = IlvFocusManager.a((Container)component, ilvFilter)) == null) continue;
            return component3;
        }
        return null;
    }

    private static Container a(Component component, IlvViewContainer ilvViewContainer) {
        if (ilvViewContainer instanceof Container) {
            return (Container)((Object)ilvViewContainer);
        }
        if (component instanceof Container) {
            return (Container)component;
        }
        return null;
    }

    public static Component GetFocusOwnerInHierarchy(Container container) {
        if (container == null) {
            return null;
        }
        if (container.isFocusOwner()) {
            return container;
        }
        int n = container.getComponentCount();
        Component component = null;
        Component component2 = null;
        for (int i = 0; i < n; ++i) {
            component = container.getComponent(i);
            if (!(component instanceof Container) || (component2 = IlvFocusManager.GetFocusOwnerInHierarchy((Container)component)) == null) continue;
            return component2;
        }
        return null;
    }

    public boolean isLocked() {
        return this.i != 0;
    }

    public void lock() {
        ++this.i;
    }

    public void unlock() {
        --this.i;
    }

    static void a(String string) {
        System.err.println(string);
    }

    static String a(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof IlvDocumentView) {
            String string = "view ";
            IlvDocumentView ilvDocumentView = (IlvDocumentView)object;
            IlvDocument ilvDocument = ilvDocumentView.getDocument();
            string = string + (ilvDocument == null ? "null" : ilvDocument.getTitle());
            string = string + " [" + IlvFocusManager.b(object) + "]";
            return string;
        }
        return "[" + IlvFocusManager.b(object) + "]";
    }

    private static String b(Object object) {
        if (object.getClass().getName().indexOf(46) == -1) {
            return object.getClass().getName();
        }
        return object.getClass().getName().substring(object.getClass().getName().lastIndexOf(46) + 1);
    }

    private static class DebugFocusListener
    implements FocusListener {
        private DebugFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            String string = focusEvent.isTemporary() ? "temporary" : "permanent";
            IlvFocusManager.a("FOCUS_GAINED, " + string + ", component = " + IlvFocusManager.a(focusEvent.getComponent()) + ", opposite = " + IlvFocusManager.a(focusEvent.getOppositeComponent()));
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            String string = focusEvent.isTemporary() ? "temporary" : "permanent";
            IlvFocusManager.a("FOCUS_LOST, " + string + ", component = " + IlvFocusManager.a(focusEvent.getComponent()) + ", opposite = " + IlvFocusManager.a(focusEvent.getOppositeComponent()));
        }
    }

    static class FocusContainerListener
    implements ContainerListener {
        FocusRouter a;
        IlvFocusManager b;

        public FocusContainerListener(IlvFocusManager ilvFocusManager, FocusRouter focusRouter) {
            this.a = focusRouter;
            this.b = ilvFocusManager;
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            if (containerEvent.getID() == 300) {
                this.b.addFocusListener(containerEvent.getChild(), this.a, this);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            if (containerEvent.getID() == 301) {
                this.b.removeFocusListener(containerEvent.getChild());
            }
        }
    }

    public class FocusRouter
    extends MouseAdapter {
        IlvViewContainer a;
        Component b;

        public FocusRouter(IlvViewContainer ilvViewContainer, Component component) {
            this.a = ilvViewContainer;
            this.b = component;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (!(component instanceof JTabbedPane) || component instanceof IlvMDITabbedPane) {
                this.componentActivated(component);
            }
        }

        public void componentActivated(Component component) {
            if (IlvFocusManager.this.isLocked()) {
                return;
            }
            Component component2 = component;
            if (this.a != null) {
                this.a.setProperty(IlvFocusManager.b, component2);
            }
            IlvFocusManager.this.setActiveClosestView(component2, this.a instanceof Container ? (Container)((Object)this.a) : (this.b instanceof Container ? (Container)this.b : null));
        }
    }
}

