/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing.docking;

import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.swing.docking.IlvComponentConfiguration;
import ilog.views.appframe.swing.docking.IlvDockableConfiguration;
import ilog.views.appframe.swing.docking.IlvDockablePaneStyle;
import ilog.views.appframe.swing.docking.IlvDockingManager;
import ilog.views.appframe.swing.docking.IlvWorkspace;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;

class IlvConfigurationExtension {
    private String a;
    private ArrayList b;
    private HashMap c;
    private HashMap d;
    private transient IlvSettingsElement e;
    private transient ArrayList f = new ArrayList();
    private static final String g = "dock";
    private static final String h = "undock";
    private static final String i = "tab";
    private static final String j = "split";
    private static final String k = "show";
    private static final String l = "hide";

    public IlvConfigurationExtension(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) {
        this.readSettings(ilvSettingsElement, ilvApplication);
    }

    public void apply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
        if (this.b != null) {
            for (int i = 0; i < this.b.size(); ++i) {
                Object object = (ConfigurationAction)this.b.get(i);
                ((ConfigurationAction)object).apply(ilvDockingManager, ilvWorkspace);
            }
        }
        if (ilvDockingManager.ab()) {
            for (Object object : this.c.values()) {
                ((IlvDockablePaneStyle)object).apply(ilvDockingManager);
                if (!((IlvDockablePaneStyle)object).isExtension()) continue;
                ilvDockingManager.a((IlvDockablePaneStyle)object);
            }
        }
    }

    public void unApply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
        if (this.b != null) {
            for (int i = this.b.size() - 1; i >= 0; --i) {
                ConfigurationAction configurationAction = (ConfigurationAction)this.b.get(i);
                configurationAction.unApply(ilvDockingManager, ilvWorkspace);
            }
        }
    }

    public void addPaneStyles(IlvDockingManager ilvDockingManager) {
        this.a(ilvDockingManager, true);
    }

    public void removePaneStyles(IlvDockingManager ilvDockingManager) {
        this.a(ilvDockingManager, false);
    }

    void a(IlvDockingManager ilvDockingManager, boolean bl) {
        if (this.c == null || this.c.size() == 0) {
            return;
        }
        if (bl && this.d == null) {
            this.d = new HashMap(this.c.size());
        }
        for (IlvDockablePaneStyle ilvDockablePaneStyle : this.c.values()) {
            IlvDockablePaneStyle ilvDockablePaneStyle2;
            if (bl) {
                ilvDockablePaneStyle2 = ilvDockingManager.b(ilvDockablePaneStyle);
                ilvDockablePaneStyle.setExtension(ilvDockablePaneStyle2 == null);
                this.d.put(ilvDockablePaneStyle.getName(), ilvDockablePaneStyle2);
                continue;
            }
            ilvDockablePaneStyle2 = (IlvDockablePaneStyle)this.d.get(ilvDockablePaneStyle.getName());
            if (ilvDockablePaneStyle2 == null) {
                ilvDockingManager.c(ilvDockablePaneStyle);
                continue;
            }
            ilvDockingManager.b(ilvDockablePaneStyle2);
        }
    }

    public void readSettings(IlvSettingsElement ilvSettingsElement, IlvApplication ilvApplication) {
        Object object;
        int n;
        IlvSettingsElement[] ilvSettingsElementArray;
        this.e = ilvSettingsElement;
        this.a = ilvSettingsElement.getString("name");
        IlvSettingsElement ilvSettingsElement2 = ilvSettingsElement.getFirstChild("actions");
        this.b = null;
        if (ilvSettingsElement2 != null && (ilvSettingsElementArray = ilvSettingsElement2.getChildren()) != null && ilvSettingsElementArray.length != 0) {
            this.b = new ArrayList(ilvSettingsElementArray.length);
            for (n = 0; n < ilvSettingsElementArray.length; ++n) {
                object = this.createAction(ilvSettingsElementArray[n].getType());
                if (object == null) continue;
                ((ConfigurationAction)object).setExtension(this);
                ((ConfigurationAction)object).readSettings(ilvSettingsElementArray[n]);
                this.b.add(object);
            }
        }
        ilvSettingsElementArray = (ilvSettingsElement2 = ilvSettingsElement.getFirstChild("paneStyles")) == null ? null : ilvSettingsElement2.getChildren("pane");
        this.c = new HashMap();
        if (ilvSettingsElementArray != null) {
            for (n = 0; n < ilvSettingsElementArray.length; ++n) {
                object = new IlvDockablePaneStyle(ilvSettingsElementArray[n], ilvApplication);
                this.c.put(((IlvDockablePaneStyle)object).getName(), object);
            }
        }
    }

    public void writeSettings(IlvSettingsElement ilvSettingsElement) {
        IlvSettingsElement ilvSettingsElement2;
        IlvSettingsElement ilvSettingsElement3;
        IlvSettings ilvSettings = ilvSettingsElement.getSettings();
        ilvSettingsElement.removeAll(null);
        if (this.a != null) {
            ilvSettingsElement.setString("name", this.a);
        }
        if (this.b != null && this.b.size() != 0) {
            ilvSettingsElement3 = ilvSettingsElement.ensureChildElement("actions");
            for (int i = 0; i < this.b.size(); ++i) {
                Object object = (ConfigurationAction)this.b.get(i);
                ilvSettingsElement2 = ilvSettings.createSettingsElement(((ConfigurationAction)object).getSettingsType());
                ((ConfigurationAction)object).writeSettings(ilvSettingsElement2);
                ilvSettingsElement3.getSettings().addSettingsElement(ilvSettingsElement3, ilvSettingsElement2, -1);
            }
        }
        ilvSettingsElement.removeAll("paneStyles");
        if (this.c != null && this.c.size() != 0) {
            ilvSettingsElement3 = ilvSettingsElement.ensureChildElement("paneStyles");
            for (Object object : this.c.values()) {
                ilvSettingsElement2 = ilvSettings.createSettingsElement("pane");
                ((IlvDockablePaneStyle)object).writeSettings(ilvSettingsElement2);
                ilvSettingsElement3.add(ilvSettingsElement2);
            }
        }
    }

    public String getName() {
        return this.a;
    }

    public IlvSettingsElement getSettingsElement() {
        return this.e;
    }

    public boolean doesApplyConfiguration(IlvWorkspace ilvWorkspace) {
        if (this.a == null || this.a.length() == 0) {
            return true;
        }
        return this.a.compareToIgnoreCase(ilvWorkspace.getName()) == 0;
    }

    protected ConfigurationAction createAction(String string) {
        if (string.equals(g)) {
            return new DockAction();
        }
        if (string.equals(h)) {
            return new UndockAction();
        }
        if (string.equals(i)) {
            return new TabAction();
        }
        if (string.equals(j)) {
            return new SplitAction();
        }
        if (string.equals(k)) {
            return new VisibilityAction(true);
        }
        if (string.equals(l)) {
            return new VisibilityAction(false);
        }
        IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Logging.Docking.UnknownConfigAction", new Object[]{string});
        return null;
    }

    static class VisibilityAction
    extends ConfigurationAction {
        boolean a = false;
        boolean b;
        boolean c;

        public VisibilityAction(boolean bl) {
            this.b = bl;
        }

        @Override
        public String getSettingsType() {
            return this.b ? IlvConfigurationExtension.k : IlvConfigurationExtension.l;
        }

        @Override
        public void apply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            boolean bl = this.firstUse;
            this.a = ilvDockingManager.e() && !this.force && !this.isExtensionPane(this.name);
            super.apply(ilvDockingManager, ilvWorkspace);
            if (this.a) {
                return;
            }
            IlvDockableConfiguration ilvDockableConfiguration = ilvWorkspace.a(this.name);
            if (bl) {
                boolean bl2 = this.c = ilvDockableConfiguration == null ? false : ((IlvComponentConfiguration)ilvDockableConfiguration).isVisible();
            }
            if (this.c != this.b && ilvDockableConfiguration != null) {
                ilvDockableConfiguration.setVisible(this.b, false);
            }
        }

        @Override
        public void unApply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            if (this.a) {
                return;
            }
            IlvDockableConfiguration ilvDockableConfiguration = ilvWorkspace.a(this.name);
            if (this.c != this.b && ilvDockableConfiguration != null) {
                ilvDockableConfiguration.setVisible(this.c, false);
            }
        }
    }

    static class SplitAction
    extends ConfigurationAction {
        String a;
        int b;
        double c;

        SplitAction() {
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            super.readSettings(ilvSettingsElement);
            this.a = ilvSettingsElement.getString("paneToSplit");
            this.b = this.a(ilvSettingsElement, "orientation");
            this.c = ilvSettingsElement.getDouble("location", 0.5);
        }

        @Override
        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            super.writeSettings(ilvSettingsElement);
            ilvSettingsElement.setString("onPane", this.a);
            this.a(ilvSettingsElement, "orientation", this.b);
            ilvSettingsElement.setDouble("location", this.c);
        }

        @Override
        public String getSettingsType() {
            return IlvConfigurationExtension.j;
        }

        @Override
        public void apply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            boolean bl = this.firstUse;
            super.apply(ilvDockingManager, ilvWorkspace);
            if (bl) {
                boolean bl2 = this.a(ilvWorkspace);
                if (!bl2 || this.force) {
                    if (!bl2) {
                        this.registerExtensionPane(this.name);
                    }
                    ilvWorkspace.split(this.a, this.name, this.b, this.c);
                }
            } else {
                ilvDockingManager.a(this.name, true, false);
            }
        }

        @Override
        public void unApply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            if (ilvDockingManager.aa()) {
                ilvDockingManager.a(this.name, false, false);
            } else {
                ilvDockingManager.removeDockable(this.name, false);
            }
        }
    }

    static class TabAction
    extends ConfigurationAction {
        private String a;
        private boolean b;
        private boolean c;

        TabAction() {
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            super.readSettings(ilvSettingsElement);
            this.a = ilvSettingsElement.getString("onPane");
            this.b = ilvSettingsElement.getBoolean("after", true);
            this.c = ilvSettingsElement.getBoolean("select", true);
        }

        @Override
        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            super.writeSettings(ilvSettingsElement);
            ilvSettingsElement.setString("onPane", this.a);
            ilvSettingsElement.setBoolean("after", this.b);
        }

        @Override
        public String getSettingsType() {
            return IlvConfigurationExtension.i;
        }

        @Override
        public void apply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            boolean bl = this.firstUse;
            super.apply(ilvDockingManager, ilvWorkspace);
            if (bl) {
                boolean bl2 = this.a(ilvWorkspace);
                if (!bl2 || this.force) {
                    if (!bl2) {
                        this.registerExtensionPane(this.name);
                    }
                    ilvWorkspace.addTab(this.name, this.a, this.b, this.c);
                }
            } else {
                ilvDockingManager.a(this.name, true, false);
            }
        }

        @Override
        public void unApply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            if (ilvDockingManager.aa()) {
                ilvDockingManager.a(this.name, false, false);
            } else {
                ilvDockingManager.removeDockable(this.name, false);
            }
        }
    }

    static class UndockAction
    extends ConfigurationAction {
        Point a;

        UndockAction() {
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            super.readSettings(ilvSettingsElement);
            this.a = new Point(ilvSettingsElement.getInt("x", 0), ilvSettingsElement.getInt("y", 0));
        }

        @Override
        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            super.writeSettings(ilvSettingsElement);
            ilvSettingsElement.setInt("x", this.a.x);
            ilvSettingsElement.setInt("y", this.a.y);
        }

        @Override
        public String getSettingsType() {
            return IlvConfigurationExtension.h;
        }

        @Override
        public void apply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            boolean bl = this.firstUse;
            super.apply(ilvDockingManager, ilvWorkspace);
            if (bl) {
                boolean bl2 = this.a(ilvWorkspace);
                if (!bl2 || this.force) {
                    if (!bl2) {
                        this.registerExtensionPane(this.name);
                    }
                    ilvDockingManager.undock(this.name, this.a, false);
                }
            } else {
                ilvDockingManager.a(this.name, true, false);
            }
        }

        @Override
        public void unApply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            if (ilvDockingManager.aa()) {
                ilvDockingManager.a(this.name, false, false);
            } else {
                ilvDockingManager.removeDockable(this.name, false);
            }
        }
    }

    static class DockAction
    extends ConfigurationAction {
        int a;
        double b;

        DockAction() {
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            super.readSettings(ilvSettingsElement);
            this.a = this.a(ilvSettingsElement, "orientation");
            this.b = ilvSettingsElement.getDouble("location", -1.0);
        }

        @Override
        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            super.writeSettings(ilvSettingsElement);
            this.a(ilvSettingsElement, "orientation", this.a);
            ilvSettingsElement.setDouble("location", this.b);
        }

        @Override
        public String getSettingsType() {
            return IlvConfigurationExtension.g;
        }

        @Override
        public void apply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            boolean bl = this.firstUse;
            super.apply(ilvDockingManager, ilvWorkspace);
            if (bl) {
                boolean bl2 = this.a(ilvWorkspace);
                if (!bl2 || this.force) {
                    if (!bl2) {
                        this.registerExtensionPane(this.name);
                    }
                    ilvWorkspace.dock(this.name, this.a, this.b, false);
                }
            } else {
                ilvDockingManager.a(this.name, true, false);
            }
        }

        @Override
        public void unApply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            if (ilvDockingManager.aa()) {
                ilvDockingManager.a(this.name, false, false);
            } else {
                ilvDockingManager.removeDockable(this.name, false);
            }
        }
    }

    static abstract class ConfigurationAction {
        protected boolean ownBar;
        protected boolean firstUse = true;
        protected String name;
        protected boolean force;
        protected IlvConfigurationExtension extension;

        ConfigurationAction() {
        }

        public void apply(IlvDockingManager ilvDockingManager, IlvWorkspace ilvWorkspace) {
            if (this.firstUse) {
                this.ownBar = !ilvDockingManager.b(this.name);
                this.firstUse = false;
            }
        }

        public abstract void unApply(IlvDockingManager var1, IlvWorkspace var2);

        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            this.name = ilvSettingsElement.getString("name");
            this.force = ilvSettingsElement.getBoolean("force", false);
        }

        public void writeSettings(IlvSettingsElement ilvSettingsElement) {
            ilvSettingsElement.setString("name", this.name);
            ilvSettingsElement.setBoolean("force", this.force);
        }

        public abstract String getSettingsType();

        int a(IlvSettingsElement ilvSettingsElement, String string) {
            String string2 = ilvSettingsElement.getString(string, "north");
            if (string2.compareToIgnoreCase("north") == 0) {
                return 1;
            }
            if (string2.compareToIgnoreCase("west") == 0) {
                return 7;
            }
            if (string2.compareToIgnoreCase("east") == 0) {
                return 3;
            }
            return 5;
        }

        void a(IlvSettingsElement ilvSettingsElement, String string, int n) {
            switch (n) {
                case 7: {
                    ilvSettingsElement.setString(string, "west");
                    break;
                }
                case 1: {
                    ilvSettingsElement.setString(string, "north");
                    break;
                }
                case 3: {
                    ilvSettingsElement.setString(string, "east");
                    break;
                }
                case 5: {
                    ilvSettingsElement.setString(string, "south");
                    break;
                }
                default: {
                    ilvSettingsElement.setString(string, "top");
                }
            }
        }

        boolean a(IlvWorkspace ilvWorkspace) {
            if (this.name == null) {
                return false;
            }
            IlvDockableConfiguration ilvDockableConfiguration = ilvWorkspace.a(this.name);
            return ilvDockableConfiguration != null;
        }

        public void setExtension(IlvConfigurationExtension ilvConfigurationExtension) {
            this.extension = ilvConfigurationExtension;
        }

        public void registerExtensionPane(String string) {
            if (!this.extension.f.contains(string)) {
                this.extension.f.add(string);
            }
        }

        protected boolean isExtensionPane(String string) {
            return this.extension.f.contains(string);
        }
    }
}

