/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.swing;

import ilog.views.appframe.IlvAction;
import ilog.views.appframe.IlvApplication;
import ilog.views.appframe.form.IlvFormException;
import ilog.views.appframe.form.services.IlvServicesProvider;
import ilog.views.appframe.form.swing.IlvSwingFormReader;
import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.settings.IlvSettingsQuery;
import ilog.views.appframe.settings.beans.IlvBeanSettings;
import ilog.views.appframe.settings.internal.IlvSettingsObjectInstaller;
import ilog.views.appframe.settings.internal.IlvSettingsUtils;
import ilog.views.appframe.swing.IlvMenuBar;
import ilog.views.appframe.swing.IlvToolBar;
import ilog.views.appframe.swing.internal.IlvMenuCompletionInstaller;
import ilog.views.appframe.swing.util.IlvAppFrameServicesProvider;
import ilog.views.appframe.swing.util.IlvSwingUtil;
import ilog.views.appframe.util.logging.IlvLog;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;

public class IlvMenuCompletion
extends CompoundEdit {
    private transient IlvSettings a;
    private String b;
    private String c;
    private transient IlvApplication d;
    private transient IlvServicesProvider e;
    private transient boolean f = true;
    private transient Map g = new HashMap();
    private static final String h = "JAppFrame:CompletionListener";
    static boolean i = false;

    public boolean completeMenus(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0 || this.edits == null || this.edits.size() == 0) {
            return false;
        }
        if (!this.f) {
            this.redo();
            return true;
        }
        IlvBeanSettings ilvBeanSettings = new IlvBeanSettings("bars");
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof JToolBar) {
                this.a(ilvBeanSettings, (JToolBar)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof JMenuBar) {
                this.a(ilvBeanSettings, (JMenuBar)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof JPopupMenu) {
                this.a(ilvBeanSettings, (JPopupMenu)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Component) {
                this.a(ilvBeanSettings, (Component)objectArray[i]);
                continue;
            }
            IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, "Logging.MenuCompletion.UnknownMenuType", new Object[]{objectArray[i].getClass().getName()});
        }
        IlvApplication ilvApplication = this.getApplication();
        try {
            for (int i = 0; i < this.edits.size(); ++i) {
                AbstractMenuEdit abstractMenuEdit = (AbstractMenuEdit)this.edits.get(i);
                abstractMenuEdit.completeMenus(ilvBeanSettings, ilvApplication, this.e);
            }
        }
        catch (CompletionException completionException) {
            this.f = false;
            IlvLog.Log("ilog.views.appframe", IlvLog.WARNING, completionException, "Logging.MenuCompletion.CouldNotCompleteMenu", new Object[]{this.getSettingsName()});
            return false;
        }
        this.f = false;
        return true;
    }

    public boolean readSettings(IlvSettings ilvSettings) {
        this.a = ilvSettings;
        IlvSettingsElement ilvSettingsElement = this.a(ilvSettings);
        if (ilvSettingsElement == null) {
            return false;
        }
        return this.readSettings(ilvSettingsElement);
    }

    public boolean readSettings(IlvSettingsElement ilvSettingsElement) {
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren((String)null);
        if (ilvSettingsElementArray == null) {
            this.edits = null;
            return true;
        }
        for (int i = 0; i < ilvSettingsElementArray.length; ++i) {
            AbstractMenuEdit abstractMenuEdit = this.a(ilvSettingsElementArray[i]);
            abstractMenuEdit.readSettings(ilvSettingsElementArray[i]);
            this.addEdit(abstractMenuEdit);
        }
        this.end();
        return true;
    }

    AbstractMenuEdit a(IlvSettingsElement ilvSettingsElement) {
        String string = ilvSettingsElement.getType();
        if (string.equals("insert")) {
            return new BarItemInsertion(this);
        }
        if (string.equals("remove")) {
            return new BarItemRemoval(this);
        }
        if (string.equals("move")) {
            return new BarItemMove(this);
        }
        return null;
    }

    public String getSettingsPath() {
        return this.b;
    }

    public void setSettingsPath(String string) {
        this.b = string;
    }

    public String getSettingsName() {
        return this.c;
    }

    public void setSettingsName(String string) {
        this.c = string;
        this.b = "/menuCompletion[@name=\"" + string + "\"]";
    }

    public IlvApplication getApplication() {
        return this.d;
    }

    public void setApplication(IlvApplication ilvApplication) {
        this.d = ilvApplication;
        this.e = IlvAppFrameServicesProvider.GetServicesProvider(ilvApplication);
    }

    IlvSettingsElement a(IlvSettings ilvSettings) {
        String string = this.getSettingsPath();
        if (string == null || string.length() == 0) {
            return null;
        }
        IlvSettingsQuery ilvSettingsQuery = new IlvSettingsQuery(string);
        return ilvSettings.selectElement(ilvSettingsQuery);
    }

    void a(IlvBeanSettings ilvBeanSettings, JMenuBar jMenuBar) {
        this.a(ilvBeanSettings, null, jMenuBar);
    }

    void a(IlvBeanSettings ilvBeanSettings, JPopupMenu jPopupMenu) {
        this.a(ilvBeanSettings, null, jPopupMenu);
    }

    void a(IlvBeanSettings ilvBeanSettings, Object object, Component component) {
        JComponent jComponent;
        ilvBeanSettings.addObject(object, component);
        object = component;
        JPopupMenu jPopupMenu = null;
        if (component instanceof JMenu) {
            jComponent = (JMenu)component;
            jPopupMenu = ((JMenu)jComponent).getPopupMenu();
            if (jPopupMenu == null) {
                return;
            }
            this.g.put(component, jComponent);
        } else if (component instanceof JPopupMenu) {
            jPopupMenu = (JPopupMenu)component;
        }
        Container container = jPopupMenu != null ? jPopupMenu : (jComponent = component instanceof Container ? (Container)component : null);
        if (jComponent != null) {
            for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                this.a(ilvBeanSettings, object, jComponent.getComponent(i));
            }
        }
    }

    void a(IlvBeanSettings ilvBeanSettings, JToolBar jToolBar) {
        ilvBeanSettings.addObject(jToolBar);
        for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
            ilvBeanSettings.addObject(jToolBar, jToolBar.getComponentAtIndex(i));
        }
    }

    void a(IlvBeanSettings ilvBeanSettings, Component component) {
        ilvBeanSettings.addObject(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.a(ilvBeanSettings, container.getComponent(i));
            }
        }
    }

    static boolean a(Component component, Container container) {
        if (container instanceof JMenuBar) {
            return component instanceof JMenu || component instanceof JButton;
        }
        boolean bl = container instanceof MenuElement;
        if (component instanceof MenuElement) {
            return bl;
        }
        return !bl;
    }

    static boolean a(Component component, Container container, Container container2) {
        return IlvMenuCompletion.b(component, container) != IlvMenuCompletion.a(container2);
    }

    static boolean b(Component component, Container container) {
        if (component instanceof JMenu) {
            return true;
        }
        if (container instanceof JMenuBar) {
            return false;
        }
        return container instanceof JMenu || container instanceof JPopupMenu;
    }

    static boolean a(Container container) {
        return container instanceof JMenuBar || container instanceof JMenu || container instanceof JPopupMenu;
    }

    @Override
    public void redo() {
        super.redo();
        this.f = false;
    }

    @Override
    public boolean canRedo() {
        return !this.f && super.canRedo();
    }

    @Override
    public boolean canUndo() {
        return !this.f && super.canUndo();
    }

    private CompletionContainerListener b(Container container) {
        CompletionContainerListener completionContainerListener = (CompletionContainerListener)((JComponent)container).getClientProperty(h);
        if (completionContainerListener != null) {
            return completionContainerListener;
        }
        completionContainerListener = new CompletionContainerListener(container);
        container.addContainerListener(completionContainerListener);
        ((JComponent)container).putClientProperty(h, completionContainerListener);
        return completionContainerListener;
    }

    private static int b(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return -1;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    static void a(String string) {
        if (i) {
            System.out.println(string);
        }
    }

    static {
        IlvSettingsObjectInstaller.RegisterInstaller(IlvMenuCompletionInstaller.class);
    }

    private static class CompletionContainerListener
    implements ContainerListener {
        private List a;
        private List b;
        private List c = new ArrayList();
        private List d = new ArrayList();

        public CompletionContainerListener(Container container) {
            int n = container.getComponentCount();
            this.a = new ArrayList(n);
            this.b = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                this.a.add(component);
                this.b.add(component);
            }
        }

        public void addMenuComponent(MenuComponent menuComponent) {
            this.c.add(menuComponent);
            this.d.add(menuComponent.getComponent().getParent() == menuComponent.getContainer() ? Boolean.TRUE : Boolean.FALSE);
        }

        public void removeMenuElement(MenuComponent menuComponent) {
            int n = this.c.indexOf(menuComponent);
            if (n != -1) {
                this.c.remove(n);
                this.d.remove(n);
            }
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            int n = IlvMenuCompletion.b(component);
            this.a.add(n, component);
            int n2 = this.b.indexOf(component);
            if (n2 == -1) {
                if (n == containerEvent.getContainer().getComponentCount() - 1) {
                    n2 = this.b.size();
                    this.b.add(component);
                } else {
                    Component component2 = containerEvent.getContainer().getComponent(n + 1);
                    n2 = this.b.indexOf(component2);
                    this.b.add(n2, component);
                }
            }
            for (int i = 0; i < this.c.size(); ++i) {
                MenuComponent menuComponent = (MenuComponent)this.c.get(i);
                if (menuComponent.getComponent() == component) {
                    this.d.set(i, Boolean.TRUE);
                    continue;
                }
                if (menuComponent.getIndex() > n) {
                    menuComponent.setIndex(menuComponent.getIndex() + 1);
                    continue;
                }
                if (menuComponent.getIndex() != n || n2 >= this.b.indexOf(menuComponent.getComponent())) continue;
                menuComponent.setIndex(menuComponent.getIndex() + 1);
            }
            if (i) {
                IlvMenuCompletion.a(this.b(component) + " inserted at " + n);
                this.a("    ");
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            int n = this.a.indexOf(component);
            if (n == -1) {
                if (i) {
                    System.err.println("Unregistered component " + component.getClass().getName());
                }
                return;
            }
            int n2 = this.b.indexOf(component);
            this.a.remove(n);
            for (int i = 0; i < this.c.size(); ++i) {
                MenuComponent menuComponent = (MenuComponent)this.c.get(i);
                if (menuComponent.getComponent() == component) {
                    this.d.set(i, Boolean.FALSE);
                    continue;
                }
                if (menuComponent.getIndex() > n) {
                    menuComponent.setIndex(menuComponent.getIndex() - 1);
                    continue;
                }
                if (menuComponent.getIndex() != n || n2 >= this.b.indexOf(menuComponent.getComponent())) continue;
                menuComponent.setIndex(menuComponent.getIndex() - 1);
            }
            if (i) {
                IlvMenuCompletion.a(this.b(component) + " removed at " + n);
                this.a("    ");
            }
        }

        private int a(Component component) {
            for (int i = 0; i < this.c.size(); ++i) {
                MenuComponent menuComponent = (MenuComponent)this.c.get(i);
                if (menuComponent.getComponent() != component) continue;
                return i;
            }
            return -1;
        }

        private void a(String string) {
            for (int i = 0; i < this.c.size(); ++i) {
                MenuComponent menuComponent = (MenuComponent)this.c.get(i);
                IlvMenuCompletion.a(string + " " + this.a(menuComponent));
            }
        }

        private String a(MenuComponent menuComponent) {
            return this.b(menuComponent.a) + " [" + menuComponent.getIndex() + "]";
        }

        private String b(Component component) {
            int n = this.a(component);
            if (component instanceof JSeparator) {
                return "Separator " + component.getName();
            }
            if (component instanceof JMenu) {
                return "JMenu " + ((JMenu)component).getText();
            }
            Action action = null;
            if (n != -1) {
                action = ((MenuComponent)this.c.get((int)n)).d;
            }
            if (component instanceof JMenuItem) {
                if (action == null) {
                    action = ((JMenuItem)component).getAction();
                }
                if (action != null) {
                    return "Menu item " + action.getValue("ActionCommandKey");
                }
                return "Menu item " + ((JMenuItem)component).getText();
            }
            if (component instanceof JButton) {
                if (action == null) {
                    action = ((JButton)component).getAction();
                }
                if (action != null) {
                    return "Button " + action.getValue("ActionCommandKey");
                }
                return "Button " + ((JButton)component).getText();
            }
            return component.getClass().getName();
        }
    }

    static class BarItemMove
    extends AbstractMenuEdit {
        ComponentKey a;
        ComponentKey b;
        MenuComponent c;
        MenuComponent d;
        Action e;

        public BarItemMove(IlvMenuCompletion ilvMenuCompletion) {
            super(ilvMenuCompletion);
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            this.a = new ComponentKey();
            this.a.readSettings(ilvSettingsElement);
            this.b = new ComponentKey();
            this.b.readSettings(ilvSettingsElement, "dest_key", "dest_mode");
        }

        @Override
        public void completeMenus(IlvBeanSettings ilvBeanSettings, IlvApplication ilvApplication, IlvServicesProvider ilvServicesProvider) throws CompletionException {
            if (this.a == null) {
                throw new CompletionException("Could not initialize the menu edition properly");
            }
            Component component = this.a.findComponent(ilvBeanSettings, ilvApplication);
            if (component == null || component.getParent() == null) {
                throw new CannotFindComponentException(this.a, ilvBeanSettings);
            }
            this.c = this.a(component, ilvApplication);
            this.c.removeFromContainer(false);
            MenuComponent[] menuComponentArray = this.a(new Component[]{component}, this.b, ilvBeanSettings, ilvApplication, ilvServicesProvider, true);
            if (menuComponentArray == null || menuComponentArray.length == 0 || menuComponentArray[0] == null) {
                throw new CannotFindComponentException(this.b, ilvBeanSettings);
            }
            this.d = menuComponentArray[0];
            this.firstUse = false;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.c == null || this.d == null) {
                return;
            }
            this.d.removeFromContainer(true);
            this.c.addToContainer(true);
            if (this.d.getContainer() != this.c.getContainer()) {
                this.c.b();
            }
            this.d.b();
        }

        @Override
        public void redo() {
            if (this.c == null || this.d == null) {
                return;
            }
            this.c.removeFromContainer(true);
            this.d.addToContainer(true);
            if (this.d.getContainer() != this.c.getContainer()) {
                this.c.b();
            }
            this.d.b();
            super.redo();
        }
    }

    static class BarItemRemoval
    extends AbstractMenuEdit {
        protected ComponentKey key;
        MenuComponent a;

        public BarItemRemoval(IlvMenuCompletion ilvMenuCompletion) {
            super(ilvMenuCompletion);
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            this.key = new ComponentKey();
            this.key.readSettings(ilvSettingsElement);
        }

        @Override
        public void completeMenus(IlvBeanSettings ilvBeanSettings, IlvApplication ilvApplication, IlvServicesProvider ilvServicesProvider) throws CompletionException {
            if (this.key == null) {
                throw new CompletionException("Could not initialize the menu edition properly");
            }
            Component component = this.key.findComponent(ilvBeanSettings, ilvApplication);
            if (component == null || component.getParent() == null) {
                throw new CannotFindComponentException(this.key, ilvBeanSettings);
            }
            this.a = this.a(component, ilvApplication);
            this.redo();
        }

        @Override
        public void undo() {
            super.undo();
            if (this.a != null) {
                this.a.addToContainer(true);
                this.a.b();
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.a != null) {
                this.a.removeFromContainer(true);
                this.a.b();
            }
        }
    }

    private static class BarItemInsertion
    extends AbstractMenuEdit {
        ComponentKey a;
        IlvSettingsElement[] b;
        MenuComponent[] c;

        public BarItemInsertion(IlvMenuCompletion ilvMenuCompletion) {
            super(ilvMenuCompletion);
        }

        @Override
        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            this.a = new ComponentKey();
            this.a.readSettings(ilvSettingsElement);
            IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren();
            if (ilvSettingsElementArray != null) {
                this.b = new IlvSettingsElement[ilvSettingsElementArray.length];
                System.arraycopy(ilvSettingsElementArray, 0, this.b, 0, ilvSettingsElementArray.length);
            } else {
                this.b = new IlvSettingsElement[0];
            }
        }

        @Override
        public void completeMenus(IlvBeanSettings ilvBeanSettings, IlvApplication ilvApplication, IlvServicesProvider ilvServicesProvider) throws CompletionException {
            if (this.a == null || this.b == null || this.b.length == 0) {
                throw new CompletionException("Component could not initialize properly");
            }
            Component[] componentArray = new Component[this.b.length];
            IlvSwingFormReader ilvSwingFormReader = new IlvSwingFormReader();
            try {
                for (int i = 0; i < this.b.length; ++i) {
                    componentArray[i] = ilvSwingFormReader.readComponent(IlvSettingsUtils.GetDOMElement(this.b[i]), ilvServicesProvider);
                    if (componentArray[i] != null) continue;
                    throw new CannotReadComponentException(this.a);
                }
            }
            catch (IlvFormException ilvFormException) {
                throw new CompletionException(ilvFormException.getMessage());
            }
            this.c = this.a(componentArray, this.a, ilvBeanSettings, ilvApplication, ilvServicesProvider, true);
            if (this.c == null) {
                throw new CompletionException("Could not insert the component of key " + this.a.toString() + " in a menu or toolbar");
            }
            if (this.c.length != 0) {
                this.c[0].a();
            }
            this.firstUse = false;
        }

        @Override
        public void undo() {
            super.undo();
            if (this.c != null && this.c.length > 0) {
                for (int i = this.c.length - 1; i >= 0; --i) {
                    this.c[i].removeFromContainer(true);
                }
                this.c[0].b();
            }
        }

        @Override
        public void redo() {
            super.redo();
            if (this.c != null && this.c.length > 0) {
                for (int i = 0; i < this.c.length; ++i) {
                    this.c[i].addToContainer(true);
                }
                this.c[0].b();
            }
        }
    }

    private static abstract class AbstractMenuEdit
    extends AbstractUndoableEdit {
        protected boolean firstUse = true;
        IlvMenuCompletion a;

        public AbstractMenuEdit(IlvMenuCompletion ilvMenuCompletion) {
            this.a = ilvMenuCompletion;
        }

        public abstract void readSettings(IlvSettingsElement var1);

        public abstract void completeMenus(IlvBeanSettings var1, IlvApplication var2, IlvServicesProvider var3) throws CompletionException;

        @Override
        public void redo() {
            super.redo();
            this.firstUse = false;
        }

        @Override
        public boolean canRedo() {
            return this.firstUse || super.canRedo();
        }

        @Override
        public boolean canUndo() {
            return !this.firstUse && super.canUndo();
        }

        MenuComponent[] a(Component[] componentArray, ComponentKey componentKey, IlvBeanSettings ilvBeanSettings, IlvApplication ilvApplication, IlvServicesProvider ilvServicesProvider, boolean bl) {
            Container container;
            int n;
            Component component = componentKey.findComponent(ilvBeanSettings, ilvApplication);
            if (component == null || componentArray == null || componentArray.length == 0) {
                return null;
            }
            MenuComponent[] menuComponentArray = new MenuComponent[componentArray.length];
            switch (componentKey.getInsertionMode()) {
                case 0: {
                    return null;
                }
                case -1: 
                case 1: {
                    n = IlvMenuCompletion.b(component) + (componentKey.getInsertionMode() == 1 ? 1 : 0);
                    container = component.getParent();
                    break;
                }
                case 2: {
                    if (component instanceof Container) {
                        container = (Container)component;
                        n = container.getComponentCount();
                        break;
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            Object v = this.a.g.get(container);
            if (v != null) {
                container = (Container)v;
            }
            boolean bl2 = bl ? !(container instanceof JMenuBar) && container instanceof MenuElement : false;
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2;
                Action action;
                if (!bl) {
                    menuComponentArray[i] = new MenuComponent(this.a, componentArray[i], container, n, ilvApplication);
                    container.add(componentArray[i], n++);
                    action = IlvSwingUtil.GetAssociatedAction(componentArray[i]);
                    IlvAction.RegisterActionInGroup(action, componentArray[i]);
                    continue;
                }
                action = IlvSwingUtil.GetAssociatedAction(componentArray[i]);
                if (action != null) {
                    IlvAction.SetAction(componentArray[i], null, ilvApplication);
                    if (bl2) {
                        component2 = IlvSwingUtil.CreateMenuItem(action, ilvApplication, (JMenuItem)componentArray[i]);
                        if (component2 != componentArray[i]) {
                            component2.setName(componentArray[i].getName());
                        }
                    } else {
                        component2 = componentArray[i];
                        if (container instanceof IlvToolBar) {
                            IlvToolBar.SetButtonProperties((IlvToolBar)container, (AbstractButton)component2, action);
                        }
                    }
                    container.add(component2, n++);
                    IlvAction.SetAction(component2, action, ilvApplication);
                    IlvAction.RegisterActionInGroup(action, component2);
                    menuComponentArray[i] = new MenuComponent(this.a, component2, container, n - 1, ilvApplication);
                    continue;
                }
                if (componentArray[i] instanceof JSeparator) {
                    component2 = bl2 ? IlvMenuBar.AddSeparator(container, n++) : IlvToolBar.AddSeparator(container, n++);
                    if (componentArray[i].getName() != null) {
                        component2.setName(componentArray[i].getName());
                    }
                    menuComponentArray[i] = new MenuComponent(this.a, component2, container, n - 1, ilvApplication);
                    continue;
                }
                menuComponentArray[i] = new MenuComponent(this.a, componentArray[i], container, n, ilvApplication);
                container.add(componentArray[i], n++);
            }
            return menuComponentArray;
        }

        MenuComponent a(Component component, IlvApplication ilvApplication) {
            Object v;
            Container container = component.getParent();
            int n = IlvMenuCompletion.b(component);
            if (container instanceof JPopupMenu && (v = this.a.g.get(container)) != null) {
                container = (Container)v;
            }
            return new MenuComponent(this.a, component, container, n, ilvApplication);
        }
    }

    static class MenuComponent {
        Component a;
        Container b;
        int c;
        Action d;
        IlvApplication e;

        public MenuComponent(IlvMenuCompletion ilvMenuCompletion, Component component, Container container, int n, IlvApplication ilvApplication) {
            this.a = component;
            this.b = container;
            this.c = n;
            this.d = IlvSwingUtil.GetAssociatedAction(component);
            this.e = ilvApplication;
            CompletionContainerListener completionContainerListener = ilvMenuCompletion.b(container);
            completionContainerListener.addMenuComponent(this);
        }

        public MenuComponent(IlvMenuCompletion ilvMenuCompletion, Component component, IlvApplication ilvApplication) {
            this(ilvMenuCompletion, component, component.getParent(), IlvMenuCompletion.b(component), ilvApplication);
        }

        static void a(Container container) {
            if (!i || container == null) {
                return;
            }
            if (container instanceof JMenu) {
                IlvMenuCompletion.a("Menu completion for menu[" + ((JMenu)container).getText() + "]");
            } else if (container instanceof JPopupMenu) {
                MenuComponent.a(container.getParent());
            } else {
                IlvMenuCompletion.a("Menu completion for container[" + container + "]");
            }
        }

        public Component getComponent() {
            return this.a;
        }

        public void setIndex(int n) {
            this.c = n;
        }

        public int getIndex() {
            return this.c;
        }

        public Container getContainer() {
            return this.b;
        }

        public void setContainer(Container container) {
            this.b = container;
        }

        public void removeFromContainer(boolean bl) {
            if (bl && this.d != null) {
                this.a(null);
            }
            IlvAction.UnregisterActionInGroup(this.a);
            this.b.remove(this.c);
        }

        public void addToContainer(boolean bl) {
            if (this.d != null && bl) {
                this.a(this.d);
            }
            this.b.add(this.a, this.c);
            IlvAction.RegisterActionInGroup(this.d, this.a);
        }

        boolean a() {
            if (this.b == null || !(this.b instanceof MenuElement)) {
                return false;
            }
            if (this.b instanceof JMenu && ((JMenu)this.b).getPopupMenu() != null) {
                IlvSwingUtil.UpdateWithActions(((JMenu)this.b).getPopupMenu().getSubElements(), true, false);
            } else {
                IlvSwingUtil.UpdateWithActions(((MenuElement)((Object)this.b)).getSubElements(), true, false);
            }
            return true;
        }

        void b() {
            this.a();
            if (this.b.getLayout() != null) {
                this.b.getLayout().layoutContainer(this.b);
            }
            this.b.invalidate();
            this.b.repaint();
        }

        void a(Action action) {
            if (IlvSwingUtil.GetAssociatedAction(this.a) != action) {
                IlvAction.SetAction(this.a, action, this.e);
            }
        }

        Action c() {
            return this.d;
        }
    }

    static class ComponentKey {
        protected IlvSettingsQuery query;
        protected int insertionMode = 0;
        public static final int NO_INSERTION = 0;
        public static final int INSERT_AFTER = 1;
        public static final int INSERT_BEFORE = -1;
        public static final int INSERT_AS_CHILD = 2;

        public ComponentKey() {
            this.query = null;
        }

        public ComponentKey(String string) {
            this.query = new IlvSettingsQuery(string);
        }

        public synchronized Component findComponent(IlvBeanSettings ilvBeanSettings, IlvApplication ilvApplication) {
            if (this.query == null) {
                return null;
            }
            this.query.setTranslateLiterals(true);
            this.query.setResourceBundle(ilvApplication.getResourceBundleManager());
            IlvSettingsElement ilvSettingsElement = ilvBeanSettings.selectElement(this.query);
            if (ilvSettingsElement == null) {
                return null;
            }
            return (Component)ilvSettingsElement.getCascadedElement(0);
        }

        public void readSettings(IlvSettingsElement ilvSettingsElement) {
            this.readSettings(ilvSettingsElement, "key", "insertionMode");
        }

        public void readSettings(IlvSettingsElement ilvSettingsElement, String string, String string2) {
            String string3 = ilvSettingsElement.getString(string);
            this.query = string3 == null || string3.length() == 0 ? null : new IlvSettingsQuery(string3);
            string3 = ilvSettingsElement.getString(string2);
            this.insertionMode = string3 == null || string3.length() == 0 ? 0 : (string3.equals("after") ? 1 : (string3.equals("before") ? -1 : (string3.equals("as_child") ? 2 : 0)));
        }

        public int getInsertionMode() {
            return this.insertionMode;
        }

        public String toString() {
            return this.query == null ? "" : this.query.getPath();
        }
    }

    private static class CannotReadComponentException
    extends CompletionException {
        public CannotReadComponentException(ComponentKey componentKey) {
            super("Cannot read the component to insert at " + componentKey.toString());
        }
    }

    private static class CannotFindComponentException
    extends CompletionException {
        public CannotFindComponentException(ComponentKey componentKey, IlvBeanSettings ilvBeanSettings) {
            super("Cannot find a component with the key " + componentKey.toString());
        }
    }

    private static class CompletionException
    extends Exception {
        public CompletionException(String string) {
            super(string);
        }
    }
}

