/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.settings.query;

import ilog.views.appframe.settings.query.IlvEvaluationContext;
import ilog.views.appframe.settings.query.Node;
import ilog.views.appframe.settings.query.XPathParser;
import ilog.views.appframe.settings.query.XPathParserTreeConstants;
import java.util.HashMap;

class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected XPathParser parser;
    protected static HashMap symtab = new HashMap();

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(XPathParser xPathParser, int n) {
        this(n);
        this.parser = xPathParser;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        return XPathParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    @Override
    public void evaluate(IlvEvaluationContext ilvEvaluationContext) {
        int n;
        if (this.children == null) {
            ilvEvaluationContext.push(null);
            return;
        }
        int n2 = ilvEvaluationContext.getTopStack();
        for (n = 0; n < this.children.length; ++n) {
            this.jjtGetChild(n).evaluate(ilvEvaluationContext);
        }
        for (n = ilvEvaluationContext.getTopStack(); n2 < n && ilvEvaluationContext.getStackObject(n) == null; --n) {
        }
        if (n2 + 1 < n) {
            ilvEvaluationContext.setStackObject(n2 + 1, ilvEvaluationContext.getStackObject(n));
        }
        ilvEvaluationContext.setTopStack(n2 == n ? n : n2 + 1);
    }
}

