/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.swing.internal;

import ilog.views.appframe.form.controls.IlvFormInput;
import ilog.views.appframe.form.events.ControlListener;
import ilog.views.appframe.form.events.InputEvent;
import ilog.views.appframe.form.events.InputListener;
import ilog.views.appframe.form.swing.internal.ComponentNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class InputNode
extends ComponentNode
implements IlvFormInput {
    @Override
    public String getControlType() {
        return "TextField";
    }

    @Override
    public String getInputText() {
        return ((JTextComponent)this.component).getText();
    }

    @Override
    public void setInputText(String string) {
        ((JTextComponent)this.component).setText(string);
    }

    @Override
    public boolean isInputEditable() {
        return ((JTextComponent)this.component).isEditable();
    }

    @Override
    public void setInputEditable(boolean bl) {
        JTextComponent jTextComponent = (JTextComponent)this.component;
        jTextComponent.setEditable(bl);
        this.setEnabled(bl);
    }

    @Override
    protected Object installDeviceControlListener(Class clazz, ControlListener controlListener) {
        if (clazz == InputListener.class) {
            SwingInputListener swingInputListener = new SwingInputListener((InputListener)controlListener, this.component);
            if (this.component instanceof JTextField) {
                ((JTextField)this.component).addActionListener(swingInputListener);
            }
            if (this.component instanceof JTextComponent) {
                ((JTextComponent)this.component).getDocument().addDocumentListener(swingInputListener);
            }
            return swingInputListener;
        }
        return super.installDeviceControlListener(clazz, controlListener);
    }

    @Override
    protected void uninstallDeviceControlListener(Class clazz, ControlListener controlListener, Object object) {
        if (clazz == InputListener.class) {
            if (this.component instanceof JTextField) {
                ((JTextField)this.component).removeActionListener((SwingInputListener)object);
            }
            if (this.component instanceof JTextComponent) {
                ((JTextComponent)this.component).getDocument().removeDocumentListener((SwingInputListener)object);
            }
            return;
        }
        super.uninstallDeviceControlListener(clazz, controlListener, object);
    }

    private static class SwingInputListener
    implements ActionListener,
    DocumentListener {
        private InputListener a;
        private Component b;

        public SwingInputListener(InputListener inputListener, Component component) {
            this.a = inputListener;
            this.b = component;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.a.inputActivated(new InputEvent(this.b));
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.a.inputTextChanged(new InputEvent(this.b));
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.a.inputTextChanged(new InputEvent(this.b));
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

