/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.internal.controller;

import ilog.views.appframe.form.controls.IlvFormControl;
import ilog.views.appframe.form.controls.IlvFormInput;
import ilog.views.appframe.form.events.InputEvent;
import ilog.views.appframe.form.events.InputListener;
import ilog.views.appframe.form.internal.controller.IlvEditionContext;
import ilog.views.appframe.form.internal.controller.IlvFormSingleEditor;
import ilog.views.appframe.form.internal.controller.io.IlvStringEvaluator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.w3c.dom.Element;

public class IlvInputEditor
extends IlvFormSingleEditor {
    protected IlvFormInput input;
    private InputListener a;
    private IlvStringEvaluator b;
    public static final String EDITABLE_PROPERTY = "Editable";

    public IlvInputEditor() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (IlvInputEditor.EDITABLE_PROPERTY.equals(propertyChangeEvent.getPropertyName()) && !IlvInputEditor.this.isInitializing()) {
                    IlvInputEditor.this.setInputEditable(IlvInputEditor.this.isEditable());
                }
            }
        });
    }

    @Override
    protected IlvFormControl getFormControl() {
        return this.input;
    }

    @Override
    public void connectModel(IlvEditionContext ilvEditionContext) {
        super.connectModel(ilvEditionContext);
        if (this.b != null) {
            this.setEditable(this.b.evaluateBoolean(""));
        }
    }

    @Override
    public void connectUI(IlvEditionContext ilvEditionContext) {
        super.connectUI(ilvEditionContext);
        this.input = this.control == null ? null : this.getForm().getInput(this.control);
        this.setFormControl(this.input);
        if (this.control != null) {
            this.getForm().addControlListener(this.control, InputListener.class, this.d());
        }
    }

    @Override
    public void initializeUI(IlvEditionContext ilvEditionContext) {
        super.initializeUI(ilvEditionContext);
        if (this.b != null && this.input != null) {
            this.setInputEditable(this.isEditable());
        }
    }

    @Override
    public void disconnectUI(IlvEditionContext ilvEditionContext) {
        super.disconnectUI(ilvEditionContext);
        if (this.control != null && this.a != null) {
            this.getForm().addControlListener(this.control, InputListener.class, this.a);
        }
        this.input = null;
    }

    public String getInputText() {
        return this.input == null ? null : this.input.getInputText();
    }

    public void setInputText(String string) {
        if (this.input != null) {
            this.input.setInputText(string);
        }
    }

    public boolean isEditable() {
        return this.getBooleanProperty(EDITABLE_PROPERTY, true);
    }

    public void setEditable(boolean bl) {
        this.setBooleanProperty(EDITABLE_PROPERTY, bl);
    }

    protected void setInputEditable(boolean bl) {
        if (this.input != null) {
            this.input.setInputEditable(bl);
        }
    }

    @Override
    protected void setControlValue(String string) {
        if (this.input != null) {
            if (string != null) {
                this.input.setInputText(string);
            } else {
                this.input.setInputText("");
            }
        }
    }

    @Override
    protected String getControlValue() {
        return this.input == null ? null : this.input.getInputText();
    }

    @Override
    public void read(Element element) {
        super.read(element);
        String string = element.getAttribute("editable");
        if (string != null && string.length() != 0) {
            this.b = new IlvStringEvaluator(string);
            this.addStringEvaluator(this.b);
        }
    }

    private InputListener d() {
        if (this.a == null) {
            this.a = new InputListener(){

                @Override
                public void inputActivated(InputEvent inputEvent) {
                }

                @Override
                public void inputTextChanged(InputEvent inputEvent) {
                    IlvInputEditor.this.displayedValueChanged();
                }
            };
        }
        return this.a;
    }
}

