/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGrapherLinkProperty;
import ilog.views.IlvGrapherObjectProperty;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvObjectProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.linkpolicy.IlvPolicyAwareLinkImage;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringBufferInputStream;

public abstract class IlvLinkConnector
implements Serializable,
IlvPersistentObject {
    private IlvGraphic a;
    private IlvLinkImage b;
    private boolean c;
    private boolean d = false;
    private static final String e = "__ilvLinkConnector";
    private static final String f = "__ilvFromLinkConnector";
    private static final String g = "__ilvToLinkConnector";

    public IlvLinkConnector() {
    }

    public IlvLinkConnector(IlvGraphic ilvGraphic) {
        this.attach(ilvGraphic, true);
    }

    public IlvLinkConnector(IlvLinkImage ilvLinkImage, boolean bl) {
        this.attach(ilvLinkImage, bl, true);
    }

    public IlvLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
    }

    public void attach(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        if (ilvGraphic instanceof IlvLinkImage) {
            throw new IllegalArgumentException("attach(IlvGraphic, boolean) should be used only for nodes. Use attach(IlvLinkImage, boolean, boolean) for the link " + ilvGraphic);
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvGraphic);
        if (ilvLinkConnector == this) {
            return;
        }
        if (this.d) {
            throw new IllegalArgumentException("Link connector " + this + " has been already attached to a link, for its end-node (" + this.a + ") which is different than the specified node (" + ilvGraphic + ")");
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.detach(bl);
        }
        this.detach(bl);
        this.a = ilvGraphic;
        IlvLinkConnector.a(this.a, this, bl);
    }

    public void attach(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        IlvGraphic ilvGraphic;
        if (ilvLinkImage == null) {
            throw new IllegalArgumentException("link cannot be null");
        }
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.GetAttached(ilvLinkImage, bl);
        if (ilvLinkConnector == this) {
            return;
        }
        if (!this.d) {
            this.b = ilvLinkImage;
            this.c = bl;
        } else {
            if (ilvLinkImage.getFrom() != null && ilvLinkImage.getTo() != null && ilvLinkImage.getFrom().getGraphicBag() != ilvLinkImage.getTo().getGraphicBag()) {
                throw new IllegalArgumentException("Link connector " + this + " cannot be shared among intergraph links");
            }
            if (this.b != null && this.b.getFrom() != null && this.b.getTo() != null && this.b.getFrom().getGraphicBag() != this.b.getTo().getGraphicBag()) {
                throw new IllegalArgumentException("Link connector " + this + " cannot be shared among intergraph links");
            }
            this.b = null;
        }
        IlvGraphic ilvGraphic2 = ilvGraphic = bl ? ilvLinkImage.getFrom() : ilvLinkImage.getTo();
        if (this.a != null) {
            if (IlvLinkConnector.GetAttached(this.a) == this) {
                throw new IllegalArgumentException("Link connector " + this + " has been already attached to a node (" + this.a + ")");
            }
            if (this.a != ilvGraphic) {
                throw new IllegalArgumentException("Link connector " + this + " has been already attached to a link for its extremity " + this.a + " which is different than the end-node " + ilvGraphic + " of the specified link " + ilvLinkImage);
            }
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.detach(ilvLinkImage, bl, bl2);
        }
        this.detach(ilvLinkImage, bl, bl2);
        this.a = ilvGraphic;
        IlvLinkConnector.a(ilvLinkImage, this, bl, bl2);
    }

    public IlvLinkConnector attach(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2, boolean bl3) {
        if (this.a == null && !this.d) {
            bl = false;
        }
        IlvLinkConnector ilvLinkConnector = this;
        if (bl && (ilvLinkConnector = IlvLinkConnector.a(this)) == null) {
            return null;
        }
        ilvLinkConnector.attach(ilvLinkImage, bl2, bl3);
        return ilvLinkConnector;
    }

    public void detach(boolean bl) {
        if (this.a == null) {
            return;
        }
        if (this.d) {
            IlvLinkImage ilvLinkImage;
            IlvGraphicBag ilvGraphicBag = this.a.getGraphicBag();
            if (!(ilvGraphicBag instanceof IlvGrapher)) {
                throw new RuntimeException("Link connector " + this + " has been attached to at least one link and its node is not contained" + " in an IlvGrapher. Use detach(IlvLinkImage,boolean,boolean) instead.");
            }
            IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphicBag;
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvGrapher.getLinksFrom(this.a);
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                if (IlvLinkConnector.GetAttached(ilvLinkImage, true) != this) continue;
                this.detach(ilvLinkImage, true, bl);
            }
            ilvGraphicEnumeration = ilvGrapher.getLinksTo(this.a);
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
                if (IlvLinkConnector.GetAttached(ilvLinkImage, false) != this) continue;
                this.detach(ilvLinkImage, false, bl);
            }
            this.d = false;
        }
        IlvLinkConnector.a(this.a, null, bl);
        this.a = null;
        this.b = null;
    }

    public void detach(IlvLinkImage ilvLinkImage, boolean bl, boolean bl2) {
        if (this.a == null) {
            return;
        }
        IlvLinkConnector.a(ilvLinkImage, null, bl, bl2);
        if (ilvLinkImage == this.b) {
            this.b = null;
            this.a = null;
            this.d = false;
        }
    }

    public static IlvLinkConnector GetAttached(IlvGraphic ilvGraphic) {
        IlvObjectProperty ilvObjectProperty = ilvGraphic.m();
        return ilvObjectProperty instanceof IlvGrapherObjectProperty ? ((IlvGrapherObjectProperty)ilvObjectProperty).k() : (IlvLinkConnector)ilvGraphic.getProperty(e);
    }

    public static IlvLinkConnector GetAttached(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvObjectProperty ilvObjectProperty = ilvLinkImage.m();
        return ilvObjectProperty instanceof IlvGrapherLinkProperty ? ((IlvGrapherLinkProperty)ilvObjectProperty).f(bl) : (IlvLinkConnector)ilvLinkImage.getProperty(bl ? f : g);
    }

    private static void a(final IlvGraphic ilvGraphic, final IlvLinkConnector ilvLinkConnector, boolean bl) {
        final IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag == null) {
            ilvGraphic.setProperty(e, ilvLinkConnector);
        } else {
            ilvGraphicBag.applyToObject(ilvGraphic, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic2, Object object) {
                    if (ilvGraphicBag instanceof IlvManager) {
                        IlvObjectProperty ilvObjectProperty = ilvGraphic.m();
                        if (ilvObjectProperty instanceof IlvGrapherObjectProperty) {
                            ((IlvGrapherObjectProperty)ilvObjectProperty).a(ilvLinkConnector);
                        } else {
                            ilvGraphic.setProperty(IlvLinkConnector.e, ilvLinkConnector);
                        }
                    } else {
                        ilvGraphic.setProperty(IlvLinkConnector.e, ilvLinkConnector);
                    }
                    IlvLinkConnector.b(ilvGraphic2);
                }
            }, null, bl);
        }
    }

    private static void b(IlvGraphic ilvGraphic) {
        IlvPolicyAwareLinkImage ilvPolicyAwareLinkImage;
        IlvLinkImage ilvLinkImage;
        if (!(ilvGraphic.getGraphicBag() instanceof IlvGrapher)) {
            return;
        }
        IlvGrapher ilvGrapher = (IlvGrapher)ilvGraphic.getGraphicBag();
        if (!ilvGrapher.isNode(ilvGraphic)) {
            return;
        }
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvGrapher.getLinksFrom(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
            if (!(ilvLinkImage instanceof IlvPolicyAwareLinkImage) || (ilvPolicyAwareLinkImage = (IlvPolicyAwareLinkImage)ilvLinkImage).getLinkShapePolicy() == null) continue;
            ilvPolicyAwareLinkImage.getLinkShapePolicy().afterFromNodeMoved(ilvPolicyAwareLinkImage);
        }
        ilvGraphicEnumeration = ilvGrapher.getLinksTo(ilvGraphic);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            ilvLinkImage = (IlvLinkImage)ilvGraphicEnumeration.nextElement();
            if (!(ilvLinkImage instanceof IlvPolicyAwareLinkImage) || (ilvPolicyAwareLinkImage = (IlvPolicyAwareLinkImage)ilvLinkImage).getLinkShapePolicy() == null) continue;
            ilvPolicyAwareLinkImage.getLinkShapePolicy().afterToNodeMoved(ilvPolicyAwareLinkImage);
        }
    }

    private static void a(final IlvLinkImage ilvLinkImage, final IlvLinkConnector ilvLinkConnector, final boolean bl, boolean bl2) {
        final IlvGraphicBag ilvGraphicBag = ilvLinkImage.getGraphicBag();
        if (ilvGraphicBag == null) {
            ilvLinkImage.setProperty(bl ? f : g, ilvLinkConnector);
        } else {
            ilvGraphicBag.applyToObject(ilvLinkImage, new IlvApplyObject(){

                @Override
                public void apply(IlvGraphic ilvGraphic, Object object) {
                    if (ilvGraphicBag instanceof IlvManager) {
                        IlvObjectProperty ilvObjectProperty = ilvLinkImage.m();
                        if (ilvObjectProperty instanceof IlvGrapherLinkProperty) {
                            ((IlvGrapherLinkProperty)ilvObjectProperty).a(ilvLinkConnector, bl);
                        } else {
                            ilvLinkImage.setProperty(bl ? IlvLinkConnector.f : IlvLinkConnector.g, ilvLinkConnector);
                        }
                    } else {
                        ilvLinkImage.setProperty(bl ? IlvLinkConnector.f : IlvLinkConnector.g, ilvLinkConnector);
                    }
                    IlvLinkConnector.b(ilvLinkImage, bl);
                }
            }, null, bl2);
        }
        if (ilvLinkConnector != null) {
            ilvLinkConnector.d = true;
        }
    }

    private static void b(IlvLinkImage ilvLinkImage, boolean bl) {
        IlvPolicyAwareLinkImage ilvPolicyAwareLinkImage;
        if (ilvLinkImage instanceof IlvPolicyAwareLinkImage && (ilvPolicyAwareLinkImage = (IlvPolicyAwareLinkImage)ilvLinkImage).getLinkShapePolicy() != null) {
            if (bl) {
                ilvPolicyAwareLinkImage.getLinkShapePolicy().afterFromNodeMoved(ilvPolicyAwareLinkImage);
            } else {
                ilvPolicyAwareLinkImage.getLinkShapePolicy().afterToNodeMoved(ilvPolicyAwareLinkImage);
            }
        }
    }

    static final void a(IlvGraphic ilvGraphic, IlvGrapherObjectProperty ilvGrapherObjectProperty, IlvGrapherObjectProperty ilvGrapherObjectProperty2) {
        if (ilvGrapherObjectProperty == ilvGrapherObjectProperty2) {
            return;
        }
        if (ilvGrapherObjectProperty != null) {
            IlvLinkConnector ilvLinkConnector = ilvGrapherObjectProperty.k();
            if (ilvLinkConnector != null) {
                ilvGrapherObjectProperty.a((IlvLinkConnector)null);
                if (ilvGrapherObjectProperty2 != null) {
                    ilvGrapherObjectProperty2.a(ilvGrapherObjectProperty.k());
                } else {
                    ilvGraphic.setProperty(e, ilvLinkConnector);
                }
            }
        } else if (ilvGrapherObjectProperty2 != null) {
            ilvGrapherObjectProperty2.a((IlvLinkConnector)ilvGraphic.getProperty(e));
            ilvGraphic.setProperty(e, null);
        }
    }

    static final void a(IlvLinkImage ilvLinkImage, IlvGrapherLinkProperty ilvGrapherLinkProperty, IlvGrapherLinkProperty ilvGrapherLinkProperty2) {
        if (ilvGrapherLinkProperty == ilvGrapherLinkProperty2) {
            return;
        }
        IlvLinkConnector.a(ilvLinkImage, ilvGrapherLinkProperty, ilvGrapherLinkProperty2, true);
        IlvLinkConnector.a(ilvLinkImage, ilvGrapherLinkProperty, ilvGrapherLinkProperty2, false);
    }

    private static void a(IlvLinkImage ilvLinkImage, IlvGrapherLinkProperty ilvGrapherLinkProperty, IlvGrapherLinkProperty ilvGrapherLinkProperty2, boolean bl) {
        String string = bl ? f : g;
        if (ilvGrapherLinkProperty != null) {
            IlvLinkConnector ilvLinkConnector = ilvGrapherLinkProperty.f(bl);
            if (ilvLinkConnector != null) {
                ilvGrapherLinkProperty.a(null, bl);
                if (ilvGrapherLinkProperty2 != null) {
                    ilvGrapherLinkProperty2.a(ilvGrapherLinkProperty.k(), bl);
                } else {
                    ilvLinkImage.setProperty(string, ilvLinkConnector);
                }
            }
        } else if (ilvGrapherLinkProperty2 != null) {
            ilvGrapherLinkProperty2.a((IlvLinkConnector)ilvLinkImage.getProperty(string), bl);
            ilvLinkImage.setProperty(string, null);
        }
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
    }

    public void write(IlvOutputStream ilvOutputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IOException {
    }

    public void read(IlvInputStream ilvInputStream, IlvLinkImage ilvLinkImage, boolean bl) throws IlvReadFileException {
    }

    public boolean isPersistent() {
        return false;
    }

    static IlvLinkConnector a(IlvLinkConnector ilvLinkConnector) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IlvOutputStream ilvOutputStream = new IlvOutputStream(byteArrayOutputStream);
            ilvOutputStream.write("aux", ilvLinkConnector);
            ilvOutputStream.flush();
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(((Object)byteArrayOutputStream).toString());
            IlvInputStream ilvInputStream = new IlvInputStream(stringBufferInputStream);
            ilvInputStream.setCopyPasteMode();
            ilvLinkConnector = (IlvLinkConnector)ilvInputStream.readPersistentObject("aux");
            return ilvLinkConnector;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final IlvGraphic getNode() {
        if (this.b != null && this.b.getGraphicBag() != null) {
            if (this.c) {
                return this.b.getVisibleFrom();
            }
            return this.b.getVisibleTo();
        }
        return this.a;
    }

    public static IlvLinkConnector Get(IlvGraphic ilvGraphic) {
        return IlvLinkConnector.GetAttached(ilvGraphic);
    }

    public static IlvLinkConnector Get(IlvLinkImage ilvLinkImage, boolean bl) {
        return IlvLinkConnector.a(ilvLinkImage, null, bl);
    }

    static IlvLinkConnector a(IlvLinkImage ilvLinkImage, IlvGraphic ilvGraphic, boolean bl) {
        IlvLinkConnector ilvLinkConnector;
        IlvGraphic ilvGraphic2;
        IlvGraphic ilvGraphic3 = ilvGraphic2 = bl ? ilvLinkImage.getFrom() : ilvLinkImage.getTo();
        if (ilvGraphic2 == null) {
            return null;
        }
        if (ilvGraphic == null) {
            IlvGraphic ilvGraphic4 = ilvGraphic = bl ? ilvLinkImage.getVisibleFrom() : ilvLinkImage.getVisibleTo();
        }
        if (ilvGraphic2 == ilvGraphic && (ilvLinkConnector = IlvLinkConnector.GetAttached(ilvLinkImage, bl)) != null) {
            return ilvLinkConnector;
        }
        return IlvLinkConnector.GetAttached(ilvGraphic);
    }

    public abstract IlvPoint getConnectionPoint(IlvLinkImage var1, boolean var2, IlvTransformer var3);

    protected abstract boolean zoomable();

    public abstract IlvPoint getClosestConnectionPoint(IlvPoint var1, Object var2, Object var3, Object var4, boolean var5, IlvTransformer var6);

    public abstract void connectLink(IlvLinkImage var1, IlvPoint var2, boolean var3, IlvTransformer var4);

    public void disconnectLink(IlvLinkImage ilvLinkImage, boolean bl) {
    }

    public boolean allowsConnectionPointMove(IlvLinkImage ilvLinkImage, boolean bl) {
        return true;
    }

    public void linkRemoved(IlvLinkImage ilvLinkImage) {
    }

    protected void allLinksRemoved() {
    }

    public void drawGhost(Graphics graphics, IlvTransformer ilvTransformer, Object object, Object object2, Object object3, boolean bl) {
    }

    public abstract IlvRect getGhostBoundingBox(IlvTransformer var1);

    public boolean supportsDrawGhost() {
        return false;
    }
}

