/*
 * Decompiled with CFR 0.152.
 */
package ilog.views;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvRect;
import ilog.views.IlvRegion;
import ilog.views.IlvTransformer;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.impl.IlvUtility2D;
import java.awt.AWTEvent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;

public class IlvHoverHighlightingImageOperation
extends IlvObjectInteractor {
    public static boolean HIGHLIGHT_SELECTION = false;
    static float[] a;
    static float b;
    static float[] c;
    static float[] d;
    static byte[][] e;
    public static final BufferedImageOp BRIGHTEN_OP;
    public static final BufferedImageOp SHARPEN_OP;
    public static final BufferedImageOp BLUR_OP;
    public static final BufferedImageOp GRAYSCALE_OP;
    public static final BufferedImageOp INVERT_COLORS_OP;
    private transient IlvGraphic f;
    private transient IlvManagerView g;
    private Filter h = null;
    private float i = 0.8f;
    private BufferedImageOp j = INVERT_COLORS_OP;

    public void setAlpha(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0,1.0]");
        }
        this.i = f;
    }

    public IlvHoverHighlightingImageOperation() {
        this(INVERT_COLORS_OP, 0.8f);
    }

    public IlvHoverHighlightingImageOperation(BufferedImageOp bufferedImageOp, float f) {
        this.setImageOperation(bufferedImageOp);
        this.setAlpha(f);
    }

    public float getAlpha() {
        return this.i;
    }

    public BufferedImageOp getImageOperation() {
        return this.j;
    }

    public void setImageOperation(BufferedImageOp bufferedImageOp) {
        this.j = bufferedImageOp;
    }

    @Override
    public boolean processEvent(IlvGraphic ilvGraphic, AWTEvent aWTEvent, IlvObjectInteractorContext ilvObjectInteractorContext) {
        if (aWTEvent.getID() == 503) {
            return this.showHighlight(ilvGraphic, (IlvManagerView)aWTEvent.getSource());
        }
        return false;
    }

    @Override
    public void onExit(IlvGraphic ilvGraphic, IlvObjectInteractorContext ilvObjectInteractorContext) {
        super.onExit(ilvGraphic, ilvObjectInteractorContext);
        this.hideHighlight(1);
    }

    public void setHighlightFilter(Filter filter) {
        this.h = filter;
    }

    public Filter getHighlightFilter() {
        return this.h;
    }

    public boolean showHighlight(IlvGraphic ilvGraphic, IlvManagerView ilvManagerView) {
        Filter filter;
        if (this.getHighlightedGraphic() == ilvGraphic) {
            return false;
        }
        if (this.getHighlightedGraphic() != null) {
            this.hideHighlight(1);
        }
        if ((filter = this.getHighlightFilter()) != null && !filter.highlightObject(ilvGraphic)) {
            return false;
        }
        if (!HIGHLIGHT_SELECTION && ilvManagerView != null && ilvManagerView.getManager().isSelected(ilvGraphic)) {
            return false;
        }
        this.setHighlightedGraphic(ilvGraphic);
        this.setTargetView(ilvManagerView);
        return this.drawHighlight();
    }

    protected synchronized boolean drawHighlight() {
        IlvRect ilvRect;
        if (this.getTargetView() == null) {
            throw new IllegalArgumentException("target view cannot be null");
        }
        Graphics graphics = this.getTargetView().getGraphics();
        if (!(graphics instanceof Graphics2D)) {
            return false;
        }
        IlvTransformer ilvTransformer = IlvHoverHighlightingImageOperation.a(this.getTargetView(), this.getHighlightedGraphic());
        Rectangle rectangle = this.getTargetView().visibleRect();
        if (rectangle.intersects(ilvRect = this.getHighlightedGraphic().boundingBox(ilvTransformer))) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (graphics2D.getClipBounds() == null) {
                graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (this.getTargetView().isAntialiasing()) {
                IlvGraphicUtil.StartAntiAliasing(graphics2D);
            }
            if (this.getAlpha() != 1.0f) {
                IlvUtility2D.SetAlphaComposite(graphics2D, this.getAlpha());
            }
            IlvDrawWithBufferedImage.drawWithBufferedImage(this.getHighlightedGraphic(), graphics2D, ilvTransformer, this.getImageOperation());
            graphics2D.dispose();
            return true;
        }
        return false;
    }

    private static IlvTransformer a(IlvManagerView ilvManagerView, IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager) {
            IlvManager ilvManager = (IlvManager)ilvGraphicBag;
            IlvTransformer ilvTransformer = IlvHoverHighlightingImageOperation.a(ilvManagerView, ilvManager);
            IlvTransformer ilvTransformer2 = ilvManager.getTransformer();
            ilvTransformer2.compose(ilvTransformer);
            return ilvTransformer2;
        }
        if (ilvGraphicBag instanceof IlvGraphic) {
            return IlvHoverHighlightingImageOperation.a(ilvManagerView, (IlvGraphic)((Object)ilvGraphicBag));
        }
        return ilvManagerView.getTransformer();
    }

    protected synchronized void hideHighlight(int n) {
        if (this.getHighlightedGraphic() != null && this.getTargetView() != null) {
            IlvTransformer ilvTransformer = IlvHoverHighlightingImageOperation.a(this.getTargetView(), this.getHighlightedGraphic());
            IlvTransformer ilvTransformer2 = this.getTargetView().getTransformer();
            IlvRect ilvRect = this.getHighlightedGraphic().boundingBox(ilvTransformer);
            if (ilvTransformer2 != null) {
                ilvTransformer2.inverse(ilvRect);
            }
            ilvRect.x -= (float)(IlvDrawWithBufferedImage.MARGINS[0] + n);
            ilvRect.y -= (float)(IlvDrawWithBufferedImage.MARGINS[1] + n);
            ilvRect.width += (float)(IlvDrawWithBufferedImage.MARGINS[2] + n * 2);
            ilvRect.height += (float)(IlvDrawWithBufferedImage.MARGINS[3] + n * 2);
            IlvRegion ilvRegion = new IlvRegion();
            ilvRegion.add(ilvRect);
            IlvManager ilvManager = this.getTargetView().getManager();
            int n2 = this.getTargetView().getRedrawMode();
            this.getTargetView().setRedrawMode(1);
            ilvManager.reDrawRegion(ilvRegion);
            this.getTargetView().setRedrawMode(n2);
        }
        this.setHighlightedGraphic(null);
        this.setTargetView(null);
    }

    protected IlvGraphic getHighlightedGraphic() {
        return this.f;
    }

    protected void setHighlightedGraphic(IlvGraphic ilvGraphic) {
        this.f = ilvGraphic;
    }

    protected IlvManagerView getTargetView() {
        return this.g;
    }

    protected synchronized void setTargetView(IlvManagerView ilvManagerView) {
        this.g = ilvManagerView;
    }

    static {
        float[] fArray = new float[1];
        fArray[0] = 1.5f;
        a = fArray;
        b = 0.11111111f;
        c = new float[]{b, b, b, b, b, b, b, b, b};
        float[] fArray2 = new float[9];
        fArray2[0] = 0.0f;
        fArray2[1] = -1.0f;
        fArray2[2] = 0.0f;
        fArray2[3] = -1.0f;
        fArray2[4] = 5.0f;
        fArray2[5] = -1.0f;
        fArray2[6] = 0.0f;
        fArray2[7] = -1.0f;
        fArray2[8] = 0.0f;
        d = fArray2;
        e = new byte[4][256];
        int n = 3;
        for (int i = 0; i < 256; ++i) {
            IlvHoverHighlightingImageOperation.e[0][i] = (byte)(n == 0 ? i : 255 - i);
            IlvHoverHighlightingImageOperation.e[1][i] = (byte)(n == 1 ? i : 255 - i);
            IlvHoverHighlightingImageOperation.e[2][i] = (byte)(n == 2 ? i : 255 - i);
            IlvHoverHighlightingImageOperation.e[3][i] = (byte)(n == 3 ? i : 255 - i);
        }
        BRIGHTEN_OP = new ConvolveOp(new Kernel(1, 1, a));
        SHARPEN_OP = new ConvolveOp(new Kernel(3, 3, d), 1, null);
        BLUR_OP = new ConvolveOp(new Kernel(3, 3, c));
        GRAYSCALE_OP = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        INVERT_COLORS_OP = new LookupOp(new ByteLookupTable(0, e), null);
    }

    public static class GraphicBagFilter
    implements Filter {
        @Override
        public boolean highlightObject(IlvGraphic ilvGraphic) {
            return ilvGraphic instanceof IlvGraphicBag;
        }
    }

    public static class NonGraphicBagFilter
    implements Filter {
        @Override
        public boolean highlightObject(IlvGraphic ilvGraphic) {
            return !(ilvGraphic instanceof IlvGraphicBag);
        }
    }

    public static interface Filter {
        public boolean highlightObject(IlvGraphic var1);
    }
}

