/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.tint.BlockPainter;
import oracle.ide.ceditor.tint.BlockShape;
import oracle.ide.ceditor.tint.TintBlock;
import oracle.ide.ceditor.tint.TintModel;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.folding.CodeFoldingMargin;

public abstract class DefaultBlockPainter
implements BlockPainter {
    protected static int LEADING_INSET = 2;
    protected static int TRAILING_INSET = 8;

    protected abstract boolean isPaintingEnabled();

    @Override
    public void paint(Graphics2D g2, BasicEditorPane editor, TintModel model) {
        if (this.isPaintingEnabled()) {
            return;
        }
        TintBlock block = model.getRoot();
        if (block == null) {
            return;
        }
        Rectangle visRect = editor.getVisibleRect();
        int firstOff = editor.viewToModel(visRect.getLocation());
        int lastOff = editor.viewToModel(new Point(visRect.x + visRect.width, visRect.y + visRect.height));
        int depth = 0;
        int lineHeight = editor.getFontHelper().getFontMetrics(editor.getFont(), (Component)editor).getHeight();
        this.visit(g2, editor, model, block, firstOff, lastOff, depth, lineHeight);
    }

    protected void visit(Graphics2D g2, BasicEditorPane editor, TintModel model, TintBlock block, int firstOff, int lastOff, int depth, int lineHeight) {
        if (block.getEndOffset() < firstOff) {
            return;
        }
        if (block.getStartOffset() > lastOff) {
            return;
        }
        if (DefaultBlockPainter.isFolded(editor, block)) {
            return;
        }
        if (block.isVisible()) {
            this.paintBlock(g2, editor, model, block, depth, lineHeight);
        }
        ++depth;
        for (TintBlock childBlock : model.getChildren(block)) {
            this.visit(g2, editor, model, childBlock, firstOff, lastOff, depth, lineHeight);
        }
    }

    protected void paintBlock(Graphics2D g2, BasicEditorPane editor, TintModel model, TintBlock block, int depth, int lineHeight) {
        Shape shape = this.getShape(editor, block, model, depth, lineHeight);
        if (shape == null) {
            return;
        }
        if (block.getBlockType().getColor() != null) {
            g2.setColor(block.getBlockType().getColor());
            g2.fill(shape);
        }
        if (block.getBlockType().getBlockStroke().getStroke() != null && block.getBlockType().getStrokeColor() != null) {
            g2.setStroke(block.getBlockType().getBlockStroke().getStroke());
            g2.setColor(block.getBlockType().getStrokeColor());
            g2.draw(shape);
        }
    }

    protected static boolean isFolded(BasicEditorPane editor, TintBlock block) {
        CodeFoldingMargin foldingMargin = (CodeFoldingMargin)editor.getProperty("code-folding-margin");
        if (foldingMargin == null || foldingMargin.getModel() == null) {
            return false;
        }
        Object foldedBlock = foldingMargin.getLargestCollapsedBlock(foldingMargin.getModel(), foldingMargin.getModel().getRoot(), block.getStartOffset());
        return foldedBlock != null;
    }

    protected int getEditorBlockWidth(BasicEditorPane editor, TintModel model, TintBlock block, int x, int depth) {
        int width = editor.getPreferredSize().width;
        int w = width + LEADING_INSET + (model.getMaxDepth() - depth - 1) * TRAILING_INSET - x;
        return w;
    }

    protected int getBlockWidth(BasicEditorPane editor, TintModel model, TintBlock block, int x, int depth) {
        return this.getEditorBlockWidth(editor, model, block, x, depth);
    }

    private Shape getShape(BasicEditorPane editor, TintBlock block, TintModel model, int depth, int lineHeight) {
        try {
            Shape shape;
            Rectangle start = editor.modelToView(block.getStartOffset());
            Rectangle end = editor.modelToView(block.getEndOffset());
            int x = Math.min(start.x, end.x) - LEADING_INSET;
            int width = this.getBlockWidth(editor, model, block, x, depth);
            int height = Math.min(end.y - start.y + lineHeight, editor.getHeight() - 1);
            if (block.getBlockType().getBlockShape() == BlockShape.CUTOUT) {
                if (start.y == end.y) {
                    shape = new RoundRectangle2D.Float(start.x, start.y, end.x - start.x + end.width, height, 10.0f, 10.0f);
                } else {
                    if (start.y != end.y) {
                        int endLine = editor.getLineFromOffset(block.getEndOffset());
                        for (int line = editor.getLineFromOffset(block.getStartOffset()) + 1; line <= endLine; ++line) {
                            int off = editor.getLineStartOffset(line);
                            int endLineOff = editor.getLineEndOffset(line);
                            char c = editor.getTextBuffer().getChar(off++);
                            while (off < endLineOff && Character.isWhitespace(c)) {
                                c = editor.getTextBuffer().getChar(off++);
                            }
                            x = Math.min(x, editor.modelToView((int)(off - 1)).x);
                        }
                    }
                    int ARC = 5;
                    int TOP = start.y;
                    int RIGHT = width + x;
                    int BOTTOM = end.y + end.height;
                    int LEFT = x;
                    int START_LOWER = start.y + start.height;
                    int END_RIGHT = end.x + end.width;
                    int END_UPPER = end.y;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(start.x + 5, TOP);
                    path.lineTo(RIGHT - 5, TOP);
                    path.quadTo(RIGHT, TOP, RIGHT, TOP + 5);
                    path.lineTo(RIGHT, END_UPPER - 5);
                    path.quadTo(RIGHT, END_UPPER, RIGHT - 5, END_UPPER);
                    path.lineTo(END_RIGHT + 5, END_UPPER);
                    path.quadTo(END_RIGHT, END_UPPER, END_RIGHT, END_UPPER + 5);
                    path.lineTo(END_RIGHT, BOTTOM - 5);
                    path.quadTo(END_RIGHT, BOTTOM, END_RIGHT - 5, BOTTOM);
                    path.lineTo(LEFT + 5, BOTTOM);
                    path.quadTo(LEFT, BOTTOM, LEFT, BOTTOM - 5);
                    path.lineTo(LEFT, START_LOWER + 5);
                    path.quadTo(LEFT, START_LOWER, LEFT + 5, START_LOWER);
                    path.lineTo(start.x - 5, START_LOWER);
                    path.quadTo(start.x, START_LOWER, start.x, START_LOWER - 5);
                    path.moveTo(start.x, TOP + 5);
                    path.quadTo(start.x, TOP, start.x + 5, TOP);
                    path.closePath();
                    shape = path;
                }
            } else {
                shape = new RoundRectangle2D.Float(x, start.y, width, height, 10.0f, 10.0f);
            }
            return shape;
        }
        catch (BadLocationException e) {
            return null;
        }
    }
}

