/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.wizard;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Element;
import oracle.ide.wizard.TriggerInvokable;
import oracle.ide.wizard.Wizard;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

public class NewDBObjectWizard
implements TriggerInvokable {
    public boolean invoke(Context context) {
        return this.createObject(context.getElement(), Wizard.getWizardId((Context)context), true);
    }

    public Object getInvalidStateMessage(Context context) {
        return UIBundle.format("OBJTYPE_NOT_SUPPORTED", Wizard.getWizardId((Context)context));
    }

    public boolean canInvoke(Context context) {
        return this.createObject(context.getElement(), Wizard.getWizardId((Context)context), false);
    }

    private boolean createObject(Element e, String objType, boolean doit) {
        String dbName = DBObjectNodeUtil.getConnectionName(e);
        if (dbName != null) {
            try {
                Database db = (Database)DBObjectNodeUtil.findProvider(e);
                if (db == null) {
                    DBLog.getLogger(NewDBObjectWizard.class).warning(objType + " wizard couldn't find database: " + dbName);
                } else {
                    Schema s = e instanceof DBObjectTypeNode ? DBObjectNodeUtil.getSchema((DBObjectTypeNode)e, true) : db.getDefaultSchema();
                    DBEditorFactory factory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)db, objType);
                    if (factory != null) {
                        if (doit) {
                            DBEditorConfig config = DBEditorConfig.newCreateConfig((DBObjectProvider)db, objType, s);
                            factory.launchDialog(config);
                            return config.getResult() == DBEditorConfig.Result.SUCCESS;
                        }
                        return factory.canCreateDBObject(s, (DBObjectProvider)db, objType);
                    }
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger(NewDBObjectWizard.class).log(Level.WARNING, objType + " wizard encountered an error: " + dbe.getMessage());
            }
        }
        return false;
    }
}

