/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.validate;

import java.awt.Component;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.validate.DBValidationComponent;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.ideimpl.db.validate.DBValidationListCellRenderer;
import oracle.ideimpl.db.validate.DBValidationTreeCellRenderer;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.validators.DBObjectValidationModel;
import oracle.javatools.db.validators.ValidationException;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.MultiItemTemplate;
import oracle.javatools.ui.infotip.templates.SingleItemTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public abstract class DBValidationManager {
    private static Reference<Icon> s_invalidIcon;
    private static Reference<Icon> s_emptyIcon;

    public abstract DBValidationHandler createHandler(DBEditorConfig var1, ComponentFactory var2);

    public abstract DBObjectValidationModel getValidationModel();

    public Component processRendererComponent(Component c, DBObject obj, String prop) {
        Component retval = c;
        DBObjectValidationModel model = this.getValidationModel();
        if (model != null && prop != null && c instanceof JComponent) {
            DBValidationComponent dvc = DBValidationComponent.findOrCreateValidationComponent((JComponent)c, null);
            Collection ves = (Collection)model.getValidationMap(obj).get(prop);
            if (ves != null) {
                for (ValidationException ve : ves) {
                    dvc.addValidationException(ve);
                }
            }
        }
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            String ICON_KEY = "DBValidationManager.ICON_KEY";
            if (model != null && (prop == null || "name".equals(prop))) {
                Icon icon = null;
                boolean useIndicator = false;
                boolean valid = model.isValid(obj);
                if (valid) {
                    Object val;
                    DBObject par = obj.getParent();
                    String parProp = DBUtil.getParentProperty((DBObject)obj);
                    if (parProp != null && (val = par.getProperty(parProp)) instanceof DBObject[]) {
                        boolean oneInvalid = false;
                        for (DBObject child : (DBObject[])val) {
                            if (child == obj || model.isValid(child)) continue;
                            oneInvalid = true;
                            break;
                        }
                        if (oneInvalid) {
                            useIndicator = true;
                        }
                    }
                } else {
                    useIndicator = true;
                }
                if (useIndicator) {
                    icon = valid ? DBValidationManager.getEmptyLabelIcon() : DBValidationManager.getInvalidLabelIcon();
                }
                label.setIcon(icon);
                label.putClientProperty("DBValidationManager.ICON_KEY", icon);
            } else {
                Icon existingIcon = label.getIcon();
                if (existingIcon != null && label.getClientProperty("DBValidationManager.ICON_KEY") == existingIcon) {
                    label.setIcon(null);
                }
                label.putClientProperty("DBValidationManager.ICON_KEY", null);
            }
        }
        return retval;
    }

    public TreeCellRenderer wrapTreeCellRenderer(TreeCellRenderer tcr) {
        return new DBValidationTreeCellRenderer(this, tcr);
    }

    public ListCellRenderer wrapListCellRenderer(ListCellRenderer lcr) {
        return new DBValidationListCellRenderer(this, lcr);
    }

    public static TreeCellRenderer wrapTreeCellRenderer(TreeCellRenderer tcr, Namespace dataContext) {
        TreeCellRenderer retval = tcr;
        DBValidationManager mgr = (DBValidationManager)dataContext.find(DBValidationManager.class);
        if (mgr != null) {
            retval = mgr.wrapTreeCellRenderer(tcr);
        }
        return retval;
    }

    public static ListCellRenderer wrapListCellRenderer(ListCellRenderer lcr, Namespace dataContext) {
        ListCellRenderer retval = lcr;
        DBValidationManager mgr = (DBValidationManager)dataContext.find(DBValidationManager.class);
        if (mgr != null) {
            retval = mgr.wrapListCellRenderer(lcr);
        }
        return retval;
    }

    public static Icon getInvalidLabelIcon() {
        Icon retval;
        Reference<Icon> ref = s_invalidIcon;
        Icon icon = retval = ref == null ? null : ref.get();
        if (retval == null) {
            StatusIndicator indicator = new StatusIndicator();
            indicator.setStatus(StatusIndicator.Status.ERROR);
            retval = indicator.getIcon(StatusIndicator.OkPolicy.HIDE);
            s_invalidIcon = new SoftReference<Icon>(retval);
        }
        return retval;
    }

    public static Icon getEmptyLabelIcon() {
        Icon retval;
        Reference<Icon> ref = s_emptyIcon;
        Icon icon = retval = ref == null ? null : ref.get();
        if (retval == null) {
            StatusIndicator indicator = new StatusIndicator();
            indicator.setStatus(StatusIndicator.Status.OK);
            retval = indicator.getIcon(StatusIndicator.OkPolicy.HIDE);
            s_emptyIcon = new SoftReference<Icon>(retval);
        }
        return retval;
    }

    public static Icon getLabelIcon(Icon existingIcon, boolean isValid) {
        Icon errorIcon = DBValidationManager.getInvalidLabelIcon();
        if (existingIcon == errorIcon) {
            existingIcon = null;
        }
        Icon retval = isValid ? existingIcon : errorIcon;
        return retval;
    }

    public static Template createInfoTipContent(Collection<ValidationException> errors) {
        ArrayList<SingleItemTemplate> templates = new ArrayList<SingleItemTemplate>();
        for (ValidationException ex : errors) {
            SingleItemTemplate sit = new SingleItemTemplate(SingleItemTemplate.Severity.ERROR, ex.getMessage(), null, Collections.emptyList(), InfoTipStyles.DEFAULT);
            templates.add(sit);
        }
        Template retval = null;
        if (templates.size() == 1) {
            retval = (Template)templates.get(0);
        } else if (templates.size() > 1) {
            retval = new MultiItemTemplate(templates);
        }
        return retval;
    }
}

